/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.RateListCellRenderer;
import com.tridium.eas.cost.ui.RateListParentPanel;
import com.tridium.eas.cost.ui.RateUserObjectComparator;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasList;
import com.tridium.eas.ui.widgets.SortedListModel;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RateList
extends EasList
implements ListSelectionListener {
    private Rate[] rates;
    private RateListParentPanel rateEditor = null;
    private EasSession session = null;

    public RateList(ResourceManager resourceManager) {
        this.setModel(new SortedListModel(new RateUserObjectComparator()));
        this.setCellRenderer(new RateListCellRenderer(resourceManager));
        this.addListSelectionListener(this);
    }

    public void setRateEditor(RateListParentPanel rateListParentPanel) {
        this.rateEditor = rateListParentPanel;
    }

    public void init(EasSession easSession) {
        this.session = easSession;
    }

    public EasSession getSession() {
        return this.session;
    }

    public void refreshData(boolean bl) {
        if (!bl) {
            this.refreshData(this.rates);
            return;
        }
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        try {
            String[] stringArray = EasCostClient.retrieveRateNames(this.getSession());
            if (stringArray != null) {
                String[] stringArray2 = new String[stringArray.length];
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("CustomComponents")) continue;
                    stringArray2[n] = stringArray[i];
                    ++n;
                }
                String[] stringArray3 = new String[n];
                System.arraycopy(stringArray2, 0, stringArray3, 0, n);
                this.rates = new Rate[stringArray3.length];
                for (int i = 0; i < stringArray3.length; ++i) {
                    this.rates[i] = new Rate(stringArray3[i]);
                    sortedListModel.addElement(this.rates[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refreshData(Rate[] rateArray) {
        this.rates = rateArray;
        SortedListModel sortedListModel = (SortedListModel)this.getModel();
        sortedListModel.removeAllElements();
        try {
            if (rateArray != null) {
                for (int i = 0; i < rateArray.length; ++i) {
                    sortedListModel.addElement(rateArray[i]);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Rate rate = (Rate)this.getSelectedValue();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Rate rate2 = null;
            if (rate != null) {
                rate2 = this.getRate(rate.getName(), false);
            }
            if (this.rateEditor != null) {
                this.rateEditor.setRateEditorValue(rate2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Rate[] getRates() {
        return this.rates;
    }

    public Rate getSelectedRate() {
        Rate rate = (Rate)this.getSelectedValue();
        this.setCursor(Cursor.getPredefinedCursor(3));
        Rate rate2 = null;
        try {
            if (rate != null) {
                rate2 = this.getRate(rate.getName(), false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
        return rate2;
    }

    public Rate getRate(String string, boolean bl) {
        try {
            if (this.rates == null) {
                Rate rate = EasCostClient.retrieveRate(this.getSession(), string);
                if (rate != null) {
                    this.rates = new Rate[1];
                    this.rates[0] = rate;
                }
                return rate;
            }
            for (int i = 0; i < this.rates.length; ++i) {
                if (!this.rates[i].getName().equals(string)) continue;
                if (this.rates[i].getResync() || bl) {
                    this.rates[i] = EasCostClient.retrieveRate(this.getSession(), string);
                    this.rates[i].setResync(false);
                }
                return this.rates[i];
            }
            Rate rate = EasCostClient.retrieveRate(this.getSession(), string);
            if (rate != null) {
                Rate[] rateArray = new Rate[this.rates.length + 1];
                for (int i = 0; i < this.rates.length; ++i) {
                    rateArray[i] = this.rates[i];
                }
                rateArray[this.rates.length] = rate;
                this.rates = rateArray;
            }
            return rate;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void saveRate(Rate rate) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (rate == null) {
                return;
            }
            EasCostClient.storeRate(this.getSession(), rate);
            if (this.rates == null) {
                this.rates = new Rate[1];
                this.rates[0] = rate;
            } else {
                boolean bl = false;
                for (int i = 0; i < this.rates.length; ++i) {
                    if (!this.rates[i].getName().equals(rate.getName())) continue;
                    this.rates[i] = rate;
                    bl = true;
                    break;
                }
                if (!bl) {
                    Rate[] rateArray = new Rate[this.rates.length + 1];
                    for (int i = 0; i < this.rates.length; ++i) {
                        rateArray[i] = this.rates[i];
                    }
                    rateArray[this.rates.length] = rate;
                    this.rates = rateArray;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void renameRate(Rate rate, String string) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (rate == null) {
                return;
            }
            if (this.rates != null) {
                for (int i = 0; i < this.rates.length; ++i) {
                    if (!this.rates[i].getName().equals(rate.getName())) continue;
                    String string2 = rate.getName();
                    EasCostClient.renameRate(this.getSession(), string2, string);
                    this.rates[i].setName(string);
                    return;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void deleteRate(Rate rate) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (rate == null) {
                return;
            }
            EasCostClient.deleteRate(this.getSession(), rate.getName());
            if (this.rates == null || this.rates.length <= 0) {
                return;
            }
            int n = -1;
            for (int i = 0; i < this.rates.length; ++i) {
                if (!this.rates[i].getName().equals(rate.getName())) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                Rate[] rateArray = new Rate[this.rates.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.rates.length; ++i) {
                    if (i == n) continue;
                    rateArray[n2] = this.rates[i];
                    ++n2;
                }
                this.rates = rateArray;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Rate getRateObject(String string) {
        if (this.rates != null) {
            for (int i = 0; i < this.rates.length; ++i) {
                if (!this.rates[i].getName().equals(string)) continue;
                return this.rates[i];
            }
        }
        return null;
    }

    public void reloadRate() {
        Rate rate = (Rate)this.getSelectedValue();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Rate rate2 = null;
            if (rate != null && (rate2 = this.getRate(rate.getName(), true)) != null) {
                rate = rate2;
            }
            if (this.rateEditor != null) {
                this.rateEditor.setRateEditorValue(rate2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = 175;
        if (dimension.width > n) {
            n = dimension.width;
        }
        return new Dimension(n, dimension.height);
    }

    public void setSelected(int n, boolean bl) {
        if (bl) {
            this.addSelectionInterval(n, n);
        } else {
            this.removeSelectionInterval(n, n);
        }
    }

    public void setSelectedValues(Object[] objectArray) {
        this.clearSelection();
        ListModel listModel = this.getModel();
        int n = listModel.getSize();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                for (int j = 0; j < n; ++j) {
                    Object e = listModel.getElementAt(j);
                    if (!object.equals(e)) continue;
                    this.setSelected(j, true);
                }
            }
        }
    }

    public void selectAll() {
        this.setSelectedValues(this.rates);
    }
}

