/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.CombinationPercentageFee;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.ui.CreateARateApplication;
import com.tridium.eas.cost.ui.RateComponentDetailPanel;
import com.tridium.eas.cost.ui.RateComponentList;
import com.tridium.eas.cost.ui.RateListParentPanel;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.widgets.EasButton;
import com.tridium.eas.ui.widgets.EasPopupMenu;
import com.tridium.eas.ui.widgets.EasScrollPane;
import com.tridium.eas.ui.widgets.EasTextField;
import com.tridium.eas.ui.widgets.ListPopupHandler;
import com.tridium.eas.ui.widgets.UnitComboBox;
import com.tridium.eas.ui.widgets.UnitTreeComboBox;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.Lexicon;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RateDetailPanel
extends JPanel
implements RateListParentPanel,
FocusListener {
    private EasSession session = null;
    private ResourceManager resourceManager = null;
    private CreateARateApplication parentApplication = null;
    protected Lexicon lex;
    private EasTextField nameTextField = null;
    private EasTextField providerTextField = null;
    private EasTextField phoneTextField = null;
    private EasTextField websiteTextField = null;
    private EasTextField locationTextField = null;
    private UnitComboBox currencyUnitsEditor = null;
    private UnitTreeComboBox consumptionUnitsEditor = null;
    private UnitTreeComboBox demandUnitsEditor = null;
    private UnitComboBox reactiveEnergyUnitsEditor = null;
    private UnitComboBox apparentEnergyUnitsEditor = null;
    private UnitComboBox reactivePowerUnitsEditor = null;
    private UnitComboBox apparentPowerUnitsEditor = null;
    private JLabel reactiveEnergyLabel = null;
    private JLabel apparentEnergyLabel = null;
    private JLabel reactivePowerLabel = null;
    private JLabel apparentPowerLabel = null;
    private EasScrollPane upperPanelScrollPane = null;
    private CardLayout layout = null;
    private JButton applyButton = null;
    private JButton discardChangesButton = null;
    private JButton upButton = null;
    private JButton downButton = null;
    private RateComponentList rateComponents = null;
    private RateComponentDetailPanel rateComponentDetails = null;
    private boolean initializingRateValues;
    private boolean renameRate = false;
    private String newRateName;
    private Rate currentSelectedRate = null;
    private RateComponentPopup rateComponentPopup = null;
    private JSplitPane upperPane;
    private JButton moreUnitsButton;
    private boolean showUnits = false;

    protected RateDetailPanel(ResourceManager resourceManager, CreateARateApplication createARateApplication, Lexicon lexicon) {
        this.lex = lexicon;
        this.resourceManager = resourceManager;
        this.parentApplication = createARateApplication;
        this.initializingRateValues = true;
        this.layout = new CardLayout();
        this.setLayout(this.layout);
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        this.add("show", jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout(), false);
        jPanel2.setBorder(BorderFactory.createTitledBorder(lexicon.getText("rateDetails")));
        this.add("hide", jPanel2);
        this.upperPane = new JSplitPane();
        this.upperPane.setDividerSize(4);
        JPanel jPanel3 = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildRateFixedPropertiesPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 12;
        jPanel3.add((Component)this.buildRateDynamicComponentsPanel(), gridBagConstraints);
        this.upperPanelScrollPane = new EasScrollPane(jPanel3);
        this.upperPanelScrollPane.getViewport().setBackground(Color.white);
        this.upperPane.setLeftComponent(this.upperPanelScrollPane);
        this.upperPane.setRightComponent(this.buildRateComponentEditorPanel());
        jPanel.add((Component)new JScrollPane(this.upperPane), "Center");
        JPanel jPanel4 = new JPanel(new FlowLayout(1), false);
        this.applyButton = new JButton(lexicon.getText("applyChanges"));
        this.applyButton.setEnabled(false);
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.applyChanges()) {
                    RateDetailPanel.this.discardChangesButton.setEnabled(false);
                    RateDetailPanel.this.applyButton.setEnabled(false);
                }
            }
        });
        jPanel4.add(this.applyButton);
        this.discardChangesButton = new JButton(lexicon.getText("discardChanges"));
        this.discardChangesButton.setEnabled(false);
        this.discardChangesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateDetailPanel.this.applyButton.setEnabled(false);
                RateDetailPanel.this.discardChangesButton.setEnabled(false);
                RateDetailPanel.this.discardChanges();
            }
        });
        jPanel4.add(this.discardChangesButton);
        jPanel.add((Component)jPanel4, "South");
        this.setRateEditorValue(null);
        this.initializingRateValues = false;
    }

    protected JComponent buildRateFixedPropertiesPanel() {
        Object object;
        UnitDatabase.Quantity quantity;
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateDetails")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("name")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        this.nameTextField = new EasTextField(12, 50);
        this.nameTextField.setUseLabelAppearanceWhenDisabled(true);
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.renameRate = true;
                RateDetailPanel.this.newRateName = RateDetailPanel.this.nameTextField.getText();
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        this.nameTextField.addFocusListener(this);
        jPanel.add((Component)this.nameTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("energyProvider")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.providerTextField = new EasTextField(15, 50);
        this.providerTextField.setUseLabelAppearanceWhenDisabled(true);
        this.providerTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setEnergyProvider(RateDetailPanel.this.providerTextField.getText());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        this.providerTextField.addFocusListener(this);
        jPanel.add((Component)this.providerTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("providerPhone")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.phoneTextField = new EasTextField(15, 50);
        this.phoneTextField.setUseLabelAppearanceWhenDisabled(true);
        this.phoneTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setPhoneNumber(RateDetailPanel.this.phoneTextField.getText());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        this.phoneTextField.addFocusListener(this);
        jPanel.add((Component)this.phoneTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("providerWebsite")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.websiteTextField = new EasTextField(15, 250);
        this.websiteTextField.setUseLabelAppearanceWhenDisabled(true);
        this.websiteTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setWebsite(RateDetailPanel.this.websiteTextField.getText());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        this.websiteTextField.addFocusListener(this);
        jPanel.add((Component)this.websiteTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("location")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.locationTextField = new EasTextField(15, 50);
        this.locationTextField.setUseLabelAppearanceWhenDisabled(true);
        this.locationTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setLocation(RateDetailPanel.this.locationTextField.getText());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        this.locationTextField.addFocusListener(this);
        jPanel.add((Component)this.locationTextField, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(this.lex.getText("currency")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        BUnit bUnit = null;
        try {
            bUnit = BUnit.getUnit((String)"dollar");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bUnit == null) {
            bUnit = BUnit.make((String)"dollar", (String)"$", (BDimension)BDimension.make((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1));
        }
        if ((quantity = UnitDatabase.getDefault().getQuantity(bUnit)) != null) {
            this.currencyUnitsEditor = new UnitComboBox(quantity, this.lex);
        } else {
            object = new BUnit[]{bUnit};
            this.currencyUnitsEditor = new UnitComboBox((BUnit[])object, this.lex);
        }
        this.currencyUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setCurrency(RateDetailPanel.this.currencyUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.currencyUnitsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("consumptionUnits")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.consumptionUnitsEditor = new UnitTreeComboBox(this.getResourceManager(), false, this.lex);
        this.consumptionUnitsEditor.setSelectedItem(BUnit.getUnit((String)"kilowatt hour"));
        this.consumptionUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setConsumptionUnits(RateDetailPanel.this.consumptionUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.consumptionUnitsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(this.lex.getText("demandUnits")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.demandUnitsEditor = new UnitTreeComboBox(this.getResourceManager(), false, this.lex);
        this.demandUnitsEditor.setSelectedItem(BUnit.getUnit((String)"kilowatt"));
        this.demandUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setDemandUnits(RateDetailPanel.this.demandUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.demandUnitsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.moreUnitsButton = new JButton(this.lex.getText("moreUnits"));
        this.moreUnitsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateDetailPanel.this.showUnits = !RateDetailPanel.this.showUnits;
                if (RateDetailPanel.this.showUnits) {
                    RateDetailPanel.this.moreUnitsButton.setText(RateDetailPanel.this.lex.getText("lessUnits"));
                } else {
                    RateDetailPanel.this.moreUnitsButton.setText(RateDetailPanel.this.lex.getText("moreUnits"));
                }
                RateDetailPanel.this.reactiveEnergyLabel.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.reactiveEnergyUnitsEditor.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.apparentEnergyLabel.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.apparentEnergyUnitsEditor.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.reactivePowerLabel.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.reactivePowerUnitsEditor.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.apparentPowerLabel.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.apparentPowerUnitsEditor.setVisible(RateDetailPanel.this.showUnits);
                RateDetailPanel.this.parentApplication.revalidate();
            }
        });
        jPanel.add((Component)this.moreUnitsButton, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.reactiveEnergyLabel = new JLabel(this.lex.getText("reactiveEnergyUnits"));
        this.reactiveEnergyLabel.setVisible(this.showUnits);
        jPanel.add((Component)this.reactiveEnergyLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.reactiveEnergyUnitsEditor = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"kilovolt ampere reactive hour")), this.lex);
        this.reactiveEnergyUnitsEditor.setVisible(this.showUnits);
        this.reactiveEnergyUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setReactiveEnergyUnits(RateDetailPanel.this.reactiveEnergyUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.reactiveEnergyUnitsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.apparentEnergyLabel = new JLabel(this.lex.getText("apparentEnergyUnits"));
        this.apparentEnergyLabel.setVisible(this.showUnits);
        jPanel.add((Component)this.apparentEnergyLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.apparentEnergyUnitsEditor = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"kilovolt ampere hour")), this.lex);
        this.apparentEnergyUnitsEditor.setVisible(this.showUnits);
        this.apparentEnergyUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setApparentEnergyUnits(RateDetailPanel.this.apparentEnergyUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.apparentEnergyUnitsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.reactivePowerLabel = new JLabel(this.lex.getText("reactivePowerUnits"));
        this.reactivePowerLabel.setVisible(this.showUnits);
        jPanel.add((Component)this.reactivePowerLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.reactivePowerUnitsEditor = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"kilovolt ampere reactive")), this.lex);
        this.reactivePowerUnitsEditor.setVisible(this.showUnits);
        this.reactivePowerUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setReactivePowerUnits(RateDetailPanel.this.reactivePowerUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.reactivePowerUnitsEditor, gridBagConstraints);
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        this.apparentPowerLabel = new JLabel(this.lex.getText("apparentPowerUnits"));
        this.apparentPowerLabel.setVisible(this.showUnits);
        jPanel.add((Component)this.apparentPowerLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        this.apparentPowerUnitsEditor = new UnitComboBox(UnitDatabase.getDefault().getQuantity(BUnit.getUnit((String)"kilovolt ampere")), this.lex);
        this.apparentPowerUnitsEditor.setVisible(this.showUnits);
        this.apparentPowerUnitsEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RateDetailPanel.this.initializingRateValues) {
                    return;
                }
                RateDetailPanel.this.getSelectedRate().setApparentPowerUnits(RateDetailPanel.this.apparentPowerUnitsEditor.getSelectedUnit());
                RateDetailPanel.this.handleRateChange(false);
            }
        });
        jPanel.add((Component)this.apparentPowerUnitsEditor, gridBagConstraints);
        object = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                JComponent jComponent = (JComponent)focusEvent.getSource();
                RateDetailPanel.this.upperPanelScrollPane.makeVisible(jComponent);
            }
        };
        this.nameTextField.setNextFocusableComponent(this.providerTextField);
        this.providerTextField.setNextFocusableComponent(this.phoneTextField);
        this.phoneTextField.setNextFocusableComponent(this.websiteTextField);
        this.websiteTextField.setNextFocusableComponent(this.locationTextField);
        this.locationTextField.setNextFocusableComponent(this.currencyUnitsEditor);
        this.currencyUnitsEditor.setNextFocusableComponent(this.consumptionUnitsEditor);
        this.consumptionUnitsEditor.setNextFocusableComponent(this.demandUnitsEditor);
        this.demandUnitsEditor.setNextFocusableComponent(this.reactiveEnergyUnitsEditor);
        this.reactiveEnergyUnitsEditor.setNextFocusableComponent(this.apparentEnergyUnitsEditor);
        this.apparentEnergyUnitsEditor.setNextFocusableComponent(this.reactivePowerUnitsEditor);
        this.reactivePowerUnitsEditor.setNextFocusableComponent(this.apparentPowerUnitsEditor);
        this.apparentPowerUnitsEditor.setNextFocusableComponent(this.nameTextField);
        this.nameTextField.addFocusListener((FocusListener)object);
        this.providerTextField.addFocusListener((FocusListener)object);
        this.phoneTextField.addFocusListener((FocusListener)object);
        this.websiteTextField.addFocusListener((FocusListener)object);
        this.locationTextField.addFocusListener((FocusListener)object);
        this.currencyUnitsEditor.addFocusListener((FocusListener)object);
        this.consumptionUnitsEditor.addFocusListener((FocusListener)object);
        this.demandUnitsEditor.addFocusListener((FocusListener)object);
        this.reactiveEnergyUnitsEditor.addFocusListener((FocusListener)object);
        this.apparentEnergyUnitsEditor.addFocusListener((FocusListener)object);
        this.reactivePowerUnitsEditor.addFocusListener((FocusListener)object);
        this.apparentPowerUnitsEditor.addFocusListener((FocusListener)object);
        return jPanel;
    }

    protected JComponent buildRateDynamicComponentsPanel() {
        this.rateComponents = new RateComponentList(this.getResourceManager());
        this.rateComponents.getSelectionModel().setSelectionMode(0);
        this.rateComponents.setPopupHandler(new ListPopupHandler(){

            public void openPopup(Object object, int n, int n2, int n3) {
                if (RateDetailPanel.this.rateComponents.isEnabled()) {
                    if (RateDetailPanel.this.rateComponentPopup == null) {
                        RateDetailPanel.this.rateComponentPopup = new RateComponentPopup(RateDetailPanel.this.lex);
                    }
                    RateDetailPanel.this.rateComponentPopup.show(RateDetailPanel.this.rateComponents, n >= 0, n2, n3);
                }
            }
        });
        this.rateComponents.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 8) {
                    RateDetailPanel.this.deleteRateComponent();
                } else if (keyEvent.getKeyCode() == 67 && keyEvent.isControlDown()) {
                    RateDetailPanel.this.copyRateComponent();
                } else if (keyEvent.getKeyCode() == 86 && keyEvent.isControlDown() && CreateARateApplication.clipboard != null && CreateARateApplication.clipboard instanceof RateComponent) {
                    RateDetailPanel.this.pasteRateComponent();
                }
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout(), false);
        jPanel.setBorder(BorderFactory.createTitledBorder(this.lex.getText("rateComponents")));
        jPanel.add((Component)new JScrollPane(this.rateComponents), "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(1), false);
        this.upButton = new EasButton((ResourceManager)this.parentApplication, 314, this.lex.getText("moveUp"));
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateDetailPanel.this.moveComponentUp();
            }
        });
        jPanel2.add(this.upButton);
        this.downButton = new EasButton((ResourceManager)this.parentApplication, 315, this.lex.getText("moveDown"));
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RateDetailPanel.this.moveComponentDown();
            }
        });
        jPanel2.add(this.downButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    protected JComponent buildRateComponentEditorPanel() {
        this.rateComponentDetails = new RateComponentDetailPanel(this, this.lex);
        this.rateComponents.setRateComponentEditor(this.rateComponentDetails);
        return this.rateComponentDetails;
    }

    public void setRateEditorValue(Rate rate) {
        this.initializingRateValues = true;
        this.currentSelectedRate = rate;
        if (rate == null) {
            this.layout.show(this, "hide");
        } else {
            this.layout.show(this, "show");
            this.nameTextField.setText(rate.getName());
            this.providerTextField.setText(rate.getEnergyProvider());
            this.phoneTextField.setText(rate.getPhoneNumber());
            this.websiteTextField.setText(rate.getWebsite());
            this.locationTextField.setText(rate.getLocation());
            this.currencyUnitsEditor.setSelectedUnit(rate.getCurrency());
            this.consumptionUnitsEditor.setSelectedItem(rate.getConsumptionUnits());
            this.demandUnitsEditor.setSelectedItem(rate.getDemandUnits());
            this.reactiveEnergyUnitsEditor.setSelectedUnit(rate.getReactiveEnergyUnits());
            this.apparentEnergyUnitsEditor.setSelectedUnit(rate.getApparentEnergyUnits());
            this.reactivePowerUnitsEditor.setSelectedUnit(rate.getReactivePowerUnits());
            this.apparentPowerUnitsEditor.setSelectedUnit(rate.getApparentPowerUnits());
            this.rateComponents.setRate(rate);
            this.rateComponents.refreshData();
        }
        this.initializingRateValues = false;
    }

    private Rate getSelectedRate() {
        return this.currentSelectedRate;
    }

    public void handleRateChange(boolean bl) {
        if (this.initializingRateValues) {
            return;
        }
        this.parentApplication.setRateSelectionEnabled(false);
        this.discardChangesButton.setEnabled(true);
        this.applyButton.setEnabled(true);
        if (bl) {
            this.rateComponents.repaint();
        }
    }

    public boolean unsavedChangesExist() {
        if (this.applyButton != null) {
            return this.applyButton.isEnabled();
        }
        return false;
    }

    public void doRefresh() {
        this.discardChangesButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    public boolean applyChanges() {
        Rate rate = this.getSelectedRate();
        if (this.renameRate) {
            if (this.parentApplication.rateNameIllegal(this.newRateName)) {
                JOptionPane.showMessageDialog(this.parentApplication, this.newRateName + " " + this.lex.getText("illegalRateName"), this.lex.getText("rateNameError"), 0);
                return false;
            }
            if (this.parentApplication.rateNameAlreadyExists(rate, this.newRateName)) {
                JOptionPane.showMessageDialog(this.parentApplication, this.newRateName + " " + this.lex.getText("rateAlreadyExists"), this.lex.getText("rateNameError"), 0);
                return false;
            }
            this.parentApplication.renameRateAndSave(rate, this.newRateName);
            this.renameRate = false;
        } else {
            this.parentApplication.saveRate(rate);
        }
        this.parentApplication.setRateSelectionEnabled(true);
        return true;
    }

    private void discardChanges() {
        this.parentApplication.setRateSelectionEnabled(true);
        this.parentApplication.reloadRate();
    }

    private void deleteRateComponent() {
        RateComponent rateComponent;
        Rate rate = this.getSelectedRate();
        if (rate != null && this.rateComponents != null && (rateComponent = (RateComponent)this.rateComponents.getSelectedValue()) != null) {
            String string = this.lex.getText("deleteWarning") + "\n\"" + rateComponent.getName() + "\"?";
            int n = JOptionPane.showConfirmDialog(this, string, this.lex.getText("confirmDelete"), 0);
            if (n != 0) {
                return;
            }
            if (rateComponent instanceof ChoiceComponentChild) {
                RateComponent rateComponent2 = ((ChoiceComponentChild)rateComponent).getParentRateComponent();
                ((ChoiceComponent)rateComponent2).removeRateComponent(rateComponent);
            } else {
                rate.removeRateComponent(rateComponent);
            }
            this.setRateEditorValue(rate);
            this.handleRateChange(false);
        }
    }

    private void duplicateRateComponent() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent != null) {
            if (rateComponent instanceof ChoiceComponentChild) {
                RateComponent rateComponent2 = ((ChoiceComponentChild)rateComponent).getParentRateComponent();
                this.parentApplication.addChoiceComponentChild((ChoiceComponent)rateComponent2, (RateComponent)((ChoiceComponentChild)rateComponent).getRateComponent().newCopy());
            } else {
                this.parentApplication.addRateComponent((RateComponent)rateComponent.newCopy());
            }
        }
    }

    private void copyRateComponent() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent != null) {
            if (rateComponent instanceof ChoiceComponentChild) {
                rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent();
            }
            CreateARateApplication.clipboard = (RateComponent)rateComponent.newCopy();
        }
    }

    private void pasteRateComponent() {
        RateComponent rateComponent = (RateComponent)CreateARateApplication.clipboard;
        if (rateComponent != null) {
            RateComponent rateComponent2;
            RateComponent rateComponent3 = (RateComponent)this.rateComponents.getSelectedValue();
            if (rateComponent3 instanceof ChoiceComponentChild && (rateComponent2 = ((ChoiceComponentChild)rateComponent3).getRateComponent()) instanceof ChoiceComponent) {
                rateComponent3 = rateComponent2;
            }
            if (rateComponent3 != null && rateComponent3 instanceof ChoiceComponent) {
                this.parentApplication.addChoiceComponentChild((ChoiceComponent)rateComponent3, rateComponent);
            } else {
                this.parentApplication.addRateComponent(rateComponent);
            }
        }
    }

    private void moveComponentUp() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent != null) {
            Rate rate = this.getSelectedRate();
            if (rate == null) {
                return;
            }
            RateComponent[] rateComponentArray = null;
            if (rateComponent instanceof ChoiceComponentChild) {
                ChoiceComponent choiceComponent = (ChoiceComponent)((ChoiceComponentChild)rateComponent).getParentRateComponent();
                if (choiceComponent == null) {
                    return;
                }
                ChoiceComponentChild[] choiceComponentChildArray = choiceComponent.getRateComponents();
                if (choiceComponentChildArray == null) {
                    return;
                }
                rateComponentArray = new ChoiceComponentChild[choiceComponentChildArray.length];
                for (int i = 0; i < choiceComponentChildArray.length; ++i) {
                    if (choiceComponentChildArray[i].getName().equals(rateComponent.getName())) {
                        if (i > 0) {
                            rateComponentArray[i - 1] = (ChoiceComponentChild)rateComponent;
                            rateComponentArray[i] = choiceComponentChildArray[i - 1];
                            continue;
                        }
                        return;
                    }
                    rateComponentArray[i] = choiceComponentChildArray[i];
                }
                choiceComponent.setRateComponents((ChoiceComponentChild[])rateComponentArray);
                rateComponentArray = rate.getRateComponents();
            } else {
                RateComponent[] rateComponentArray2 = rate.getRateComponents();
                if (rateComponentArray2 == null) {
                    return;
                }
                rateComponentArray = new RateComponent[rateComponentArray2.length];
                for (int i = 0; i < rateComponentArray2.length; ++i) {
                    if (rateComponentArray2[i].getName().equals(rateComponent.getName())) {
                        if (i > 0) {
                            rateComponentArray[i - 1] = rateComponent;
                            rateComponentArray[i] = rateComponentArray2[i - 1];
                            continue;
                        }
                        return;
                    }
                    rateComponentArray[i] = rateComponentArray2[i];
                }
            }
            this.parentApplication.componentsReordered(rateComponent, rateComponentArray);
        }
    }

    private void moveComponentDown() {
        RateComponent rateComponent = (RateComponent)this.rateComponents.getSelectedValue();
        if (rateComponent != null) {
            Rate rate = this.getSelectedRate();
            if (rate == null) {
                return;
            }
            RateComponent[] rateComponentArray = null;
            if (rateComponent instanceof ChoiceComponentChild) {
                ChoiceComponent choiceComponent = (ChoiceComponent)((ChoiceComponentChild)rateComponent).getParentRateComponent();
                if (choiceComponent == null) {
                    return;
                }
                ChoiceComponentChild[] choiceComponentChildArray = choiceComponent.getRateComponents();
                if (choiceComponentChildArray == null) {
                    return;
                }
                rateComponentArray = new ChoiceComponentChild[choiceComponentChildArray.length];
                for (int i = 0; i < choiceComponentChildArray.length; ++i) {
                    if (choiceComponentChildArray[i].getName().equals(rateComponent.getName())) {
                        if (i < choiceComponentChildArray.length - 1) {
                            rateComponentArray[i + 1] = (ChoiceComponentChild)rateComponent;
                            rateComponentArray[i] = choiceComponentChildArray[i + 1];
                            ++i;
                            continue;
                        }
                        return;
                    }
                    rateComponentArray[i] = choiceComponentChildArray[i];
                }
                choiceComponent.setRateComponents((ChoiceComponentChild[])rateComponentArray);
                rateComponentArray = rate.getRateComponents();
            } else {
                RateComponent[] rateComponentArray2 = rate.getRateComponents();
                if (rateComponentArray2 == null) {
                    return;
                }
                rateComponentArray = new RateComponent[rateComponentArray2.length];
                for (int i = 0; i < rateComponentArray2.length; ++i) {
                    if (rateComponentArray2[i].getName().equals(rateComponent.getName())) {
                        if (i < rateComponentArray2.length - 1) {
                            rateComponentArray[i + 1] = rateComponent;
                            rateComponentArray[i] = rateComponentArray2[i + 1];
                            ++i;
                            continue;
                        }
                        return;
                    }
                    rateComponentArray[i] = rateComponentArray2[i];
                }
            }
            this.parentApplication.componentsReordered(rateComponent, rateComponentArray);
        }
    }

    public void updateCombinationPercentageFees(String string, String string2) {
        Rate rate = this.getSelectedRate();
        if (rate == null) {
            return;
        }
        RateComponent[] rateComponentArray = rate.getRateComponents();
        if (rateComponentArray == null) {
            return;
        }
        for (int i = 0; i < rateComponentArray.length; ++i) {
            if (!(rateComponentArray[i] instanceof CombinationPercentageFee)) continue;
            ((CombinationPercentageFee)rateComponentArray[i]).replaceRateComponentId(string2, string);
        }
    }

    public void setSelectedRateComponent(RateComponent rateComponent) {
        if (this.rateComponents != null) {
            this.rateComponents.setSelectedValue(rateComponent, true);
        }
    }

    public void adjustSplitPane() {
        this.upperPane.setDividerLocation(-1);
    }

    protected void init(EasSession easSession) {
        this.session = easSession;
        this.layout.show(this, "hide");
        this.rateComponents.init(easSession);
        this.rateComponents.setEnabled(true);
        this.rateComponentDetails.init(easSession);
    }

    protected void initApplication() {
        this.parentApplication.initApplication(true);
    }

    protected EasSession getSession() {
        return this.session;
    }

    protected ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public String getCurrency() {
        if (this.currencyUnitsEditor == null) {
            return "";
        }
        return this.currencyUnitsEditor.getSelectedItemString();
    }

    public String getConsumptionUnits() {
        if (this.consumptionUnitsEditor == null) {
            return "";
        }
        return this.consumptionUnitsEditor.getSelectedUnit().toString();
    }

    public String getDemandUnits() {
        if (this.demandUnitsEditor == null) {
            return "";
        }
        return this.demandUnitsEditor.getSelectedUnit().toString();
    }

    public String getReactiveEnergyUnits() {
        if (this.reactiveEnergyUnitsEditor == null) {
            return "";
        }
        return this.reactiveEnergyUnitsEditor.getSelectedItemString();
    }

    public String getApparentEnergyUnits() {
        if (this.apparentEnergyUnitsEditor == null) {
            return "";
        }
        return this.apparentEnergyUnitsEditor.getSelectedItemString();
    }

    public String getReactivePowerUnits() {
        if (this.reactivePowerUnitsEditor == null) {
            return "";
        }
        return this.reactivePowerUnitsEditor.getSelectedItemString();
    }

    public String getApparentPowerUnits() {
        if (this.apparentPowerUnitsEditor == null) {
            return "";
        }
        return this.apparentPowerUnitsEditor.getSelectedItemString();
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component instanceof JTextField && ((JTextField)component).isEditable()) {
            this.selectItLater(component);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    private void selectItLater(Component component) {
        if (component instanceof JTextField) {
            final JTextField jTextField = (JTextField)component;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    jTextField.selectAll();
                }
            });
        }
    }

    private class RateComponentPopup
    extends EasPopupMenu {
        private EasPopupMenu.EasPopupMenuItem deleteItem = null;
        private boolean deleteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem copyItem = null;
        private boolean copyItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem pasteItem = null;
        private boolean pasteItemShowing = false;
        private EasPopupMenu.EasPopupMenuItem duplicateItem = null;
        private boolean duplicateItemShowing = false;
        private Lexicon lex;

        public RateComponentPopup(Lexicon lexicon) {
            this.lex = lexicon;
            this.duplicateItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("duplicate"), 0, null);
            this.copyItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("copy"), 1, null);
            this.pasteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("Paste"), 2, null);
            this.deleteItem = new EasPopupMenu.EasPopupMenuItem(lexicon.getText("deleteRateComponent"), 3, null);
        }

        protected void processCommand(int n, Object object) {
            switch (n) {
                case 0: {
                    RateDetailPanel.this.duplicateRateComponent();
                    break;
                }
                case 1: {
                    RateDetailPanel.this.copyRateComponent();
                    break;
                }
                case 2: {
                    RateDetailPanel.this.pasteRateComponent();
                    break;
                }
                case 3: {
                    RateDetailPanel.this.deleteRateComponent();
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void show(Component component, boolean bl, int n, int n2) {
            boolean bl2 = bl;
            boolean bl3 = CreateARateApplication.clipboard != null && CreateARateApplication.clipboard instanceof RateComponent;
            boolean bl4 = bl2;
            if (bl2 && !this.duplicateItemShowing) {
                this.duplicateItem.addActionListener(this);
                this.insert(this.duplicateItem, 0);
                this.revalidate();
                this.duplicateItemShowing = true;
            } else if (this.duplicateItemShowing && !bl2) {
                this.remove(this.duplicateItem);
                this.revalidate();
                this.duplicateItemShowing = false;
            }
            if (bl4 && !this.copyItemShowing) {
                this.copyItem.addActionListener(this);
                if (this.duplicateItemShowing) {
                    this.insert(this.copyItem, 1);
                } else {
                    this.insert(this.copyItem, 0);
                }
                this.revalidate();
                this.copyItemShowing = true;
            } else if (this.copyItemShowing && !bl4) {
                this.remove(this.copyItem);
                this.revalidate();
                this.copyItemShowing = false;
            }
            if (bl3 && !this.pasteItemShowing) {
                this.pasteItem.addActionListener(this);
                if (this.copyItemShowing && this.duplicateItemShowing) {
                    this.insert(this.pasteItem, 2);
                } else if (this.duplicateItemShowing || this.copyItemShowing) {
                    this.insert(this.pasteItem, 1);
                } else {
                    this.insert(this.pasteItem, 0);
                }
                this.revalidate();
                this.pasteItemShowing = true;
            } else if (this.pasteItemShowing && !bl3) {
                this.remove(this.pasteItem);
                this.revalidate();
                this.pasteItemShowing = false;
            }
            if (bl2 && !this.deleteItemShowing) {
                this.add(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = true;
            } else if (this.deleteItemShowing && !bl2) {
                this.remove(this.deleteItem);
                this.revalidate();
                this.deleteItemShowing = false;
            }
            if (this.deleteItemShowing || this.copyItemShowing || this.pasteItemShowing || this.duplicateItemShowing) {
                super.show(component, n, n2);
            }
        }
    }
}

