/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.api.EasSession;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.ui.EasCostClient;
import com.tridium.eas.cost.ui.RateComponentDetailPanel;
import com.tridium.eas.cost.ui.RateListCellRenderer;
import com.tridium.eas.ui.ResourceManager;
import com.tridium.eas.ui.dbconfig.EasList;
import java.awt.Cursor;
import javax.swing.DefaultListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RateComponentList
extends EasList
implements ListSelectionListener {
    private Rate rate = null;
    private Rate custom = null;
    private RateComponentDetailPanel rateComponentDetails = null;
    private EasSession session = null;

    public RateComponentList(ResourceManager resourceManager) {
        this.setModel(new DefaultListModel());
        this.setCellRenderer(new RateListCellRenderer(resourceManager));
        this.addListSelectionListener(this);
    }

    public void setRateComponentEditor(RateComponentDetailPanel rateComponentDetailPanel) {
        this.rateComponentDetails = rateComponentDetailPanel;
    }

    public void setRate(Rate rate) {
        this.rate = rate;
    }

    public void setCustomRate(Rate rate) {
        this.custom = rate;
    }

    public void init(EasSession easSession) {
        this.session = easSession;
        this.refreshData();
    }

    public EasSession getSession() {
        return this.session;
    }

    public void refreshData() {
        int n;
        RateComponent[] rateComponentArray;
        DefaultListModel defaultListModel = (DefaultListModel)this.getModel();
        defaultListModel.removeAllElements();
        if (this.rate != null && (rateComponentArray = this.rate.getRateComponents()) != null) {
            for (n = 0; n < rateComponentArray.length; ++n) {
                defaultListModel.addElement(rateComponentArray[n]);
                if (!(rateComponentArray[n] instanceof ChoiceComponent)) continue;
                defaultListModel = RateComponentList.addChoiceComponentChildren(defaultListModel, (ChoiceComponent)rateComponentArray[n], 0);
            }
        }
        if (this.custom != null && (rateComponentArray = this.custom.getRateComponents()) != null) {
            for (n = 0; n < rateComponentArray.length; ++n) {
                defaultListModel.addElement(rateComponentArray[n]);
                if (!(rateComponentArray[n] instanceof ChoiceComponent)) continue;
                defaultListModel = RateComponentList.addChoiceComponentChildren(defaultListModel, (ChoiceComponent)rateComponentArray[n], 0);
            }
        }
    }

    private static DefaultListModel addChoiceComponentChildren(DefaultListModel defaultListModel, ChoiceComponent choiceComponent, int n) {
        if (choiceComponent == null) {
            return defaultListModel;
        }
        ChoiceComponentChild[] choiceComponentChildArray = choiceComponent.getRateComponents();
        if (choiceComponentChildArray != null) {
            int n2 = n + 1;
            for (int i = 0; i < choiceComponentChildArray.length; ++i) {
                choiceComponentChildArray[i].setIndent(n);
                defaultListModel.addElement(choiceComponentChildArray[i]);
                RateComponent rateComponent = choiceComponentChildArray[i].getRateComponent();
                if (!(rateComponent instanceof ChoiceComponent)) continue;
                defaultListModel = RateComponentList.addChoiceComponentChildren(defaultListModel, (ChoiceComponent)rateComponent, n2);
            }
        }
        return defaultListModel;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.rateComponentDetails == null) {
            return;
        }
        RateComponent rateComponent = (RateComponent)this.getSelectedValue();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.rateComponentDetails.setRateComponentEditorValue(rateComponent);
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void saveRateComponent(RateComponent rateComponent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.custom == null) {
                return;
            }
            this.custom.addRateComponent(rateComponent);
            EasCostClient.storeRate(this.getSession(), this.custom);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public void deleteRateComponent(RateComponent rateComponent) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            if (this.custom == null) {
                return;
            }
            this.custom.removeRateComponent(rateComponent);
            EasCostClient.storeRate(this.getSession(), this.custom);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }
}

