/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.ui;

import com.tridium.eas.ui.widgets.NumberTextField;
import java.text.DecimalFormatSymbols;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class CostTextField
extends NumberTextField {
    public CostTextField(int n, boolean bl) {
        super(n, bl);
    }

    public float getFloatValue() {
        DecimalFormatSymbols decimalFormatSymbols;
        String string = this.getText();
        if (this.getFormatter() != null && (decimalFormatSymbols = this.getFormatter().getDecimalFormatSymbols()) != null) {
            char c = decimalFormatSymbols.getGroupingSeparator();
            string = CostTextField.replace(string, String.valueOf(c), "");
        }
        if (string.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(string);
    }

    public double getDoubleValue() {
        DecimalFormatSymbols decimalFormatSymbols;
        String string = this.getText();
        if (this.getFormatter() != null && (decimalFormatSymbols = this.getFormatter().getDecimalFormatSymbols()) != null) {
            char c = decimalFormatSymbols.getGroupingSeparator();
            string = CostTextField.replace(string, String.valueOf(c), "");
        }
        if (string.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    private static final String replace(String string, String string2, String string3) {
        if (string == null) {
            return "";
        }
        int n = string2.length();
        int n2 = string.length();
        int n3 = string.indexOf(string2);
        if (n3 < 0) {
            return string;
        }
        n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n3 < n2) {
            if (string.regionMatches(n3, string2, 0, n)) {
                stringBuffer.append(string3);
                n3 += n;
                continue;
            }
            stringBuffer.append(string.charAt(n3));
            ++n3;
        }
        string = stringBuffer.toString();
        return string;
    }

    protected Document createDefaultModel() {
        return new NumberDocument();
    }

    private class NumberDocument
    extends PlainDocument {
        private NumberDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null || CostTextField.this.getMaxLength() >= 0 && CostTextField.this.getText().length() + string.length() >= CostTextField.this.getMaxLength()) {
                return;
            }
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length];
            int n2 = 0;
            String string2 = CostTextField.this.getText();
            boolean bl = string2.indexOf(CostTextField.this.getFormatter().getDecimalFormatSymbols().getDecimalSeparator()) != -1;
            boolean bl2 = string2.indexOf(CostTextField.this.getFormatter().getDecimalFormatSymbols().getMinusSign()) != -1;
            DecimalFormatSymbols decimalFormatSymbols = CostTextField.this.getFormatter().getDecimalFormatSymbols();
            for (int i = 0; i < cArray2.length; ++i) {
                if (!(Character.isDigit(cArray[i]) || !bl && cArray[i] == decimalFormatSymbols.getDecimalSeparator() || n + n2 == 0 && cArray[i] == decimalFormatSymbols.getMinusSign() && CostTextField.this.getAllowNegative() && !bl2) && cArray[i] != decimalFormatSymbols.getGroupingSeparator()) continue;
                cArray2[n2++] = cArray[i];
                if (cArray[i] == decimalFormatSymbols.getDecimalSeparator()) {
                    bl = true;
                }
                if (cArray[i] != decimalFormatSymbols.getMinusSign()) continue;
                bl2 = true;
            }
            if (CostTextField.this.getMaxLength() < 0 || CostTextField.this.getText().length() + n2 <= CostTextField.this.getMaxLength()) {
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
        }
    }
}

