/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.report;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ProjectedCostInfo;
import com.tridium.eas.cost.report.ReconciliationNote;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.util.DBSpecific;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.baja.units.BUnit;

public class ReconciliationReport
implements XmlSupport {
    private String name = "-";
    private RateBillingPeriod[] rateBillingPeriods = null;
    private double miscCost = 0.0;
    private Hashtable actualCosts = new Hashtable();
    private Hashtable actualCostsSet = new Hashtable();
    private ReconciliationRow[] reconciliationRows = null;
    private ReconciliationNote[] reconciliationNotes = null;
    private ProjectedCostInfo lastProjection = null;
    public static String TYPE = "ReconciliationReport";
    public static String TOTAL_COST = "Total Cost 12345";
    public static String MISC_COST = "Miscellaneous Actual Cost 12345";
    public static String CATEGORY_CONSUMPTION_COST = "Category Consumption Cost 12345";
    public static String CATEGORY_DEMAND_COST = "Category Demand Cost 12345";
    public static String CATEGORY_OTHER_COST = "Category Other Cost 12345";
    public static String CATEGORY_USER_DEF1_COST = "Category UserDef1 Cost 12345";
    public static String CATEGORY_USER_DEF2_COST = "Category UserDef2 Cost 12345";
    public static String CATEGORY_USER_DEF3_COST = "Category UserDef3 Cost 12345";
    public static String CATEGORY_USER_DEF4_COST = "Category UserDef4 Cost 12345";

    public ReconciliationReport() {
    }

    public ReconciliationReport(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public RateBillingPeriod[] getRateBillingPeriods() {
        return this.rateBillingPeriods;
    }

    public void setRateBillingPeriods(RateBillingPeriod[] rateBillingPeriodArray) {
        this.rateBillingPeriods = rateBillingPeriodArray;
    }

    public void addRateBillingPeriod(RateBillingPeriod rateBillingPeriod) {
        if (this.rateBillingPeriods == null) {
            this.rateBillingPeriods = new RateBillingPeriod[1];
            this.rateBillingPeriods[0] = rateBillingPeriod;
            return;
        }
        RateBillingPeriod[] rateBillingPeriodArray = new RateBillingPeriod[this.rateBillingPeriods.length + 1];
        for (int i = 0; i < this.rateBillingPeriods.length; ++i) {
            rateBillingPeriodArray[i] = this.rateBillingPeriods[i];
        }
        rateBillingPeriodArray[this.rateBillingPeriods.length] = rateBillingPeriod;
        this.rateBillingPeriods = rateBillingPeriodArray;
    }

    public void removeRateBillingPeriod(RateBillingPeriod rateBillingPeriod) {
        if (this.rateBillingPeriods != null && this.rateBillingPeriods.length > 0) {
            int n = -1;
            for (int i = 0; i < this.rateBillingPeriods.length; ++i) {
                if (!this.rateBillingPeriods[i].equals(rateBillingPeriod)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                RateBillingPeriod[] rateBillingPeriodArray = new RateBillingPeriod[this.rateBillingPeriods.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.rateBillingPeriods.length; ++i) {
                    if (i == n) continue;
                    rateBillingPeriodArray[n2] = this.rateBillingPeriods[i];
                    ++n2;
                }
                this.rateBillingPeriods = rateBillingPeriodArray;
            }
        }
    }

    public double getMiscCost(boolean bl, double d) {
        double d2 = this.miscCost;
        if (bl) {
            d2 /= d;
        }
        return d2;
    }

    public void setMiscCost(double d) {
        this.miscCost = d;
    }

    public double getActualCost(String string) {
        Object v = this.actualCosts.get(string);
        if (v == null) {
            return 0.0;
        }
        return (Double)v;
    }

    public void setActualCost(String string, double d) {
        this.actualCosts.put(string, new Double(d));
        for (int i = 0; i < this.reconciliationRows.length; ++i) {
            if (!this.reconciliationRows[i].getName().equals(string)) continue;
            this.reconciliationRows[i].setActualCost(d);
        }
    }

    public boolean getActualCostSet(String string) {
        Object v = this.actualCostsSet.get(string);
        if (v == null) {
            return false;
        }
        return (Boolean)v;
    }

    public void setActualCostSet(String string, boolean bl) {
        this.actualCostsSet.put(string, new Boolean(bl));
        for (int i = 0; i < this.reconciliationRows.length; ++i) {
            if (!this.reconciliationRows[i].getName().equals(string)) continue;
            this.reconciliationRows[i].setActualCostSet(bl);
        }
    }

    public ReconciliationRow[] getReconciliationRows() {
        return this.reconciliationRows;
    }

    public void setReconciliationRows(ReconciliationRow[] reconciliationRowArray) {
        this.reconciliationRows = reconciliationRowArray;
    }

    public void addReconciliationRow(ReconciliationRow reconciliationRow) {
        if (this.reconciliationRows == null) {
            this.reconciliationRows = new ReconciliationRow[1];
            this.reconciliationRows[0] = reconciliationRow;
            return;
        }
        ReconciliationRow[] reconciliationRowArray = new ReconciliationRow[this.reconciliationRows.length + 1];
        for (int i = 0; i < this.reconciliationRows.length; ++i) {
            reconciliationRowArray[i] = this.reconciliationRows[i];
        }
        reconciliationRowArray[this.reconciliationRows.length] = reconciliationRow;
        this.reconciliationRows = reconciliationRowArray;
    }

    public void removeReconciliationRow(ReconciliationRow reconciliationRow) {
        if (this.reconciliationRows != null && this.reconciliationRows.length > 0) {
            int n = -1;
            for (int i = 0; i < this.reconciliationRows.length; ++i) {
                if (!this.reconciliationRows[i].equals(reconciliationRow)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                ReconciliationRow[] reconciliationRowArray = new ReconciliationRow[this.reconciliationRows.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.reconciliationRows.length; ++i) {
                    if (i == n) continue;
                    reconciliationRowArray[n2] = this.reconciliationRows[i];
                    ++n2;
                }
                this.reconciliationRows = reconciliationRowArray;
            }
        }
    }

    public ReconciliationNote[] getReconciliationNotes() {
        return this.reconciliationNotes;
    }

    public void setReconciliationNotes(ReconciliationNote[] reconciliationNoteArray) {
        this.reconciliationNotes = reconciliationNoteArray;
    }

    public void addNote(ReconciliationNote reconciliationNote) {
        if (reconciliationNote == null) {
            return;
        }
        if (this.reconciliationNotes == null) {
            this.reconciliationNotes = new ReconciliationNote[1];
            this.reconciliationNotes[0] = reconciliationNote;
            return;
        }
        ReconciliationNote[] reconciliationNoteArray = new ReconciliationNote[this.reconciliationNotes.length + 1];
        for (int i = 0; i < this.reconciliationNotes.length; ++i) {
            if (reconciliationNote.getName().equals(this.reconciliationNotes[i].getName())) {
                this.reconciliationNotes[i] = reconciliationNote;
                return;
            }
            reconciliationNoteArray[i] = this.reconciliationNotes[i];
        }
        reconciliationNoteArray[this.reconciliationNotes.length] = reconciliationNote;
        this.reconciliationNotes = reconciliationNoteArray;
    }

    public void removeNote(ReconciliationNote reconciliationNote) {
        if (this.reconciliationNotes != null && this.reconciliationNotes.length > 0) {
            int n = -1;
            for (int i = 0; i < this.reconciliationNotes.length; ++i) {
                if (!this.reconciliationNotes[i].equals(reconciliationNote)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                ReconciliationNote[] reconciliationNoteArray = new ReconciliationNote[this.reconciliationNotes.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.reconciliationNotes.length; ++i) {
                    if (i == n) continue;
                    reconciliationNoteArray[n2] = this.reconciliationNotes[i];
                    ++n2;
                }
                this.reconciliationNotes = reconciliationNoteArray;
            }
        }
    }

    public void runReport(String string, RateHistory rateHistory, Meter meter, boolean bl, boolean bl2, boolean bl3, BUnit bUnit, double d, boolean bl4, int n, double d2, boolean bl5, DataPoint dataPoint) {
        rateHistory.computeForInterval(string, this.getRateBillingPeriods(), meter, bl, bl2, bl3, bUnit, d, bl4, n, d2, bl5, dataPoint);
        this.generateRows(rateHistory);
    }

    public void runReport(String string, RateHistory rateHistory, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        rateHistory.computeForInterval(string, this.getRateBillingPeriods(), meterArray, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        this.generateRows(rateHistory);
    }

    public void generateRows(RateHistory rateHistory) {
        this.cacheActual();
        this.setReconciliationRows(null);
        Rate[] rateArray = rateHistory.getComputedRates();
        if (rateArray != null) {
            for (int i = 0; i < rateArray.length; ++i) {
                RateBillingPeriod rateBillingPeriod = ReconciliationReport.findMatchingRateBillingPeriod(this.getRateBillingPeriods(), rateArray[i].getName());
                if (rateBillingPeriod == null || !rateArray[i].isEffective(rateBillingPeriod.getStartTime(), rateBillingPeriod.getEndTime())) continue;
                this.addReconciliationRow(new ReconciliationRow(rateArray[i].getName()));
                RateComponent[] rateComponentArray = rateArray[i].getRateComponents();
                if (rateComponentArray == null) continue;
                String string = rateArray[i].getName();
                int n = string.length();
                BUnit bUnit = rateArray[i].getCurrency();
                BUnit bUnit2 = rateArray[i].getConsumptionUnits();
                BUnit bUnit3 = rateArray[i].getDemandUnits();
                BUnit bUnit4 = rateArray[i].getReactiveEnergyUnits();
                BUnit bUnit5 = rateArray[i].getApparentEnergyUnits();
                BUnit bUnit6 = rateArray[i].getReactivePowerUnits();
                BUnit bUnit7 = rateArray[i].getApparentPowerUnits();
                for (int j = 0; j < rateComponentArray.length; ++j) {
                    String string2 = string + rateComponentArray[j].getName();
                    BUnit bUnit8 = null;
                    switch (rateComponentArray[j].getApplicableData()) {
                        case 0: {
                            bUnit8 = bUnit2;
                            break;
                        }
                        case 1: {
                            bUnit8 = bUnit3;
                            break;
                        }
                        case 2: {
                            bUnit8 = bUnit4;
                            break;
                        }
                        case 4: {
                            bUnit8 = bUnit5;
                            break;
                        }
                        case 3: {
                            bUnit8 = bUnit6;
                            break;
                        }
                        case 5: {
                            bUnit8 = bUnit7;
                        }
                    }
                    this.addReconciliationRow(new ReconciliationRow(string2, n, (RateComponent)rateComponentArray[j].newCopy(), this.getActualCost(string2), this.getActualCostSet(string2), bUnit, bUnit8));
                }
            }
        }
    }

    private void cacheActual() {
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i] == null) continue;
                this.actualCosts.put(reconciliationRowArray[i].getName(), new Double(reconciliationRowArray[i].getActualCost(false, 1.0)));
                this.actualCostsSet.put(reconciliationRowArray[i].getName(), new Boolean(reconciliationRowArray[i].getActualCostSet()));
            }
        }
    }

    public static RateBillingPeriod findMatchingRateBillingPeriod(RateBillingPeriod[] rateBillingPeriodArray, String string) {
        if (rateBillingPeriodArray == null) {
            return null;
        }
        for (int i = 0; i < rateBillingPeriodArray.length; ++i) {
            if (!rateBillingPeriodArray[i].getName().equals(string)) continue;
            return rateBillingPeriodArray[i];
        }
        return null;
    }

    public double getTotalCalculatedCost() {
        double d = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                d += reconciliationRowArray[i].getCalculatedCost();
            }
        }
        return d;
    }

    public double getTotalActualCost(boolean bl, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                d2 += !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl, d);
            }
        }
        return d2 + this.getMiscCost(bl, d);
    }

    public double getTotalDeltaCost(boolean bl, double d) {
        return this.getTotalCalculatedCost() - this.getTotalActualCost(bl, d);
    }

    public double getAbsoluteTotalCalculatedCost() {
        double d = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                double d2 = reconciliationRowArray[i].getCalculatedCost();
                if (d2 < 0.0) {
                    d2 *= -1.0;
                }
                d += d2;
            }
        }
        return d;
    }

    public double getAbsoluteTotalActualCost(boolean bl, double d) {
        double d2;
        double d3 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                double d4;
                double d5 = d4 = !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl, d);
                if (d4 < 0.0) {
                    d4 *= -1.0;
                }
                d3 += d4;
            }
        }
        if ((d2 = this.getMiscCost(bl, d)) < 0.0) {
            d2 *= -1.0;
        }
        return d3 + d2;
    }

    public double getAbsoluteTotalDeltaCost(boolean bl, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                double d3 = reconciliationRowArray[i].getCalculatedCost() - (!reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl, d));
                if (d3 < 0.0) {
                    d3 *= -1.0;
                }
                d2 += d3;
            }
        }
        return d2;
    }

    public double getTotalConsumptionCost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 0) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getTotalDemandCost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 1) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getTotalOtherCost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 2) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getTotalUserDef1Cost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 3) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getTotalUserDef2Cost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 4) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getTotalUserDef3Cost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 5) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getTotalUserDef4Cost(boolean bl, boolean bl2, double d) {
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i].getRateComponent() == null || reconciliationRowArray[i].getRateComponent().getCategory() != 6) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public double getComponentCost(String string, boolean bl, boolean bl2, double d) {
        if (string.equals(TOTAL_COST)) {
            if (bl) {
                return this.getTotalCalculatedCost();
            }
            return this.getTotalActualCost(bl2, d);
        }
        if (string.equals(MISC_COST)) {
            return this.getMiscCost(bl2, d);
        }
        if (string.equals(CATEGORY_CONSUMPTION_COST)) {
            return this.getTotalConsumptionCost(bl, bl2, d);
        }
        if (string.equals(CATEGORY_DEMAND_COST)) {
            return this.getTotalDemandCost(bl, bl2, d);
        }
        if (string.equals(CATEGORY_OTHER_COST)) {
            return this.getTotalOtherCost(bl, bl2, d);
        }
        if (string.equals(CATEGORY_USER_DEF1_COST)) {
            return this.getTotalUserDef1Cost(bl, bl2, d);
        }
        if (string.equals(CATEGORY_USER_DEF2_COST)) {
            return this.getTotalUserDef2Cost(bl, bl2, d);
        }
        if (string.equals(CATEGORY_USER_DEF3_COST)) {
            return this.getTotalUserDef3Cost(bl, bl2, d);
        }
        if (string.equals(CATEGORY_USER_DEF4_COST)) {
            return this.getTotalUserDef4Cost(bl, bl2, d);
        }
        double d2 = 0.0;
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (!reconciliationRowArray[i].getComponentName().equalsIgnoreCase(string)) continue;
                d2 += bl || !reconciliationRowArray[i].getActualCostSet() ? reconciliationRowArray[i].getCalculatedCost() : reconciliationRowArray[i].getActualCost(bl2, d);
            }
        }
        return d2;
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        ReconciliationRow[] reconciliationRowArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nname: " + this.getName());
        stringBuffer.append("\n  miscCost: " + this.getMiscCost(false, 1.0));
        RateBillingPeriod[] rateBillingPeriodArray = this.getRateBillingPeriods();
        if (rateBillingPeriodArray != null) {
            for (int i = 0; i < rateBillingPeriodArray.length; ++i) {
                stringBuffer.append("\n   rateBillingPeriod[" + i + "]: " + rateBillingPeriodArray[i].toString());
            }
        }
        if ((reconciliationRowArray = this.getReconciliationRows()) != null) {
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                stringBuffer.append("\n    row[" + i + "]: " + reconciliationRowArray[i].toDebugString());
            }
        }
        return stringBuffer.toString();
    }

    public boolean isPartialReport() {
        long l = EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ);
        RateBillingPeriod[] rateBillingPeriodArray = this.getRateBillingPeriods();
        if (rateBillingPeriodArray != null && rateBillingPeriodArray.length > 0) {
            for (int i = 0; i < rateBillingPeriodArray.length; ++i) {
                if (rateBillingPeriodArray[i] == null || l >= rateBillingPeriodArray[i].getEndTime()) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public ProjectedCostInfo computeProjectedCosts(long l) {
        ReconciliationRow[] reconciliationRowArray = this.getReconciliationRows();
        if (reconciliationRowArray != null) {
            double d;
            double d2;
            RateBillingPeriod[] rateBillingPeriodArray = this.getRateBillingPeriods();
            String string = "";
            ProjectedCostInfo[] projectedCostInfoArray = new ProjectedCostInfo[reconciliationRowArray.length];
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (reconciliationRowArray[i] == null) continue;
                if (reconciliationRowArray[i].getShowCostColumns()) {
                    RateBillingPeriod rateBillingPeriod = ReconciliationReport.findMatchingRateBillingPeriod(rateBillingPeriodArray, string);
                    if (rateBillingPeriod == null) continue;
                    d2 = 1.0;
                    d = 0.0;
                    if (l >= rateBillingPeriod.getStartTime() && l < rateBillingPeriod.getEndTime()) {
                        d2 = (double)(rateBillingPeriod.getEndTime() - rateBillingPeriod.getStartTime()) / (double)(l - rateBillingPeriod.getStartTime());
                        d = (double)(l - rateBillingPeriod.getStartTime()) / (double)(rateBillingPeriod.getEndTime() - rateBillingPeriod.getStartTime());
                    } else if (l >= rateBillingPeriod.getEndTime()) {
                        d = 1.0;
                    }
                    projectedCostInfoArray[i] = new ProjectedCostInfo(reconciliationRowArray[i].computeProjectedCost(d2, this), d);
                    continue;
                }
                string = reconciliationRowArray[i].getName();
            }
            double d3 = 0.0;
            d2 = 0.0;
            d = 0.0;
            int n = 0;
            for (int i = 0; i < projectedCostInfoArray.length; ++i) {
                if (projectedCostInfoArray[i] == null) continue;
                d3 += projectedCostInfoArray[i].getProjectedCost();
                d += projectedCostInfoArray[i].getConfidenceFactor();
                ++n;
            }
            if (n > 0) {
                d2 = d / (double)n;
            }
            this.lastProjection = new ProjectedCostInfo(d3, d2);
            return this.lastProjection;
        }
        this.lastProjection = null;
        return this.lastProjection;
    }

    public ProjectedCostInfo getProjectedCosts() {
        return this.lastProjection;
    }

    public double getTotalProjectedCost() {
        double d = 0.0;
        if (this.lastProjection != null) {
            d = this.lastProjection.getProjectedCost();
        }
        return d;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("miscCost")) {
                this.setMiscCost(Double.valueOf(string2));
            }
        } else if (xmlSupport instanceof ReconciliationRow) {
            ReconciliationRow reconciliationRow = (ReconciliationRow)xmlSupport;
            this.addReconciliationRow(reconciliationRow);
            this.actualCosts.put(reconciliationRow.getName(), new Double(reconciliationRow.getActualCost(false, 1.0)));
            this.actualCostsSet.put(reconciliationRow.getName(), new Boolean(reconciliationRow.getActualCostSet()));
        } else if (xmlSupport instanceof RateBillingPeriod) {
            this.addRateBillingPeriod((RateBillingPeriod)xmlSupport);
        } else if (xmlSupport instanceof ReconciliationNote) {
            this.addNote((ReconciliationNote)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n;
        XmlSupport[] xmlSupportArray = this.getReconciliationRows();
        XmlSupport[] xmlSupportArray2 = this.getRateBillingPeriods();
        XmlSupport[] xmlSupportArray3 = this.getReconciliationNotes();
        XmlSupport[] xmlSupportArray4 = null;
        int n2 = 1;
        if (xmlSupportArray != null) {
            n2 += xmlSupportArray.length;
        }
        if (xmlSupportArray2 != null) {
            n2 += xmlSupportArray2.length;
        }
        if (xmlSupportArray3 != null) {
            n2 += xmlSupportArray3.length;
        }
        if (n2 <= 0) {
            return xmlSupportArray4;
        }
        xmlSupportArray4 = new XmlSupport[n2];
        xmlSupportArray4[0] = new XmlSimple("miscCost", String.valueOf(this.getMiscCost(false, 1.0)));
        int n3 = 1;
        if (xmlSupportArray != null) {
            for (n = 0; n < xmlSupportArray.length; ++n) {
                xmlSupportArray4[n3] = xmlSupportArray[n];
                ++n3;
            }
        }
        if (xmlSupportArray2 != null) {
            for (n = 0; n < xmlSupportArray2.length; ++n) {
                xmlSupportArray4[n3] = xmlSupportArray2[n];
                ++n3;
            }
        }
        if (xmlSupportArray3 != null) {
            for (n = 0; n < xmlSupportArray3.length; ++n) {
                xmlSupportArray4[n3] = xmlSupportArray3[n];
                ++n3;
            }
        }
        return xmlSupportArray4;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
        if (string == null) {
            return;
        }
        try {
            this.setMiscCost(Double.valueOf(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final ReconciliationReport consolidateReconciliations(ReconciliationReport[] reconciliationReportArray) {
        if (reconciliationReportArray == null || reconciliationReportArray.length <= 0) {
            return null;
        }
        if (reconciliationReportArray.length == 1) {
            return reconciliationReportArray[0];
        }
        ReconciliationReport reconciliationReport = reconciliationReportArray[0];
        for (int i = 1; i < reconciliationReportArray.length; ++i) {
            ReconciliationNote[] reconciliationNoteArray;
            int n;
            int n2;
            XmlSupport[] xmlSupportArray;
            reconciliationReport.setMiscCost(reconciliationReport.getMiscCost(false, 1.0) + reconciliationReportArray[i].getMiscCost(false, 1.0));
            RateBillingPeriod[] rateBillingPeriodArray = reconciliationReportArray[i].getRateBillingPeriods();
            if (rateBillingPeriodArray != null && rateBillingPeriodArray.length > 0) {
                xmlSupportArray = reconciliationReport.getRateBillingPeriods();
                for (int j = 0; j < rateBillingPeriodArray.length; ++j) {
                    if (rateBillingPeriodArray[j] == null) continue;
                    n2 = 0;
                    if (xmlSupportArray != null && xmlSupportArray.length > 0) {
                        for (n = 0; n < xmlSupportArray.length; ++n) {
                            if (xmlSupportArray[n] == null || !((RateBillingPeriod)xmlSupportArray[n]).getName().equals(rateBillingPeriodArray[j].getName())) continue;
                            n2 = 1;
                            break;
                        }
                    }
                    if (n2 != 0) continue;
                    reconciliationReport.addRateBillingPeriod(rateBillingPeriodArray[j]);
                }
            }
            if ((xmlSupportArray = reconciliationReportArray[i].getReconciliationRows()) != null && xmlSupportArray.length > 0) {
                ReconciliationRow[] reconciliationRowArray = reconciliationReport.getReconciliationRows();
                for (n2 = 0; n2 < xmlSupportArray.length; ++n2) {
                    if (xmlSupportArray[n2] == null) continue;
                    n = 0;
                    if (reconciliationRowArray != null && reconciliationRowArray.length > 0) {
                        for (int j = 0; j < reconciliationRowArray.length; ++j) {
                            String string;
                            if (reconciliationRowArray[j] == null || !(string = reconciliationRowArray[j].getName()).equals(((ReconciliationRow)xmlSupportArray[n2]).getName())) continue;
                            n = 1;
                            if (!reconciliationRowArray[j].getShowCostColumns()) break;
                            RateComponent rateComponent = reconciliationRowArray[j].getRateComponent();
                            if (rateComponent != null) {
                                rateComponent.setCalculatedCostForInterval(reconciliationRowArray[j].getCalculatedCost() + ((ReconciliationRow)xmlSupportArray[n2]).getCalculatedCost());
                            }
                            reconciliationReport.setActualCost(string, reconciliationReport.getActualCost(string) + ((ReconciliationRow)xmlSupportArray[n2]).getActualCost(false, 1.0));
                            reconciliationReport.setActualCostSet(string, reconciliationReport.getActualCostSet(string) || ((ReconciliationRow)xmlSupportArray[n2]).getActualCostSet());
                            break;
                        }
                    }
                    if (n != 0) continue;
                    reconciliationReport.addReconciliationRow((ReconciliationRow)xmlSupportArray[n2]);
                    reconciliationReport.actualCosts.put(((ReconciliationRow)xmlSupportArray[n2]).getName(), new Double(((ReconciliationRow)xmlSupportArray[n2]).getActualCost(false, 1.0)));
                    reconciliationReport.actualCostsSet.put(((ReconciliationRow)xmlSupportArray[n2]).getName(), new Boolean(((ReconciliationRow)xmlSupportArray[n2]).getActualCostSet()));
                }
            }
            if ((reconciliationNoteArray = reconciliationReportArray[i].getReconciliationNotes()) == null || reconciliationNoteArray.length <= 0) continue;
            for (n2 = 0; n2 < reconciliationNoteArray.length; ++n2) {
                if (reconciliationNoteArray[n2] == null) continue;
                reconciliationReport.addNote(reconciliationNoteArray[n2]);
            }
        }
        return reconciliationReport;
    }

    public void saveToRdb(int n, String string, Statement statement, DBSpecific dBSpecific) throws SQLException {
        int n2 = Dbx.parseBillCycleMonth(string);
        int n3 = Dbx.parseBillCycleYear(string);
        this.saveActualToRdb(n, n2, n3, statement, dBSpecific);
        this.saveMiscToRdb(n, n2, n3, statement, dBSpecific);
        this.saveBillCyclesToRdb(n, n2, n3, statement, dBSpecific);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveActualToRdb(int var1_1, int var2_2, int var3_3, Statement var4_4, DBSpecific var5_5) throws SQLException {
        var6_6 = this.getReconciliationRows();
        if (var6_6 == null) {
            return;
        }
        for (var7_7 = 0; var7_7 < var6_6.length; ++var7_7) {
            block15: {
                var8_8 = var6_6[var7_7];
                if (!var8_8.getShowCostColumns() || !var8_8.getActualCostSet()) continue;
                var9_9 = var8_8.getRateName();
                var10_10 = var8_8.getComponentName();
                var11_11 = var8_8.getActualCost(false, 1.0);
                var13_12 = false;
                var14_13 = null;
                try {
                    block14: {
                        var15_14 = "select COST from " + var5_5.getFullTableName("EAS", "ACTUAL_COSTS") + " where METER_ID=" + var1_1 + " and MONTH=" + var2_2 + " and YEAR=" + var3_3 + " and RATE_NAME=" + Dbx.str2db(var9_9) + " and COMP_NAME=" + Dbx.str2db(var10_10);
                        var14_13 = var4_4.executeQuery(var15_14);
                        if (!var14_13.next()) break block14;
                        var16_16 = var14_13.getDouble(1);
                        var13_12 = true;
                    }
                    var19_17 = null;
                    ** if (var14_13 == null) goto lbl-1000
                }
                catch (Throwable var18_19) {
                    var19_17 = null;
                    if (var14_13 != null) {
                        try {
                            var14_13.close();
                        }
                        catch (SQLException var20_18) {
                            var20_18.printStackTrace();
                        }
                    }
                    throw var18_19;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var14_13.close();
                    }
                    catch (SQLException var20_18) {
                        var20_18.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (SQLException var15_15) {
                        var15_15.printStackTrace();
                        var19_17 = null;
                        if (var14_13 != null) {
                            try {
                                var14_13.close();
                            }
                            catch (SQLException var20_18) {
                                var20_18.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (var13_12) {
                var15_14 = "update " + var5_5.getFullTableName("EAS", "ACTUAL_COSTS") + " set COST=" + var11_11 + " where METER_ID=" + var1_1 + " and MONTH=" + var2_2 + " and YEAR=" + var3_3 + " and RATE_NAME=" + Dbx.str2db(var9_9) + " and COMP_NAME=" + Dbx.str2db(var10_10);
                var4_4.executeUpdate(var15_14);
                continue;
            }
            var15_14 = "insert into " + var5_5.getFullTableName("EAS", "ACTUAL_COSTS") + " (METER_ID,MONTH,YEAR,RATE_NAME,COMP_NAME,COST) values (" + var1_1 + "," + var2_2 + "," + var3_3 + "," + Dbx.str2db(var9_9) + "," + Dbx.str2db(var10_10) + "," + var11_11 + ")";
            var4_4.executeUpdate(var15_14);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveMiscToRdb(int var1_1, int var2_2, int var3_3, Statement var4_4, DBSpecific var5_5) throws SQLException {
        block14: {
            var6_6 = false;
            var7_7 = null;
            try {
                block13: {
                    var8_8 = "select MISC_COST from " + var5_5.getFullTableName("EAS", "MISC_COSTS") + " where METER_ID=" + var1_1 + " and MONTH=" + var2_2 + " and YEAR=" + var3_3;
                    var7_7 = var4_4.executeQuery(var8_8);
                    if (!var7_7.next()) break block13;
                    var9_10 = var7_7.getDouble(1);
                    var6_6 = true;
                }
                var12_11 = null;
                ** if (var7_7 == null) goto lbl-1000
            }
            catch (Throwable var11_17) {
                var12_13 = null;
                if (var7_7 != null) {
                    try {
                        var7_7.close();
                    }
                    catch (SQLException var13_16) {
                        var13_16.printStackTrace();
                    }
                }
                throw var11_17;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var7_7.close();
                }
                catch (SQLException var13_14) {
                    var13_14.printStackTrace();
                }
            }
lbl-1000:
            // 2 sources

            {
                break block14;
                catch (SQLException var8_9) {
                    var8_9.printStackTrace();
                    var12_12 = null;
                    if (var7_7 != null) {
                        try {
                            var7_7.close();
                        }
                        catch (SQLException var13_15) {
                            var13_15.printStackTrace();
                        }
                    }
                }
            }
        }
        if (var6_6) {
            var8_8 = "update " + var5_5.getFullTableName("EAS", "MISC_COSTS") + " set MISC_COST=" + this.getMiscCost(false, 1.0) + " where METER_ID=" + var1_1 + " and MONTH=" + var2_2 + " and YEAR=" + var3_3;
            var4_4.executeUpdate(var8_8);
        } else {
            var8_8 = "insert into " + var5_5.getFullTableName("EAS", "MISC_COSTS") + " (METER_ID,MONTH,YEAR,MISC_COST) values (" + var1_1 + "," + var2_2 + "," + var3_3 + "," + this.getMiscCost(false, 1.0) + ")";
            var4_4.executeUpdate(var8_8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void saveBillCyclesToRdb(int var1_1, int var2_2, int var3_3, Statement var4_4, DBSpecific var5_5) throws SQLException {
        var6_6 = this.getRateBillingPeriods();
        if (var6_6 == null) {
            return;
        }
        for (var7_7 = 0; var7_7 < var6_6.length; ++var7_7) {
            block15: {
                var8_8 = var6_6[var7_7];
                var9_9 = var8_8.getName();
                var10_10 = var8_8.getStartTime();
                var12_11 = var8_8.getEndTime();
                var14_12 = false;
                var15_13 = null;
                try {
                    block14: {
                        var16_14 = "select START_TIME, END_TIME from " + var5_5.getFullTableName("EAS", "BILLING_CYCLES") + " where METER_ID=" + var1_1 + " and MONTH=" + var2_2 + " and YEAR=" + var3_3 + " and RATE_NAME=" + Dbx.str2db(var9_9);
                        var15_13 = var4_4.executeQuery(var16_14);
                        if (!var15_13.next()) break block14;
                        var17_16 = var15_13.getLong(1);
                        var17_16 = var15_13.getLong(2);
                        var14_12 = true;
                    }
                    var20_17 = null;
                    ** if (var15_13 == null) goto lbl-1000
                }
                catch (Throwable var19_19) {
                    var20_17 = null;
                    if (var15_13 != null) {
                        try {
                            var15_13.close();
                        }
                        catch (SQLException var21_18) {
                            var21_18.printStackTrace();
                        }
                    }
                    throw var19_19;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var15_13.close();
                    }
                    catch (SQLException var21_18) {
                        var21_18.printStackTrace();
                    }
                }
lbl-1000:
                // 2 sources

                {
                    break block15;
                    catch (SQLException var16_15) {
                        var16_15.printStackTrace();
                        var20_17 = null;
                        if (var15_13 != null) {
                            try {
                                var15_13.close();
                            }
                            catch (SQLException var21_18) {
                                var21_18.printStackTrace();
                            }
                        }
                    }
                }
            }
            if (var14_12) {
                var16_14 = "update " + var5_5.getFullTableName("EAS", "BILLING_CYCLES") + " set START_TIME=" + var10_10 + ",END_TIME=" + var12_11 + " where METER_ID=" + var1_1 + " and MONTH=" + var2_2 + " and YEAR=" + var3_3 + " and RATE_NAME=" + Dbx.str2db(var9_9);
                var4_4.executeUpdate(var16_14);
                continue;
            }
            var16_14 = "insert into " + var5_5.getFullTableName("EAS", "BILLING_CYCLES") + " (METER_ID,MONTH,YEAR,RATE_NAME,START_TIME,END_TIME) values (" + var1_1 + "," + var2_2 + "," + var3_3 + "," + Dbx.str2db(var9_9) + "," + var10_10 + "," + var12_11 + ")";
            var4_4.executeUpdate(var16_14);
        }
    }

    public static ReconciliationReport loadFromRdb(ReconciliationReport reconciliationReport, int n, String string, Statement statement, DBSpecific dBSpecific) throws SQLException {
        if (reconciliationReport == null) {
            return reconciliationReport;
        }
        int n2 = Dbx.parseBillCycleMonth(string);
        int n3 = Dbx.parseBillCycleYear(string);
        reconciliationReport = ReconciliationReport.loadActualFromRdb(reconciliationReport, n, n2, n3, statement, dBSpecific);
        reconciliationReport = ReconciliationReport.loadMiscFromRdb(reconciliationReport, n, n2, n3, statement, dBSpecific);
        reconciliationReport = ReconciliationReport.loadBillCyclesFromRdb(reconciliationReport, n, n2, n3, statement, dBSpecific);
        return reconciliationReport;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReconciliationReport loadActualFromRdb(ReconciliationReport reconciliationReport, int n, int n2, int n3, Statement statement, DBSpecific dBSpecific) throws SQLException {
        ReconciliationRow[] reconciliationRowArray = reconciliationReport.getReconciliationRows();
        if (reconciliationRowArray == null) {
            return reconciliationReport;
        }
        ResultSet resultSet = null;
        String string = "select RATE_NAME, COMP_NAME, COST from " + dBSpecific.getFullTableName("EAS", "ACTUAL_COSTS") + " where METER_ID=" + n + " and MONTH=" + n2 + " and YEAR=" + n3;
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            String string3 = resultSet.getString(2);
            double d = resultSet.getDouble(3);
            String string4 = string2 + string3;
            for (int i = 0; i < reconciliationRowArray.length; ++i) {
                if (!reconciliationRowArray[i].getName().equals(string4)) continue;
                reconciliationRowArray[i].setActualCost(d);
                reconciliationRowArray[i].setActualCostSet(true);
            }
        }
        Object var16_15 = null;
        if (resultSet == null) return reconciliationReport;
        try {
            resultSet.close();
            return reconciliationReport;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return reconciliationReport;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReconciliationReport loadMiscFromRdb(ReconciliationReport reconciliationReport, int n, int n2, int n3, Statement statement, DBSpecific dBSpecific) throws SQLException {
        ResultSet resultSet;
        block7: {
            resultSet = null;
            String string = "select MISC_COST from " + dBSpecific.getFullTableName("EAS", "MISC_COSTS") + " where METER_ID=" + n + " and MONTH=" + n2 + " and YEAR=" + n3;
            resultSet = statement.executeQuery(string);
            if (!resultSet.next()) break block7;
            reconciliationReport.setMiscCost(resultSet.getDouble(1));
        }
        Object var9_9 = null;
        if (resultSet == null) return reconciliationReport;
        try {
            resultSet.close();
            return reconciliationReport;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return reconciliationReport;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReconciliationReport loadBillCyclesFromRdb(ReconciliationReport reconciliationReport, int n, int n2, int n3, Statement statement, DBSpecific dBSpecific) throws SQLException {
        RateBillingPeriod[] rateBillingPeriodArray = reconciliationReport.getRateBillingPeriods();
        if (rateBillingPeriodArray == null) {
            return reconciliationReport;
        }
        ResultSet resultSet = null;
        String string = "select RATE_NAME, START_TIME, END_TIME from " + dBSpecific.getFullTableName("EAS", "BILLING_CYCLES") + " where METER_ID=" + n + " and MONTH=" + n2 + " and YEAR=" + n3;
        resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            long l = resultSet.getLong(2);
            long l2 = resultSet.getLong(3);
            RateBillingPeriod rateBillingPeriod = ReconciliationReport.findMatchingRateBillingPeriod(rateBillingPeriodArray, string2);
            rateBillingPeriod.setStartTime(l);
            rateBillingPeriod.setEndTime(l2);
        }
        Object var16_14 = null;
        if (resultSet == null) return reconciliationReport;
        try {
            resultSet.close();
            return reconciliationReport;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return reconciliationReport;
        {
            catch (SQLException sQLException) {
                throw sQLException;
            }
        }
        catch (Throwable throwable) {
            Object var16_15 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
            throw throwable;
        }
    }

    public static void deleteFromRdb(int n, String string, Statement statement, DBSpecific dBSpecific) throws SQLException {
        int n2 = Dbx.parseBillCycleMonth(string);
        int n3 = Dbx.parseBillCycleYear(string);
        String string2 = "delete from " + dBSpecific.getFullTableName("EAS", "ACTUAL_COSTS") + " where METER_ID=" + n + " and MONTH=" + n2 + " and YEAR=" + n3;
        statement.executeUpdate(string2);
        string2 = "delete from " + dBSpecific.getFullTableName("EAS", "MISC_COSTS") + " where METER_ID=" + n + " and MONTH=" + n2 + " and YEAR=" + n3;
        statement.executeUpdate(string2);
        string2 = "delete from " + dBSpecific.getFullTableName("EAS", "BILLING_CYCLES") + " where METER_ID=" + n + " and MONTH=" + n2 + " and YEAR=" + n3;
        statement.executeUpdate(string2);
    }
}

