/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.report;

import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.report.AnalyzerAdjustment;
import com.tridium.eas.cost.report.ReconciliationReport;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.util.Lexicon;

public class BillCycleResult
implements XmlSupport {
    private String name = "-";
    private String billingCycle = "Jan2004";
    private ReconciliationReport[] reconciliations = null;
    private AnalyzerAdjustment[] adjustments = null;
    public static String TYPE = "BillCycleResult";

    public BillCycleResult() {
    }

    public BillCycleResult(String string) {
        this.setName(string);
    }

    public BillCycleResult(String string, String string2, ReconciliationReport[] reconciliationReportArray) {
        this.setName(string);
        this.setBillingCycle(string2);
        this.setReconciliations(reconciliationReportArray, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public String getBillingCycle() {
        return this.billingCycle;
    }

    public void setBillingCycle(String string) {
        this.billingCycle = string;
    }

    public ReconciliationReport[] getReconciliations() {
        return this.reconciliations;
    }

    public void setReconciliations(ReconciliationReport[] reconciliationReportArray, boolean bl) {
        this.reconciliations = reconciliationReportArray;
        if (bl) {
            this.setAdjustments(null);
            if (this.reconciliations != null) {
                for (int i = 0; i < this.reconciliations.length; ++i) {
                    ReconciliationRow[] reconciliationRowArray;
                    if (this.reconciliations[i] == null || (reconciliationRowArray = this.reconciliations[i].getReconciliationRows()) == null) continue;
                    RateBillingPeriod[] rateBillingPeriodArray = this.reconciliations[i].getRateBillingPeriods();
                    long l = 0L;
                    long l2 = 0L;
                    for (int j = 0; j < reconciliationRowArray.length; ++j) {
                        RateBillingPeriod rateBillingPeriod;
                        if (reconciliationRowArray[j] == null) continue;
                        if (!reconciliationRowArray[j].getShowCostColumns() && (rateBillingPeriod = ReconciliationReport.findMatchingRateBillingPeriod(rateBillingPeriodArray, reconciliationRowArray[j].getName())) != null) {
                            l = rateBillingPeriod.getStartTime();
                            l2 = rateBillingPeriod.getEndTime();
                        }
                        this.addAdjustment(new AnalyzerAdjustment(reconciliationRowArray[j], this.reconciliations[i].getName(), l, l2));
                    }
                }
            }
        }
    }

    public void addReconciliation(ReconciliationReport reconciliationReport, boolean bl) {
        XmlSupport[] xmlSupportArray;
        if (bl && reconciliationReport != null && (xmlSupportArray = reconciliationReport.getReconciliationRows()) != null) {
            RateBillingPeriod[] rateBillingPeriodArray = reconciliationReport.getRateBillingPeriods();
            long l = 0L;
            long l2 = 0L;
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                RateBillingPeriod rateBillingPeriod;
                if (xmlSupportArray[i] == null) continue;
                if (!((ReconciliationRow)xmlSupportArray[i]).getShowCostColumns() && (rateBillingPeriod = ReconciliationReport.findMatchingRateBillingPeriod(rateBillingPeriodArray, ((ReconciliationRow)xmlSupportArray[i]).getName())) != null) {
                    l = rateBillingPeriod.getStartTime();
                    l2 = rateBillingPeriod.getEndTime();
                }
                this.addAdjustment(new AnalyzerAdjustment((ReconciliationRow)xmlSupportArray[i], reconciliationReport.getName(), l, l2));
            }
        }
        if (this.reconciliations == null) {
            this.reconciliations = new ReconciliationReport[1];
            this.reconciliations[0] = reconciliationReport;
            return;
        }
        xmlSupportArray = new ReconciliationReport[this.reconciliations.length + 1];
        for (int i = 0; i < this.reconciliations.length; ++i) {
            xmlSupportArray[i] = this.reconciliations[i];
        }
        xmlSupportArray[this.reconciliations.length] = reconciliationReport;
        this.reconciliations = xmlSupportArray;
    }

    public AnalyzerAdjustment[] getAdjustments() {
        return this.adjustments;
    }

    public void setAdjustments(AnalyzerAdjustment[] analyzerAdjustmentArray) {
        this.adjustments = analyzerAdjustmentArray;
    }

    public void addAdjustment(AnalyzerAdjustment analyzerAdjustment) {
        if (this.adjustments == null) {
            this.adjustments = new AnalyzerAdjustment[1];
            this.adjustments[0] = analyzerAdjustment;
            return;
        }
        AnalyzerAdjustment[] analyzerAdjustmentArray = new AnalyzerAdjustment[this.adjustments.length + 1];
        for (int i = 0; i < this.adjustments.length; ++i) {
            analyzerAdjustmentArray[i] = this.adjustments[i];
        }
        analyzerAdjustmentArray[this.adjustments.length] = analyzerAdjustment;
        this.adjustments = analyzerAdjustmentArray;
    }

    public void resetComponents() {
        AnalyzerAdjustment[] analyzerAdjustmentArray = this.getAdjustments();
        if (analyzerAdjustmentArray != null) {
            for (int i = 0; i < analyzerAdjustmentArray.length; ++i) {
                analyzerAdjustmentArray[i].resetComponents();
            }
        }
    }

    public String getBillingCycle(Lexicon lexicon) {
        String string = this.getBillingCycle();
        String string2 = string.substring(0, 3);
        String string3 = string.substring(3);
        return lexicon.getText(string2) + " " + string3;
    }

    public double getCalculatedCost() {
        AnalyzerAdjustment[] analyzerAdjustmentArray = this.getAdjustments();
        double d = 0.0;
        if (analyzerAdjustmentArray != null) {
            for (int i = 0; i < analyzerAdjustmentArray.length; ++i) {
                d += analyzerAdjustmentArray[i].getCalculatedCost();
            }
        }
        return d;
    }

    public double getAdjustedCost() {
        AnalyzerAdjustment[] analyzerAdjustmentArray = this.getAdjustments();
        double d = 0.0;
        if (analyzerAdjustmentArray != null) {
            for (int i = 0; i < analyzerAdjustmentArray.length; ++i) {
                d += analyzerAdjustmentArray[i].getAdjustedCost();
            }
        }
        return d;
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        AnalyzerAdjustment[] analyzerAdjustmentArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nname: " + this.getName());
        stringBuffer.append("\n  billingCycle: " + this.getBillingCycle());
        ReconciliationReport[] reconciliationReportArray = this.getReconciliations();
        if (reconciliationReportArray != null) {
            for (int i = 0; i < reconciliationReportArray.length; ++i) {
                stringBuffer.append("\n   reconciliation[" + i + "]: " + reconciliationReportArray[i].toDebugString());
            }
        }
        if ((analyzerAdjustmentArray = this.getAdjustments()) != null) {
            for (int i = 0; i < analyzerAdjustmentArray.length; ++i) {
                stringBuffer.append("\n    adjustment[" + i + "]: " + analyzerAdjustmentArray[i].toDebugString());
            }
        }
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("billingCycle")) {
                this.setBillingCycle(string2);
            }
        } else if (xmlSupport instanceof ReconciliationReport) {
            this.addReconciliation((ReconciliationReport)xmlSupport, false);
        } else if (xmlSupport instanceof AnalyzerAdjustment) {
            this.addAdjustment((AnalyzerAdjustment)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n;
        XmlSupport[] xmlSupportArray = this.getReconciliations();
        XmlSupport[] xmlSupportArray2 = this.getAdjustments();
        XmlSupport[] xmlSupportArray3 = null;
        int n2 = 1;
        if (xmlSupportArray != null) {
            n2 += xmlSupportArray.length;
        }
        if (xmlSupportArray2 != null) {
            n2 += xmlSupportArray2.length;
        }
        if (n2 <= 0) {
            return xmlSupportArray3;
        }
        xmlSupportArray3 = new XmlSupport[n2];
        xmlSupportArray3[0] = new XmlSimple("billingCycle", this.getBillingCycle());
        int n3 = 1;
        if (xmlSupportArray != null) {
            for (n = 0; n < xmlSupportArray.length; ++n) {
                xmlSupportArray3[n3] = xmlSupportArray[n];
                ++n3;
            }
        }
        if (xmlSupportArray2 != null) {
            for (n = 0; n < xmlSupportArray2.length; ++n) {
                xmlSupportArray3[n3] = xmlSupportArray2[n];
                ++n3;
            }
        }
        return xmlSupportArray3;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

