/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.report;

import com.tridium.eas.cost.report.BillCycleResult;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.util.StringTokenizer;

public class AnalyzerReport
implements XmlSupport {
    private String name = "-";
    private String startingBillingCycle = "Jan2004";
    private int numCycles = 1;
    private int[] meterIds = null;
    private BillCycleResult[] cycleResults = null;
    private boolean dataCleanse = false;
    private int dataCleanseWindow = 4;
    private double dataCleansePercentage = 100.0;
    public static String TYPE = "AnalyzerReport";

    public AnalyzerReport() {
    }

    public AnalyzerReport(String string) {
        this.setName(string);
    }

    public AnalyzerReport(String string, String string2, int n, int[] nArray, BillCycleResult[] billCycleResultArray, boolean bl, int n2, double d) {
        this.setName(string);
        this.setStartingBillingCycle(string2);
        this.setNumCycles(n);
        this.setMeterIds(nArray);
        this.setCycleResults(billCycleResultArray);
        this.setDataCleanse(bl);
        this.setDataCleanseWindow(n2);
        this.setDataCleansePercentage(d);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public String getStartingBillingCycle() {
        return this.startingBillingCycle;
    }

    public void setStartingBillingCycle(String string) {
        this.startingBillingCycle = string;
    }

    public int getNumCycles() {
        return this.numCycles;
    }

    public void setNumCycles(int n) {
        this.numCycles = n;
    }

    public int[] getMeterIds() {
        return this.meterIds;
    }

    public void setMeterIds(int[] nArray) {
        this.meterIds = nArray;
    }

    public void addMeterId(int n) {
        if (this.meterIds == null) {
            this.meterIds = new int[1];
            this.meterIds[0] = n;
            return;
        }
        int[] nArray = new int[this.meterIds.length + 1];
        for (int i = 0; i < this.meterIds.length; ++i) {
            nArray[i] = this.meterIds[i];
        }
        nArray[this.meterIds.length] = n;
        this.meterIds = nArray;
    }

    public void removeMeterId(int n) {
        if (this.meterIds != null && this.meterIds.length > 0) {
            int n2 = -1;
            for (int i = 0; i < this.meterIds.length; ++i) {
                if (this.meterIds[i] != n) continue;
                n2 = i;
                break;
            }
            if (n2 >= 0) {
                int[] nArray = new int[this.meterIds.length - 1];
                int n3 = 0;
                for (int i = 0; i < this.meterIds.length; ++i) {
                    if (i == n2) continue;
                    nArray[n3] = this.meterIds[i];
                    ++n3;
                }
                this.meterIds = nArray;
            }
        }
    }

    public BillCycleResult[] getCycleResults() {
        return this.cycleResults;
    }

    public void setCycleResults(BillCycleResult[] billCycleResultArray) {
        this.cycleResults = billCycleResultArray;
    }

    public void addCycleResult(BillCycleResult billCycleResult) {
        if (this.cycleResults == null) {
            this.cycleResults = new BillCycleResult[1];
            this.cycleResults[0] = billCycleResult;
            return;
        }
        BillCycleResult[] billCycleResultArray = new BillCycleResult[this.cycleResults.length + 1];
        for (int i = 0; i < this.cycleResults.length; ++i) {
            billCycleResultArray[i] = this.cycleResults[i];
        }
        billCycleResultArray[this.cycleResults.length] = billCycleResult;
        this.cycleResults = billCycleResultArray;
    }

    public boolean getDataCleanse() {
        return this.dataCleanse;
    }

    public void setDataCleanse(boolean bl) {
        this.dataCleanse = bl;
    }

    public int getDataCleanseWindow() {
        return this.dataCleanseWindow;
    }

    public void setDataCleanseWindow(int n) {
        this.dataCleanseWindow = n;
    }

    public double getDataCleansePercentage() {
        return this.dataCleansePercentage;
    }

    public void setDataCleansePercentage(double d) {
        this.dataCleansePercentage = d;
    }

    public void resetComponents() {
        BillCycleResult[] billCycleResultArray = this.getCycleResults();
        if (billCycleResultArray != null) {
            for (int i = 0; i < billCycleResultArray.length; ++i) {
                billCycleResultArray[i].resetComponents();
            }
        }
    }

    public double getTotalCalculatedCost() {
        BillCycleResult[] billCycleResultArray = this.getCycleResults();
        double d = 0.0;
        if (billCycleResultArray != null) {
            for (int i = 0; i < billCycleResultArray.length; ++i) {
                d += billCycleResultArray[i].getCalculatedCost();
            }
        }
        return d;
    }

    public double getTotalAdjustedCost() {
        BillCycleResult[] billCycleResultArray = this.getCycleResults();
        double d = 0.0;
        if (billCycleResultArray != null) {
            for (int i = 0; i < billCycleResultArray.length; ++i) {
                d += billCycleResultArray[i].getAdjustedCost();
            }
        }
        return d;
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        BillCycleResult[] billCycleResultArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nname: " + this.getName());
        stringBuffer.append("\n  startingBillingCycle: " + this.getStartingBillingCycle());
        stringBuffer.append("\n  numCycles: " + this.getNumCycles());
        int[] nArray = this.getMeterIds();
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append("\n   meterIds[" + i + "]: " + nArray[i]);
            }
        }
        if ((billCycleResultArray = this.getCycleResults()) != null) {
            for (int i = 0; i < billCycleResultArray.length; ++i) {
                stringBuffer.append("\n    cycleResults[" + i + "]: " + billCycleResultArray[i].toDebugString());
            }
        }
        stringBuffer.append("\n  dataCleanse: " + this.getDataCleanse());
        stringBuffer.append("\n  dataCleanseWindow: " + this.getDataCleanseWindow());
        stringBuffer.append("\n  dataCleansePercentage: " + this.getDataCleansePercentage());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("startingBillingCycle")) {
                this.setStartingBillingCycle(string2);
            } else if (string.equals("numCycles")) {
                this.setNumCycles(Integer.parseInt(string2));
            } else if (string.equals("meterIds")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n <= 0) {
                    return;
                }
                int[] nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = Integer.parseInt(stringTokenizer.nextToken());
                }
                this.setMeterIds(nArray);
            } else if (string.equals("dataCleanse")) {
                this.setDataCleanse(Boolean.valueOf(string2));
            } else if (string.equals("dataCleanseWindow")) {
                this.setDataCleanseWindow(Integer.parseInt(string2));
            } else if (string.equals("dataCleansePercentage")) {
                this.setDataCleansePercentage(Double.valueOf(string2));
            }
        } else if (xmlSupport instanceof BillCycleResult) {
            this.addCycleResult((BillCycleResult)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n;
        XmlSupport[] xmlSupportArray = this.getCycleResults();
        XmlSupport[] xmlSupportArray2 = null;
        int n2 = 6;
        if (xmlSupportArray != null) {
            n2 += xmlSupportArray.length;
        }
        if (n2 <= 0) {
            return xmlSupportArray2;
        }
        xmlSupportArray2 = new XmlSupport[n2];
        xmlSupportArray2[0] = new XmlSimple("startingBillingCycle", this.getStartingBillingCycle());
        xmlSupportArray2[1] = new XmlSimple("numCycles", String.valueOf(this.getNumCycles()));
        int[] nArray = this.getMeterIds();
        int n3 = 0;
        if (nArray != null) {
            n3 = nArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(n3));
        if (nArray != null) {
            for (n = 0; n < n3; ++n) {
                stringBuffer.append(";" + nArray[n]);
            }
        }
        xmlSupportArray2[2] = new XmlSimple("meterIds", stringBuffer.toString());
        xmlSupportArray2[3] = new XmlSimple("dataCleanse", String.valueOf(this.getDataCleanse()));
        xmlSupportArray2[4] = new XmlSimple("dataCleanseWindow", String.valueOf(this.getDataCleanseWindow()));
        xmlSupportArray2[5] = new XmlSimple("dataCleansePercentage", String.valueOf(this.getDataCleansePercentage()));
        n = 6;
        if (xmlSupportArray != null) {
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                xmlSupportArray2[n] = xmlSupportArray[i];
                ++n;
            }
        }
        return xmlSupportArray2;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

