/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.report;

import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.rate.components.ScheduledDemandCharge;
import com.tridium.eas.cost.rate.components.ScheduledFeePerUnit;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;

public class AnalyzerAdjustment
implements XmlSupport {
    private String name = "-";
    private boolean feeExists = false;
    private double feePerUnit = 0.0;
    private boolean unitsExist = false;
    private double calcUnits = 1.0;
    private ReconciliationRow reconciliationRow = null;
    private long startTime = 0L;
    private long endTime = 0L;
    public static String TYPE = "AnalyzerAdjustment";

    public AnalyzerAdjustment() {
    }

    public AnalyzerAdjustment(String string) {
        this.setName(string);
    }

    public AnalyzerAdjustment(ReconciliationRow reconciliationRow, String string, long l, long l2) {
        this.setReconciliationRow(reconciliationRow);
        this.setStartTime(l);
        this.setEndTime(l2);
        if (reconciliationRow == null) {
            return;
        }
        if (reconciliationRow.getShowCostColumns()) {
            this.setName(reconciliationRow.getFullName());
            RateComponent rateComponent = reconciliationRow.getRateComponent();
            if (rateComponent != null) {
                if (rateComponent instanceof ChoiceComponentChild && (rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent()) == null) {
                    return;
                }
                this.feeExists = true;
                this.feePerUnit = rateComponent.getCalculatedCostForInterval();
                if (rateComponent instanceof FlatFeePerUnit) {
                    this.calcUnits = ((FlatFeePerUnit)rateComponent).getCalculatedUnits();
                    if (((FlatFeePerUnit)rateComponent).getDataRangeApproach() == 0) {
                        this.calcUnits = ((FlatFeePerUnit)rateComponent).getCalculatedUnits() < ((FlatFeePerUnit)rateComponent).getMinDataValue() ? 0.0 : (((FlatFeePerUnit)rateComponent).getCalculatedUnits() > ((FlatFeePerUnit)rateComponent).getMaxDataValue() ? ((FlatFeePerUnit)rateComponent).getMaxDataValue() - ((FlatFeePerUnit)rateComponent).getMinDataValue() : (this.calcUnits -= ((FlatFeePerUnit)rateComponent).getMinDataValue()));
                    } else if (((FlatFeePerUnit)rateComponent).getDataRangeApproach() == 1 && (((FlatFeePerUnit)rateComponent).getCalculatedUnits() < ((FlatFeePerUnit)rateComponent).getMinDataValue() || ((FlatFeePerUnit)rateComponent).getCalculatedUnits() >= ((FlatFeePerUnit)rateComponent).getMaxDataValue())) {
                        this.calcUnits = 0.0;
                    }
                    this.unitsExist = true;
                    if (rateComponent instanceof ScheduledFeePerUnit || rateComponent instanceof ScheduledDemandCharge) {
                        long l3 = 0L;
                        double d = 0.0;
                        if (rateComponent instanceof ScheduledFeePerUnit) {
                            l3 = ((ScheduledFeePerUnit)rateComponent).getTransitionTime();
                            d = ((ScheduledFeePerUnit)rateComponent).getNewFee();
                        } else {
                            l3 = ((ScheduledDemandCharge)rateComponent).getTransitionTime();
                            d = ((ScheduledDemandCharge)rateComponent).getNewFee();
                        }
                        this.feePerUnit = l3 < this.getStartTime() ? d / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee() : (l3 > this.getEndTime() ? ((FlatFeePerUnit)rateComponent).getFee() / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee() : (this.calcUnits != 0.0 ? this.getCalculatedCost() / this.calcUnits : d / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee()));
                    } else {
                        this.feePerUnit = ((FlatFeePerUnit)rateComponent).getFee() / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee();
                        if (this.feePerUnit != 0.0 && (rateComponent.getType().equals("PeakChargePerDay") || rateComponent.getType().equals("TwelveMonthRatchet"))) {
                            this.calcUnits = rateComponent.getCalculatedCostForInterval() / this.feePerUnit;
                        }
                    }
                }
            }
        } else {
            this.setName(string + reconciliationRow.getFullName());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean getFeeExists() {
        return this.feeExists;
    }

    public void setFeeExists(boolean bl) {
        this.feeExists = bl;
    }

    public double getFeePerUnit() {
        return this.feePerUnit;
    }

    public void setFeePerUnit(double d) {
        this.feePerUnit = d;
    }

    public boolean getUnitsExist() {
        return this.unitsExist;
    }

    public void setUnitsExist(boolean bl) {
        this.unitsExist = bl;
    }

    public double getCalcUnits() {
        return this.calcUnits;
    }

    public void setCalcUnits(double d) {
        this.calcUnits = d;
    }

    public ReconciliationRow getReconciliationRow() {
        return this.reconciliationRow;
    }

    public void setReconciliationRow(ReconciliationRow reconciliationRow) {
        this.reconciliationRow = reconciliationRow;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.startTime = l;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.endTime = l;
    }

    public void resetComponents() {
        RateComponent rateComponent;
        this.feeExists = false;
        this.feePerUnit = 0.0;
        this.unitsExist = false;
        this.calcUnits = 1.0;
        ReconciliationRow reconciliationRow = this.getReconciliationRow();
        if (reconciliationRow == null) {
            return;
        }
        if (reconciliationRow.getShowCostColumns() && (rateComponent = reconciliationRow.getRateComponent()) != null) {
            if (rateComponent instanceof ChoiceComponentChild && (rateComponent = ((ChoiceComponentChild)rateComponent).getRateComponent()) == null) {
                return;
            }
            this.feeExists = true;
            this.feePerUnit = rateComponent.getCalculatedCostForInterval();
            if (rateComponent instanceof FlatFeePerUnit) {
                this.calcUnits = ((FlatFeePerUnit)rateComponent).getCalculatedUnits();
                if (((FlatFeePerUnit)rateComponent).getDataRangeApproach() == 0) {
                    this.calcUnits = ((FlatFeePerUnit)rateComponent).getCalculatedUnits() < ((FlatFeePerUnit)rateComponent).getMinDataValue() ? 0.0 : (((FlatFeePerUnit)rateComponent).getCalculatedUnits() > ((FlatFeePerUnit)rateComponent).getMaxDataValue() ? ((FlatFeePerUnit)rateComponent).getMaxDataValue() - ((FlatFeePerUnit)rateComponent).getMinDataValue() : (this.calcUnits -= ((FlatFeePerUnit)rateComponent).getMinDataValue()));
                } else if (((FlatFeePerUnit)rateComponent).getDataRangeApproach() == 1 && (((FlatFeePerUnit)rateComponent).getCalculatedUnits() < ((FlatFeePerUnit)rateComponent).getMinDataValue() || ((FlatFeePerUnit)rateComponent).getCalculatedUnits() >= ((FlatFeePerUnit)rateComponent).getMaxDataValue())) {
                    this.calcUnits = 0.0;
                }
                this.unitsExist = true;
                if (rateComponent instanceof ScheduledFeePerUnit || rateComponent instanceof ScheduledDemandCharge) {
                    long l = 0L;
                    double d = 0.0;
                    if (rateComponent instanceof ScheduledFeePerUnit) {
                        l = ((ScheduledFeePerUnit)rateComponent).getTransitionTime();
                        d = ((ScheduledFeePerUnit)rateComponent).getNewFee();
                    } else {
                        l = ((ScheduledDemandCharge)rateComponent).getTransitionTime();
                        d = ((ScheduledDemandCharge)rateComponent).getNewFee();
                    }
                    this.feePerUnit = l < this.getStartTime() ? d / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee() : (l > this.getEndTime() ? ((FlatFeePerUnit)rateComponent).getFee() / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee() : (this.calcUnits != 0.0 ? this.getCalculatedCost() / this.calcUnits : d / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee()));
                } else {
                    this.feePerUnit = ((FlatFeePerUnit)rateComponent).getFee() / (double)((FlatFeePerUnit)rateComponent).getUnitsInFee();
                    if (this.feePerUnit != 0.0 && (rateComponent.getType().equals("PeakChargePerDay") || rateComponent.getType().equals("TwelveMonthRatchet"))) {
                        this.calcUnits = rateComponent.getCalculatedCostForInterval() / this.feePerUnit;
                    }
                }
            }
        }
    }

    public double getCalculatedCost() {
        double d = 0.0;
        if (this.getReconciliationRow() != null) {
            d = this.getReconciliationRow().getCalculatedCost();
        }
        return d;
    }

    public double getAdjustedCost() {
        double d = 0.0;
        if (this.getFeeExists()) {
            d = this.getFeePerUnit();
            if (this.getUnitsExist()) {
                d *= this.getCalcUnits();
            }
        }
        return d;
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nname: " + this.getName());
        stringBuffer.append("\n  feeExists: " + this.getFeeExists());
        stringBuffer.append("\n  feePerUnit: " + this.getFeePerUnit());
        stringBuffer.append("\n  unitsExist: " + this.getUnitsExist());
        stringBuffer.append("\n  calcUnits: " + this.getCalcUnits());
        stringBuffer.append("\n  reconciliationRow: " + this.getReconciliationRow().toDebugString());
        stringBuffer.append("\n  startTime: " + this.getStartTime());
        stringBuffer.append("\n  endTime: " + this.getEndTime());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("feeExists")) {
                this.setFeeExists(Boolean.valueOf(string2));
            } else if (string.equals("feePerUnit")) {
                this.setFeePerUnit(Double.valueOf(string2));
            } else if (string.equals("unitsExist")) {
                this.setUnitsExist(Boolean.valueOf(string2));
            } else if (string.equals("calcUnits")) {
                this.setCalcUnits(Double.valueOf(string2));
            } else if (string.equals("startTime")) {
                this.setStartTime(Long.parseLong(string2));
            } else if (string.equals("endTime")) {
                this.setEndTime(Long.parseLong(string2));
            }
        } else if (xmlSupport instanceof ReconciliationRow) {
            this.setReconciliationRow((ReconciliationRow)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 6;
        if (this.getReconciliationRow() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("feeExists", String.valueOf(this.getFeeExists()));
        xmlSupportArray[1] = new XmlSimple("feePerUnit", String.valueOf(this.getFeePerUnit()));
        xmlSupportArray[2] = new XmlSimple("unitsExist", String.valueOf(this.getUnitsExist()));
        xmlSupportArray[3] = new XmlSimple("calcUnits", String.valueOf(this.getCalcUnits()));
        xmlSupportArray[4] = new XmlSimple("startTime", String.valueOf(this.getStartTime()));
        xmlSupportArray[5] = new XmlSimple("endTime", String.valueOf(this.getEndTime()));
        if (this.getReconciliationRow() != null) {
            xmlSupportArray[6] = this.getReconciliationRow();
        }
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

