/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.CostTextField;
import com.tridium.eas.cost.ui.RateComponentDetailPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PercentageFeePerUnit
extends FlatFeePerUnit
implements CustomRateComponent {
    private double percentConsumption = 100.0;
    public static String TYPE = "PercentageFeePerUnit";
    private CostTextField percentageTextField;

    public PercentageFeePerUnit() {
    }

    public PercentageFeePerUnit(String string) {
        super(string);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((PercentageFeePerUnit)rateComponent).setPercentConsumption(this.getPercentConsumption());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new PercentageFeePerUnit());
    }

    public double getPercentConsumption() {
        return this.percentConsumption;
    }

    public void setPercentConsumption(double d) {
        this.setComputeFromScratch(true);
        this.percentConsumption = d;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        try {
            RawCostData rawCostData10 = null;
            long l3 = 0L;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    l3 = 450000L;
                    l += l3;
                    l2 += l3;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    l3 = 450000L;
                    l += l3;
                    l2 += l3;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    l3 = 450000L;
                    l += l3;
                    l2 += l3;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                }
            }
            Result result = rawCostData10.get(l, l2);
            Record record = rawCostData10.createRecord();
            double d2 = 0.0;
            record = result.next(record);
            while (record != null) {
                long l4;
                if (record instanceof DoubleRecord && this.isEffective((l4 = record.getTimestamp()) - l3, ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l4, l, l2) && this.getParentRate().includes(l4 - l3, this.getTimeZone()) && PercentageFeePerUnit.validStatus(record.getStatus())) {
                    d2 += ((DoubleRecord)record).getDoubleValue();
                }
                record = result.next(record);
            }
            this.setCalculatedUnits(d2 *= this.getPercentConsumption() / 100.0);
            if (this.getDataRangeApproach() == 0) {
                if (d2 < this.getMinDataValue()) {
                    return 0.0;
                }
                d2 = d2 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d2 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d2 < this.getMinDataValue() || d2 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d3 = d2 / (double)this.getUnitsInFee();
            return this.getFee() * d3;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in PercentageFeePerUnit.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      percentConsumption: " + this.getPercentConsumption());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else if (string.equals("percentConsumption")) {
                this.setPercentConsumption(Double.valueOf(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 11;
        if (this.getRateSchedule() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("fee", String.valueOf(this.getFee()));
        xmlSupportArray[4] = new XmlSimple("minDataValue", String.valueOf(this.getMinDataValue()));
        xmlSupportArray[5] = new XmlSimple("maxDataValue", String.valueOf(this.getMaxDataValue()));
        xmlSupportArray[6] = new XmlSimple("unitsInFee", String.valueOf(this.getUnitsInFee()));
        xmlSupportArray[7] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray[8] = new XmlSimple("calculatedUnits", String.valueOf(this.getCalculatedUnits()));
        xmlSupportArray[9] = new XmlSimple("dataRangeApproach", String.valueOf(this.getDataRangeApproach()));
        xmlSupportArray[10] = new XmlSimple("percentConsumption", String.valueOf(this.getPercentConsumption()));
        if (this.getRateSchedule() != null) {
            xmlSupportArray[11] = this.getRateSchedule();
        }
        return xmlSupportArray;
    }

    public boolean supportsRateSchedule() {
        return true;
    }

    public boolean supportsAdvancedProperties() {
        return true;
    }

    public JComponent buildComponentEditor(RateComponentDetailPanel rateComponentDetailPanel, Lexicon lexicon) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("percentConsumed")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.percentageTextField = new CostTextField(10, false);
        this.percentageTextField.setMaximumFractionDigits(5);
        this.percentageTextField.setAllowNegative(false);
        this.percentageTextField.setUseLabelAppearanceWhenDisabled(true);
        this.percentageTextField.getDocument().addDocumentListener(new MyDocumentListener(rateComponentDetailPanel));
        this.percentageTextField.addFocusListener(rateComponentDetailPanel);
        this.percentageTextField.setText(this.getPercentConsumption());
        jPanel.add((Component)this.percentageTextField, gridBagConstraints);
        return jPanel;
    }

    public void loadComponentEditor(CustomRateComponent customRateComponent) {
        this.percentageTextField.setText(((PercentageFeePerUnit)customRateComponent).getPercentConsumption());
    }

    public void buildReconciliationDetails(ReconciliationRow reconciliationRow, JPanel jPanel, GridBagConstraints gridBagConstraints, Lexicon lexicon) {
        gridBagConstraints.gridy = gridBagConstraints.gridy++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("percentConsumed")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)new JLabel(String.valueOf(this.getPercentConsumption()), 4), gridBagConstraints);
    }

    private class MyDocumentListener
    implements DocumentListener {
        private RateComponentDetailPanel parentPanel;

        public MyDocumentListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            try {
                ((PercentageFeePerUnit)this.parentPanel.getSelectedRateComponentBase()).setPercentConsumption(PercentageFeePerUnit.this.percentageTextField.getDoubleValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parentPanel.handleRateComponentChange(false);
        }
    }
}

