/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.rate.components.CustomRateComponent;
import com.tridium.eas.cost.rate.components.DemandCharge;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.report.ReconciliationRow;
import com.tridium.eas.cost.ui.RateComponentDetailPanel;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.ui.widgets.EasComboBox;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PeakChargePerDay
extends DemandCharge
implements CustomRateComponent {
    public static final int OVERALL_PEAK_APPROACH = 0;
    public static final int DAILY_PEAK_APPROACH = 1;
    private int peakApproach = 1;
    public static String TYPE = "PeakChargePerDay";
    private EasComboBox peakApproachComboBox;

    public PeakChargePerDay() {
    }

    public PeakChargePerDay(String string) {
        super(string);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((PeakChargePerDay)rateComponent).setPeakApproach(this.getPeakApproach());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new PeakChargePerDay());
    }

    public int getPeakApproach() {
        return this.peakApproach;
    }

    public void setPeakApproach(int n) {
        this.peakApproach = n;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        this.setCostStatus("calculating");
        try {
            RawCostData rawCostData10 = null;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                }
            }
            long l3 = l2 - l;
            if (l3 < 0L) {
                l3 *= -1L;
            }
            int n = (int)(l3 / 86400000L);
            double d2 = (double)l3 / 8.64E7;
            Result result = rawCostData10.get(l, l2);
            Record record = rawCostData10.createRecord();
            double d3 = 0.0;
            long l4 = -1L;
            if (this.getPeakApproach() == 0) {
                record = result.next(record);
                while (record != null) {
                    double d4;
                    long l5;
                    if (record instanceof DoubleRecord && this.isEffective(l5 = record.getTimestamp(), d4 = ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l5, l, l2) && this.getParentRate().includes(l5, this.getTimeZone()) && PeakChargePerDay.validStatus(record.getStatus()) && d4 > d3) {
                        d3 = d4;
                        l4 = l5;
                    }
                    record = result.next(record);
                }
            } else {
                double[] dArray = new double[n + 2];
                double d5 = 0.0;
                Calendar calendar = Calendar.getInstance((TimeZone)this.getTimeZone().tzSupport());
                calendar.setTime(new Date(l));
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                long l6 = calendar.getTime().getTime();
                record = result.next(record);
                while (record != null) {
                    double d6;
                    long l7;
                    if (record instanceof DoubleRecord && this.isEffective(l7 = record.getTimestamp(), d6 = ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l7, l, l2) && this.getParentRate().includes(l7, this.getTimeZone()) && PeakChargePerDay.validStatus(record.getStatus())) {
                        int n2;
                        if (d6 > d5) {
                            d5 = d6;
                            l4 = l7;
                        }
                        if ((n2 = (int)((l7 - l6) / 86400000L)) < 0) {
                            n2 *= -1;
                        }
                        if (d6 > dArray[n2]) {
                            dArray[n2] = d6;
                        }
                    }
                    record = result.next(record);
                }
                for (int i = 0; i < dArray.length; ++i) {
                    d3 += dArray[i];
                }
            }
            this.setCalculatedUnits(d3);
            this.setPeakTime(l4);
            if (this.getDataRangeApproach() == 0) {
                if (d3 < this.getMinDataValue()) {
                    return 0.0;
                }
                d3 = d3 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d3 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d3 < this.getMinDataValue() || d3 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d7 = d3 / (double)this.getUnitsInFee();
            if (this.getPeakApproach() == 0) {
                return this.getFee() * d7 * d2;
            }
            return this.getFee() * d7;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in PeakChargePerDay.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      peakApproach: " + this.getPeakApproach());
        return stringBuffer.toString();
    }

    public double getProjectedCost(double d) {
        return this.getCalculatedCostForInterval() * d;
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("peakTime")) {
                this.setPeakTime(Long.parseLong(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else if (string.equals("peakApproach")) {
                this.setPeakApproach(Integer.parseInt(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 12;
        if (this.getRateSchedule() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("fee", String.valueOf(this.getFee()));
        xmlSupportArray[4] = new XmlSimple("minDataValue", String.valueOf(this.getMinDataValue()));
        xmlSupportArray[5] = new XmlSimple("maxDataValue", String.valueOf(this.getMaxDataValue()));
        xmlSupportArray[6] = new XmlSimple("unitsInFee", String.valueOf(this.getUnitsInFee()));
        xmlSupportArray[7] = new XmlSimple("peakTime", String.valueOf(this.getPeakTime()));
        xmlSupportArray[8] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray[9] = new XmlSimple("calculatedUnits", String.valueOf(this.getCalculatedUnits()));
        xmlSupportArray[10] = new XmlSimple("dataRangeApproach", String.valueOf(this.getDataRangeApproach()));
        xmlSupportArray[11] = new XmlSimple("peakApproach", String.valueOf(this.getPeakApproach()));
        if (this.getRateSchedule() != null) {
            xmlSupportArray[12] = this.getRateSchedule();
        }
        return xmlSupportArray;
    }

    public boolean supportsRateSchedule() {
        return true;
    }

    public boolean supportsAdvancedProperties() {
        return true;
    }

    public JComponent buildComponentEditor(RateComponentDetailPanel rateComponentDetailPanel, Lexicon lexicon) {
        JPanel jPanel = new JPanel(new GridBagLayout(), false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("peakApproach")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        this.peakApproachComboBox = new EasComboBox(new String[]{lexicon.getText("overallApproach"), lexicon.getText("dailyApproach")});
        this.peakApproachComboBox.addActionListener(new MyActionListener(rateComponentDetailPanel));
        jPanel.add((Component)this.peakApproachComboBox.getPanel(), gridBagConstraints);
        return jPanel;
    }

    public void loadComponentEditor(CustomRateComponent customRateComponent) {
        this.peakApproachComboBox.setSelectedIndex(((PeakChargePerDay)customRateComponent).getPeakApproach());
    }

    public void buildReconciliationDetails(ReconciliationRow reconciliationRow, JPanel jPanel, GridBagConstraints gridBagConstraints, Lexicon lexicon) {
        gridBagConstraints.gridy = gridBagConstraints.gridy++;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)new JLabel(lexicon.getText("peakApproach")), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        String string = lexicon.getText("overallApproach");
        if (this.getPeakApproach() == 1) {
            string = lexicon.getText("dailyApproach");
        }
        jPanel.add((Component)new JLabel(string, 4), gridBagConstraints);
    }

    private class MyActionListener
    implements ActionListener {
        private RateComponentDetailPanel parentPanel;

        public MyActionListener(RateComponentDetailPanel rateComponentDetailPanel) {
            this.parentPanel = rateComponentDetailPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.parentPanel.getInitializingComponents()) {
                return;
            }
            ((PeakChargePerDay)this.parentPanel.getSelectedRateComponentBase()).setPeakApproach(PeakChargePerDay.this.peakApproachComboBox.getSelectedIndex());
            this.parentPanel.handleRateComponentChange(false);
        }
    }
}

