/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.datatypes.TimePeriods;
import com.tridium.eas.cost.rate.components.Ratchet;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;

public class HistoricalRatchet
extends Ratchet {
    private double percentage = 100.0;
    private TimePeriods periodsARatchetIsValid = new TimePeriods(12, 0);
    public static String TYPE = "HistoricalRatchet";

    public HistoricalRatchet() {
        this.setApplicableData(1);
        this.setCategory(1);
    }

    public HistoricalRatchet(String string) {
        super(string);
        this.setApplicableData(1);
        this.setCategory(1);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((HistoricalRatchet)rateComponent).setPercentage(this.getPercentage());
        ((HistoricalRatchet)rateComponent).setPeriodsARatchetIsValid((TimePeriods)this.getPeriodsARatchetIsValid().newCopy());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new HistoricalRatchet());
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double d) {
        this.percentage = d;
        this.setComputeFromScratch(true);
    }

    public TimePeriods getPeriodsARatchetIsValid() {
        return this.periodsARatchetIsValid;
    }

    public void setPeriodsARatchetIsValid(TimePeriods timePeriods) {
        this.periodsARatchetIsValid = timePeriods;
        this.setComputeFromScratch(true);
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        this.setCostStatus("calculating");
        try {
            RawCostData rawCostData10 = null;
            RawCostData rawCostData11 = null;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    rawCostData11 = rawCostData3;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    rawCostData11 = rawCostData8;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                    rawCostData11 = rawCostData9;
                }
            }
            double d2 = 0.0;
            long l3 = -1L;
            double d3 = 0.0;
            long l4 = -1L;
            double d4 = 0.0;
            long l5 = -1L;
            PeakTimePair peakTimePair = this.getHistoricalPeak(rawCostData11, l, bl, d, l, l2);
            d3 = peakTimePair.peak;
            l4 = peakTimePair.timestamp;
            MaxPeakTimePairCombo maxPeakTimePairCombo = this.getMaxUnitsForPeriod(rawCostData10, l, l2, d3, l4, bl, d);
            d2 = maxPeakTimePairCombo.max;
            l3 = maxPeakTimePairCombo.maxTimestamp;
            if (maxPeakTimePairCombo.pair != null) {
                d4 = maxPeakTimePairCombo.pair.peak;
                l5 = maxPeakTimePairCombo.pair.timestamp;
            }
            this.setCalculatedUnits(d2);
            this.setPeakTime(l3);
            if (this.getDataRangeApproach() == 0) {
                if (d2 < this.getMinDataValue()) {
                    return 0.0;
                }
                d2 = d2 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d2 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d2 < this.getMinDataValue() || d2 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d5 = d2 / (double)this.getUnitsInFee();
            return this.getFee() * d5;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in HistoricalRatchet.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    protected MaxPeakTimePairCombo getMaxUnitsForPeriod(RawCostData rawCostData, long l, long l2, double d, long l3, boolean bl, double d2) throws Exception {
        Result result = rawCostData.get(l, l2);
        Record record = rawCostData.createRecord();
        double d3 = d * (this.getPercentage() / 100.0);
        long l4 = l3;
        double d4 = this.getMinimumContractPeakLevel();
        if (bl) {
            d4 /= d2;
        }
        if (d3 < d4) {
            d3 = d4;
            l4 = -1L;
        }
        double d5 = 0.0;
        long l5 = -1L;
        boolean bl2 = false;
        record = result.next(record);
        while (record != null) {
            double d6;
            long l6;
            if (record instanceof DoubleRecord && this.isEffective(l6 = record.getTimestamp(), d6 = ((DoubleRecord)record).getDoubleValue(), bl, d2, l, l2) && CostTimeUtil.includes(l6, l, l2) && this.getParentRate().includes(l6, this.getTimeZone()) && HistoricalRatchet.validStatus(record.getStatus())) {
                bl2 = true;
                if (d6 > d3) {
                    d3 = d6;
                    l4 = l6;
                }
                if (d6 > d5) {
                    d5 = d6;
                    l5 = l6;
                }
            }
            record = result.next(record);
        }
        if (!bl2) {
            d3 = 0.0;
            l4 = -1L;
        }
        return new MaxPeakTimePairCombo(d3, l4, new PeakTimePair(d5, l5));
    }

    protected PeakTimePair getHistoricalPeak(RawCostData rawCostData, long l, boolean bl, double d, long l2, long l3) throws Exception {
        long l4 = -1L;
        double d2 = 0.0;
        long l5 = l;
        long l6 = this.getParentRate().getStartTime();
        l6 = CostTimeUtil.convertTime(l6, CostTimeUtil.DEFAULT_TZ, this.getTimeZone());
        long l7 = l;
        PeakTimePair peakTimePair = this.findPeak(rawCostData, l6, l7, true, bl, d, l2, l3);
        d2 = peakTimePair.peak;
        if (peakTimePair.timestamp >= 0L) {
            l5 = peakTimePair.timestamp;
        }
        l4 = CostTimeUtil.getCycleEnd(this.getTimeZone(), l5, this.getParentRate().getBillingCycleStart(), this.getParentRate().getBillingCycle(), 0);
        boolean bl2 = true;
        while (CostTimeUtil.incrementByTimePeriod(this.getTimeZone(), l4, this.getParentRate().getBillingCycle(), this.getPeriodsARatchetIsValid(), true) <= l7) {
            peakTimePair = this.findPeak(rawCostData, l4, CostTimeUtil.incrementByTimePeriod(this.getTimeZone(), l4, this.getParentRate().getBillingCycle(), this.getPeriodsARatchetIsValid(), true), bl2, bl, d, l2, l3);
            d2 = peakTimePair.peak;
            l5 = peakTimePair.timestamp;
            if (l5 < 0L) {
                l5 = l4;
            }
            bl2 = l5 != l4;
            l4 = CostTimeUtil.getCycleEnd(this.getTimeZone(), l5, this.getParentRate().getBillingCycleStart(), this.getParentRate().getBillingCycle(), 0);
        }
        if (l4 < l7) {
            peakTimePair = this.findPeak(rawCostData, l4, l7, true, bl, d, l2, l3);
            double d3 = peakTimePair.peak;
            long l8 = peakTimePair.timestamp;
            if (l8 >= 0L && d3 >= d2) {
                d2 = d3;
                l5 = l8;
            }
        }
        return new PeakTimePair(d2, l5);
    }

    private PeakTimePair findPeak(RawCostData rawCostData, long l, long l2, boolean bl, boolean bl2, double d, long l3, long l4) throws Exception {
        double d2 = 0.0;
        long l5 = -1L;
        Result result = rawCostData.get(l, l2);
        Record record = rawCostData.createRecord();
        record = result.next(record);
        while (record != null) {
            if (record instanceof DoubleRecord) {
                long l6 = record.getTimestamp();
                double d3 = ((DoubleRecord)record).getDoubleValue();
                if (l6 == l && !bl) {
                    record = result.next(record);
                    continue;
                }
                if (this.isEffective(l6, d3, bl2, d, l3, l4) && CostTimeUtil.includes(l6, l, l2) && this.getParentRate().includes(l6, this.getTimeZone()) && HistoricalRatchet.validStatus(record.getStatus()) && d3 > d2) {
                    d2 = d3;
                    l5 = l6;
                }
            }
            record = result.next(record);
        }
        return new PeakTimePair(d2, l5);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      percentage: " + this.getPercentage());
        stringBuffer.append("\n      periodsARatchetIsValid: " + this.getPeriodsARatchetIsValid());
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("peakTime")) {
                this.setPeakTime(Long.parseLong(string2));
            } else if (string.equals("minimumContractPeakLevel")) {
                this.setMinimumContractPeakLevel(Double.valueOf(string2));
            } else if (string.equals("percentage")) {
                this.setPercentage(Double.valueOf(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else if (xmlSupport instanceof TimePeriods) {
            this.setPeriodsARatchetIsValid((TimePeriods)xmlSupport);
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = super.getChildObjects();
        int n = 1;
        if (xmlSupportArray != null) {
            n = xmlSupportArray.length + 1;
        }
        XmlSupport[] xmlSupportArray2 = new XmlSupport[n];
        xmlSupportArray2[0] = this.getPeriodsARatchetIsValid();
        if (xmlSupportArray != null) {
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                xmlSupportArray2[i + 1] = xmlSupportArray[i];
            }
        }
        XmlSupport[] xmlSupportArray3 = new XmlSupport[xmlSupportArray2.length + 1];
        xmlSupportArray3[0] = new XmlSimple("percentage", String.valueOf(this.getPercentage()));
        for (int i = 0; i < xmlSupportArray2.length; ++i) {
            xmlSupportArray3[i + 1] = xmlSupportArray2[i];
        }
        return xmlSupportArray3;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }

    private class MaxPeakTimePairCombo {
        public double max = 0.0;
        public long maxTimestamp = -1L;
        public PeakTimePair pair = null;

        public MaxPeakTimePairCombo(double d, long l, PeakTimePair peakTimePair) {
            this.max = d;
            this.maxTimestamp = l;
            this.pair = peakTimePair;
        }
    }

    private class PeakTimePair {
        public double peak = 0.0;
        public long timestamp = -1L;

        public PeakTimePair(double d, long l) {
            this.peak = d;
            this.timestamp = l;
        }
    }
}

