/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.rate.components.FlatFeePerUnit;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.DoubleRecord;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.cost.util.Record;
import com.tridium.eas.cost.util.Result;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;

public class DemandCharge
extends FlatFeePerUnit {
    private long peakTime = -1L;
    public static String TYPE = "DemandCharge";

    public DemandCharge() {
        this.setApplicableData(1);
        this.setCategory(1);
    }

    public DemandCharge(String string) {
        super(string);
        this.setApplicableData(1);
        this.setCategory(1);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((DemandCharge)rateComponent).setPeakTime(this.getPeakTime());
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new DemandCharge());
    }

    public long getPeakTime() {
        return this.peakTime;
    }

    public void setPeakTime(long l) {
        this.peakTime = l;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        this.setCostStatus("calculating");
        try {
            RawCostData rawCostData10 = null;
            switch (this.getApplicableData()) {
                case 0: {
                    rawCostData10 = rawCostData;
                    break;
                }
                case 1: {
                    rawCostData10 = rawCostData2;
                    break;
                }
                case 2: {
                    rawCostData10 = rawCostData4;
                    break;
                }
                case 4: {
                    rawCostData10 = rawCostData5;
                    break;
                }
                case 3: {
                    rawCostData10 = rawCostData6;
                    break;
                }
                case 5: {
                    rawCostData10 = rawCostData7;
                }
            }
            Result result = rawCostData10.get(l, l2);
            Record record = rawCostData10.createRecord();
            double d2 = 0.0;
            long l3 = -1L;
            record = result.next(record);
            while (record != null) {
                double d3;
                long l4;
                if (record instanceof DoubleRecord && this.isEffective(l4 = record.getTimestamp(), d3 = ((DoubleRecord)record).getDoubleValue(), bl, d, l, l2) && CostTimeUtil.includes(l4, l, l2) && this.getParentRate().includes(l4, this.getTimeZone()) && DemandCharge.validStatus(record.getStatus()) && d3 > d2) {
                    d2 = d3;
                    l3 = l4;
                }
                record = result.next(record);
            }
            this.setCalculatedUnits(d2);
            this.setPeakTime(l3);
            if (this.getDataRangeApproach() == 0) {
                if (d2 < this.getMinDataValue()) {
                    return 0.0;
                }
                d2 = d2 > this.getMaxDataValue() ? this.getMaxDataValue() - this.getMinDataValue() : (d2 -= this.getMinDataValue());
            } else if (this.getDataRangeApproach() == 1 && (d2 < this.getMinDataValue() || d2 >= this.getMaxDataValue())) {
                return 0.0;
            }
            double d4 = d2 / (double)this.getUnitsInFee();
            return this.getFee() * d4;
        }
        catch (Exception exception) {
            System.out.println("Caught exception in DemandCharge.computeCostForRange(): ");
            exception.printStackTrace();
            return 0.0;
        }
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      peakTime: " + this.getPeakTime());
        return stringBuffer.toString();
    }

    public double getProjectedCost(double d) {
        return this.getCalculatedCostForInterval();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("fee")) {
                this.setFee(Double.valueOf(string2));
            } else if (string.equals("minDataValue")) {
                this.setMinDataValue(Double.valueOf(string2));
            } else if (string.equals("maxDataValue")) {
                this.setMaxDataValue(Double.valueOf(string2));
            } else if (string.equals("unitsInFee")) {
                this.setUnitsInFee(Integer.parseInt(string2));
            } else if (string.equals("peakTime")) {
                this.setPeakTime(Long.parseLong(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("calculatedUnits")) {
                this.setCalculatedUnits(Double.valueOf(string2));
            } else if (string.equals("dataRangeApproach")) {
                this.setDataRangeApproach(Integer.parseInt(string2));
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        int n = 11;
        if (this.getRateSchedule() != null) {
            ++n;
        }
        XmlSupport[] xmlSupportArray = new XmlSupport[n];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("fee", String.valueOf(this.getFee()));
        xmlSupportArray[4] = new XmlSimple("minDataValue", String.valueOf(this.getMinDataValue()));
        xmlSupportArray[5] = new XmlSimple("maxDataValue", String.valueOf(this.getMaxDataValue()));
        xmlSupportArray[6] = new XmlSimple("unitsInFee", String.valueOf(this.getUnitsInFee()));
        xmlSupportArray[7] = new XmlSimple("peakTime", String.valueOf(this.getPeakTime()));
        xmlSupportArray[8] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray[9] = new XmlSimple("calculatedUnits", String.valueOf(this.getCalculatedUnits()));
        xmlSupportArray[10] = new XmlSimple("dataRangeApproach", String.valueOf(this.getDataRangeApproach()));
        if (this.getRateSchedule() != null) {
            xmlSupportArray[11] = this.getRateSchedule();
        }
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

