/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate.components;

import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.util.StringTokenizer;
import javax.baja.timezone.BTimeZone;

public class CombinationPercentageFee
extends RateComponent {
    private double percentage = 0.0;
    private String[] registeredComponentIds = null;
    public static String TYPE = "CombinationPercentageFee";

    public CombinationPercentageFee() {
        this.setCategory(2);
    }

    public CombinationPercentageFee(String string) {
        super(string);
        this.setCategory(2);
    }

    protected RateComponent copyParameters(RateComponent rateComponent) {
        ((CombinationPercentageFee)rateComponent).setPercentage(this.getPercentage());
        String[] stringArray = null;
        if (this.getRegisteredComponentIds() != null) {
            String[] stringArray2 = this.getRegisteredComponentIds();
            stringArray = new String[stringArray2.length];
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray[i] = new String(stringArray2[i]);
            }
        }
        ((CombinationPercentageFee)rateComponent).setRegisteredComponentIds(stringArray);
        return super.copyParameters(rateComponent);
    }

    public Object newCopy() {
        return this.copyParameters(new CombinationPercentageFee());
    }

    public double getPercentage() {
        return this.percentage;
    }

    public void setPercentage(double d) {
        this.percentage = d;
        this.setComputeFromScratch(true);
    }

    public String[] getRegisteredComponentIds() {
        return this.registeredComponentIds;
    }

    public void setRegisteredComponentIds(String[] stringArray) {
        this.registeredComponentIds = stringArray;
        this.setComputeFromScratch(true);
    }

    public void addRateComponentId(String string) {
        this.setComputeFromScratch(true);
        if (this.registeredComponentIds == null) {
            this.registeredComponentIds = new String[1];
            this.registeredComponentIds[0] = string;
            return;
        }
        String[] stringArray = new String[this.registeredComponentIds.length + 1];
        for (int i = 0; i < this.registeredComponentIds.length; ++i) {
            stringArray[i] = this.registeredComponentIds[i];
        }
        stringArray[this.registeredComponentIds.length] = string;
        this.registeredComponentIds = stringArray;
    }

    public void removeRateComponentId(String string) {
        this.setComputeFromScratch(true);
        if (this.registeredComponentIds != null && this.registeredComponentIds.length > 0) {
            int n = -1;
            for (int i = 0; i < this.registeredComponentIds.length; ++i) {
                if (!this.registeredComponentIds[i].equals(string)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                String[] stringArray = new String[this.registeredComponentIds.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.registeredComponentIds.length; ++i) {
                    if (i == n) continue;
                    stringArray[n2] = this.registeredComponentIds[i];
                    ++n2;
                }
                this.registeredComponentIds = stringArray;
            }
        }
    }

    public void replaceRateComponentId(String string, String string2) {
        this.setComputeFromScratch(true);
        if (this.registeredComponentIds != null && this.registeredComponentIds.length > 0) {
            for (int i = 0; i < this.registeredComponentIds.length; ++i) {
                if (!this.registeredComponentIds[i].equals(string)) continue;
                this.registeredComponentIds[i] = string2;
                break;
            }
        }
    }

    public RateComponent[] getRegisteredComponents() {
        int n;
        String[] stringArray = this.getRegisteredComponentIds();
        RateComponent[] rateComponentArray = this.getParentRate().getRateComponents();
        if (stringArray == null || stringArray.length <= 0 || rateComponentArray == null || rateComponentArray.length <= 0) {
            return null;
        }
        RateComponent[] rateComponentArray2 = new RateComponent[stringArray.length];
        int n2 = 0;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            for (n = 0; n < rateComponentArray.length; ++n) {
                if (!rateComponentArray[n].getName().equals(stringArray[i])) continue;
                rateComponentArray2[n2] = rateComponentArray[n];
                ++n2;
                continue block0;
            }
        }
        RateComponent[] rateComponentArray3 = new RateComponent[n2];
        for (n = 0; n < n2; ++n) {
            rateComponentArray3[n] = rateComponentArray2[n];
        }
        return rateComponentArray3;
    }

    public boolean isRegistered(String string) {
        if (this.registeredComponentIds == null) {
            return false;
        }
        for (int i = 0; i < this.registeredComponentIds.length; ++i) {
            if (!this.registeredComponentIds[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    protected double computeCostForRange(String string, long l, long l2, RawCostData rawCostData, RawCostData rawCostData2, RawCostData rawCostData3, boolean bl, double d, RawCostData rawCostData4, RawCostData rawCostData5, RawCostData rawCostData6, RawCostData rawCostData7, RawCostData rawCostData8, RawCostData rawCostData9) {
        double d2 = 0.0;
        RateComponent[] rateComponentArray = this.getRegisteredComponents();
        if (rateComponentArray != null && rateComponentArray.length > 0) {
            for (int i = 0; i < rateComponentArray.length; ++i) {
                d2 += rateComponentArray[i].computeCostForRange(string, l, l2, rawCostData, rawCostData2, rawCostData3, bl, d, rawCostData4, rawCostData5, rawCostData6, rawCostData7, rawCostData8, rawCostData9);
            }
        }
        return d2 * (this.getPercentage() / 100.0);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n      percentage: " + this.getPercentage());
        String[] stringArray = this.getRegisteredComponentIds();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append("\n        registeredComponentId[" + i + "]: " + stringArray[i]);
            }
        }
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("timezone")) {
                this.setTimeZone(BTimeZone.getTimeZone((String)XmlEncoder.decodeXmlString(string2)));
            } else if (string.equals("applicableData")) {
                this.setApplicableData(Integer.parseInt(string2));
            } else if (string.equals("category")) {
                this.setCategory(Integer.parseInt(string2));
            } else if (string.equals("percentage")) {
                this.setPercentage(Double.valueOf(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            } else if (string.equals("registeredComponents")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                if (n <= 0) {
                    return;
                }
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = XmlEncoder.decodeXmlString(stringTokenizer.nextToken());
                }
                this.setRegisteredComponentIds(stringArray);
            } else {
                super.addChildObject(xmlSupport);
            }
        } else {
            super.addChildObject(xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = new XmlSupport[6];
        xmlSupportArray[0] = new XmlSimple("timezone", XmlEncoder.encodeXmlString(String.valueOf(this.getTimeZone().getId())));
        xmlSupportArray[1] = new XmlSimple("applicableData", String.valueOf(this.getApplicableData()));
        xmlSupportArray[2] = new XmlSimple("category", String.valueOf(this.getCategory()));
        xmlSupportArray[3] = new XmlSimple("percentage", String.valueOf(this.getPercentage()));
        xmlSupportArray[4] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        String[] stringArray = this.getRegisteredComponentIds();
        int n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(n));
        if (stringArray != null) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(";" + XmlEncoder.encodeXmlString(stringArray[i]));
            }
        }
        xmlSupportArray[5] = new XmlSimple("registeredComponents", stringBuffer.toString());
        return xmlSupportArray;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

