/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Meter;
import com.tridium.eas.cost.RateLoader;
import com.tridium.eas.cost.datatypes.RateBillingPeriod;
import com.tridium.eas.cost.datatypes.TimePeriods;
import com.tridium.eas.cost.rate.Rate;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.util.DBSpecific;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.web.EasCostHandler;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.TimeZone;
import javax.baja.units.BUnit;

public class RateHistory
implements XmlSupport {
    private static RateLoader rateLoader = null;
    private String name = "-";
    private double calculatedCostForInterval = 0.0;
    private RateLink[] rateLinks = null;
    public static String TYPE = "RateHistory";
    private Rate[] computedRates = null;

    public RateHistory() {
    }

    public RateHistory(String string) {
        this.setName(string);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public double getCalculatedCostForInterval() {
        return this.calculatedCostForInterval;
    }

    public void setCalculatedCostForInterval(double d) {
        this.calculatedCostForInterval = d;
    }

    public RateLink[] getRateLinks() {
        return this.rateLinks;
    }

    public void setRateLinks(RateLink[] rateLinkArray) {
        this.rateLinks = rateLinkArray;
    }

    public void addRateLink(RateLink rateLink) {
        if (this.rateLinks == null) {
            this.rateLinks = new RateLink[1];
            this.rateLinks[0] = rateLink;
            return;
        }
        RateLink[] rateLinkArray = new RateLink[this.rateLinks.length + 1];
        for (int i = 0; i < this.rateLinks.length; ++i) {
            rateLinkArray[i] = this.rateLinks[i];
        }
        rateLinkArray[this.rateLinks.length] = rateLink;
        this.rateLinks = rateLinkArray;
    }

    public void removeRateLink(RateLink rateLink) {
        if (this.rateLinks != null && this.rateLinks.length > 0) {
            int n = -1;
            for (int i = 0; i < this.rateLinks.length; ++i) {
                if (!this.rateLinks[i].equals(rateLink)) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                RateLink[] rateLinkArray = new RateLink[this.rateLinks.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.rateLinks.length; ++i) {
                    if (i == n) continue;
                    rateLinkArray[n2] = this.rateLinks[i];
                    ++n2;
                }
                this.rateLinks = rateLinkArray;
            }
        }
    }

    public void computeForInterval(String string, RateBillingPeriod[] rateBillingPeriodArray, Meter meter, boolean bl, boolean bl2, boolean bl3, BUnit bUnit, double d, boolean bl4, int n, double d2, boolean bl5, DataPoint dataPoint) {
        this.doComputeForInterval(string, rateBillingPeriodArray, meter, bl, bl2, bl3, bUnit, d, bl4, n, d2, bl5, dataPoint);
    }

    public void computeForInterval(String string, RateBillingPeriod[] rateBillingPeriodArray, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.doComputeForInterval(string, rateBillingPeriodArray, meterArray, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
    }

    private void doComputeForInterval(String string, RateBillingPeriod[] rateBillingPeriodArray, Meter meter, boolean bl, boolean bl2, boolean bl3, BUnit bUnit, double d, boolean bl4, int n, double d2, boolean bl5, DataPoint dataPoint) {
        this.setCalculatedCostForInterval(this.computeCostForInterval(string, rateBillingPeriodArray, meter, bl, bl2, bl3, bUnit, d, bl4, n, d2, bl5, dataPoint));
    }

    private void doComputeForInterval(String string, RateBillingPeriod[] rateBillingPeriodArray, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.setCalculatedCostForInterval(this.computeCostForInterval(string, rateBillingPeriodArray, meterArray, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint));
    }

    public double computeCostForInterval(String string, RateBillingPeriod[] rateBillingPeriodArray, Meter meter, boolean bl, boolean bl2, boolean bl3, BUnit bUnit, double d, boolean bl4, int n, double d2, boolean bl5, DataPoint dataPoint) {
        Rate[] rateArray = this.generateRates();
        double d3 = 0.0;
        if (rateArray != null && rateArray.length > 0) {
            for (int i = 0; i < rateArray.length; ++i) {
                RateBillingPeriod rateBillingPeriod = RateHistory.findMatchingRateBillingPeriod(rateBillingPeriodArray, rateArray[i].getName());
                if (rateBillingPeriod == null) continue;
                long l = rateBillingPeriod.getStartTime();
                long l2 = rateBillingPeriod.getEndTime();
                if (!bl) {
                    long l3 = EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ);
                    if (l3 < l2) {
                        l2 = l3;
                    }
                    if (l3 < l) {
                        l = l3;
                    }
                }
                rateArray[i].computeForInterval(string, l, l2, meter, bl2, bl3, bUnit, d, bl4, n, d2, bl5, dataPoint);
                d3 += rateArray[i].getCalculatedCostForInterval();
            }
        }
        this.computedRates = rateArray;
        return d3;
    }

    public double computeCostForInterval(String string, RateBillingPeriod[] rateBillingPeriodArray, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        Rate[] rateArray = this.generateRates();
        double d3 = 0.0;
        if (rateArray != null && rateArray.length > 0) {
            for (int i = 0; i < rateArray.length; ++i) {
                RateBillingPeriod rateBillingPeriod = RateHistory.findMatchingRateBillingPeriod(rateBillingPeriodArray, rateArray[i].getName());
                if (rateBillingPeriod == null) continue;
                rateArray[i].computeForInterval(string, rateBillingPeriod.getStartTime(), rateBillingPeriod.getEndTime(), meterArray, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
                d3 += rateArray[i].getCalculatedCostForInterval();
            }
        }
        this.computedRates = rateArray;
        return d3;
    }

    public Rate[] getComputedRates() {
        if (this.computedRates != null) {
            return this.computedRates;
        }
        return this.generateRates();
    }

    public Rate[] generateRates() {
        RateLink[] rateLinkArray = this.getRateLinks();
        if (rateLinkArray == null || rateLinkArray.length <= 0) {
            return null;
        }
        Rate[] rateArray = new Rate[rateLinkArray.length];
        int n = 0;
        for (int i = 0; i < rateLinkArray.length; ++i) {
            Rate rate = null;
            try {
                if (rateLoader == null) {
                    rateLoader = new EasCostHandler();
                }
                rate = rateLoader.loadRateByName(rateLinkArray[i].getName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (rate == null) continue;
            rateArray[n] = rate;
            rateArray[n].setStartTime(rateLinkArray[i].getStartTime());
            rateArray[n].setEndTime(rateLinkArray[i].getEndTime());
            rateArray[n].setBillingCycleStart(rateLinkArray[i].getBillingCycleStart());
            rateArray[n].setBillingCycle(rateLinkArray[i].getBillingCycle());
            ++n;
        }
        Rate[] rateArray2 = new Rate[n];
        System.arraycopy(rateArray, 0, rateArray2, 0, n);
        return rateArray2;
    }

    public static RateBillingPeriod findMatchingRateBillingPeriod(RateBillingPeriod[] rateBillingPeriodArray, String string) {
        if (rateBillingPeriodArray == null) {
            return null;
        }
        for (int i = 0; i < rateBillingPeriodArray.length; ++i) {
            if (!rateBillingPeriodArray[i].getName().equals(string)) continue;
            return rateBillingPeriodArray[i];
        }
        return null;
    }

    public long computeDefaultStartTime(String string, String string2) {
        int n;
        long l = System.currentTimeMillis();
        TimePeriods timePeriods = new TimePeriods(1, 5);
        if (this.rateLinks != null) {
            for (int i = 0; i < this.rateLinks.length; ++i) {
                if (!this.rateLinks[i].getName().equals(string)) continue;
                l = this.rateLinks[i].getBillingCycleStart();
                timePeriods = this.rateLinks[i].getBillingCycle();
                break;
            }
        }
        Calendar calendar = Calendar.getInstance((TimeZone)CostTimeUtil.DEFAULT_TZ.tzSupport());
        int n2 = calendar.get(2);
        int n3 = calendar.get(1);
        int n4 = Dbx.parseBillCycleMonth(string2);
        if (n4 >= 0) {
            n2 = n4;
        }
        if ((n = Dbx.parseBillCycleYear(string2)) >= 0) {
            n3 = n;
        }
        calendar.set(2, n2);
        calendar.set(1, n3);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return CostTimeUtil.getCycleStart(CostTimeUtil.DEFAULT_TZ, calendar.getTime().getTime(), l, timePeriods, 0);
    }

    public long computeDefaultEndTime(String string, String string2) {
        TimePeriods timePeriods = new TimePeriods(1, 5);
        if (this.rateLinks != null) {
            for (int i = 0; i < this.rateLinks.length; ++i) {
                if (!this.rateLinks[i].getName().equals(string)) continue;
                timePeriods = this.rateLinks[i].getBillingCycle();
                break;
            }
        }
        return CostTimeUtil.incrementTime(CostTimeUtil.DEFAULT_TZ, this.computeDefaultStartTime(string, string2), timePeriods, 0);
    }

    public String toString() {
        return "" + this.getCalculatedCostForInterval();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nname: " + this.getName());
        Rate[] rateArray = this.generateRates();
        if (rateArray != null) {
            for (int i = 0; i < rateArray.length; ++i) {
                stringBuffer.append("\n rate[" + i + "]: " + rateArray[i].toDebugString());
            }
        }
        return stringBuffer.toString();
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            }
        } else if (xmlSupport instanceof RateLink) {
            this.addRateLink((RateLink)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = this.getRateLinks();
        int n = 1;
        if (xmlSupportArray != null) {
            n = xmlSupportArray.length + 1;
        }
        XmlSupport[] xmlSupportArray2 = new XmlSupport[n];
        xmlSupportArray2[0] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        if (xmlSupportArray != null) {
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                xmlSupportArray2[i + 1] = xmlSupportArray[i];
            }
        }
        return xmlSupportArray2;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }

    public void saveToRdb(int n, Statement statement, DBSpecific dBSpecific) throws SQLException {
        RateHistory.deleteFromRdb(n, statement, dBSpecific);
        RateLink[] rateLinkArray = this.getRateLinks();
        if (rateLinkArray != null) {
            for (int i = 0; i < rateLinkArray.length; ++i) {
                String string = "insert into " + dBSpecific.getFullTableName("EAS", "RATE_ATTACHMENTS") + " (METER_ID,RATE_NAME,START_TIME,END_TIME,CYCLE_NUM,CYCLE_UNITS,BILL_START,ACCOUNT,CUST_SERV_REP,CUST_SERV_PHONE,CUST_SERV_EMAIL,SALES_REP,SALES_PHONE,SALES_EMAIL) values (" + n + "," + Dbx.str2db(rateLinkArray[i].getName()) + "," + rateLinkArray[i].getStartTime() + "," + rateLinkArray[i].getEndTime() + "," + rateLinkArray[i].getBillingCycle().getNumber() + "," + rateLinkArray[i].getBillingCycle().getTimeUnits() + "," + rateLinkArray[i].getBillingCycleStart() + "," + Dbx.str2db(rateLinkArray[i].getAccount()) + "," + Dbx.str2db(rateLinkArray[i].getCustServRep()) + "," + Dbx.str2db(rateLinkArray[i].getCustServRepPhone()) + "," + Dbx.str2db(rateLinkArray[i].getCustServRepEmail()) + "," + Dbx.str2db(rateLinkArray[i].getSalesRep()) + "," + Dbx.str2db(rateLinkArray[i].getSalesRepPhone()) + "," + Dbx.str2db(rateLinkArray[i].getSalesRepEmail()) + ")";
                statement.executeUpdate(string);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RateHistory loadFromRdb(int n, Statement statement, DBSpecific dBSpecific) throws SQLException {
        RateLink rateLink;
        ResultSet resultSet = null;
        try {
            String string = "select RATE_NAME, START_TIME, END_TIME, CYCLE_NUM, CYCLE_UNITS, BILL_START, ACCOUNT, CUST_SERV_REP, CUST_SERV_PHONE, CUST_SERV_EMAIL, SALES_REP, SALES_PHONE, SALES_EMAIL from " + dBSpecific.getFullTableName("EAS", "RATE_ATTACHMENTS") + " where METER_ID=" + n;
            resultSet = statement.executeQuery(string);
            XmlSupport xmlSupport = null;
            while (resultSet.next()) {
                rateLink = new RateLink(resultSet.getString(1));
                rateLink.setStartTime(resultSet.getLong(2));
                rateLink.setEndTime(resultSet.getLong(3));
                rateLink.setBillingCycle(new TimePeriods(resultSet.getInt(4), resultSet.getInt(5)));
                rateLink.setBillingCycleStart(resultSet.getLong(6));
                rateLink.setAccount(resultSet.getString(7));
                rateLink.setCustServRep(resultSet.getString(8));
                rateLink.setCustServRepPhone(resultSet.getString(9));
                rateLink.setCustServRepEmail(resultSet.getString(10));
                rateLink.setSalesRep(resultSet.getString(11));
                rateLink.setSalesRepPhone(resultSet.getString(12));
                rateLink.setSalesRepEmail(resultSet.getString(13));
                if (xmlSupport == null) {
                    xmlSupport = new RateHistory("meter" + n);
                }
                ((RateHistory)xmlSupport).addRateLink(rateLink);
            }
            rateLink = xmlSupport;
            Object var8_8 = null;
            if (resultSet == null) return rateLink;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (SQLException sQLException2) {
                sQLException2.printStackTrace();
                throw throwable;
            }
        }
        try {}
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            return rateLink;
        }
        resultSet.close();
        return rateLink;
    }

    public static int deleteFromRdb(int n, Statement statement, DBSpecific dBSpecific) throws SQLException {
        String string = "delete from " + dBSpecific.getFullTableName("EAS", "RATE_ATTACHMENTS") + " where METER_ID=" + n;
        return statement.executeUpdate(string);
    }
}

