/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.cost.rate;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasProtected;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RestorationMethod;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.cost.RateLoader;
import com.tridium.eas.cost.datatypes.TimePeriods;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.cost.rate.RateLink;
import com.tridium.eas.cost.rate.components.ChoiceComponent;
import com.tridium.eas.cost.rate.components.ChoiceComponentChild;
import com.tridium.eas.cost.rate.components.RateComponent;
import com.tridium.eas.cost.util.CopySupport;
import com.tridium.eas.cost.util.CostTimeUtil;
import com.tridium.eas.cost.util.RawCostData;
import com.tridium.eas.function.Population;
import com.tridium.eas.web.EasCostHandler;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlSimple;
import com.tridium.eas.xml.XmlSupport;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

public class Rate
implements CopySupport,
XmlSupport,
EasProtected {
    private static RateLoader rateLoader = null;
    private boolean resync = true;
    private String name = "-";
    private double calculatedCostForInterval = 0.0;
    private BUnit currency = null;
    private String energyProvider = "";
    private String location = "";
    private String phoneNumber = "";
    private String website = "";
    private long startTime = -1L;
    private long endTime = -1L;
    private BUnit consumptionUnits = BUnit.getUnit((String)"kilowatt hour");
    private BUnit demandUnits = BUnit.getUnit((String)"kilowatt");
    private BUnit reactiveEnergyUnits = BUnit.getUnit((String)"kilovolt ampere reactive hour");
    private BUnit apparentEnergyUnits = BUnit.getUnit((String)"kilovolt ampere hour");
    private BUnit reactivePowerUnits = BUnit.getUnit((String)"kilovolt ampere reactive");
    private BUnit apparentPowerUnits = BUnit.getUnit((String)"kilovolt ampere");
    private long billingCycleStart = System.currentTimeMillis();
    private TimePeriods billingCycle = new TimePeriods(1, 5);
    private RateComponent[] rateComponents = null;
    public static String TYPE = "Rate";

    public Rate() {
    }

    public Rate(String string) {
        this.setName(string);
    }

    public Rate(RateComponent[] rateComponentArray) {
        this.setRateComponents(rateComponentArray);
    }

    private Rate copyParameters(Rate rate) {
        rate.setName(new String(this.getName()));
        rate.setCurrency(this.getCurrency());
        rate.setEnergyProvider(new String(this.getEnergyProvider()));
        rate.setLocation(new String(this.getLocation()));
        rate.setPhoneNumber(new String(this.getPhoneNumber()));
        rate.setWebsite(new String(this.getWebsite()));
        rate.setStartTime(this.getStartTime());
        rate.setEndTime(this.endTime);
        rate.setConsumptionUnits(this.getConsumptionUnits());
        rate.setDemandUnits(this.getDemandUnits());
        rate.setReactiveEnergyUnits(this.getReactiveEnergyUnits());
        rate.setApparentEnergyUnits(this.getApparentEnergyUnits());
        rate.setReactivePowerUnits(this.getReactivePowerUnits());
        rate.setApparentPowerUnits(this.getApparentPowerUnits());
        rate.setResync(this.getResync());
        rate.setBillingCycleStart(this.getBillingCycleStart());
        rate.setBillingCycle((TimePeriods)this.getBillingCycle().newCopy());
        rate.setCalculatedCostForInterval(this.getCalculatedCostForInterval());
        RateComponent[] rateComponentArray = null;
        if (this.rateComponents != null) {
            rateComponentArray = new RateComponent[this.rateComponents.length];
            for (int i = 0; i < this.rateComponents.length; ++i) {
                rateComponentArray[i] = (RateComponent)this.rateComponents[i].newCopy();
            }
        }
        rate.setRateComponents(rateComponentArray);
        return rate;
    }

    public Object newCopy() {
        return this.copyParameters(new Rate());
    }

    public int getProtectedType() {
        return 4;
    }

    public String getProtectedIdentifier() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof Rate) {
            return ((Rate)object).getName().equals(this.getName());
        }
        return false;
    }

    public boolean getResync() {
        return this.resync;
    }

    public void setResync(boolean bl) {
        this.resync = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string.equals("") ? "-" : string;
    }

    public double getCalculatedCostForInterval() {
        return this.calculatedCostForInterval;
    }

    public void setCalculatedCostForInterval(double d) {
        this.calculatedCostForInterval = d;
    }

    public BUnit getCurrency() {
        if (this.currency == null) {
            try {
                this.currency = BUnit.getUnit((String)"dollar");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.currency == null) {
                this.currency = BUnit.make((String)"dollar", (String)"$", (BDimension)BDimension.make((int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)0, (int)1));
            }
        }
        return this.currency;
    }

    public void setCurrency(BUnit bUnit) {
        this.currency = bUnit;
    }

    public String getEnergyProvider() {
        return this.energyProvider;
    }

    public void setEnergyProvider(String string) {
        this.energyProvider = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String string) {
        this.phoneNumber = string;
    }

    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String string) {
        this.website = string;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long l) {
        this.resetRateComponents();
        this.startTime = l;
    }

    public long getEndTime() {
        if (this.endTime < 0L) {
            return System.currentTimeMillis();
        }
        return this.endTime;
    }

    public void setEndTime(long l) {
        this.resetRateComponents();
        this.endTime = l;
    }

    public BUnit getConsumptionUnits() {
        return this.consumptionUnits;
    }

    public void setConsumptionUnits(BUnit bUnit) {
        this.resetRateComponents();
        this.consumptionUnits = bUnit;
    }

    public BUnit getDemandUnits() {
        return this.demandUnits;
    }

    public void setDemandUnits(BUnit bUnit) {
        this.resetRateComponents();
        this.demandUnits = bUnit;
    }

    public BUnit getReactiveEnergyUnits() {
        return this.reactiveEnergyUnits;
    }

    public void setReactiveEnergyUnits(BUnit bUnit) {
        this.resetRateComponents();
        this.reactiveEnergyUnits = bUnit;
    }

    public BUnit getApparentEnergyUnits() {
        return this.apparentEnergyUnits;
    }

    public void setApparentEnergyUnits(BUnit bUnit) {
        this.resetRateComponents();
        this.apparentEnergyUnits = bUnit;
    }

    public BUnit getReactivePowerUnits() {
        return this.reactivePowerUnits;
    }

    public void setReactivePowerUnits(BUnit bUnit) {
        this.resetRateComponents();
        this.reactivePowerUnits = bUnit;
    }

    public BUnit getApparentPowerUnits() {
        return this.apparentPowerUnits;
    }

    public void setApparentPowerUnits(BUnit bUnit) {
        this.resetRateComponents();
        this.apparentPowerUnits = bUnit;
    }

    public long getBillingCycleStart() {
        return this.billingCycleStart;
    }

    public void setBillingCycleStart(long l) {
        this.resetRateComponents();
        this.billingCycleStart = l;
    }

    public TimePeriods getBillingCycle() {
        return this.billingCycle;
    }

    public void setBillingCycle(TimePeriods timePeriods) {
        this.resetRateComponents();
        this.billingCycle = timePeriods;
        if (this.billingCycle.getTimeUnits() == 0) {
            this.billingCycle.setTimeUnits(5);
        }
    }

    public RateComponent[] getRateComponents() {
        return this.rateComponents;
    }

    public void setRateComponents(RateComponent[] rateComponentArray) {
        this.rateComponents = rateComponentArray;
        if (this.rateComponents == null) {
            return;
        }
        for (int i = 0; i < this.rateComponents.length; ++i) {
            this.rateComponents[i].setParentRate(this);
        }
    }

    public void addRateComponent(RateComponent rateComponent) {
        rateComponent.setParentRate(this);
        if (this.rateComponents == null) {
            this.rateComponents = new RateComponent[1];
            this.rateComponents[0] = rateComponent;
            return;
        }
        RateComponent[] rateComponentArray = new RateComponent[this.rateComponents.length + 1];
        for (int i = 0; i < this.rateComponents.length; ++i) {
            rateComponentArray[i] = this.rateComponents[i];
        }
        rateComponentArray[this.rateComponents.length] = rateComponent;
        this.rateComponents = rateComponentArray;
    }

    public void removeRateComponent(RateComponent rateComponent) {
        if (this.rateComponents != null && this.rateComponents.length > 0) {
            int n = -1;
            for (int i = 0; i < this.rateComponents.length; ++i) {
                if (!this.rateComponents[i].equals(rateComponent)) continue;
                n = i;
                this.rateComponents[i].setParentRate(null);
                break;
            }
            if (n >= 0) {
                RateComponent[] rateComponentArray = new RateComponent[this.rateComponents.length - 1];
                int n2 = 0;
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (i == n) continue;
                    rateComponentArray[n2] = this.rateComponents[i];
                    ++n2;
                }
                this.rateComponents = rateComponentArray;
            }
        }
    }

    public void computeForInterval(String string, long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.doComputeForInterval(string, l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
    }

    public void computeForInterval(String string, long l, long l2, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.doComputeForInterval(string, l, l2, meterArray, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
    }

    private void doComputeForInterval(String string, long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.setCalculatedCostForInterval(this.computeCostForInterval(string, l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint));
    }

    private void doComputeForInterval(String string, long l, long l2, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        this.setCalculatedCostForInterval(this.computeCostForInterval(string, l, l2, meterArray, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint));
    }

    public double computeCostForInterval(String string, long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3;
        RawCostData rawCostData = this.getConsumptionNormPopulation(l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData2 = this.getDemandNormPopulation(l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData3 = this.getReactiveEnergyNormPopulation(l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData4 = this.getApparentEnergyNormPopulation(l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData5 = this.getReactivePowerNormPopulation(l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData6 = this.getApparentPowerNormPopulation(l, l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData7 = this.getDemandNormPopulation(l3, l2 < (l3 = this.getStartTime()) ? l3 : l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData8 = this.getReactivePowerNormPopulation(l3, l2 < l3 ? l3 : l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData9 = this.getApparentPowerNormPopulation(l3, l2 < l3 ? l3 : l2, meter, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        double d3 = 0.0;
        double d4 = 1.0;
        try {
            d4 = meter.getFloorAreaValue();
        }
        catch (Exception exception) {
            System.out.println("Could not find floor area for meter.");
            exception.printStackTrace();
        }
        if (this.rateComponents != null && this.rateComponents.length > 0) {
            for (int i = 0; i < this.rateComponents.length; ++i) {
                long l4 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, this.rateComponents[i].getTimeZone());
                long l5 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, this.rateComponents[i].getTimeZone());
                d3 += this.rateComponents[i].computeCostForInterval(string, l4, l5, rawCostData, rawCostData2, rawCostData7, bl, d4, rawCostData3, rawCostData4, rawCostData5, rawCostData6, rawCostData8, rawCostData9);
            }
        }
        return d3;
    }

    public double computeCostForInterval(String string, long l, long l2, Meter[] meterArray, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        int n2;
        Object object;
        Object object2;
        if (meterArray == null || meterArray.length <= 0) {
            return 0.0;
        }
        if (meterArray.length == 1) {
            return this.computeCostForInterval(string, l, l2, meterArray[0], bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
        }
        RawCostData rawCostData = this.getConsumptionPopulation(l, l2, meterArray, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData2 = this.getDemandPopulation(l, l2, meterArray, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData3 = this.getReactiveEnergyPopulation(l, l2, meterArray, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData4 = this.getApparentEnergyPopulation(l, l2, meterArray, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData5 = this.getReactivePowerPopulation(l, l2, meterArray, bl3, n, d2, bl4, dataPoint);
        RawCostData rawCostData6 = this.getApparentPowerPopulation(l, l2, meterArray, bl3, n, d2, bl4, dataPoint);
        long l3 = this.getStartTime();
        if (l3 < 0L) {
            l3 = EasLocalTime.getCurrentTime().getTimestamp(CostTimeUtil.DEFAULT_TZ);
            for (int i = 0; i < meterArray.length; ++i) {
                object2 = null;
                try {
                    if (rateLoader == null) {
                        rateLoader = new EasCostHandler();
                    }
                    object2 = rateLoader.loadRateHistoryById(meterArray[i].getId());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (object2 == null || (object = ((RateHistory)object2).getRateLinks()) == null) continue;
                for (int j = 0; j < ((RateLink[])object).length; ++j) {
                    if (object[j].getStartTime() >= l3) continue;
                    l3 = object[j].getStartTime();
                }
            }
        }
        RawCostData rawCostData7 = this.getDemandPopulation(l3, l2 < l3 ? l3 : l2, meterArray, bl3, n, d2, bl4, dataPoint);
        object2 = this.getReactivePowerPopulation(l3, l2 < l3 ? l3 : l2, meterArray, bl3, n, d2, bl4, dataPoint);
        object = this.getApparentPowerPopulation(l3, l2 < l3 ? l3 : l2, meterArray, bl3, n, d2, bl4, dataPoint);
        double d3 = 0.0;
        double d4 = 1.0;
        try {
            if (meterArray != null) {
                for (n2 = 0; n2 < meterArray.length; ++n2) {
                    d4 += meterArray[n2].getFloorAreaValue();
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Could not find floor area for meters.");
            exception.printStackTrace();
        }
        if (this.rateComponents != null && this.rateComponents.length > 0) {
            for (n2 = 0; n2 < this.rateComponents.length; ++n2) {
                long l4 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, this.rateComponents[n2].getTimeZone());
                long l5 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, this.rateComponents[n2].getTimeZone());
                d3 += this.rateComponents[n2].computeCostForInterval(string, l4, l5, rawCostData, rawCostData2, rawCostData7, bl, d4, rawCostData3, rawCostData4, rawCostData5, rawCostData6, (RawCostData)object2, (RawCostData)object);
            }
        }
        return d3;
    }

    private void resetRateComponents() {
        if (this.rateComponents != null && this.rateComponents.length > 0) {
            for (int i = 0; i < this.rateComponents.length; ++i) {
                this.rateComponents[i].setComputeFromScratch(true);
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n  name: " + this.getName());
        stringBuffer.append("\n  energyProvider: " + this.getEnergyProvider());
        stringBuffer.append("\n  location: " + this.getLocation());
        stringBuffer.append("\n  phoneNumber: " + this.getPhoneNumber());
        stringBuffer.append("\n  website: " + this.getWebsite());
        stringBuffer.append("\n  currency: " + this.getCurrency());
        stringBuffer.append("\n  calculatedCostForInterval: " + this.getCalculatedCostForInterval());
        stringBuffer.append("\n  startTime: " + this.getStartTime());
        stringBuffer.append("\n  endTime: " + this.getEndTime());
        stringBuffer.append("\n  consumptionUnits: " + this.getConsumptionUnits());
        stringBuffer.append("\n  demandUnits: " + this.getDemandUnits());
        stringBuffer.append("\n  reactiveEnergyUnits: " + this.getReactiveEnergyUnits());
        stringBuffer.append("\n  apparentEnergyUnits: " + this.getApparentEnergyUnits());
        stringBuffer.append("\n  reactivePowerUnits: " + this.getReactivePowerUnits());
        stringBuffer.append("\n  apparentPowerUnits: " + this.getApparentPowerUnits());
        stringBuffer.append("\n  billingCycleStart: " + this.getBillingCycleStart());
        stringBuffer.append("\n  billingCycle: " + this.getBillingCycle());
        RateComponent[] rateComponentArray = this.getRateComponents();
        if (rateComponentArray != null) {
            for (int i = 0; i < rateComponentArray.length; ++i) {
                stringBuffer.append("\n    rateComponent[" + i + "]: " + rateComponentArray[i].toDebugString());
            }
        }
        return stringBuffer.toString();
    }

    public boolean includes(long l, BTimeZone bTimeZone) {
        long l2 = CostTimeUtil.convertTime(l, bTimeZone, CostTimeUtil.DEFAULT_TZ);
        return this.getStartTime() <= l2 && (this.endTime == -1L || this.getEndTime() > l2);
    }

    public boolean isEffective(long l, long l2) {
        return (this.endTime == -1L || l < this.getEndTime()) && l2 >= this.getStartTime();
    }

    public RawCostData getConsumptionNormPopulation(long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3 = l;
        Population population = null;
        try {
            long l4;
            DataPoint dataPoint2 = meter.getDataPoint(RcSubtype.CONSUMPTION.getCode());
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getDataSummary(new EasLocalTime(l3, bTimeZone), new EasLocalTime((l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone)) + 2700000L, bTimeZone), dataPoint2.getUnit(), -1, 0, TimeInterval.INTERVAL_15_MINUTES, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getConsumptionPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 0) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 0, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getConsumptionPopulation(long l, long l2, Meter[] meterArray, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) {
        if (meterArray == null) {
            return null;
        }
        long l3 = l;
        Population population = null;
        try {
            int n2 = meterArray.length;
            String[] stringArray = new String[n2];
            BTimeZone[] bTimeZoneArray = new BTimeZone[n2];
            double[] dArray = new double[n2];
            BUnit[] bUnitArray = new BUnit[n2];
            DataPoint dataPoint2 = null;
            for (int i = 0; i < n2; ++i) {
                dataPoint2 = meterArray[i].getDataPoint(RcSubtype.CONSUMPTION.getCode());
                if (dataPoint2 == null) continue;
                stringArray[i] = dataPoint2.getName();
                bTimeZoneArray[i] = dataPoint2.getTimeZone();
                bUnitArray[i] = dataPoint2.getUnit();
                dArray[i] = 1.0;
            }
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            long l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getSession().getDataPointExec().getAggregatedSummary(stringArray, new EasLocalTime(l3, bTimeZone), new EasLocalTime(l4 + 2700000L, bTimeZone), bTimeZoneArray, RestorationMethod.SUM, -1, 0, TimeInterval.INTERVAL_15_MINUTES, 0, dArray, bUnitArray, dataPoint2.getUnit(), 1, dataPoint2.getSamplingInterval(), bl, n, d, bl2, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getConsumptionPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 0) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 0, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getDemandNormPopulation(long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3 = l;
        Population population = null;
        try {
            long l4;
            DataPoint dataPoint2 = meter.getDataPoint(RcSubtype.DEMAND.getCode());
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getDataSummary(new EasLocalTime(l3, bTimeZone), new EasLocalTime((l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone)) + 2700000L, bTimeZone), dataPoint2.getUnit(), -1, 0, TimeInterval.INTERVAL_15_MINUTES, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getDemandPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 1) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 1, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getDemandPopulation(long l, long l2, Meter[] meterArray, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) {
        if (meterArray == null) {
            return null;
        }
        long l3 = l;
        Population population = null;
        try {
            int n2 = meterArray.length;
            String[] stringArray = new String[n2];
            BTimeZone[] bTimeZoneArray = new BTimeZone[n2];
            double[] dArray = new double[n2];
            BUnit[] bUnitArray = new BUnit[n2];
            DataPoint dataPoint2 = null;
            for (int i = 0; i < n2; ++i) {
                dataPoint2 = meterArray[i].getDataPoint(RcSubtype.DEMAND.getCode());
                if (dataPoint2 == null) continue;
                stringArray[i] = dataPoint2.getName();
                bTimeZoneArray[i] = dataPoint2.getTimeZone();
                bUnitArray[i] = dataPoint2.getUnit();
                dArray[i] = 1.0;
            }
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            long l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getSession().getDataPointExec().getAggregatedSummary(stringArray, new EasLocalTime(l3, bTimeZone), new EasLocalTime(l4 + 2700000L, bTimeZone), bTimeZoneArray, RestorationMethod.MAX, -1, 0, TimeInterval.INTERVAL_15_MINUTES, 0, dArray, bUnitArray, dataPoint2.getUnit(), 2, dataPoint2.getSamplingInterval(), bl, n, d, bl2, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getDemandPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 1) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 1, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getReactiveEnergyNormPopulation(long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3 = l;
        Population population = null;
        try {
            long l4;
            DataPoint dataPoint2 = meter.getDataPoint(RcSubtype.REACTIVE_ENERGY.getCode());
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getDataSummary(new EasLocalTime(l3, bTimeZone), new EasLocalTime((l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone)) + 2700000L, bTimeZone), dataPoint2.getUnit(), -1, 0, TimeInterval.INTERVAL_15_MINUTES, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getConsumptionPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 2) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 2, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getReactiveEnergyPopulation(long l, long l2, Meter[] meterArray, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) {
        if (meterArray == null) {
            return null;
        }
        long l3 = l;
        Population population = null;
        try {
            int n2 = meterArray.length;
            String[] stringArray = new String[n2];
            BTimeZone[] bTimeZoneArray = new BTimeZone[n2];
            double[] dArray = new double[n2];
            BUnit[] bUnitArray = new BUnit[n2];
            DataPoint dataPoint2 = null;
            for (int i = 0; i < n2; ++i) {
                dataPoint2 = meterArray[i].getDataPoint(RcSubtype.REACTIVE_ENERGY.getCode());
                if (dataPoint2 == null) continue;
                stringArray[i] = dataPoint2.getName();
                bTimeZoneArray[i] = dataPoint2.getTimeZone();
                bUnitArray[i] = dataPoint2.getUnit();
                dArray[i] = 1.0;
            }
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            long l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getSession().getDataPointExec().getAggregatedSummary(stringArray, new EasLocalTime(l3, bTimeZone), new EasLocalTime(l4 + 2700000L, bTimeZone), bTimeZoneArray, RestorationMethod.SUM, -1, 0, TimeInterval.INTERVAL_15_MINUTES, 0, dArray, bUnitArray, dataPoint2.getUnit(), 1, dataPoint2.getSamplingInterval(), bl, n, d, bl2, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getConsumptionPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 2) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 2, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getApparentEnergyNormPopulation(long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3 = l;
        Population population = null;
        try {
            long l4;
            DataPoint dataPoint2 = meter.getDataPoint(RcSubtype.APPARENT_ENERGY.getCode());
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getDataSummary(new EasLocalTime(l3, bTimeZone), new EasLocalTime((l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone)) + 2700000L, bTimeZone), dataPoint2.getUnit(), -1, 0, TimeInterval.INTERVAL_15_MINUTES, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getConsumptionPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 4) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 4, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getApparentEnergyPopulation(long l, long l2, Meter[] meterArray, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) {
        if (meterArray == null) {
            return null;
        }
        long l3 = l;
        Population population = null;
        try {
            int n2 = meterArray.length;
            String[] stringArray = new String[n2];
            BTimeZone[] bTimeZoneArray = new BTimeZone[n2];
            double[] dArray = new double[n2];
            BUnit[] bUnitArray = new BUnit[n2];
            DataPoint dataPoint2 = null;
            for (int i = 0; i < n2; ++i) {
                dataPoint2 = meterArray[i].getDataPoint(RcSubtype.APPARENT_ENERGY.getCode());
                if (dataPoint2 == null) continue;
                stringArray[i] = dataPoint2.getName();
                bTimeZoneArray[i] = dataPoint2.getTimeZone();
                bUnitArray[i] = dataPoint2.getUnit();
                dArray[i] = 1.0;
            }
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            long l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getSession().getDataPointExec().getAggregatedSummary(stringArray, new EasLocalTime(l3, bTimeZone), new EasLocalTime(l4 + 2700000L, bTimeZone), bTimeZoneArray, RestorationMethod.SUM, -1, 0, TimeInterval.INTERVAL_15_MINUTES, 0, dArray, bUnitArray, dataPoint2.getUnit(), 1, dataPoint2.getSamplingInterval(), bl, n, d, bl2, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getConsumptionPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 4) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 4, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getReactivePowerNormPopulation(long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3 = l;
        Population population = null;
        try {
            long l4;
            DataPoint dataPoint2 = meter.getDataPoint(RcSubtype.REACTIVE_POWER.getCode());
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getDataSummary(new EasLocalTime(l3, bTimeZone), new EasLocalTime((l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone)) + 2700000L, bTimeZone), dataPoint2.getUnit(), -1, 0, TimeInterval.INTERVAL_15_MINUTES, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getDemandPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 3) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 3, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getReactivePowerPopulation(long l, long l2, Meter[] meterArray, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) {
        if (meterArray == null) {
            return null;
        }
        long l3 = l;
        Population population = null;
        try {
            int n2 = meterArray.length;
            String[] stringArray = new String[n2];
            BTimeZone[] bTimeZoneArray = new BTimeZone[n2];
            double[] dArray = new double[n2];
            BUnit[] bUnitArray = new BUnit[n2];
            DataPoint dataPoint2 = null;
            for (int i = 0; i < n2; ++i) {
                dataPoint2 = meterArray[i].getDataPoint(RcSubtype.REACTIVE_POWER.getCode());
                if (dataPoint2 == null) continue;
                stringArray[i] = dataPoint2.getName();
                bTimeZoneArray[i] = dataPoint2.getTimeZone();
                bUnitArray[i] = dataPoint2.getUnit();
                dArray[i] = 1.0;
            }
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            long l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getSession().getDataPointExec().getAggregatedSummary(stringArray, new EasLocalTime(l3, bTimeZone), new EasLocalTime(l4 + 2700000L, bTimeZone), bTimeZoneArray, RestorationMethod.MAX, -1, 0, TimeInterval.INTERVAL_15_MINUTES, 0, dArray, bUnitArray, dataPoint2.getUnit(), 2, dataPoint2.getSamplingInterval(), bl, n, d, bl2, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getDemandPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 3) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 3, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getApparentPowerNormPopulation(long l, long l2, Meter meter, boolean bl, boolean bl2, BUnit bUnit, double d, boolean bl3, int n, double d2, boolean bl4, DataPoint dataPoint) {
        long l3 = l;
        Population population = null;
        try {
            long l4;
            DataPoint dataPoint2 = meter.getDataPoint(RcSubtype.APPARENT_POWER.getCode());
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getDataSummary(new EasLocalTime(l3, bTimeZone), new EasLocalTime((l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone)) + 2700000L, bTimeZone), dataPoint2.getUnit(), -1, 0, TimeInterval.INTERVAL_15_MINUTES, bl, bl2, bUnit, d, bl3, n, d2, bl4, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getDemandPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 5) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 5, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    public RawCostData getApparentPowerPopulation(long l, long l2, Meter[] meterArray, boolean bl, int n, double d, boolean bl2, DataPoint dataPoint) {
        if (meterArray == null) {
            return null;
        }
        long l3 = l;
        Population population = null;
        try {
            int n2 = meterArray.length;
            String[] stringArray = new String[n2];
            BTimeZone[] bTimeZoneArray = new BTimeZone[n2];
            double[] dArray = new double[n2];
            BUnit[] bUnitArray = new BUnit[n2];
            DataPoint dataPoint2 = null;
            for (int i = 0; i < n2; ++i) {
                dataPoint2 = meterArray[i].getDataPoint(RcSubtype.APPARENT_POWER.getCode());
                if (dataPoint2 == null) continue;
                stringArray[i] = dataPoint2.getName();
                bTimeZoneArray[i] = dataPoint2.getTimeZone();
                bUnitArray[i] = dataPoint2.getUnit();
                dArray[i] = 1.0;
            }
            if (dataPoint2 == null) {
                return null;
            }
            BTimeZone bTimeZone = dataPoint2.getTimeZone();
            l3 = CostTimeUtil.convertTime(l, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            long l4 = CostTimeUtil.convertTime(l2, CostTimeUtil.DEFAULT_TZ, bTimeZone);
            TSDataSummary tSDataSummary = dataPoint2.getSession().getDataPointExec().getAggregatedSummary(stringArray, new EasLocalTime(l3, bTimeZone), new EasLocalTime(l4 + 2700000L, bTimeZone), bTimeZoneArray, RestorationMethod.MAX, -1, 0, TimeInterval.INTERVAL_15_MINUTES, 0, dArray, bUnitArray, dataPoint2.getUnit(), 2, dataPoint2.getSamplingInterval(), bl, n, d, bl2, dataPoint);
            if (tSDataSummary != null) {
                population = tSDataSummary.getDemandPopulation();
            }
            if (this.rateComponents != null && this.rateComponents.length > 0) {
                for (int i = 0; i < this.rateComponents.length; ++i) {
                    if (this.rateComponents[i].getApplicableData() == 5) {
                        this.rateComponents[i].setTimeZone(bTimeZone);
                    }
                    if (!(this.rateComponents[i] instanceof ChoiceComponent)) continue;
                    Rate.setChoiceTimeZone((ChoiceComponent)this.rateComponents[i], 5, bTimeZone);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (population == null) {
            return null;
        }
        return new RawCostData(population, l3, 15);
    }

    private static void setChoiceTimeZone(ChoiceComponent choiceComponent, int n, BTimeZone bTimeZone) {
        if (choiceComponent == null) {
            return;
        }
        ChoiceComponentChild[] choiceComponentChildArray = choiceComponent.getRateComponents();
        if (choiceComponentChildArray != null) {
            for (int i = 0; i < choiceComponentChildArray.length; ++i) {
                if (choiceComponentChildArray[i] == null) continue;
                if (((RateComponent)choiceComponentChildArray[i]).getApplicableData() == n) {
                    ((RateComponent)choiceComponentChildArray[i]).setTimeZone(bTimeZone);
                }
                if (!(choiceComponentChildArray[i] instanceof ChoiceComponent)) continue;
                Rate.setChoiceTimeZone((ChoiceComponent)((Object)choiceComponentChildArray[i]), n, bTimeZone);
            }
        }
    }

    public String getType() {
        return TYPE;
    }

    public void addChildObject(XmlSupport xmlSupport) {
        if (xmlSupport == null) {
            return;
        }
        if (xmlSupport instanceof XmlSimple) {
            String string = ((XmlSimple)xmlSupport).getName();
            String string2 = ((XmlSimple)xmlSupport).getValue();
            if (string.equals("currency")) {
                try {
                    this.setCurrency(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {}
            } else if (string.equals("energyProvider")) {
                this.setEnergyProvider(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("location")) {
                this.setLocation(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("phoneNumber")) {
                this.setPhoneNumber(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("website")) {
                this.setWebsite(XmlEncoder.decodeXmlString(string2));
            } else if (string.equals("startTime")) {
                this.setStartTime(Long.parseLong(string2));
            } else if (string.equals("endTime")) {
                this.setEndTime(Long.parseLong(string2));
            } else if (string.equals("consumptionUnits")) {
                try {
                    this.setConsumptionUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("demandUnits")) {
                try {
                    this.setDemandUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("reactiveEnergyUnits")) {
                try {
                    this.setReactiveEnergyUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("apparentEnergyUnits")) {
                try {
                    this.setApparentEnergyUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("reactivePowerUnits")) {
                try {
                    this.setReactivePowerUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("apparentPowerUnits")) {
                try {
                    this.setApparentPowerUnits(BUnit.getUnit((String)XmlEncoder.decodeXmlString(string2)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else if (string.equals("billingCycleStart")) {
                this.setBillingCycleStart(Long.parseLong(string2));
            } else if (string.equals("calculatedCostForInterval")) {
                this.setCalculatedCostForInterval(Double.valueOf(string2));
            }
        } else if (xmlSupport instanceof TimePeriods) {
            this.setBillingCycle((TimePeriods)xmlSupport);
        } else if (xmlSupport instanceof RateComponent) {
            this.addRateComponent((RateComponent)xmlSupport);
        }
    }

    public XmlSupport[] getChildObjects() {
        XmlSupport[] xmlSupportArray = this.getRateComponents();
        int n = 16;
        if (xmlSupportArray != null) {
            n = xmlSupportArray.length + 16;
        }
        XmlSupport[] xmlSupportArray2 = new XmlSupport[n];
        xmlSupportArray2[0] = new XmlSimple("currency", XmlEncoder.encodeXmlString(this.getCurrency() != null ? this.getCurrency().getUnitName() : ""));
        xmlSupportArray2[1] = new XmlSimple("energyProvider", XmlEncoder.encodeXmlString(this.getEnergyProvider()));
        xmlSupportArray2[2] = new XmlSimple("location", XmlEncoder.encodeXmlString(this.getLocation()));
        xmlSupportArray2[3] = new XmlSimple("phoneNumber", XmlEncoder.encodeXmlString(this.getPhoneNumber()));
        xmlSupportArray2[4] = new XmlSimple("website", XmlEncoder.encodeXmlString(this.getWebsite()));
        xmlSupportArray2[5] = new XmlSimple("startTime", String.valueOf(this.getStartTime()));
        xmlSupportArray2[6] = new XmlSimple("endTime", String.valueOf(this.endTime));
        xmlSupportArray2[7] = new XmlSimple("consumptionUnits", XmlEncoder.encodeXmlString(this.getConsumptionUnits() != null ? this.getConsumptionUnits().getUnitName() : ""));
        xmlSupportArray2[8] = new XmlSimple("demandUnits", XmlEncoder.encodeXmlString(this.getDemandUnits() != null ? this.getDemandUnits().getUnitName() : ""));
        xmlSupportArray2[9] = new XmlSimple("reactiveEnergyUnits", XmlEncoder.encodeXmlString(this.getReactiveEnergyUnits() != null ? this.getReactiveEnergyUnits().getUnitName() : ""));
        xmlSupportArray2[10] = new XmlSimple("apparentEnergyUnits", XmlEncoder.encodeXmlString(this.getApparentEnergyUnits() != null ? this.getApparentEnergyUnits().getUnitName() : ""));
        xmlSupportArray2[11] = new XmlSimple("reactivePowerUnits", XmlEncoder.encodeXmlString(this.getReactivePowerUnits() != null ? this.getReactivePowerUnits().getUnitName() : ""));
        xmlSupportArray2[12] = new XmlSimple("apparentPowerUnits", XmlEncoder.encodeXmlString(this.getApparentPowerUnits() != null ? this.getApparentPowerUnits().getUnitName() : ""));
        xmlSupportArray2[13] = new XmlSimple("billingCycleStart", String.valueOf(this.getBillingCycleStart()));
        xmlSupportArray2[14] = new XmlSimple("calculatedCostForInterval", String.valueOf(this.getCalculatedCostForInterval()));
        xmlSupportArray2[15] = this.getBillingCycle();
        if (xmlSupportArray != null) {
            for (int i = 0; i < xmlSupportArray.length; ++i) {
                xmlSupportArray2[i + 16] = xmlSupportArray[i];
            }
        }
        return xmlSupportArray2;
    }

    public String encodeToString() {
        return null;
    }

    public void decodeFromString(String string) {
    }
}

