/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.util.Alg;
import javax.baja.timezone.BTimeZone;

public class TimeInterval {
    public static final int INTERVAL_MILLS = 1;
    public static final int INTERVAL_MILLIS = 1;
    public static final int INTERVAL_SECOND = 2;
    public static final int INTERVAL_MINUTE = 3;
    public static final int INTERVAL_HOUR = 4;
    public static final int INTERVAL_DAY = 5;
    public static final int INTERVAL_WEEK = 6;
    public static final int INTERVAL_MONTH = 7;
    public static final int INTERVAL_YEAR = 8;
    public static int MILLIS_IN_DAY = 86400000;
    public static final TimeInterval INTERVAL_15_MINUTES = new TimeInterval(15L, 3);
    public static final TimeInterval INTERVAL_20_MINUTES = new TimeInterval(20L, 3);
    public static final TimeInterval HALF_HOUR = new TimeInterval(30L, 3);
    public static final TimeInterval ONE_HOUR = new TimeInterval(1L, 4);
    public static final TimeInterval SIX_HOURS = new TimeInterval(6L, 4);
    public static final TimeInterval HALF_DAY = new TimeInterval(12L, 4);
    public static final TimeInterval ONE_DAY = new TimeInterval(1L, 5);
    public static final TimeInterval ONE_WEEK = new TimeInterval(7L, 5);
    public static final TimeInterval ONE_MONTH = new TimeInterval(1L, 7);
    public static final TimeInterval INFINITY = new TimeInterval(Long.MAX_VALUE, 1);
    public static final BTimeZone GMT = BTimeZone.getTimeZone((String)"GMT");
    private int timeUnit;
    private long nUnits;

    public TimeInterval(long l, int n) {
        this.timeUnit = n;
        this.nUnits = l;
    }

    public void set(long l, int n) {
        this.timeUnit = n;
        this.nUnits = l;
    }

    public boolean equals(TimeInterval timeInterval) {
        return this.getMilliseconds() == timeInterval.getMilliseconds();
    }

    public boolean equals(long l) {
        return this.getMilliseconds() == l;
    }

    public boolean longer(TimeInterval timeInterval) {
        return this.getMilliseconds() > timeInterval.getMilliseconds();
    }

    public boolean longer(long l) {
        return this.getMilliseconds() > l;
    }

    public boolean shorter(TimeInterval timeInterval) {
        return this.getMilliseconds() < timeInterval.getMilliseconds();
    }

    public boolean shorter(long l) {
        return this.getMilliseconds() < l;
    }

    public boolean shorterUnits(TimeInterval timeInterval) {
        return TimeInterval.getIntervalInMillis(1L, this.getUnit()) < TimeInterval.getIntervalInMillis(1L, timeInterval.getUnit());
    }

    public TimeInterval toShorterUnit() {
        switch (this.getUnit()) {
            case 1: {
                return this;
            }
            case 2: {
                return new TimeInterval(this.getNUnits() * 1000L, 1);
            }
            case 3: {
                return new TimeInterval(this.getNUnits() * 60L, 2);
            }
            case 4: {
                return new TimeInterval(this.getNUnits() * 60L, 3);
            }
            case 5: {
                return new TimeInterval(this.getNUnits() * 24L, 4);
            }
            case 6: {
                return new TimeInterval(this.getNUnits() * 7L, 5);
            }
            case 7: {
                return new TimeInterval(this.getNUnits() * 31L, 5);
            }
            case 8: {
                return new TimeInterval(this.getNUnits() * 12L, 7);
            }
        }
        throw new IllegalArgumentException("Illegal time unit " + this.getUnit());
    }

    public TimeInterval getGreatestCommonInterval(TimeInterval timeInterval) {
        if (timeInterval.equals(INFINITY)) {
            return this;
        }
        if (this.equals(INFINITY)) {
            return timeInterval;
        }
        if (this.getUnit() == timeInterval.getUnit()) {
            long l;
            long l2 = this.getNUnits();
            long l3 = Alg.getGreatestCommonDivisor(l2, l = timeInterval.getNUnits());
            if (l3 == 1L && this.getUnit() != 1) {
                return this.toShorterUnit().getGreatestCommonInterval(timeInterval.toShorterUnit());
            }
            return new TimeInterval(l3, this.getUnit());
        }
        if (this.shorterUnits(timeInterval)) {
            TimeInterval timeInterval2 = timeInterval.toShorterUnit();
            while (this.shorterUnits(timeInterval2)) {
                timeInterval2 = timeInterval2.toShorterUnit();
            }
            return this.getGreatestCommonInterval(timeInterval2);
        }
        TimeInterval timeInterval3 = this.toShorterUnit();
        while (timeInterval3.shorterUnits(timeInterval)) {
            timeInterval3 = timeInterval3.toShorterUnit();
        }
        return timeInterval3.getGreatestCommonInterval(timeInterval);
    }

    public boolean isMultipleOf(TimeInterval timeInterval) {
        if (this.getUnit() == timeInterval.getUnit()) {
            long l;
            long l2 = this.getNUnits();
            if (l2 > (l = timeInterval.getNUnits())) {
                return l2 % l == 0L;
            }
            if (l > l2) {
                return l % l2 == 0L;
            }
            return true;
        }
        if (this.shorterUnits(timeInterval)) {
            TimeInterval timeInterval2 = timeInterval.toShorterUnit();
            while (this.shorterUnits(timeInterval2)) {
                timeInterval2 = timeInterval2.toShorterUnit();
            }
            return this.isMultipleOf(timeInterval2);
        }
        TimeInterval timeInterval3 = this.toShorterUnit();
        while (timeInterval3.shorterUnits(timeInterval)) {
            timeInterval3 = timeInterval3.toShorterUnit();
        }
        return timeInterval3.isMultipleOf(timeInterval);
    }

    public void setUnit(int n) {
        this.timeUnit = n;
    }

    public void setNUnits(long l) {
        this.nUnits = l;
    }

    public int getUnit() {
        return this.timeUnit;
    }

    public long getNUnits() {
        return this.nUnits;
    }

    public long getMilliseconds() {
        return TimeInterval.getIntervalInMillis(this.nUnits, this.timeUnit);
    }

    public static long getIntervalInMillis(long l, int n) {
        switch (n) {
            case 1: {
                return l;
            }
            case 2: {
                return l * 1000L;
            }
            case 3: {
                return l * 60L * 1000L;
            }
            case 4: {
                return l * 60L * 60L * 1000L;
            }
            case 5: {
                return l * 24L * 60L * 60L * 1000L;
            }
            case 6: {
                return l * 7L * 24L * 60L * 60L * 1000L;
            }
            case 7: {
                return (long)((double)l * 30.475 * 24.0 * 60.0 * 60.0 * 1000.0);
            }
            case 8: {
                return (long)((double)l * 365.25 * 24.0 * 60.0 * 60.0 * 1000.0);
            }
        }
        return 0L;
    }

    public int getCalendarField() {
        return TimeInterval.getCalendarField(this.timeUnit);
    }

    public static int getCalendarField(int n) {
        switch (n) {
            case 1: {
                return 14;
            }
            case 2: {
                return 13;
            }
            case 3: {
                return 12;
            }
            case 4: {
                return 11;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 2;
            }
            case 8: {
                return 1;
            }
        }
        return -1;
    }

    public int getIndexByOffset(long l) {
        switch (this.timeUnit) {
            case 1: {
                return (int)(l / this.nUnits);
            }
            case 2: {
                return (int)(l / (this.nUnits * 1000L));
            }
            case 3: {
                return (int)(l / (this.nUnits * 60000L));
            }
            case 4: {
                return (int)(l / (this.nUnits * 3600000L));
            }
            case 5: {
                return (int)(l / (this.nUnits * 24L * 3600000L));
            }
            case 6: {
                return (int)(l / (this.nUnits * 7L * 24L * 3600000L));
            }
        }
        throw new IllegalArgumentException("Illegal intl_unit agument value " + this.timeUnit);
    }

    public String toString() {
        return "TimeInterval[" + this.timeUnit + "," + this.nUnits + "]";
    }
}

