/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataSummaryElement;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.function.Population;
import javax.baja.units.BUnit;

public class TSDataSummaryRepeating
extends TSDataSummary {
    private int repeatSize = 0;

    public TSDataSummaryRepeating(TSDataSummary tSDataSummary, int n, RegularTimeParameters regularTimeParameters) {
        super(regularTimeParameters, tSDataSummary.getValueUnit(), tSDataSummary.getSummaries());
        this.repeatSize = n;
    }

    public DataSummaryElement getDataSummary(int n) {
        return this.getSummaries()[n % this.getDataSize()];
    }

    public int getDataSize() {
        return this.getSummaries() == null ? 0 : this.getSummaries().length;
    }

    public int getSize() {
        return this.getSummaries() == null ? 0 : this.repeatSize;
    }

    public boolean isValid(int n) {
        return this.getSummaries()[n % this.getDataSize()].isValid();
    }

    protected void convertUnit(int n, BUnit bUnit) {
        this.getSummaries()[n % this.getDataSize()].convertUnit(this.getValueUnit(), bUnit);
    }

    public Population getMeanPopulation() {
        return new Population(){

            public BUnit getUnit() {
                return TSDataSummaryRepeating.this.getValueUnit();
            }

            public int getSize() {
                return TSDataSummaryRepeating.this.getSize();
            }

            public double getSample(int n) {
                return TSDataSummaryRepeating.this.getSummaries()[n % TSDataSummaryRepeating.this.getDataSize()].getAvgDemand();
            }

            public boolean isValid(int n) {
                return TSDataSummaryRepeating.this.isValid(n);
            }
        };
    }

    public Population getDemandPopulation() {
        return new Population(){

            public BUnit getUnit() {
                return TSDataSummaryRepeating.this.getValueUnit();
            }

            public int getSize() {
                return TSDataSummaryRepeating.this.getSize();
            }

            public double getSample(int n) {
                return TSDataSummaryRepeating.this.getSummaries()[n % TSDataSummaryRepeating.this.getDataSize()].getPeakDemand();
            }

            public boolean isValid(int n) {
                return TSDataSummaryRepeating.this.isValid(n);
            }
        };
    }

    public Population getConsumptionPopulation() {
        return new Population(){

            public BUnit getUnit() {
                return TSDataSummaryRepeating.this.getValueUnit();
            }

            public int getSize() {
                return TSDataSummaryRepeating.this.getSize();
            }

            public double getSample(int n) {
                return TSDataSummaryRepeating.this.getSummaries()[n % TSDataSummaryRepeating.this.getDataSize()].getTotalConsumption();
            }

            public boolean isValid(int n) {
                return TSDataSummaryRepeating.this.isValid(n);
            }
        };
    }
}

