/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataSample;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.TSData;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public class TSDataIrregular
implements TSData {
    private EasLocalTime easStartTime;
    private BTimeZone tz;
    private long zonelessStart;
    private long defaultStart;
    private long localStart;
    private DataSample[] data;
    private BUnit valueUnit;
    protected static final BTimeZone GMT = BTimeZone.getTimeZone((String)"GMT");

    public TSDataIrregular() {
    }

    public TSDataIrregular(DataSample[] dataSampleArray, BTimeZone bTimeZone) {
        this.data = dataSampleArray;
        this.tz = bTimeZone;
        if (dataSampleArray != null && dataSampleArray.length > 0) {
            this.defaultStart = dataSampleArray[0].getTime();
            this.easStartTime = new EasLocalTime(this.defaultStart, bTimeZone);
            this.zonelessStart = this.easStartTime.getTimestamp(GMT);
            this.localStart = this.easStartTime.getTimestamp(BTimeZone.getLocal());
        }
    }

    public int getSize() {
        return this.data == null ? 0 : this.data.length;
    }

    public double getDouble(int n) {
        return this.data[n].getDouble();
    }

    public boolean getBool(int n) {
        return this.data[n].getBool();
    }

    public int getStatus(int n) {
        return this.data[n].getStatus();
    }

    public long getOffsetMillis(int n) {
        return this.data[n].getTime() - this.defaultStart;
    }

    public long getZonelessTime(int n) {
        return this.zonelessStart + this.getOffsetMillis(n);
    }

    public long getDefaultTime(int n) {
        return this.data[n].getTime();
    }

    public long getLocalTime(int n) {
        return this.localStart + this.getOffsetMillis(n);
    }

    public BTimeZone getTimeZone() {
        return this.tz;
    }

    public void setValueUnit(BUnit bUnit) {
        this.valueUnit = bUnit;
    }

    public BUnit getValueUnit() {
        return this.valueUnit;
    }

    public EasLocalTime getStart() {
        return this.easStartTime;
    }

    public boolean isValid(int n) {
        return this.data[n].isValid();
    }

    public int getType() {
        return 2;
    }

    public int getIndexByOffset(long l) {
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getOffsetMillis(i) < l) continue;
            return i;
        }
        return -1;
    }

    public int getIndex(EasLocalTime easLocalTime) {
        return this.getIndexByOffset(easLocalTime.getTimestamp(this.tz) - this.defaultStart);
    }

    public DataSample[] getData() {
        return this.data;
    }

    protected void setEasStartTime(EasLocalTime easLocalTime) {
        this.easStartTime = easLocalTime;
    }

    protected void setZonelessStart(long l) {
        this.zonelessStart = l;
    }

    protected long getDefaultStart() {
        return this.defaultStart;
    }

    protected void setLocalStart(long l) {
        this.localStart = l;
    }
}

