/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RollupMethod;

public class RestorationMethod {
    public static final int SUM_ID = 0;
    public static final int MAX_ID = 1;
    public static final int MIN_ID = 2;
    public static final int AVG_ID = 3;
    public static final int RND_ID = 4;
    public static final int NON_ID = 5;
    public static final int MULTISTATE_ID = 6;
    public static RestorationMethod SUM = new RestorationMethod(0);
    public static RestorationMethod MAX = new RestorationMethod(1);
    public static RestorationMethod MIN = new RestorationMethod(2);
    public static RestorationMethod AVG = new RestorationMethod(3);
    public static RestorationMethod RND = new RestorationMethod(4);
    public static RestorationMethod NON = new RestorationMethod(5);
    public static RestorationMethod MULTISTATE = new RestorationMethod(6);
    private static RestorationMethod[] allMethods = new RestorationMethod[]{SUM, MAX, MIN, AVG, RND, NON, MULTISTATE};
    private int methoId;

    public RestorationMethod(int n) {
        this.methoId = n;
    }

    public RestorationMethod(RcSubtype rcSubtype) {
        this.methoId = rcSubtype.getCode() == RcSubtype.CONSUMPTION.getCode() || rcSubtype.getCode() == RcSubtype.APPARENT_ENERGY.getCode() || rcSubtype.getCode() == RcSubtype.REACTIVE_ENERGY.getCode() ? 0 : (rcSubtype.getCode() == RcSubtype.DEMAND.getCode() || rcSubtype.getCode() == RcSubtype.APPARENT_POWER.getCode() || rcSubtype.getCode() == RcSubtype.REACTIVE_POWER.getCode() ? 1 : 3);
    }

    public boolean equals(int n) {
        return this.methoId == n;
    }

    public boolean equals(RestorationMethod restorationMethod) {
        return this.methoId == restorationMethod.methoId;
    }

    public int getId() {
        return this.methoId;
    }

    public void setId(int n) {
        this.methoId = n;
    }

    public RollupMethod getRollupMethod() {
        switch (this.methoId) {
            case 2: {
                return new RollupMethod(3);
            }
            case 1: {
                return new RollupMethod(2);
            }
            case 0: {
                return new RollupMethod(1);
            }
            case 3: {
                return new RollupMethod(4);
            }
        }
        return new RollupMethod(4);
    }

    public double getInitialValue() {
        switch (this.methoId) {
            case 2: {
                return Double.MAX_VALUE;
            }
            case 1: {
                return -1.7976931348623157E308;
            }
        }
        return 0.0;
    }

    public double getNewValue(double d, double d2) {
        switch (this.methoId) {
            case 2: {
                return Math.min(d, d2);
            }
            case 1: {
                return Math.max(d, d2);
            }
            case 4: 
            case 5: 
            case 6: {
                return d2;
            }
        }
        return d + d2;
    }

    public double getRestoredValue(double d, int n) {
        if (this.methoId == 3) {
            return n == 0 ? d : d / (double)n;
        }
        return d;
    }

    public String toString() {
        switch (this.methoId) {
            case 0: {
                return "sum";
            }
            case 1: {
                return "max";
            }
            case 2: {
                return "min";
            }
            case 3: {
                return "avg";
            }
            case 4: {
                return "rnd";
            }
            case 5: {
                return "non";
            }
            case 6: {
                return "multistate";
            }
        }
        return Integer.toString(this.methoId);
    }

    public static RestorationMethod getById(int n) {
        return allMethods[n];
    }

    public static RestorationMethod getByRcSubType(RcSubtype rcSubtype) {
        int n = rcSubtype.getCode() == RcSubtype.CONSUMPTION.getCode() || rcSubtype.getCode() == RcSubtype.APPARENT_ENERGY.getCode() || rcSubtype.getCode() == RcSubtype.REACTIVE_ENERGY.getCode() ? 0 : (rcSubtype.getCode() == RcSubtype.DEMAND.getCode() || rcSubtype.getCode() == RcSubtype.APPARENT_POWER.getCode() || rcSubtype.getCode() == RcSubtype.REACTIVE_POWER.getCode() ? 1 : 3);
        return allMethods[n];
    }
}

