/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.function.Population;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public class RegularTimeParameters {
    private EasLocalTime startTime;
    private TimeInterval interval;
    private long zonelessStart;
    private long defaultStart;
    private long localStart;
    private BTimeZone tz;
    private EasLocalTime endTime;
    private int numIntervals = -1;

    public RegularTimeParameters(EasLocalTime easLocalTime, TimeInterval timeInterval, int n, BTimeZone bTimeZone) {
        this.startTime = easLocalTime;
        this.interval = timeInterval;
        this.tz = bTimeZone;
        this.zonelessStart = easLocalTime.getTimestamp(TimeInterval.GMT);
        this.defaultStart = easLocalTime.getTimestamp(bTimeZone);
        this.localStart = easLocalTime.getTimestamp(BTimeZone.getLocal());
        this.numIntervals = n;
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(easLocalTime.getDate(bTimeZone));
        switch (timeInterval.getUnit()) {
            case 1: {
                calendar.add(14, n);
                break;
            }
            case 2: {
                calendar.add(13, n);
                break;
            }
            case 3: {
                calendar.add(12, n);
                break;
            }
            case 4: {
                calendar.add(10, n);
                break;
            }
            case 5: {
                calendar.add(5, n);
                break;
            }
            case 6: {
                calendar.add(4, n);
                break;
            }
            case 7: {
                calendar.add(2, n);
                break;
            }
            case 8: {
                calendar.add(1, n);
            }
        }
        this.endTime = new EasLocalTime(calendar);
    }

    public RegularTimeParameters(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, TimeInterval timeInterval, BTimeZone bTimeZone) {
        this.startTime = easLocalTime;
        this.interval = timeInterval;
        this.endTime = easLocalTime2;
        this.tz = bTimeZone;
        this.zonelessStart = easLocalTime.getTimestamp(TimeInterval.GMT);
        this.localStart = easLocalTime.getTimestamp(BTimeZone.getLocal());
        this.defaultStart = easLocalTime.getTimestamp(bTimeZone);
    }

    public RegularTimeParameters createTimeParameters(TimeInterval timeInterval) {
        return new RegularTimeParameters(this.getStartTime(), this.getEndTime(), timeInterval, this.getDefaultTimeZone());
    }

    public int getDefaultNumIntervals() {
        return this.getNumIntervals(this.tz);
    }

    public int getZonelessNumIntervals() {
        return this.getNumIntervals(TimeInterval.GMT);
    }

    public int getLocalNumIntervals() {
        return this.getNumIntervals(BTimeZone.getLocal());
    }

    public int getNumIntervals(BTimeZone bTimeZone) {
        if (this.numIntervals == -1) {
            switch (this.getInterval().getUnit()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.numIntervals = (int)((this.endTime.getTimestamp(bTimeZone) - this.getStartTime().getTimestamp(bTimeZone)) / this.getInterval().getMilliseconds());
                    break;
                }
                default: {
                    Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
                    calendar.setTime(this.getStartTime().getDate(bTimeZone));
                    Date date = this.endTime.getDate(bTimeZone);
                    this.numIntervals = 0;
                    while (date.before(calendar.getTime())) {
                        ++this.numIntervals;
                        switch (this.getInterval().getUnit()) {
                            case 5: {
                                calendar.add(5, 1);
                                break;
                            }
                            case 6: {
                                calendar.add(4, 1);
                                break;
                            }
                            case 7: {
                                calendar.add(2, 1);
                                break;
                            }
                            case 8: {
                                calendar.add(1, 1);
                            }
                        }
                    }
                    break block0;
                }
            }
        }
        return this.numIntervals;
    }

    public Population getZonelessTimePopulation() {
        return new Population(){
            private int size = -1;

            public int getSize() {
                if (this.size == -1) {
                    this.size = RegularTimeParameters.this.getNumIntervals(TimeInterval.GMT);
                }
                return this.size;
            }

            public double getSample(int n) {
                return RegularTimeParameters.this.getZonelessTime(n);
            }

            public boolean isValid(int n) {
                return true;
            }

            public BUnit getUnit() {
                return BUnit.getUnit((String)"millisecond");
            }
        };
    }

    public Population getDefaultTimePopulation() {
        return new Population(){
            private int size = -1;

            public int getSize() {
                if (this.size == -1) {
                    this.size = RegularTimeParameters.this.getNumIntervals(RegularTimeParameters.this.getDefaultTimeZone());
                }
                return this.size;
            }

            public double getSample(int n) {
                return RegularTimeParameters.this.getDefaultTime(n);
            }

            public boolean isValid(int n) {
                return true;
            }

            public BUnit getUnit() {
                return BUnit.getUnit((String)"millisecond");
            }
        };
    }

    public Population getLocalTimePopulation() {
        return new Population(){
            private int size = -1;

            public int getSize() {
                if (this.size == -1) {
                    this.size = RegularTimeParameters.this.getNumIntervals(BTimeZone.getLocal());
                }
                return this.size;
            }

            public double getSample(int n) {
                return RegularTimeParameters.this.getLocalTime(n);
            }

            public boolean isValid(int n) {
                return true;
            }

            public BUnit getUnit() {
                return BUnit.getUnit((String)"millisecond");
            }
        };
    }

    public static int getIndex(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, long l, int n) {
        if (n == 7) {
            int n2 = easLocalTime.getMonth();
            int n3 = easLocalTime.getYear();
            int n4 = easLocalTime2.getMonth();
            int n5 = easLocalTime2.getYear();
            return (int)(l * (long)((n3 - n5) * 12 + n2 - n4));
        }
        long l2 = easLocalTime.getTimestamp(TimeInterval.GMT) - easLocalTime2.getTimestamp(TimeInterval.GMT);
        switch (n) {
            case 1: {
                return (int)(l2 / l);
            }
            case 2: {
                return (int)(l2 / (l * 1000L));
            }
            case 3: {
                return (int)(l2 / (l * 60000L));
            }
            case 4: {
                return (int)(l2 / (l * 3600000L));
            }
            case 5: {
                return (int)(l2 / (l * 24L * 3600000L));
            }
            case 6: {
                return (int)(l2 / (l * 7L * 24L * 3600000L));
            }
        }
        throw new IllegalArgumentException("Illegal intl_unit agument value " + n);
    }

    public int getIndex(EasLocalTime easLocalTime) {
        if (this.interval.getUnit() == 7) {
            int n = easLocalTime.getMonth();
            int n2 = easLocalTime.getYear();
            return (int)(this.interval.getNUnits() * (long)((n2 - this.startTime.getYear()) * 12 + n - this.startTime.getMonth()));
        }
        long l = easLocalTime.getTimestamp(TimeInterval.GMT);
        return this.getIndexByOffset(l - this.zonelessStart);
    }

    public long getOffsetMillis(int n) {
        if (this.interval.getUnit() == 7 || this.interval.getUnit() == 8) {
            return this.getZonelessTime(n) - this.zonelessStart;
        }
        return (long)n * this.interval.getMilliseconds();
    }

    public long getZonelessTime(int n) {
        if (this.interval.getUnit() == 7 || this.interval.getUnit() == 8) {
            Calendar calendar = this.startTime.getCalendar(TimeInterval.GMT);
            calendar.add(TimeInterval.getCalendarField(this.interval.getUnit()), (int)this.interval.getNUnits() * n);
            return calendar.getTime().getTime();
        }
        return this.zonelessStart + (long)n * this.interval.getMilliseconds();
    }

    public int getIndexByOffset(long l) {
        if (l < 0L) {
            return -1;
        }
        switch (this.interval.getUnit()) {
            case 1: {
                return (int)(l / this.interval.getNUnits());
            }
            case 2: {
                return (int)(l / (this.interval.getNUnits() * 1000L));
            }
            case 3: {
                return (int)(l / (this.interval.getNUnits() * 60000L));
            }
            case 4: {
                return (int)(l / (this.interval.getNUnits() * 3600000L));
            }
            case 5: {
                return (int)(l / (this.interval.getNUnits() * 24L * 3600000L));
            }
            case 6: {
                return (int)(l / (this.interval.getNUnits() * 7L * 24L * 3600000L));
            }
        }
        throw new IllegalArgumentException("Illegal intl_unit agument value " + this.interval.getUnit());
    }

    public long getDefaultTime(int n) {
        return this.defaultStart + this.getOffsetMillis(n);
    }

    public long getLocalTime(int n) {
        return this.localStart + this.getOffsetMillis(n);
    }

    public long getLocalStartTime() {
        return this.localStart;
    }

    public long getDefaultStartTime() {
        return this.defaultStart;
    }

    public long getZonelessStartTime() {
        return this.zonelessStart;
    }

    public long getLocalEndTime() {
        return this.endTime.getTimestamp(BTimeZone.getLocal());
    }

    public long getZonelessEndTime() {
        return this.endTime.getTimestamp(TimeInterval.GMT);
    }

    public long getDefaultEndTime() {
        return this.endTime.getTimestamp(this.tz);
    }

    public EasLocalTime getEndTime() {
        return this.endTime;
    }

    public BTimeZone getDefaultTimeZone() {
        return this.tz;
    }

    public EasLocalTime getStartTime() {
        return this.startTime;
    }

    public TimeInterval getInterval() {
        return this.interval;
    }
}

