/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.RcSubtype;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

public class RcType {
    private int code;
    public String description;
    private RcSubtype[] validSubtypes;
    private BUnit[] subtypeUnits;
    public static RcType ELECTRIC = new RcType(0, "Electric", new RcSubtype[]{RcSubtype.CONSUMPTION, RcSubtype.DEMAND, RcSubtype.POWER_FACTOR, RcSubtype.REACTIVE_ENERGY, RcSubtype.APPARENT_ENERGY, RcSubtype.REACTIVE_POWER, RcSubtype.APPARENT_POWER, RcSubtype.OTHER}, new BUnit[]{BUnit.getUnit((String)"kilowatt hour"), BUnit.getUnit((String)"kilowatt"), BUnit.getUnit((String)"null"), BUnit.getUnit((String)"kilovolt ampere reactive hour"), BUnit.getUnit((String)"kilovolt ampere hour"), BUnit.getUnit((String)"kilovolt ampere reactive"), BUnit.getUnit((String)"kilovolt ampere")});
    public static RcType GAS = new RcType(1, "Gas", new RcSubtype[]{RcSubtype.CONSUMPTION, RcSubtype.DEMAND, RcSubtype.OTHER}, new BUnit[]{BUnit.getUnit((String)"btu"), BUnit.getUnit((String)"btus per hour")});
    public static RcType WATER = new RcType(2, "Water", new RcSubtype[]{RcSubtype.CONSUMPTION, RcSubtype.DEMAND, RcSubtype.OTHER}, new BUnit[]{BUnit.getUnit((String)"gallon"), BUnit.getUnit((String)"gallons per minute")});
    public static RcType SEWER = new RcType(3, "Sewer", new RcSubtype[]{RcSubtype.VOLUME, RcSubtype.PEAK_FLOW, RcSubtype.OTHER}, new BUnit[]{BUnit.getUnit((String)"gallon")});
    public static RcType OTHER = new RcType(4, "Other", new RcSubtype[]{RcSubtype.OTHER}, new BUnit[0]);
    public static RcType OUTSIDE_AIR_TEMP = new RcType(5, "OutsideAirTemp", new RcSubtype[]{RcSubtype.OTHER}, new BUnit[]{BUnit.getUnit((String)"fahrenheit")});
    public static RcType OTHER_CONSUMPTION = new RcType(6, "OtherConsumption", new RcSubtype[]{RcSubtype.CONSUMPTION}, new BUnit[0]);
    public static RcType PRODUCTION_UNITS = new RcType(7, "ProductionUnits", new RcSubtype[]{RcSubtype.CONSUMPTION}, new BUnit[0]);
    private static RcType[] typesByCode = new RcType[]{ELECTRIC, GAS, WATER, SEWER, OTHER, OUTSIDE_AIR_TEMP, OTHER_CONSUMPTION, PRODUCTION_UNITS};

    private RcType(int n, String string, RcSubtype[] rcSubtypeArray, BUnit[] bUnitArray) {
        this.code = n;
        this.description = string;
        this.validSubtypes = rcSubtypeArray;
        this.subtypeUnits = bUnitArray;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDescription(Lexicon lexicon) {
        if (lexicon != null) {
            return lexicon.getText(this.description);
        }
        return this.description;
    }

    public RcSubtype[] getValidSubtypes() {
        return this.validSubtypes;
    }

    public String toString() {
        return this.getDescription();
    }

    public BUnit getDefaultUnitForSubtype(RcSubtype rcSubtype) {
        for (int i = 0; i < this.subtypeUnits.length; ++i) {
            if (this.validSubtypes[i] != rcSubtype) continue;
            return this.subtypeUnits[i];
        }
        return null;
    }

    public static RcType getByCode(int n) {
        return typesByCode[n];
    }

    public static RcType[] getAll() {
        return typesByCode;
    }
}

