/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.util.LexiconUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public abstract class Period {
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 4;
    public static final int WEDNESDAY = 8;
    public static final int THURSDAY = 16;
    public static final int FRIDAY = 32;
    public static final int SATURDAY = 64;
    public static final int EVERY_DAY = 127;
    public static final int[] MONTH_DAYS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final long MILLIS_PER_DAY = 86400000L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    private EasLocalTime startTime;
    private EasLocalTime endTime;
    private int daysOfWeek;
    public Lexicon lex;
    private static DateFormatSymbols dateSymbols;

    public Period() {
    }

    public Period(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n) {
        this.startTime = easLocalTime;
        this.endTime = easLocalTime2;
        this.daysOfWeek = n;
    }

    public Period(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n, Lexicon lexicon) {
        this.startTime = easLocalTime;
        this.endTime = easLocalTime2;
        this.daysOfWeek = n;
        this.lex = lexicon;
    }

    public EasLocalTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(EasLocalTime easLocalTime) {
        this.startTime = easLocalTime;
    }

    public long getStartTimeMillis(BTimeZone bTimeZone) {
        return this.getStartTime().getTimestamp(bTimeZone);
    }

    public String getFullStartString() {
        return this.formatLexiconFull(this.startTime, false);
    }

    public String getStartTimeString() {
        return Period.formatTime(this.startTime);
    }

    public String getStartDateString() {
        return this.formatLexiconDate(this.startTime, false);
    }

    public EasLocalTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(EasLocalTime easLocalTime) {
        this.endTime = easLocalTime;
    }

    public long getEndTimeMillis(BTimeZone bTimeZone) {
        return this.getEndTime().getTimestamp(bTimeZone);
    }

    public String getFullEndString() {
        return this.formatLexiconFull(this.endTime, true);
    }

    public String getEndTimeString() {
        return Period.formatTime(this.endTime);
    }

    public String getEndDateString() {
        return this.formatLexiconDate(this.endTime, true);
    }

    public String getDateRangeString() {
        String string;
        String string2 = this.getStartDateString();
        if (string2.equals(string = this.getEndDateString())) {
            return string2;
        }
        if (this.lex != null) {
            return string2 + " " + this.lex.getText("to") + " " + string;
        }
        return string2 + " to " + string;
    }

    public int getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public boolean includeSunday() {
        return (this.getDaysOfWeek() & 1) != 0;
    }

    public boolean includeMonday() {
        return (this.getDaysOfWeek() & 2) != 0;
    }

    public boolean includeTuesday() {
        return (this.getDaysOfWeek() & 4) != 0;
    }

    public boolean includeWednesday() {
        return (this.getDaysOfWeek() & 8) != 0;
    }

    public boolean includeThursday() {
        return (this.getDaysOfWeek() & 0x10) != 0;
    }

    public boolean includeFriday() {
        return (this.getDaysOfWeek() & 0x20) != 0;
    }

    public boolean includeSaturday() {
        return (this.getDaysOfWeek() & 0x40) != 0;
    }

    public static String formatDate(EasLocalTime easLocalTime) {
        if (dateSymbols == null) {
            dateSymbols = new DateFormatSymbols();
        }
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(easLocalTime.getDay());
        stringBuffer.append(' ');
        stringBuffer.append(dateSymbols.getShortMonths()[easLocalTime.getMonth()]);
        stringBuffer.append(' ');
        stringBuffer.append(easLocalTime.getYear());
        return stringBuffer.toString();
    }

    public String formatLexiconDate(EasLocalTime easLocalTime, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lex != null) {
            SimpleDateFormat simpleDateFormat;
            Date date = easLocalTime.getDate(BTimeZone.getLocal());
            if (bl) {
                date = new Date(date.getTime() - 1L);
            }
            try {
                simpleDateFormat = new SimpleDateFormat(this.lex.getText("defaultDateFormat"), LexiconUtil.getLocale(this.lex));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                simpleDateFormat = new SimpleDateFormat("d MMM yyyy", LexiconUtil.getLocale(this.lex));
            }
            stringBuffer.append(simpleDateFormat.format(date));
        } else {
            if (dateSymbols == null) {
                dateSymbols = new DateFormatSymbols();
            }
            stringBuffer.append(easLocalTime.getDay());
            stringBuffer.append(' ');
            stringBuffer.append(dateSymbols.getShortMonths()[easLocalTime.getMonth()]);
            stringBuffer.append(' ');
            stringBuffer.append(easLocalTime.getYear());
        }
        return stringBuffer.toString();
    }

    public static String formatTime(EasLocalTime easLocalTime) {
        StringBuffer stringBuffer = new StringBuffer(5);
        stringBuffer.append(easLocalTime.getHour());
        stringBuffer.append(':');
        int n = easLocalTime.getMinute();
        if (n < 9) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        return stringBuffer.toString();
    }

    public static String formatFull(EasLocalTime easLocalTime) {
        StringBuffer stringBuffer = new StringBuffer(18);
        stringBuffer.append(Period.formatDate(easLocalTime));
        stringBuffer.append(", ");
        stringBuffer.append(Period.formatTime(easLocalTime));
        return stringBuffer.toString();
    }

    public String formatLexiconFull(EasLocalTime easLocalTime, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.formatLexiconDate(easLocalTime, bl));
        stringBuffer.append(", ");
        stringBuffer.append(Period.formatTime(easLocalTime));
        return stringBuffer.toString();
    }

    public void save(DataOutput dataOutput) throws IOException {
        this.startTime.save(dataOutput);
        this.endTime.save(dataOutput);
        dataOutput.writeInt(this.getDaysOfWeek());
    }

    public void load(DataInput dataInput) throws IOException, EasException {
        this.startTime = new EasLocalTime();
        this.startTime.load(dataInput);
        this.endTime = new EasLocalTime();
        this.endTime.load(dataInput);
        this.daysOfWeek = dataInput.readInt();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.getFullStartString();
        String string2 = this.getFullEndString();
        stringBuffer.append(string);
        if (this.lex != null) {
            if (!string.equals(string2)) {
                stringBuffer.append(" " + this.lex.getText("to") + " ").append(string2);
            }
            stringBuffer.append(" (");
            if (this.includeSunday()) {
                stringBuffer.append(" " + this.lex.getText("sunday.short"));
            }
            if (this.includeMonday()) {
                stringBuffer.append(" " + this.lex.getText("monday.short"));
            }
            if (this.includeTuesday()) {
                stringBuffer.append(" " + this.lex.getText("tuesday.short"));
            }
            if (this.includeWednesday()) {
                stringBuffer.append(" " + this.lex.getText("wednesday.short"));
            }
            if (this.includeThursday()) {
                stringBuffer.append(" " + this.lex.getText("thursday.short"));
            }
            if (this.includeFriday()) {
                stringBuffer.append(" " + this.lex.getText("friday.short"));
            }
            if (this.includeSaturday()) {
                stringBuffer.append(" " + this.lex.getText("saturday.short"));
            }
            stringBuffer.append(" )");
        } else {
            if (!string.equals(string2)) {
                stringBuffer.append(" to ").append(string2);
            }
            stringBuffer.append(" (");
            if (this.includeSunday()) {
                stringBuffer.append(" Sun");
            }
            if (this.includeMonday()) {
                stringBuffer.append(" Mon");
            }
            if (this.includeTuesday()) {
                stringBuffer.append(" Tue");
            }
            if (this.includeWednesday()) {
                stringBuffer.append(" Wed");
            }
            if (this.includeThursday()) {
                stringBuffer.append(" Thu");
            }
            if (this.includeFriday()) {
                stringBuffer.append(" Fri");
            }
            if (this.includeSaturday()) {
                stringBuffer.append(" Sat");
            }
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }
}

