/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasClientSession;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.MeterExec;
import com.tridium.eas.api.Site;
import com.tridium.eas.xml.XmlMessage;
import com.tridium.eas.xml.XmlSupport;
import java.util.Vector;

public class MeterExecCli
implements MeterExec {
    private EasClientSession mgr;

    public MeterExecCli(EasClientSession easClientSession) {
        this.mgr = easClientSession;
    }

    public final int getAvailableLicensedMeterCount() {
        int n = 0;
        XmlMessage xmlMessage = new XmlMessage("availableLicensed");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "availableLicensed");
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                n = xmlMessage2.getInt("count");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n;
    }

    public final boolean isEasE2Licensed() {
        boolean bl = false;
        XmlMessage xmlMessage = new XmlMessage("easE2Licensed");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "easE2Licensed");
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                bl = xmlMessage2.getBoolean("licensed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public final boolean isEasCostLicensed() {
        boolean bl = false;
        XmlMessage xmlMessage = new XmlMessage("easCostLicensed");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "easCostLicensed");
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                bl = xmlMessage2.getBoolean("licensed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public final boolean isReportLicensed(String string) {
        boolean bl = false;
        XmlMessage xmlMessage = new XmlMessage("easReportLicensed");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "easReportLicensed");
        xmlMessage.add("report", string);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                bl = xmlMessage2.getBoolean("licensed");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public boolean isCustomRateComponentUnlocked(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        XmlMessage xmlMessage = new XmlMessage("customRateComponentUnlocked");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "customRateComponentUnlocked");
        xmlMessage.add("customClassName", string);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 != null) {
            try {
                bl = xmlMessage2.getBoolean("unlocked");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public Meter load(int n) {
        XmlMessage xmlMessage = new XmlMessage("load");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "load");
        xmlMessage.add("meterId", n);
        Meter meter = null;
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return meter;
        }
        try {
            n = xmlMessage2.getInt("meterId");
            String string = xmlMessage2.getString("name");
            String string2 = xmlMessage2.getString("descr");
            int n2 = xmlMessage2.getInt("rc_type");
            boolean bl = xmlMessage2.getBoolean("is_main");
            int n3 = xmlMessage2.getInt("site");
            String string3 = xmlMessage2.getString("floorarea_vunit");
            double d = xmlMessage2.getDouble("floorarea_value");
            meter = Meter.get(n, string, string2, n2, bl, n3, string3, d, true, this.mgr);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return meter;
        }
        return meter;
    }

    public int create(String string, String string2, int n, boolean bl, int n2, String string3, double d) {
        XmlMessage xmlMessage = new XmlMessage("create");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "create");
        xmlMessage.add("name", string);
        xmlMessage.add("descr", string2);
        xmlMessage.add("rc_type", n);
        xmlMessage.add("is_main", bl);
        xmlMessage.add("site", n2);
        xmlMessage.add("floorarea_vunit", string3);
        xmlMessage.add("floorarea_value", d);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return -1;
        }
        try {
            return xmlMessage2.getInt("meterId");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public int update(int n, String string, String string2, int n2, boolean bl, int n3, String string3, double d) {
        XmlMessage xmlMessage = new XmlMessage("update");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "update");
        xmlMessage.add("meterId", n);
        xmlMessage.add("name", string);
        xmlMessage.add("descr", string2);
        xmlMessage.add("rc_type", n2);
        xmlMessage.add("is_main", bl);
        xmlMessage.add("site", n3);
        xmlMessage.add("floorarea_vunit", string3);
        xmlMessage.add("floorarea_value", d);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return -1;
        }
        try {
            return xmlMessage2.getInt("status");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public int erase(int n) {
        XmlMessage xmlMessage = new XmlMessage("erase");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "erase");
        xmlMessage.add("meterId", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return -1;
        }
        try {
            return xmlMessage2.getInt("status");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public Vector getSiteMeters(Site site) {
        return this.getSiteMeters(site == null ? -1 : site.getId(), site);
    }

    public Vector getSiteMeters(int n) {
        return this.getSiteMeters(n, null);
    }

    private Vector getSiteMeters(int n, Site site) {
        Vector<Meter> vector = new Vector<Meter>();
        if (n == -1) {
            return vector;
        }
        XmlMessage xmlMessage = new XmlMessage("getSiteMeters");
        xmlMessage.add("request", "eas");
        xmlMessage.add("classname", "Meter");
        xmlMessage.add("command", "getSiteMeters");
        xmlMessage.add("site", n);
        XmlMessage xmlMessage2 = this.mgr.sendRequest(xmlMessage);
        if (xmlMessage2 == null) {
            return vector;
        }
        XmlSupport[] xmlSupportArray = xmlMessage2.getChildObjects();
        int n2 = xmlSupportArray != null ? xmlSupportArray.length : 0;
        try {
            for (int i = 0; i < n2; ++i) {
                XmlMessage xmlMessage3 = (XmlMessage)xmlSupportArray[i];
                int n3 = xmlMessage3.getInt("meterIdx");
                String string = xmlMessage3.getString("nameIdx");
                String string2 = xmlMessage3.getString("descrIdx");
                int n4 = xmlMessage3.getInt("rctypeIdx");
                boolean bl = xmlMessage3.getBoolean("ismainIdx");
                String string3 = xmlMessage3.getString("funitIdx");
                double d = xmlMessage3.getDouble("fvalueIdx");
                Meter meter = site == null ? Meter.get(n3, string, string2, n4, bl, n, string3, d, true, this.mgr) : Meter.get(n3, string, string2, n4, bl, site, string3, d, true);
                vector.addElement(meter);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return vector;
    }
}

