/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasProtected;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Manager;
import com.tridium.eas.api.PStatus;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.Site;
import com.tridium.eas.util.Alg;
import com.tridium.eas.util.Comparator;
import java.util.Vector;
import javax.baja.units.BUnit;

public class Meter
extends EasObject
implements EasProtected {
    private Vector datapoints = new Vector(0);
    private int datapointsCount = 0;
    private boolean datapointsLoaded = false;
    private String name;
    private String descr;
    private int rcType;
    private boolean main;
    private String floorarea_vunit = "square foot";
    private double floorarea_value = 0.0;
    private BUnit floorarea_unit = BUnit.getUnit((String)"square foot");
    private Site site_ref = null;
    private int site_id = -1;

    public int getProtectedType() {
        return 1;
    }

    public String getProtectedIdentifier() {
        return String.valueOf(this.getId());
    }

    public static Meter get(long l, EasSession easSession) {
        return Meter.get((int)l, easSession);
    }

    public static Meter get(int n, EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return (Meter)easSession.get(new Meter(n, easSession));
    }

    public static Meter get(int n, String string, String string2, int n2, boolean bl, int n3, String string3, double d, boolean bl2, EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        Meter meter = new Meter(n, string, string2, n2, bl, n3, string3, d, bl2, easSession);
        Meter meter2 = (Meter)easSession.get(meter);
        if (bl2 && meter2 != meter) {
            meter2.name = string;
            meter2.descr = string2;
            meter2.rcType = n2;
            meter2.main = bl;
            meter2.site_ref = null;
            meter2.site_id = n3;
            meter2.floorarea_vunit = string3;
            meter2.floorarea_value = d;
            meter2.floorarea_unit = null;
            meter2.status.setOutofdate(false);
        }
        return meter2;
    }

    public static Meter get(int n, String string, String string2, int n2, boolean bl, Site site, String string3, double d, boolean bl2) {
        Meter meter = new Meter(n, string, string2, n2, bl, site, string3, d, bl2);
        if (n == -1) {
            return meter;
        }
        Meter meter2 = (Meter)site.getSession().get(meter);
        if (bl2 && meter2 != meter) {
            meter2.name = string;
            meter2.descr = string2;
            meter2.rcType = n2;
            meter2.main = bl;
            meter2.site_ref = site;
            meter2.site_id = site == null ? -1 : site.getId();
            meter2.floorarea_vunit = string3;
            meter2.floorarea_value = d;
            meter2.floorarea_unit = null;
            meter2.status.setOutofdate(!bl2);
        }
        return meter2;
    }

    public static Meter create(String string, String string2, int n, boolean bl, Site site, String string3, double d) throws EasException {
        EasSession easSession = site.getSession();
        int n2 = easSession.getNewId();
        Meter meter = new Meter(n2, string, string2, n, bl, site, string3, d, true);
        meter.status.setInserted(true);
        site.addMeter(meter);
        return (Meter)easSession.get(meter);
    }

    public static final int getAvailableLicensedMeterCount(EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return easSession.getMeterExec().getAvailableLicensedMeterCount();
    }

    public static final boolean isEasE2Licensed(EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return easSession.getMeterExec().isEasE2Licensed();
    }

    public static final boolean isEasCostLicensed(EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return easSession.getMeterExec().isEasCostLicensed();
    }

    public static final boolean isReportLicensed(EasSession easSession, String string) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return easSession.getMeterExec().isReportLicensed(string);
    }

    public static boolean isCustomRateComponentUnlocked(EasSession easSession, String string) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return easSession.getMeterExec().isCustomRateComponentUnlocked(string);
    }

    public void remove() throws EasException {
        this.load(false);
        if (this.getSite() != null) {
            this.getSite().remMeter(this);
        }
        this.loadDataPoints(false);
        for (int i = 0; i < this.datapoints.size(); ++i) {
            DataPoint dataPoint = ((Dp)this.datapoints.elementAt((int)i)).id;
            dataPoint.setMeter(null);
            dataPoint.erase();
        }
        this.status.setRemoved(true);
    }

    public void load() throws EasException {
        this.load(false);
    }

    public void load(boolean bl) throws EasException {
        if (this.isTemporary()) {
            return;
        }
        if (bl || this.status.isOutofdate()) {
            if (!bl && this.status.isModified()) {
                throw new EasException("merge not supported");
            }
            Meter meter = this.session.getMeterExec().load(this.id);
            if (meter == null) {
                throw new EasException("object doesn't exist in the database");
            }
            if (meter != this) {
                this.name = meter.name;
                this.descr = meter.descr;
                this.rcType = meter.rcType;
                this.main = meter.main;
                this.site_ref = meter.site_ref;
                this.site_id = meter.site_id;
                this.floorarea_vunit = meter.floorarea_vunit;
                this.floorarea_value = meter.floorarea_value;
                this.floorarea_unit = meter.floorarea_unit;
            }
            this.status.setOutofdate(false);
        }
    }

    public EasObject loadFromDb() {
        return this.session.getMeterExec().load(this.id);
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return null;
        }
    }

    public RcType getRcTypeObj() throws EasException {
        return RcType.getByCode(this.getRcType());
    }

    public int getRcType() throws EasException {
        this.load();
        return this.rcType;
    }

    public void setRcType(RcType rcType) throws EasException {
        this.setRcType(rcType.getCode());
    }

    public void setRcType(int n) throws EasException {
        this.load();
        if (this.rcType == n) {
            return;
        }
        this.rcType = n;
        this.status.setModified(true);
    }

    public boolean isMain() throws EasException {
        this.load();
        return this.main;
    }

    public void setMain(boolean bl) throws EasException {
        this.load();
        if (this.main == bl) {
            return;
        }
        this.main = bl;
        this.status.setModified(true);
    }

    public String getName() throws EasException {
        this.load();
        return this.name;
    }

    public void setName(String string) throws EasException {
        this.load();
        if (this.name.equals(string)) {
            return;
        }
        this.name = string;
        this.status.setModified(true);
    }

    public String getDescr() throws EasException {
        this.load();
        return this.descr;
    }

    public void setDescr(String string) throws EasException {
        this.load();
        if (this.descr.equals(string)) {
            return;
        }
        this.descr = string;
        this.status.setModified(true);
    }

    public String getFloorAreaVUnit() throws EasException {
        this.load();
        return this.floorarea_vunit;
    }

    public void setFloorAreaVUnit(String string) throws EasException {
        this.load();
        if (this.floorarea_vunit == string) {
            return;
        }
        this.floorarea_unit = null;
        this.floorarea_vunit = string;
        this.status.setModified(true);
    }

    public double getFloorAreaValue() throws EasException {
        this.load();
        return this.floorarea_value;
    }

    public void setFloorAreaValue(double d) throws EasException {
        this.load();
        if (this.floorarea_value == d) {
            return;
        }
        this.floorarea_value = d;
        this.status.setModified(true);
    }

    public BUnit getFloorAreaUnit() throws EasException {
        this.load();
        if (this.floorarea_unit == null) {
            this.floorarea_unit = BUnit.getUnit((String)this.getFloorAreaVUnit());
        }
        return this.floorarea_unit;
    }

    public void setFloorAreaUnit(BUnit bUnit) throws EasException {
        if (bUnit == null) {
            this.setFloorAreaVUnit("null");
        } else {
            this.setFloorAreaVUnit(bUnit.getUnitName());
        }
        this.floorarea_unit = bUnit;
    }

    public Site getSite() throws EasException {
        this.load();
        if (this.site_ref != null) {
            return this.site_ref;
        }
        if (this.site_id != -1) {
            this.site_ref = (Site)Site.get(this.site_id, this.session);
        }
        return this.site_ref;
    }

    public int getSiteId() throws EasException {
        this.load();
        if (this.site_ref != null) {
            return this.site_ref.getId();
        }
        return this.site_id;
    }

    public void setSite(Site site) throws EasException {
        this.load();
        Site site2 = this.getSite();
        if (site2 == site) {
            return;
        }
        if (site == null) {
            site2.remMeter(this);
        } else {
            site.addMeter(this);
        }
        this.setSiteField(site);
        this.status.setModified(true);
    }

    public int getDataPointsCount() throws EasException {
        this.loadDataPoints(false);
        return this.datapointsCount;
    }

    public void loadDataPoints(boolean bl) throws EasException {
        if (!bl && this.datapointsLoaded) {
            return;
        }
        if (this.isInitialized()) {
            if (this.getSite() == null) {
                return;
            }
            DataPoint[] dataPointArray = this.getSite().getOwnedDataPoints();
            this.datapointsCount = 0;
            this.datapoints.setSize(0);
            for (int i = 0; i < dataPointArray.length; ++i) {
                if (dataPointArray[i].getMeter() == null || dataPointArray[i].getMeter().getId() != this.getId()) continue;
                this.datapoints.addElement(new Dp(dataPointArray[i]));
                ++this.datapointsCount;
            }
        } else {
            throw new EasException("can't load uninitialized meter");
        }
        this.datapointsLoaded = true;
    }

    public void addDataPoint(DataPoint dataPoint) throws EasException {
        Meter meter = dataPoint.getMeter();
        if (meter != null && meter.getId() != this.getId()) {
            meter.remDataPoint(dataPoint);
        }
        this.loadDataPoints(false);
        boolean bl = false;
        Dp dp = (Dp)Alg.find(this.datapoints, dataPoint, new DpCmp());
        if (dp == null) {
            dp = new Dp(dataPoint);
            dp.setInserted(true);
            this.datapoints.addElement(dp);
            ++this.datapointsCount;
            bl = true;
        } else if (dp.isRemoved()) {
            dp.setRemoved(false);
            ++this.datapointsCount;
            bl = true;
        }
        if (bl) {
            dataPoint.setMeter(this);
        }
    }

    public void remDataPoint(DataPoint dataPoint) throws EasException {
        this.loadDataPoints(false);
        boolean bl = false;
        Dp dp = (Dp)Alg.find(this.datapoints, dataPoint, new DpCmp());
        if (dp != null) {
            if (dp.isInserted()) {
                this.datapoints.removeElement(dp);
                --this.datapointsCount;
                bl = true;
            } else if (!dp.isRemoved()) {
                dp.setRemoved(true);
                --this.datapointsCount;
                bl = true;
            }
        }
        if (bl) {
            dataPoint.setMeter(null);
        }
    }

    public DataPoint[] getDataPoints() throws EasException {
        this.loadDataPoints(false);
        DataPoint[] dataPointArray = new DataPoint[this.datapointsCount];
        int n = 0;
        for (int i = 0; i < this.datapoints.size(); ++i) {
            Dp dp = (Dp)this.datapoints.elementAt(i);
            if (dp.isRemoved()) continue;
            dataPointArray[n++] = dp.id;
        }
        return dataPointArray;
    }

    public DataPoint getDataPoint(int n) throws EasException {
        this.loadDataPoints(false);
        boolean bl = false;
        for (int i = 0; i < this.datapoints.size(); ++i) {
            Dp dp = (Dp)this.datapoints.elementAt(i);
            if (dp.isRemoved() || dp.id.getRcSubType() != n) continue;
            return dp.id;
        }
        return null;
    }

    public void save() throws EasException {
        this.save(-1, true);
    }

    public void save(int n, boolean bl) throws EasException {
        if ((n & 8) != 0) {
            if (this.status.isRemoved()) {
                this.session.getMeterExec().erase(this.id);
                this.session.remove(this);
                this.status.setCurrent();
            } else if (this.status.isInserted()) {
                if (this.getSite() != null) {
                    this.getSite().save(1, true);
                }
                this.id = this.session.getMeterExec().create(this.name, this.descr, this.rcType, this.main, this.getSiteId(), this.floorarea_vunit, this.floorarea_value);
                if (this.id == -1) {
                    throw new EasException("Can't create new meter in the database");
                }
                this.session.get(this);
                this.status.setCurrent();
            } else if (this.status.isModified()) {
                if (this.getSite() != null) {
                    this.getSite().save(1, true);
                }
                this.session.getMeterExec().update(this.id, this.name, this.descr, this.rcType, this.main, this.getSiteId(), this.floorarea_vunit, this.floorarea_value);
                this.status.setCurrent();
            }
        }
        if ((n & 4) != 0 && !this.mStatus(this.datapoints).isCurrent()) {
            boolean bl2 = false;
            for (int i = 0; i < this.datapoints.size(); ++i) {
                Dp dp = (Dp)this.datapoints.elementAt(i);
                if (dp.isRemoved()) {
                    dp.id.save(4, true);
                    bl2 = true;
                    continue;
                }
                if (!dp.isInserted()) continue;
                dp.id.save(4, true);
                dp.setCurrent();
            }
            if (bl2) {
                Vector<Dp> vector = new Vector<Dp>(this.datapointsCount);
                for (int i = 0; i < this.datapoints.size(); ++i) {
                    Dp dp = (Dp)this.datapoints.elementAt(i);
                    if (dp.isRemoved()) continue;
                    vector.addElement(dp);
                }
                this.datapoints = vector;
            }
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Meter) {
            return this.id == ((Meter)object).id;
        }
        return super.equals(object);
    }

    private Meter(int n, EasSession easSession) {
        super(n, easSession);
        this.site_ref = null;
        this.site_id = -1;
        this.status.setOutofdate(true);
    }

    private Meter(int n, String string, String string2, int n2, boolean bl, Site site, String string3, double d, boolean bl2) {
        super(n, site.getSession());
        this.site_ref = site;
        this.site_id = site == null ? -1 : site.getId();
        this.name = string;
        this.descr = string2;
        this.rcType = n2;
        this.main = bl;
        this.floorarea_vunit = string3;
        this.floorarea_value = d;
        this.floorarea_unit = null;
        if (!bl2) {
            this.status.setOutofdate(true);
        }
    }

    private Meter(int n, String string, String string2, int n2, boolean bl, int n3, String string3, double d, boolean bl2, EasSession easSession) {
        super(n, easSession);
        this.site_ref = null;
        this.site_id = n3;
        this.name = string;
        this.descr = string2;
        this.rcType = n2;
        this.main = bl;
        this.floorarea_vunit = string3;
        this.floorarea_value = d;
        this.floorarea_unit = null;
        if (!bl2) {
            this.status.setOutofdate(true);
        }
    }

    private PStatus mStatus(Vector vector) {
        PStatus pStatus = new PStatus();
        int n = vector.size();
        while (--n >= 0) {
            pStatus.or((PStatus)vector.elementAt(n));
        }
        return pStatus;
    }

    private void setSiteField(Site site) {
        if (site != null) {
            if (this.site_id != site.getId()) {
                this.site_ref = site;
                this.site_id = site.getId();
            }
        } else {
            this.site_ref = null;
            this.site_id = -1;
        }
    }

    private void setSiteField(int n) {
        if (this.site_id != n) {
            this.site_ref = null;
            this.site_id = n;
        }
    }

    private class Dp
    extends PStatus {
        public DataPoint id;

        public Dp(DataPoint dataPoint) {
            this.id = dataPoint;
        }
    }

    private class DpCmp
    implements Comparator {
        private DpCmp() {
        }

        public int compare(Object object, Object object2) {
            return ((Dp)object).id.compareTo(object2);
        }
    }
}

