/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.DynGroup;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Manager;
import com.tridium.eas.api.PStatus;
import com.tridium.eas.api.Property;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.StaticGroup;
import com.tridium.eas.util.Alg;
import com.tridium.eas.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;

public class Group
extends EasObject {
    private Vector parents = new Vector(0);
    private int parentsCount;
    private boolean parentsLoaded = false;
    public static final int STATUS_OK = 0;
    public static final int NON_UNIQUE_NAME = -1;
    public static final int NOT_A_VALID_GROUP = -2;
    public static final int BAD_SQL = -3;
    public static final int ERR_MULTIPLE_UPDATES = -4;
    public static final int ERR_UPDATE_COUNT = -5;
    public static final int NOT_FOUND = -6;
    public static final char ISECT_NONE = 'N';
    public static final char ISECT_JOIN = 'A';
    public static final char ISECT_UNION = 'X';
    public static final char TYPE_SITE = 'P';
    public static final char TYPE_STATIC = 'S';
    public static final char TYPE_DYNAMIC = 'D';
    private Vector children = new Vector(0);
    private int childrenCount;
    private boolean childrenLoaded = false;
    private Vector properties = new Vector(0);
    private int propertiesCount;
    private boolean propertiesLoaded = false;
    private Vector linkedDataPoints = new Vector(0);
    private int linkedDataPointsCount;
    private boolean linkedDataPointsLoaded = false;
    private int isect = 78;
    private String name;
    private String user;
    private char type;
    private boolean hidden;

    protected Group(int n, EasSession easSession) {
        super(n, easSession);
        this.status.setOutofdate(true);
    }

    protected Group(int n, String string, String string2, char c, boolean bl, boolean bl2, EasSession easSession) {
        super(n, easSession);
        this.name = string;
        this.user = string2;
        this.type = c;
        this.hidden = bl;
        if (!bl2) {
            this.status.setOutofdate(true);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Group) {
            Group group = (Group)object;
            return this.id == ((Group)object).id;
        }
        return super.equals(object);
    }

    public static Group create(String string, char c, EasSession easSession) {
        return Group.create(string, "", c, easSession);
    }

    public static Group create(String string, String string2, char c, EasSession easSession) {
        int n = easSession.getNewId();
        Group group = null;
        switch (c) {
            case 'D': {
                group = new DynGroup(n, string, string2, c, false, true, easSession);
                break;
            }
            case 'P': {
                group = new Site(n, string, string2, c, false, true, easSession);
                break;
            }
            case 'S': {
                group = new StaticGroup(n, string, string2, c, false, true, easSession);
            }
        }
        group.status.setInserted(true);
        return (Group)easSession.get(group);
    }

    public static Group get(long l, EasSession easSession) throws EasException {
        return Group.get((int)l, easSession);
    }

    public static Group get(int n, EasSession easSession) throws EasException {
        Group group;
        Group group2;
        if (easSession == null) {
            easSession = Manager.get();
        }
        if ((group2 = (Group)easSession.cached(group = new Group(n, easSession))) != null) {
            return group2;
        }
        group.load(true);
        return Group.get(group.id, group.name, group.user, group.type, group.hidden, true, easSession);
    }

    public static Group get(int n, String string, String string2, char c, boolean bl, boolean bl2, EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        Group group = null;
        switch (c) {
            case 'D': {
                group = new DynGroup(n, string, string2, c, bl, bl2, easSession);
                break;
            }
            case 'P': {
                group = new Site(n, string, string2, c, bl, bl2, easSession);
                break;
            }
            case 'S': {
                group = new StaticGroup(n, string, string2, c, bl, bl2, easSession);
            }
        }
        Group group2 = (Group)easSession.get(group);
        if (bl2 && group2 != group) {
            group2.name = string;
            group2.user = string2;
            group2.type = c;
            group2.hidden = bl;
        }
        return group2;
    }

    public static Group get(String string, EasSession easSession) throws EasException {
        return easSession.getGroupExec().getByName(string, easSession.getUserName());
    }

    public void load(boolean bl) throws EasException {
        if (this.isTemporary()) {
            return;
        }
        if (bl || this.status.isOutofdate()) {
            if (!bl && this.status.isModified()) {
                throw new EasException("merge not supported");
            }
            Group group = this.session.getGroupExec().load(this.id, this.session.getUserName());
            if (group == null) {
                throw new EasException("object doesn't exist in the database");
            }
            if (group != this) {
                this.name = group.name;
                this.user = group.user;
                this.type = group.type;
                this.hidden = group.hidden;
            }
            this.status.setOutofdate(false);
        }
    }

    public void remove() throws EasException {
        this.status.setRemoved(true);
    }

    public static Group createStaticGroup(String string, String string2) throws EasException {
        return Group.create(string, "", 'S', null);
    }

    public static Group createStaticGroup(String string, String string2, EasSession easSession) throws EasException {
        return Group.create(string, string2, 'S', easSession);
    }

    public String getName() {
        try {
            this.load(false);
            return this.name;
        }
        catch (EasException easException) {
            return null;
        }
    }

    public String getUserId() throws EasException {
        this.load(false);
        return this.user;
    }

    public void setUserId(String string) throws EasException {
        this.load(false);
        if (this.isInitialized() && !string.equals(this.user)) {
            this.status.setModified(true);
            this.user = string;
        }
    }

    public boolean isPublic() throws EasException {
        return this.getUserId() == null || this.getUserId().trim().length() == 0;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isHidden() throws EasException {
        this.load(false);
        return this.hidden;
    }

    public void changeName(String string) throws EasException {
        this.load(false);
        if (this.isInitialized() && string != null && string.trim().length() != 0 && !string.equals(this.name)) {
            this.status.setModified(true);
            this.name = string;
        }
    }

    public int getType() throws EasException {
        this.load(false);
        return this.type;
    }

    public static Group[] getGroups(char c, EasSession easSession) {
        Vector vector = easSession.getGroupExec().getGroups(c, easSession.getUserName());
        int n = vector == null ? 0 : vector.size();
        Group[] groupArray = new Group[n];
        int n2 = n;
        while (--n2 >= 0) {
            groupArray[n2] = (Group)vector.elementAt(n2);
        }
        return groupArray;
    }

    public void setIsectType(int n) {
        this.isect = n;
    }

    public int getIsectType() {
        return this.isect;
    }

    public Group[] getIntersection() throws EasException {
        Group[] groupArray = this.getChildren();
        if (groupArray == null || this.getIsectType() == 78) {
            return groupArray;
        }
        return this.getIsectType() == 65 ? this.getJoin(groupArray) : this.getUnion(groupArray);
    }

    private Group[] getJoin(Group[] groupArray) throws EasException {
        Object object;
        Group[] groupArray2;
        if (groupArray == null) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        int n = groupArray.length;
        while (--n >= 0) {
            groupArray2 = groupArray[n];
            if (groupArray2 == null || (object = groupArray2.getChildren()) == null) continue;
            int n2 = ((Object)object).length;
            while (--n2 >= 0) {
                hashtable.put(object[n2], null);
            }
        }
        n = hashtable.size();
        groupArray2 = new Group[n];
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            groupArray2[--n] = (Group)object.nextElement();
        }
        return groupArray2;
    }

    private Group[] getUnion(Group[] groupArray) throws EasException {
        Object object;
        Object object2;
        if (groupArray == null) {
            return null;
        }
        Hashtable<Group, Count> hashtable = new Hashtable<Group, Count>();
        int n = 0;
        int n2 = groupArray.length;
        while (--n2 >= 0) {
            object2 = groupArray[n2];
            if (object2 == null) {
                return null;
            }
            object = ((Group)object2).getChildren();
            if (object == null || ((Group[])object).length == 0) {
                return null;
            }
            int n3 = ((Group[])object).length;
            while (--n3 >= 0) {
                Group group = object[n3];
                Count count = (Count)hashtable.get(group);
                if (count == null) {
                    hashtable.put(group, new Count(group, 1));
                    continue;
                }
                ++count.n;
                if (count.n != groupArray.length) continue;
                ++n;
            }
        }
        Group[] groupArray2 = new Group[n];
        if (n > 0) {
            object2 = hashtable.elements();
            while (object2.hasMoreElements()) {
                object = (Count)object2.nextElement();
                if (object.n != groupArray.length) continue;
                groupArray2[--n] = object.gid;
            }
        }
        return groupArray2;
    }

    public Group[] getChildren() {
        this.loadChildren(false);
        Group[] groupArray = new Group[this.childrenCount];
        int n = 0;
        for (int i = 0; i < groupArray.length; ++i) {
            Ch ch = (Ch)this.children.elementAt(i);
            if (ch.isRemoved()) continue;
            groupArray[n++] = ch.id;
        }
        return groupArray;
    }

    public void addChildren(Group[] groupArray) throws EasException {
        for (int i = 0; i < groupArray.length; ++i) {
            this.addChild(groupArray[i], 0);
        }
    }

    public void addChild(Group group, int n) throws EasException {
        this.addChild(group);
    }

    public void addChild(Group group) throws EasException {
        if (!this.isInitialized()) {
            throw new EasException("Can't add to uninitialized group");
        }
        if (!group.isInitialized()) {
            throw new EasException("Can't add an uninitialized group");
        }
        this.loadChildren(false);
        boolean bl = false;
        Ch ch = (Ch)Alg.find(this.children, new Ch(group), new ChCmp());
        if (ch == null) {
            ch = new Ch(group, 0);
            ch.setInserted(true);
            this.children.addElement(ch);
            bl = true;
            ++this.childrenCount;
        } else if (ch.isRemoved()) {
            ch.setRemoved(false);
            ++this.childrenCount;
            bl = true;
        }
        if (bl) {
            group.addParent(this);
        }
    }

    public void remChildren() {
        this.loadChildren(false);
        for (int i = 0; i < this.children.size(); ++i) {
            Ch ch = (Ch)this.children.elementAt(i);
            if (ch == null) continue;
            if (ch.isInserted()) {
                this.children.removeElement(ch);
                --this.childrenCount;
                --i;
                continue;
            }
            if (ch.isRemoved()) continue;
            ch.setRemoved(true);
            --this.childrenCount;
        }
    }

    public void remChild(Group group) {
        if (this.isInitialized() && group.isInitialized()) {
            this.loadChildren(false);
            Ch ch = (Ch)Alg.find(this.children, new Ch(group), new ChCmp());
            boolean bl = false;
            if (ch != null) {
                if (ch.isInserted()) {
                    this.children.removeElement(ch);
                    bl = true;
                    --this.childrenCount;
                } else if (!ch.isRemoved()) {
                    ch.setRemoved(true);
                    bl = true;
                    --this.childrenCount;
                }
            }
            if (bl) {
                group.remParent(this);
            }
        }
    }

    private void restoreChild(Group group) {
        this.loadChildren(false);
        Ch ch = (Ch)Alg.find(this.children, new Ch(group), new ChCmp());
        if (ch != null) {
            if (ch.isInserted()) {
                this.children.removeElement(ch);
                --this.childrenCount;
            } else if (ch.isRemoved()) {
                ch.setCurrent();
                ++this.childrenCount;
            }
        }
    }

    private void restoreParent(Group group) {
        this.loadParents(false);
        Ch ch = (Ch)Alg.find(this.parents, new Ch(group), new ChCmp());
        if (ch != null) {
            if (ch.isInserted()) {
                this.parents.removeElement(ch);
                --this.childrenCount;
            } else if (ch.isRemoved()) {
                ch.setCurrent();
                ++this.childrenCount;
            }
        }
    }

    public void restoreChildren() {
        this.loadChildren(false);
        for (int i = 0; i < this.children.size(); ++i) {
            Ch ch = (Ch)this.children.elementAt(i);
            ch.id.restoreParent(this);
            if (ch.isInserted()) {
                this.children.removeElementAt(i--);
                --this.childrenCount;
                continue;
            }
            if (!ch.isRemoved()) continue;
            ch.setCurrent();
            ++this.childrenCount;
        }
    }

    public void restoreParents() {
        this.loadParents(false);
        for (int i = 0; i < this.parents.size(); ++i) {
            Ch ch = (Ch)this.parents.elementAt(i);
            ch.id.restoreChild(this);
            if (ch.isInserted()) {
                this.parents.removeElementAt(i--);
                --this.childrenCount;
                continue;
            }
            if (!ch.isRemoved()) continue;
            ch.setCurrent();
            ++this.childrenCount;
        }
    }

    private void loadChildren(boolean bl) {
        if (!bl && this.childrenLoaded) {
            return;
        }
        if (this.isInitialized()) {
            Vector vector = this.session.getGroupExec().loadChildren(this.id, this.session.getUserName());
            this.childrenCount = vector.size();
            this.children.setSize(this.childrenCount);
            for (int i = 0; i < this.childrenCount; ++i) {
                this.children.setElementAt(new Ch((Group)vector.elementAt(i), i), i);
            }
            this.childrenLoaded = true;
        }
    }

    public Group[] getParents() {
        this.loadParents(false);
        Group[] groupArray = new Group[this.parentsCount];
        int n = 0;
        for (int i = 0; i < groupArray.length; ++i) {
            Ch ch = (Ch)this.parents.elementAt(i);
            if (ch.isRemoved()) continue;
            groupArray[n++] = ch.id;
        }
        return groupArray;
    }

    public void addParents(Group[] groupArray) throws EasException {
        for (int i = 0; i < groupArray.length; ++i) {
            this.addParent(groupArray[i]);
        }
    }

    public void addParent(Group group) throws EasException {
        if (!this.isInitialized()) {
            throw new EasException("Can't add to uninitialized group");
        }
        if (!group.isInitialized()) {
            throw new EasException("Can't add an uninitialized group");
        }
        this.loadParents(false);
        Ch ch = (Ch)Alg.find(this.parents, new Ch(group), new ChCmp());
        boolean bl = false;
        if (ch == null) {
            ch = new Ch(group, 0);
            ch.setInserted(true);
            this.parents.addElement(ch);
            ++this.parentsCount;
            bl = true;
        } else if (ch.isRemoved()) {
            ch.setRemoved(false);
            ++this.parentsCount;
            bl = true;
        }
        if (bl) {
            group.addChild(this, 0);
        }
    }

    public void remParents() {
        this.loadParents(false);
        for (int i = 0; i < this.parents.size(); ++i) {
            Ch ch = (Ch)this.parents.elementAt(i);
            if (ch == null) continue;
            if (ch.isInserted()) {
                this.parents.removeElement(ch);
                --this.parentsCount;
                --i;
                continue;
            }
            if (ch.isRemoved()) continue;
            ch.setRemoved(true);
            --this.parentsCount;
        }
    }

    public void remParent(Group group) {
        if (this.isInitialized() && group.isInitialized()) {
            this.loadParents(false);
            Ch ch = (Ch)Alg.find(this.parents, new Ch(group), new ChCmp());
            boolean bl = false;
            if (ch != null) {
                if (ch.isInserted()) {
                    this.parents.removeElement(ch);
                    bl = true;
                    --this.parentsCount;
                } else if (!ch.isRemoved()) {
                    ch.setRemoved(true);
                    bl = true;
                    --this.parentsCount;
                }
            }
            if (bl) {
                group.remChild(this);
            }
        }
    }

    private void loadParents(boolean bl) {
        if (!bl && this.parentsLoaded) {
            return;
        }
        if (this.isInitialized()) {
            Vector vector = this.session.getGroupExec().getParents(this.id, this.session.getUserName());
            this.parentsCount = vector == null ? 0 : vector.size();
            this.parents.setSize(this.parentsCount);
            for (int i = 0; i < this.parentsCount; ++i) {
                this.parents.setElementAt(new Ch((Group)vector.elementAt(i), i), i);
            }
            this.parentsLoaded = true;
        }
    }

    public void loadProperties(boolean bl) {
        if (!bl && this.propertiesLoaded) {
            return;
        }
        if (this.isInitialized()) {
            String[] stringArray = this.session.getGroupExec().getPropertyNames(this.id, this.session.getUserName());
            this.propertiesCount = stringArray.length;
            this.properties.setSize(this.propertiesCount);
            for (int i = 0; i < this.propertiesCount; ++i) {
                this.properties.setElementAt(new Pr(this.session.getGroupExec().getProperty(this, stringArray[i], this.session.getUserName()), i), i);
            }
            this.propertiesLoaded = true;
        }
    }

    public String[] getPropertyNames() throws EasException {
        if (this.isInitialized()) {
            this.loadProperties(false);
            String[] stringArray = new String[this.propertiesCount];
            int n = 0;
            for (int i = 0; i < this.properties.size(); ++i) {
                Pr pr = (Pr)this.properties.elementAt(i);
                if (pr.isRemoved()) continue;
                stringArray[n++] = pr.id.getName();
            }
            return stringArray;
        }
        throw new EasException("Non-initialized group");
    }

    public Property getProperty(String string) {
        if (this.isInitialized()) {
            this.loadProperties(false);
            Pr pr = (Pr)Alg.find(this.properties, string, new PrCmp());
            if (pr == null) {
                return null;
            }
            if (!pr.isRemoved()) {
                return pr.id;
            }
        }
        return null;
    }

    public void addProperty(Property property) throws EasException {
        if (this.isInitialized()) {
            this.loadProperties(false);
            Pr pr = (Pr)Alg.find(this.properties, property, new PrCmp());
            if (pr == null) {
                pr = new Pr(property);
                property.setGroup(this, property);
                pr.setInserted(true);
                this.properties.addElement(pr);
                ++this.propertiesCount;
            } else if (pr.isRemoved()) {
                pr.setRemoved(false);
                ++this.propertiesCount;
            } else {
                throw new EasException("Property name must be unique within a group");
            }
        }
    }

    public void remProperty(String string) {
        if (this.isInitialized()) {
            this.loadProperties(false);
            Pr pr = (Pr)Alg.find(this.properties, string, new PrCmp());
            if (pr != null) {
                if (pr.isInserted()) {
                    this.properties.removeElement(pr);
                    --this.propertiesCount;
                } else if (!pr.isRemoved()) {
                    pr.setRemoved(true);
                    --this.propertiesCount;
                }
            }
        }
    }

    public void changeProperty(Property property) throws EasException {
        if (property.getGroup() != null && property.getGroup() != this) {
            throw new EasException("The property doesn't belong to the group");
        }
        if (!this.isInitialized()) {
            throw new EasException("not initialized group ");
        }
        this.loadProperties(false);
        Pr pr = (Pr)Alg.find(this.properties, property, new PrCmp());
        if (pr != null && pr.id != property) {
            throw new EasException("Property name must be unique within a group");
        }
        if (pr == null) {
            throw new EasException("Property name can not be changed");
        }
        if (pr.isRemoved()) {
            throw new EasException("Property was removed from the group");
        }
        if (property.getGroup() == null) {
            property.setGroup(this, property);
        }
        pr.setModified(true);
    }

    public void loadLinkedDataPoints(boolean bl) {
        if (!bl && this.linkedDataPointsLoaded) {
            return;
        }
        if (this.isInitialized()) {
            Vector vector = this.session.getDataPointExec().getGroupDataPoints(this.getId());
            this.linkedDataPointsCount = vector.size();
            this.linkedDataPoints.setSize(this.linkedDataPointsCount);
            for (int i = 0; i < this.linkedDataPointsCount; ++i) {
                this.linkedDataPoints.setElementAt(new Dp((DataPoint)vector.elementAt(i)), i);
            }
            this.linkedDataPointsLoaded = true;
        }
    }

    public void linkDataPoint(DataPoint dataPoint) throws EasException {
        if (this.isInitialized()) {
            this.loadLinkedDataPoints(false);
            Dp dp = (Dp)Alg.find(this.linkedDataPoints, dataPoint, new DpCmp());
            boolean bl = false;
            if (dp == null) {
                dp = new Dp(dataPoint);
                dp.setInserted(true);
                this.linkedDataPoints.addElement(dp);
                ++this.linkedDataPointsCount;
                bl = true;
            } else if (dp.isRemoved()) {
                dp.setRemoved(false);
                ++this.linkedDataPointsCount;
                bl = true;
            }
            if (bl) {
                dataPoint.linkGroup(this);
            }
        }
    }

    public void unlinkDataPoint(DataPoint dataPoint) {
        this.loadLinkedDataPoints(false);
        Dp dp = (Dp)Alg.find(this.linkedDataPoints, dataPoint, new DpCmp());
        boolean bl = false;
        if (dp != null) {
            if (dp.isInserted()) {
                this.linkedDataPoints.removeElement(dp);
                --this.linkedDataPointsCount;
                bl = true;
            } else if (!dp.isRemoved()) {
                dp.setRemoved(true);
                --this.linkedDataPointsCount;
                bl = true;
            }
        }
        if (bl) {
            dataPoint.unlinkGroup(this);
        }
    }

    public DataPoint[] getLinkedDataPoints() {
        this.loadLinkedDataPoints(false);
        DataPoint[] dataPointArray = new DataPoint[this.linkedDataPointsCount];
        int n = 0;
        for (int i = 0; i < this.linkedDataPoints.size(); ++i) {
            Dp dp = (Dp)this.linkedDataPoints.elementAt(i);
            if (dp.isRemoved()) continue;
            dataPointArray[n++] = dp.id;
        }
        return dataPointArray;
    }

    public void save() throws EasException {
        this.save(-1, true);
    }

    public void save(int n, boolean bl) throws EasException {
        PStatus pStatus;
        int n2;
        boolean bl2 = false;
        if ((n & 1) != 0) {
            if (this.status.isRemoved()) {
                this.session.remove(this);
                this.session.getGroupExec().remove(this.id, this.session.getUserName());
            } else if (this.status.isInserted()) {
                this.id = this.session.getGroupExec().create(this.name, this.type, this.user, this.session.getUserName());
                if (this.id == -1) {
                    throw new EasException("Can't create new group in the database.");
                }
                this.session.get(this);
                this.status.setCurrent();
            } else if (this.status.isModified()) {
                this.session.getGroupExec().update(this.id, this.name, this.user, this.session.getUserName());
            }
            this.status.setCurrent();
        }
        if ((n & 0x20) != 0) {
            for (n2 = 0; n2 < this.children.size(); ++n2) {
                Ch ch = (Ch)this.children.elementAt(n2);
                if (ch.isRemoved()) {
                    if (bl) {
                        this.session.getGroupExec().remChild(this.id, ch.id.getId(), this.session.getUserName());
                        ch.id.save(16, false);
                    }
                    bl2 = true;
                    continue;
                }
                if (ch.isInserted()) {
                    if (bl) {
                        ch.id.save(1, true);
                        this.session.getGroupExec().addChild(this.id, ch.id.getId(), ch.seq, this.session.getUserName());
                        ch.id.save(16, false);
                    }
                    ch.setCurrent();
                    continue;
                }
                if (!ch.isModified()) continue;
                ch.setCurrent();
            }
        }
        if (bl2) {
            Vector<Ch> vector = new Vector<Ch>(this.childrenCount);
            for (int i = 0; i < this.children.size(); ++i) {
                pStatus = (Ch)this.children.elementAt(i);
                if (pStatus.isRemoved()) continue;
                vector.addElement((Ch)pStatus);
            }
            this.children = vector;
        }
        bl2 = false;
        if ((n & 0x10) != 0) {
            for (n2 = 0; n2 < this.parents.size(); ++n2) {
                Ch ch = (Ch)this.parents.elementAt(n2);
                if (ch.isRemoved()) {
                    if (bl) {
                        this.session.getGroupExec().remChild(ch.id.getId(), this.id, this.session.getUserName());
                        ch.id.save(32, false);
                    }
                    bl2 = true;
                    continue;
                }
                if (!ch.isInserted()) continue;
                if (bl) {
                    ch.id.save(1, true);
                    this.session.getGroupExec().addChild(ch.id.getId(), this.id, 0, this.session.getUserName());
                    ch.id.save(32, false);
                }
                ch.setCurrent();
            }
        }
        if (bl2) {
            Vector<Ch> vector = new Vector<Ch>(this.parentsCount);
            for (int i = 0; i < this.parents.size(); ++i) {
                pStatus = (Ch)this.parents.elementAt(i);
                if (pStatus.isRemoved()) continue;
                vector.addElement((Ch)pStatus);
            }
            this.parents = vector;
        }
        bl2 = false;
        if ((n & 0x40) != 0) {
            for (int i = 0; i < this.properties.size(); ++i) {
                Pr pr = (Pr)this.properties.elementAt(i);
                if (pr.isRemoved()) {
                    this.session.getGroupExec().remProperty(this.getId(), pr.id.getName(), this.session.getUserName());
                    bl2 = true;
                    continue;
                }
                if (pr.isInserted()) {
                    if (this.session.getGroupExec().addProperty(this.getId(), pr.id, this.session.getUserName()) != 0) {
                        throw new EasException();
                    }
                    pr.setCurrent();
                    continue;
                }
                if (!pr.isModified()) continue;
                this.session.getGroupExec().setProperty(this.getId(), pr.id, this.session.getUserName());
                pr.setCurrent();
            }
        }
        if (bl2) {
            Vector<PStatus> vector = new Vector<PStatus>(this.propertiesCount);
            for (int i = 0; i < this.properties.size(); ++i) {
                pStatus = (Pr)this.properties.elementAt(i);
                if (pStatus.isRemoved()) continue;
                vector.addElement(pStatus);
            }
            this.properties = vector;
        }
        bl2 = false;
        if ((n & 4) != 0) {
            for (int i = 0; i < this.linkedDataPoints.size(); ++i) {
                Dp dp = (Dp)this.linkedDataPoints.elementAt(i);
                if (dp.isRemoved()) {
                    if (bl) {
                        this.session.getDataPointExec().remGroupLink(dp.id.getId(), this.getId());
                        dp.id.save(1, false);
                    }
                    bl2 = true;
                    continue;
                }
                if (dp.isInserted()) {
                    if (bl) {
                        dp.id.save(4, true);
                        this.session.getDataPointExec().addGroupLink(dp.id.getId(), this.getId());
                        dp.id.save(1, false);
                    }
                    dp.setCurrent();
                    continue;
                }
                if (!dp.isModified()) continue;
                if (bl) {
                    dp.id.save();
                }
                dp.setCurrent();
            }
        }
        if (bl2) {
            Vector<PStatus> vector = new Vector<PStatus>(this.linkedDataPointsCount);
            for (int i = 0; i < this.linkedDataPoints.size(); ++i) {
                pStatus = (Dp)this.linkedDataPoints.elementAt(i);
                if (pStatus.isRemoved()) continue;
                vector.addElement(pStatus);
            }
            this.linkedDataPoints = vector;
        }
    }

    private PStatus msStatus() {
        PStatus pStatus = new PStatus();
        pStatus.or(this.mStatus(this.children));
        pStatus.or(this.mStatus(this.properties));
        pStatus.or(this.mStatus(this.linkedDataPoints));
        return pStatus;
    }

    private PStatus mStatus(Vector vector) {
        PStatus pStatus = new PStatus();
        int n = vector.size();
        while (--n >= 0) {
            pStatus.or((PStatus)vector.elementAt(n));
        }
        return pStatus;
    }

    private class Count {
        Group gid;
        int n;

        Count(Group group2, int n) {
            this.gid = group2;
            this.n = n;
        }
    }

    private class Dp
    extends PStatus {
        public DataPoint id;

        public Dp(DataPoint dataPoint) {
            this.id = dataPoint;
        }
    }

    private class DpCmp
    implements Comparator {
        private DpCmp() {
        }

        public int compare(Object object, Object object2) {
            return ((Dp)object).id.compareTo(object2);
        }
    }

    private class PrCmp
    implements Comparator {
        private PrCmp() {
        }

        public int compare(Object object, Object object2) {
            String string = object2 instanceof String ? (String)object2 : (object2 instanceof Property ? ((Property)object2).getName() : ((Pr)object2).id.getName());
            Pr pr = (Pr)object;
            return pr.id.getName().compareTo(string);
        }
    }

    private class Pr
    extends PStatus {
        public int seq;
        public Property id;

        public Pr(Property property, int n) {
            this.id = property;
            this.seq = n;
        }

        public Pr(Property property) {
            this.id = property;
            this.seq = 0;
        }
    }

    private class ChCmp
    implements Comparator {
        private ChCmp() {
        }

        public int compare(Object object, Object object2) {
            Ch ch = (Ch)object;
            Ch ch2 = (Ch)object2;
            if (ch.id.getId() == ch2.id.getId()) {
                return 0;
            }
            if (ch.seq > ch2.seq) {
                return 1;
            }
            if (ch.seq < ch2.seq) {
                return -1;
            }
            if (ch.id.getId() > ch2.id.getId()) {
                return 1;
            }
            if (ch.id.getId() < ch2.id.getId()) {
                return -1;
            }
            return 0;
        }
    }

    private class Ch
    extends PStatus {
        public int seq;
        public Group id;

        public Ch(Group group2, int n) {
            this.id = group2;
            this.seq = n;
        }

        public Ch(Group group2) {
            this.id = group2;
            this.seq = 0;
        }
    }
}

