/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPoint;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.ExceptionSummaryData;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RegularTimeParameters;
import com.tridium.eas.api.RestorationMethod;
import com.tridium.eas.api.TSDataFloat;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import com.tridium.eas.function.Population;
import com.tridium.eas.function.RepeatingPopulation;
import com.tridium.eas.function.ScalarBinaryOperation;
import com.tridium.eas.function.UnitConvertedPopulation;
import com.tridium.eas.function.VectorBinaryOperation;
import javax.baja.units.BUnit;

public class ExceptionSummary
extends ExceptionSummaryData {
    public static final int UPPER_LIMIT_SPC = 1;
    public static final int LOWER_LIMIT_SPC = 2;
    public static final int UPPER_LIMIT_RATIO = 4;
    public static final int LOWER_LIMIT_RATIO = 8;
    public static final int UPPER_LIMIT_FIXED = 64;
    public static final int LOWER_LIMIT_FIXED = 128;
    public static final int SPC_LIMITS = 3;
    public static final int FIXED_LIMITS = 192;
    public static final int RATIO_LIMITS = 12;
    public static final int UPPER_LIMITS = 69;
    public static final int LOWER_LIMITS = 138;
    public static final int BASELINE = 0;
    public static final int OBSERVED = 1;
    public static final int DIFFERENCE = 2;
    private DataPoint dp;
    private DataPoint temperature;
    private EasLocalTime report_start_time;
    private EasLocalTime report_end_time;
    private int incl_wdays;
    private int excl_wdays;
    private int startHr;
    private int startMin;
    private int endHr;
    private int endMin;
    private boolean exclusive;
    private TimeInterval granularity;
    private int rollup_method;
    private EasLocalTime baseline_start_time;
    private int baseline_length;
    private int limit_type;
    private double upper_limit;
    private double lower_limit;
    private int max_exceptions;
    private RestorationMethod restoration;
    private int violation_rules;
    private boolean weatherNorm;
    private boolean dataCleanse;
    private int dataCleanseWindow;
    private double dataCleansePercentage;
    private boolean dpNormalization;
    private DataPoint normalizer;
    private TSDataFloat baseline = null;
    private TSDataFloat observed = null;
    private TSDataSummary tempSummary = null;
    private Population diffPopulation = null;
    private Population observedPopulation = null;
    private Population baselinePopulation = null;
    private EasSession session = null;

    public static ExceptionSummary getExceptionSummary(DataPoint dataPoint, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, TimeInterval timeInterval, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, EasLocalTime easLocalTime3, int n6, int n7, int n8, double d, boolean bl3, int n9, double d2, boolean bl4, DataPoint dataPoint2) throws EasException {
        double d3 = (n8 & 4) > 0 && (n8 & 0x8A) == 0 ? -1.0 * d : 0.0;
        return ExceptionSummary.getExceptionSummary(dataPoint, easLocalTime, easLocalTime2, timeInterval, n, n2, n3, n4, n5, bl, bl2, easLocalTime3, n6, n7, n8, d, d3, bl3, n9, d2, bl4, dataPoint2);
    }

    public static ExceptionSummary getExceptionSummary(DataPoint dataPoint, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, TimeInterval timeInterval, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, EasLocalTime easLocalTime3, int n6, int n7, int n8, double d, double d2, boolean bl3, int n9, double d3, boolean bl4, DataPoint dataPoint2) throws EasException {
        String string = dataPoint.getName();
        BUnit bUnit = dataPoint.getUnit();
        DataPoint dataPoint3 = dataPoint.getTemperatureDP();
        int n10 = 0;
        int n11 = 4;
        if (dataPoint.getRcSubType() == RcSubtype.CONSUMPTION.getCode() || dataPoint.getRcSubType() == RcSubtype.APPARENT_ENERGY.getCode() || dataPoint.getRcSubType() == RcSubtype.REACTIVE_ENERGY.getCode()) {
            n11 = 1;
        }
        if (dataPoint.getRcSubType() == RcSubtype.DEMAND.getCode() || dataPoint.getRcSubType() == RcSubtype.APPARENT_POWER.getCode() || dataPoint.getRcSubType() == RcSubtype.REACTIVE_POWER.getCode()) {
            n11 = 2;
        }
        long l = 0L;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = true;
        RestorationMethod restorationMethod = RestorationMethod.getByRcSubType(dataPoint.getRcSubTypeObj());
        if (dataPoint.getSession().getDataPointExec().isMultistate(string)) {
            restorationMethod = RestorationMethod.NON;
        }
        TimeInterval timeInterval2 = dataPoint.getSamplingInterval();
        int n12 = 0;
        ExceptionSummary exceptionSummary = new ExceptionSummary(dataPoint, easLocalTime, easLocalTime2, n, n10, n2, n3, n4, n5, bl, timeInterval, bl2, n11, easLocalTime3, n6, n8, d, d2, n7, restorationMethod, n12, bl3, n9, d3, bl4, dataPoint2);
        ExceptionSummaryData exceptionSummaryData = dataPoint.getSession().getDataPointExec().getExceptionSummaryData(string, easLocalTime, easLocalTime2, dataPoint.getTimeZone(), n, n10, n2, n3, n4, n5, bl, timeInterval, dataPoint.getUnit(), bl2, dataPoint3 == null ? null : dataPoint3.getName(), n11, easLocalTime3, n6, n8, d, d2, n7, n12, restorationMethod, timeInterval2, bl3, n9, d3, bl4, dataPoint2);
        return exceptionSummary.copyResults(exceptionSummaryData);
    }

    public Population getObservedPopulation(BUnit bUnit) throws EasException {
        return new UnitConvertedPopulation(this.getObservedPopulation(), bUnit);
    }

    public Population getObservedPopulation() throws EasException {
        if (this.observedPopulation == null) {
            this.observedPopulation = this.getObserved().getPopulation();
        }
        return this.observedPopulation;
    }

    public RegularTimeParameters getTimeParameters() throws EasException {
        return this.getObserved().getTimeParameters();
    }

    public long getDefaultTime(int n) throws EasException {
        return this.getObserved().getDefaultTime(n);
    }

    public long getZonelessTime(int n) throws EasException {
        return this.getObserved().getZonelessTime(n);
    }

    public long getLocalTime(int n) throws EasException {
        return this.getObserved().getZonelessTime(n);
    }

    public Population getBaselinePopulation(BUnit bUnit) throws EasException {
        return new UnitConvertedPopulation(this.getBaselinePopulation(), bUnit);
    }

    public Population getBaselinePopulation() throws EasException {
        if (this.baselinePopulation == null) {
            this.baselinePopulation = new RepeatingPopulation(this.getBaseline().getPopulation(), this.getObserved().getSize());
        }
        return this.baselinePopulation;
    }

    public Population getDiffPopulation(BUnit bUnit) throws EasException {
        return new UnitConvertedPopulation(this.getDiffPopulation(), bUnit);
    }

    public Population getDiffPopulation() throws EasException {
        if (this.diffPopulation == null) {
            boolean bl;
            boolean bl2 = bl = (this.limit_type & 0xC) != 0;
            if (bl) {
                ScalarBinaryOperation scalarBinaryOperation = new ScalarBinaryOperation(){

                    public double getScalar(double d, double d2) {
                        return (d - d2) / d2;
                    }

                    public boolean isValid(double d, double d2) {
                        return d2 != 0.0;
                    }
                };
                this.diffPopulation = VectorBinaryOperation.getPopulation(this.getObservedPopulation(), this.getBaselinePopulation(), scalarBinaryOperation, BUnit.NULL);
            } else {
                ScalarBinaryOperation scalarBinaryOperation = new ScalarBinaryOperation(){

                    public double getScalar(double d, double d2) {
                        return d - d2;
                    }

                    public boolean isValid(double d, double d2) {
                        return true;
                    }
                };
                this.diffPopulation = VectorBinaryOperation.getPopulation(this.getObservedPopulation(), this.getBaselinePopulation(), scalarBinaryOperation);
            }
        }
        return this.diffPopulation;
    }

    public void clearCache() {
        this.baseline = null;
        this.observed = null;
        this.diffPopulation = null;
        this.observedPopulation = null;
        this.baselinePopulation = null;
    }

    public int getViolationsTotal() {
        return this.violationsAbove + this.violationsBelow;
    }

    public int getUpperLimitViolations() {
        return this.violationsAbove;
    }

    public int getLowerLimitViolations() {
        return this.violationsBelow;
    }

    public int[] getViolations() {
        return this.violations;
    }

    public int[] getViolations(boolean bl) {
        return this.violations;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public double getTotal() {
        return this.total;
    }

    public double getTotalDiff() {
        return this.totalDiff;
    }

    public double getPositiveDiff() {
        return this.positiveDiff;
    }

    public double getSPC_UpperLimit() {
        return this.SPC_UpperLimit;
    }

    public double getSPC_LowerLimit() {
        return this.SPC_LowerLimit;
    }

    public int getLimitType() {
        return this.limit_type;
    }

    public double getUpperLimit() {
        return this.upper_limit;
    }

    public double getLowerLimit() {
        return this.lower_limit;
    }

    private TSDataFloat getBaseline() throws EasException {
        if (this.baseline == null) {
            this.baseline = this.dp.getSession().getDataPointExec().getExceptionSeries(this.dp.getName(), false, this.report_start_time, this.report_end_time, this.dp.getTimeZone(), this.incl_wdays, this.excl_wdays, this.startHr, this.startMin, this.endHr, this.endMin, this.exclusive, this.granularity, this.dp.getUnit(), this.weatherNorm, this.temperature == null ? null : this.temperature.getName(), this.rollup_method, this.baseline_start_time, this.baseline_length, this.restoration, this.dp.getSamplingInterval(), this.dataCleanse, this.dataCleanseWindow, this.dataCleansePercentage, this.dpNormalization, this.normalizer);
        }
        return this.baseline;
    }

    private TSDataFloat getObserved() throws EasException {
        if (this.observed == null) {
            this.observed = this.dp.getSession().getDataPointExec().getExceptionSeries(this.dp.getName(), true, this.report_start_time, this.report_end_time, this.dp.getTimeZone(), this.incl_wdays, this.excl_wdays, this.startHr, this.startMin, this.endHr, this.endMin, this.exclusive, this.granularity, this.dp.getUnit(), this.weatherNorm, this.temperature == null ? null : this.temperature.getName(), this.rollup_method, this.baseline_start_time, this.baseline_length, this.restoration, this.dp.getSamplingInterval(), this.dataCleanse, this.dataCleanseWindow, this.dataCleansePercentage, this.dpNormalization, this.normalizer);
        }
        return this.observed;
    }

    private TSDataSummary getTemperature() throws EasException {
        if (this.tempSummary == null && this.temperature != null) {
            this.tempSummary = this.temperature.getDataSummary(this.report_start_time, this.report_end_time, BUnit.getUnit((String)"fahrenheit"), this.incl_wdays, this.excl_wdays, this.granularity, this.dataCleanse, this.dataCleanseWindow, this.dataCleansePercentage, false, null);
        }
        return this.tempSummary;
    }

    public Population getTemperaturePopulation() throws EasException {
        if (this.getTemperature() != null) {
            return this.getTemperature().getMeanPopulation();
        }
        return new Population(){

            public int getSize() {
                return 0;
            }

            public double getSample(int n) {
                return 0.0;
            }

            public BUnit getUnit() {
                return null;
            }

            public boolean isValid(int n) {
                return false;
            }
        };
    }

    private ExceptionSummary copyResults(ExceptionSummaryData exceptionSummaryData) {
        this.violationsAbove = exceptionSummaryData.violationsAbove;
        this.violationsBelow = exceptionSummaryData.violationsBelow;
        this.violations = exceptionSummaryData.violations;
        this.totalCount = exceptionSummaryData.totalCount;
        this.total = exceptionSummaryData.total;
        this.totalDiff = exceptionSummaryData.totalDiff;
        this.positiveDiff = exceptionSummaryData.positiveDiff;
        this.SPC_UpperLimit = exceptionSummaryData.SPC_UpperLimit;
        this.SPC_LowerLimit = exceptionSummaryData.SPC_LowerLimit;
        return this;
    }

    private ExceptionSummary(DataPoint dataPoint, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, TimeInterval timeInterval, boolean bl2, int n7, EasLocalTime easLocalTime3, int n8, int n9, double d, double d2, int n10, RestorationMethod restorationMethod, int n11, boolean bl3, int n12, double d3, boolean bl4, DataPoint dataPoint2) {
        this.dp = dataPoint;
        try {
            this.temperature = dataPoint.getTemperatureDP();
        }
        catch (EasException easException) {
            this.temperature = null;
        }
        this.report_start_time = easLocalTime;
        this.report_end_time = easLocalTime2;
        this.incl_wdays = n;
        this.excl_wdays = n2;
        this.startHr = n3;
        this.startMin = n4;
        this.endHr = n5;
        this.endMin = n6;
        this.exclusive = bl;
        this.granularity = timeInterval;
        this.weatherNorm = bl2;
        this.rollup_method = n7;
        this.baseline_start_time = easLocalTime3;
        this.baseline_length = n8;
        this.limit_type = n9;
        this.upper_limit = d;
        this.lower_limit = d2;
        this.max_exceptions = n10;
        this.restoration = restorationMethod;
        this.violation_rules = n11;
        this.dataCleanse = bl3;
        this.dataCleanseWindow = n12;
        this.dataCleansePercentage = d3;
        this.dpNormalization = bl4;
        this.normalizer = dataPoint2;
    }

    public static class ExceptionSummaryLimitType {
        private int limit = 0;

        public ExceptionSummaryLimitType(int n) {
            this.limit = n;
        }

        public boolean hasUpperLimitSPC() {
            return (this.limit & 1) != 0;
        }

        public boolean hasLowerLimitSPC() {
            return (this.limit & 2) != 0;
        }

        public boolean hasUpperLimitRatio() {
            return (this.limit & 4) != 0;
        }

        public boolean hasLowerLimitRatio() {
            return (this.limit & 8) != 0;
        }

        public boolean hasUpperLimitFixed() {
            return (this.limit & 0x40) != 0;
        }

        public boolean hasLowerLimitFixed() {
            return (this.limit & 0x80) != 0;
        }

        public boolean hasSPCLimits() {
            return (this.limit & 3) != 0;
        }

        public boolean hasFixedLimits() {
            return (this.limit & 0xC0) != 0;
        }

        public boolean hasRatioLimits() {
            return (this.limit & 0xC) != 0;
        }

        public boolean hasUpperLimits() {
            return (this.limit & 0x45) != 0;
        }

        public boolean hasLowerLimits() {
            return (this.limit & 0x8A) != 0;
        }
    }
}

