/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;

public class EasLocalTime
implements Cloneable {
    private static final BTimeZone GMT = BTimeZone.getTimeZone((String)"GMT");
    private int year;
    private int month;
    private int day;
    private int hour;
    private int minute;
    private int second;
    private int millisecond;

    public EasLocalTime() {
    }

    public EasLocalTime(int n, int n2, int n3) {
        this(n, n2, n3, 0, 0, 0, 0);
    }

    public EasLocalTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this(n, n2, n3, n4, n5, n6, 0);
    }

    public EasLocalTime(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hour = n4;
        this.minute = n5;
        this.second = n6;
        this.millisecond = n7;
    }

    public EasLocalTime(Calendar calendar) {
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.millisecond = calendar.get(14);
    }

    public EasLocalTime(Calendar calendar, int n, int n2, int n3, int n4) {
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.hour = n;
        this.minute = n2;
        this.second = n3;
        this.millisecond = n4;
    }

    public EasLocalTime(long l, BTimeZone bTimeZone) {
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.setTime(new Date(l));
        this.year = calendar.get(1);
        this.month = calendar.get(2);
        this.day = calendar.get(5);
        this.hour = calendar.get(11);
        this.minute = calendar.get(12);
        this.second = calendar.get(13);
        this.millisecond = calendar.get(14);
    }

    public static EasLocalTime getCurrentTime() {
        return new EasLocalTime(System.currentTimeMillis(), BTimeZone.getLocal());
    }

    public long getTimestamp(BTimeZone bTimeZone) {
        return this.getCalendar(bTimeZone).getTime().getTime();
    }

    public Calendar getCalendar(BTimeZone bTimeZone) {
        Calendar calendar = Calendar.getInstance((TimeZone)bTimeZone.tzSupport());
        calendar.set(1, this.year);
        calendar.set(2, this.month);
        calendar.set(5, this.day);
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.millisecond);
        return calendar;
    }

    public Date getDate(BTimeZone bTimeZone) {
        return this.getCalendar(bTimeZone).getTime();
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public boolean isAfter(EasLocalTime easLocalTime) {
        if (this.year > easLocalTime.year) {
            return true;
        }
        if (this.year == easLocalTime.year) {
            if (this.month > easLocalTime.month) {
                return true;
            }
            if (this.month == easLocalTime.month) {
                if (this.day > easLocalTime.day) {
                    return true;
                }
                if (this.day == easLocalTime.day) {
                    if (this.hour > easLocalTime.hour) {
                        return true;
                    }
                    if (this.hour == easLocalTime.hour) {
                        if (this.minute > easLocalTime.minute) {
                            return true;
                        }
                        if (this.minute == easLocalTime.minute) {
                            if (this.second > easLocalTime.second) {
                                return true;
                            }
                            if (this.second == easLocalTime.second) {
                                return this.millisecond > easLocalTime.millisecond;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean equals(EasLocalTime easLocalTime) {
        return this.year == easLocalTime.year && this.month == easLocalTime.month && this.day == easLocalTime.day && this.hour == easLocalTime.hour && this.minute == easLocalTime.minute && this.second == easLocalTime.second && this.millisecond == easLocalTime.millisecond;
    }

    public boolean isBefore(EasLocalTime easLocalTime) {
        return !this.equals(easLocalTime) && !this.isAfter(easLocalTime);
    }

    public long toSerializedLong() {
        return this.getTimestamp(GMT);
    }

    public static EasLocalTime fromSerializedLong(long l) {
        Calendar calendar = Calendar.getInstance((TimeZone)GMT.tzSupport());
        calendar.setTime(new Date(l));
        return new EasLocalTime(calendar.get(1), calendar.get(2), calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14));
    }

    public String toString() {
        return this.year + "-" + this.month + "-" + this.day + " " + this.hour + ":" + this.minute + ":" + this.second + "." + this.millisecond + "; ";
    }

    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.year);
        dataOutput.writeInt(this.month);
        dataOutput.writeInt(this.day);
        dataOutput.writeInt(this.hour);
        dataOutput.writeInt(this.minute);
        dataOutput.writeInt(this.second);
        dataOutput.writeInt(this.millisecond);
    }

    public void load(DataInput dataInput) throws IOException {
        this.year = dataInput.readInt();
        this.month = dataInput.readInt();
        this.day = dataInput.readInt();
        this.hour = dataInput.readInt();
        this.minute = dataInput.readInt();
        this.second = dataInput.readInt();
        this.millisecond = dataInput.readInt();
    }
}

