/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.DataPointExec;
import com.tridium.eas.api.DataPointExecCli;
import com.tridium.eas.api.DynGroupExec;
import com.tridium.eas.api.DynGroupExecCli;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.GroupExec;
import com.tridium.eas.api.GroupExecCli;
import com.tridium.eas.api.MeterExec;
import com.tridium.eas.api.MeterExecCli;
import com.tridium.eas.util.Base64Encoder;
import com.tridium.eas.xml.XmlDecoder;
import com.tridium.eas.xml.XmlEncoder;
import com.tridium.eas.xml.XmlMessage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.baja.security.BPermissions;
import javax.baja.user.BUser;

public class EasClientSession
extends EasSession {
    private GroupExecCli groupExec = null;
    private DynGroupExecCli dynGroupExec = null;
    private DataPointExecCli dataPointExec = null;
    private MeterExecCli meterExec = null;
    private URL docBase;
    private String userName;
    private String password;
    private String authHeader;
    private String language;
    private String sessionUser = null;
    private BPermissions secBits = BPermissions.none;

    public EasClientSession(URL uRL, String string) {
        this(uRL, null, null, string);
    }

    public EasClientSession(URL uRL, String string, String string2, String string3) {
        this.docBase = uRL;
        this.userName = string;
        this.password = string2;
        this.language = string3;
    }

    public int open() throws IOException {
        URL uRL = new URL(this.docBase, "/eas/login");
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        this.setAuthorization(httpURLConnection);
        this.setLanguage(httpURLConnection);
        DataInputStream dataInputStream = null;
        this.sessionUser = null;
        this.secBits = BPermissions.none;
        try {
            dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
            String string = dataInputStream.readUTF();
            if (string != null) {
                this.secBits = (BPermissions)this.secBits.decodeFromString(string);
            }
            if (this.secBits == BPermissions.none) {
                return 1;
            }
            this.sessionUser = dataInputStream.readUTF();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n = httpURLConnection.getResponseCode();
        if (dataInputStream != null) {
            dataInputStream.close();
        }
        return this.rcHttpToSession(n);
    }

    public void close() {
    }

    public URL getURL(String string) throws MalformedURLException {
        return new URL(this.docBase, string);
    }

    public BUser getUser() {
        return null;
    }

    public final String getUserName() {
        return this.sessionUser;
    }

    public final boolean hasAdminRead() {
        return this.secBits.hasAdminWrite() || this.secBits.hasAdminRead();
    }

    public final boolean hasAdminWrite() {
        return this.secBits.hasAdminWrite();
    }

    public final boolean hasOperatorRead() {
        return this.secBits.hasAdminRead() || this.secBits.hasOperatorRead();
    }

    public final boolean hasOperatorWrite() {
        return this.secBits.hasAdminWrite() || this.secBits.hasOperatorWrite();
    }

    public OutputStream put(String string) throws IOException {
        URL uRL = this.getURL(string);
        URLConnection uRLConnection = uRL.openConnection();
        this.setAuthorization(uRLConnection);
        this.setLanguage(uRLConnection);
        uRLConnection.setRequestProperty("content-type", "x-application/tridium-easdata");
        uRLConnection.setDoOutput(true);
        uRLConnection.setDoInput(true);
        return new URLConnectionOutput(uRLConnection.getOutputStream(), uRLConnection);
    }

    public InputStream get(String string) throws IOException {
        URL uRL = this.getURL(string);
        URLConnection uRLConnection = uRL.openConnection();
        this.setAuthorization(uRLConnection);
        this.setLanguage(uRLConnection);
        uRLConnection.setDoInput(true);
        return uRLConnection.getInputStream();
    }

    public String getText(String string) throws IOException {
        InputStream inputStream = this.get(string);
        if (inputStream == null) {
            return null;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(256);
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((n = bufferedInputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public XmlMessage sendRequest(XmlMessage xmlMessage) {
        int n;
        Object object;
        Object object2;
        HttpURLConnection httpURLConnection;
        Object object3;
        if (xmlMessage == null) {
            return null;
        }
        try {
            if (this.isServerDebugEnabled()) {
                xmlMessage.add("serverDebug", this.getServerDebugTag());
            }
            object3 = new URL(this.docBase, "/eas/dx");
            httpURLConnection = (HttpURLConnection)((URL)object3).openConnection();
            this.setAuthorization(httpURLConnection);
            this.setLanguage(httpURLConnection);
            httpURLConnection.setRequestProperty("content-type", "x-application/tridium-easdata");
            object2 = new ByteArrayOutputStream();
            object = new XmlEncoder((OutputStream)object2);
            object.encodeDocument(xmlMessage);
            httpURLConnection.setRequestProperty("content-length", Integer.toString(((ByteArrayOutputStream)object2).size()));
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            ((ByteArrayOutputStream)object2).writeTo(dataOutputStream);
            dataOutputStream.flush();
            dataOutputStream.close();
            n = httpURLConnection.getResponseCode();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (n < 300) {
            try {
                object3 = new DataInputStream(httpURLConnection.getInputStream());
                object2 = new XmlDecoder((InputStream)object3);
                object = (XmlMessage)((XmlDecoder)((Object)object2)).decodeDocument();
                ((FilterInputStream)object3).close();
                return object;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.out.println("EasClientSession.sendRequest ERROR - received response code " + n);
        }
        return null;
    }

    public GroupExec getGroupExec() {
        if (this.groupExec == null) {
            this.groupExec = new GroupExecCli(this);
        }
        return this.groupExec;
    }

    public DynGroupExec getDynGroupExec() {
        if (this.dynGroupExec == null) {
            this.dynGroupExec = new DynGroupExecCli(this);
        }
        return this.dynGroupExec;
    }

    public DataPointExec getDataPointExec() {
        if (this.dataPointExec == null) {
            this.dataPointExec = new DataPointExecCli(this);
        }
        return this.dataPointExec;
    }

    public MeterExec getMeterExec() {
        if (this.meterExec == null) {
            this.meterExec = new MeterExecCli(this);
        }
        return this.meterExec;
    }

    private int rcHttpToSession(int n) {
        switch (n) {
            case 200: {
                return 0;
            }
            case 401: 
            case 403: {
                return 1;
            }
            case 404: {
                return 2;
            }
        }
        return 3;
    }

    public void setAuthorization(URLConnection uRLConnection) {
        if (this.authHeader != null) {
            uRLConnection.setRequestProperty("Authorization", this.authHeader);
        } else if (this.userName != null) {
            if (this.password == null) {
                this.password = "";
            }
            this.authHeader = "Basic " + Base64Encoder.encode(this.userName + ":" + this.password);
            uRLConnection.setRequestProperty("Authorization", this.authHeader);
        }
    }

    public void setLanguage(URLConnection uRLConnection) {
        if (this.language != null) {
            uRLConnection.setRequestProperty("Accept-Language", this.language + ",en-us");
        } else {
            uRLConnection.setRequestProperty("Accept-Language", "en-us");
        }
    }

    private static class URLConnectionOutput
    extends DataOutputStream {
        private URLConnection conn;

        public URLConnectionOutput(OutputStream outputStream, URLConnection uRLConnection) {
            super(outputStream);
            this.conn = uRLConnection;
        }

        public void close() throws IOException {
            super.close();
            try {
                int n = this.conn.getContentLength();
                InputStream inputStream = this.conn.getInputStream();
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

