/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import java.util.Date;
import javax.baja.units.BUnit;

public class DataSummaryElement {
    private DataSummaryElement bad = null;
    public static final int TOTAL = 1;
    public static final int AVERAGE = 2;
    public static final int STD_DEV = 3;
    public static final int MIN_VAL = 4;
    public static final int MAX_VAL = 5;
    public static final int MAX_DATE = 6;
    public static final int MIN_DATE = 7;
    public static final int COUNT = 8;
    public static final int CYCLES = 9;
    private double sum;
    private double avgDemand;
    private double minDemand;
    private long dateOfMinDemand;
    private double peakDemand;
    private long dateOfPeakDemand;
    private int count;
    private int goodCount;
    private double sum2 = 0.0;
    private int nCycles;

    public DataSummaryElement(double d, double d2, double d3, long l, double d4, long l2, int n, int n2, int n3) {
        this.sum = d;
        this.avgDemand = d2;
        this.minDemand = d3;
        this.dateOfMinDemand = l;
        this.peakDemand = d4;
        this.dateOfPeakDemand = l2;
        this.count = n;
        this.goodCount = n2;
        this.sum2 = this.sum2;
        this.nCycles = n3;
    }

    public DataSummaryElement(DataSummaryElement dataSummaryElement) {
        this.sum = dataSummaryElement.sum;
        this.avgDemand = dataSummaryElement.avgDemand;
        this.minDemand = dataSummaryElement.minDemand;
        this.dateOfMinDemand = dataSummaryElement.dateOfMinDemand;
        this.peakDemand = dataSummaryElement.peakDemand;
        this.dateOfPeakDemand = dataSummaryElement.dateOfPeakDemand;
        this.count = dataSummaryElement.count;
        this.goodCount = dataSummaryElement.goodCount;
        this.sum2 = dataSummaryElement.sum2;
        this.nCycles = dataSummaryElement.nCycles;
        this.bad = dataSummaryElement.bad == null ? null : new DataSummaryElement(dataSummaryElement.bad);
    }

    public DataSummaryElement() {
        this.sum = 0.0;
        this.sum2 = 0.0;
        this.peakDemand = -1.7976931348623157E308;
        this.minDemand = Double.MAX_VALUE;
        this.count = 0;
        this.goodCount = 0;
        this.nCycles = 1;
    }

    public void add(DataSummaryElement dataSummaryElement) {
        this.count += dataSummaryElement.count;
        this.goodCount += dataSummaryElement.goodCount;
        this.sum += dataSummaryElement.sum;
        this.sum2 += dataSummaryElement.sum2;
        if (dataSummaryElement.minDemand < this.minDemand) {
            this.minDemand = dataSummaryElement.minDemand;
            this.dateOfMinDemand = dataSummaryElement.dateOfMinDemand;
        }
        if (dataSummaryElement.peakDemand > this.peakDemand) {
            this.peakDemand = dataSummaryElement.peakDemand;
            this.dateOfPeakDemand = dataSummaryElement.dateOfPeakDemand;
        }
    }

    private void add(double d, long l) {
        ++this.count;
        this.sum += d;
        this.sum2 += d * d;
        if (d < this.minDemand) {
            this.minDemand = d;
            this.dateOfMinDemand = l;
        }
        if (d > this.peakDemand) {
            this.peakDemand = d;
            this.dateOfPeakDemand = l;
        }
    }

    public void add(double d, long l, boolean bl) {
        if (bl) {
            ++this.goodCount;
            this.add(d, l);
        } else {
            if (this.bad == null) {
                this.bad = new DataSummaryElement(this);
            }
            this.bad.add(d, l);
        }
    }

    public void doFinal() {
        if (this.count == 0 && this.bad != null) {
            this.sum = this.bad.sum;
            this.avgDemand = this.bad.avgDemand;
            this.minDemand = this.bad.minDemand;
            this.dateOfMinDemand = this.bad.dateOfMinDemand;
            this.peakDemand = this.bad.peakDemand;
            this.dateOfPeakDemand = this.bad.dateOfPeakDemand;
            this.count = this.bad.count;
            this.goodCount = this.bad.goodCount;
            this.sum2 = this.bad.sum2;
            this.nCycles = this.bad.nCycles;
            this.bad = null;
        }
    }

    public void setNumberOfCycles(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("number of cycles can't be less than 1");
        }
        this.nCycles = n;
    }

    public float getTotalConsumption() {
        if (this.count > 0) {
            return (float)(this.sum / (double)this.nCycles);
        }
        if (this.bad != null) {
            return this.bad.getTotalConsumption();
        }
        return 0.0f;
    }

    public double getTotalConsumption(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("number of cycles can't be less than 1");
        }
        if (this.count > 0) {
            return this.sum / (double)n;
        }
        if (this.bad != null) {
            return this.bad.getTotalConsumption(n);
        }
        return 0.0;
    }

    public double getStdDev() {
        return this.count > 1 ? Math.sqrt((this.sum2 - this.sum * this.sum / (double)this.count) / (double)(this.count - 1)) : (this.bad == null ? 0.0 : this.bad.getStdDev());
    }

    public double getAvgDemand() {
        return this.count > 0 ? this.sum / (double)this.count : (this.bad == null ? 0.0 : this.bad.getAvgDemand());
    }

    public double getMinDemand() {
        return this.count > 0 ? this.minDemand : (this.bad == null ? 0.0 : this.bad.getMinDemand());
    }

    public Date getDateOfMinDemand() {
        return new Date(this.dateOfMinDemand);
    }

    public double getPeakDemand() {
        return this.count > 0 ? this.peakDemand : (this.bad == null ? 0.0 : this.bad.getPeakDemand());
    }

    public Date getDateOfPeakDemand() {
        return new Date(this.dateOfPeakDemand);
    }

    public int getCount() {
        return this.count;
    }

    public int getGoodCount() {
        return this.goodCount;
    }

    public boolean isValid() {
        return this.goodCount > 0;
    }

    public int getNCycles() {
        return this.nCycles;
    }

    public void convertUnit(BUnit bUnit, BUnit bUnit2) {
        if (bUnit2.isConvertible(bUnit)) {
            this.sum = bUnit2.fromNormal(bUnit.toNormal(this.sum));
            if (this.bad != null) {
                this.bad.convertUnit(bUnit, bUnit2);
            }
        }
    }

    public int compareTo(DataSummaryElement dataSummaryElement, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl = true;
            int n = nArray[i];
            if (n < 0) {
                bl = false;
                n = -n;
            }
            double d = 0.0;
            double d2 = 0.0;
            switch (n) {
                case 1: {
                    d = this.getTotalConsumption();
                    d2 = dataSummaryElement.getTotalConsumption();
                    break;
                }
                case 2: {
                    d = this.getAvgDemand();
                    d2 = dataSummaryElement.getAvgDemand();
                    break;
                }
                case 3: {
                    d = this.getStdDev();
                    d2 = dataSummaryElement.getStdDev();
                    break;
                }
                case 4: {
                    d = this.getMinDemand();
                    d2 = dataSummaryElement.getMinDemand();
                    break;
                }
                case 5: {
                    d = this.getPeakDemand();
                    d2 = dataSummaryElement.getPeakDemand();
                    break;
                }
                case 6: {
                    d = this.dateOfPeakDemand;
                    d2 = dataSummaryElement.dateOfPeakDemand;
                    break;
                }
                case 7: {
                    d = this.dateOfMinDemand;
                    d2 = dataSummaryElement.dateOfMinDemand;
                    break;
                }
                case 8: {
                    d = this.count;
                    d2 = dataSummaryElement.count;
                    break;
                }
                case 9: {
                    d = this.nCycles;
                    d2 = dataSummaryElement.nCycles;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value of sortByField " + n);
                }
            }
            if (d > d2) {
                return bl ? 1 : -1;
            }
            if (!(d < d2)) continue;
            return bl ? -1 : 1;
        }
        return 0;
    }
}

