/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.BEasService;
import com.tridium.eas.api.DataSample;
import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.EasObject;
import com.tridium.eas.api.EasProtected;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Manager;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.PStatus;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.api.RestorationMethod;
import com.tridium.eas.api.Site;
import com.tridium.eas.api.SiteSummary;
import com.tridium.eas.api.TSDataFloat;
import com.tridium.eas.api.TSDataIrregular;
import com.tridium.eas.api.TSDataSummary;
import com.tridium.eas.api.TimeInterval;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class DataPoint
extends EasObject
implements EasProtected {
    public static final int STATUS_OK = 0;
    public static final int NON_UNIQUE_NAME = -1;
    public static final int NOT_A_VALID_GROUP = -2;
    public static final int BAD_SQL = -3;
    public static final int ERR_MULTIPLE_UPDATES = -4;
    public static final int ERR_UPDATE_COUNT = -5;
    public static final int NOT_FOUND = -6;
    public static final int NO_FUNCTION_DEFINED = -7;
    public static final int ERR_LOG_IMPORT = -8;
    public static final int ERR_CREATE = -9;
    private TimeInterval samplingInterval = TimeInterval.INTERVAL_15_MINUTES;
    private String name = null;
    private String stationName = null;
    private String descr = null;
    private int rcType = 0;
    private int rcSubType = 0;
    private boolean isMain = false;
    private String vtype = "misc";
    private String vunit = "null";
    private BUnit unit = null;
    private Site site = null;
    private Meter meter_ref = null;
    private int meter_id = -1;
    private int interval = 15;
    private int int_unit = 3;
    private String floorarea_vunit = "square foot";
    private double floorarea_value = 0.0;
    private BUnit floorarea_unit = BUnit.getUnit((String)"square foot");
    private String timeZone = null;
    private BTimeZone tz = null;
    private int flags = 1;
    private Hashtable groups = new Hashtable();
    private int groupsCount = 0;
    private boolean groupsLoaded = false;
    private UnitDatabase unitDatabase = null;
    public static final int E2_POINT = 1;
    public static final int NON_E2_POINT = 1;

    public int getProtectedType() {
        return 2;
    }

    public String getProtectedIdentifier() {
        return String.valueOf(this.getId());
    }

    private DataPoint(int n, EasSession easSession) {
        super(n, easSession);
        this.site = null;
        this.meter_ref = null;
        this.meter_id = -1;
        this.status.setOutofdate(true);
    }

    private DataPoint(int n, String string, String string2, String string3, int n2, int n3, int n4, boolean bl, String string4, String string5, Site site, int n5, String string6, double d, String string7, boolean bl2) {
        super(n, site.getSession());
        this.name = string;
        this.stationName = string2;
        this.descr = string3;
        this.flags = n2;
        this.rcType = n3;
        this.rcSubType = n4;
        this.isMain = bl;
        this.vtype = string4;
        this.vunit = string5;
        this.site = site;
        this.meter_ref = null;
        this.meter_id = n5;
        this.floorarea_vunit = string6;
        this.floorarea_value = d;
        this.floorarea_unit = null;
        this.timeZone = string7;
        this.tz = null;
        if (!bl2) {
            this.status.setOutofdate(true);
        }
    }

    private DataPoint(int n, String string, String string2, String string3, int n2, int n3, int n4, boolean bl, String string4, String string5, Site site, Meter meter, String string6, double d, String string7, boolean bl2) {
        super(n, site.getSession());
        this.name = string;
        this.stationName = string2;
        this.descr = string3;
        this.flags = n2;
        this.rcType = n3;
        this.rcSubType = n4;
        this.isMain = bl;
        this.vtype = string4;
        this.vunit = string5;
        this.site = site;
        this.meter_ref = meter;
        this.meter_id = meter == null ? -1 : meter.getId();
        this.floorarea_vunit = string6;
        this.floorarea_value = d;
        this.floorarea_unit = null;
        this.timeZone = string7;
        if (!bl2) {
            this.status.setOutofdate(true);
        }
    }

    public static DataPoint create(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5, Site site, Meter meter, String string6, double d, String string7) throws EasException {
        EasSession easSession = site.getSession();
        int n4 = easSession.getNewId();
        DataPoint dataPoint = new DataPoint(n4, string, string2, string3, n, n2, n3, bl, string4, string5, site, meter, string6, d, string7, true);
        dataPoint.status.setInserted(true);
        return (DataPoint)easSession.get(dataPoint);
    }

    public static DataPoint create(String string, String string2, String string3, int n, int n2, int n3, boolean bl, String string4, String string5, String string6, Site site, Meter meter) throws EasException {
        return DataPoint.create(string, string2, string3, n, n2, n3, bl, string4, string5, site, meter, "square foot", 0.0, string6);
    }

    public int compareTo(Object object) {
        DataPoint dataPoint = (DataPoint)object;
        if (this.id > dataPoint.id) {
            return 1;
        }
        if (this.id < dataPoint.id) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DataPoint) {
            return this.id == ((DataPoint)object).id;
        }
        return super.equals(object);
    }

    public static DataPoint get(long l, EasSession easSession) {
        return DataPoint.get((int)l, easSession);
    }

    public static DataPoint get(int n, EasSession easSession) {
        return DataPoint.get(n, easSession, true);
    }

    public static DataPoint get(long l, EasSession easSession, boolean bl) {
        return DataPoint.get((int)l, easSession, bl);
    }

    public static DataPoint get(int n, EasSession easSession, boolean bl) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        DataPoint dataPoint = new DataPoint(n, easSession);
        return (DataPoint)easSession.get(dataPoint);
    }

    public static DataPoint[] get(int[] nArray, EasSession easSession) {
        int n;
        int n2 = nArray == null ? 0 : nArray.length;
        String string = null;
        DataPoint[] dataPointArray = new DataPoint[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n = nArray[i];
            if (n == -1) continue;
            DataPoint dataPoint = new DataPoint(n, easSession);
            DataPoint dataPoint2 = (DataPoint)easSession.cached(dataPoint);
            if (dataPoint2 == null) {
                string = string == null ? "" : string + ",";
                string = string + dataPoint;
                continue;
            }
            dataPointArray[n3++] = dataPoint2;
        }
        if (string != null) {
            Vector vector = easSession.getDataPointExec().getDataPoints(string);
            n = 0;
            while (vector != null && n < vector.size()) {
                dataPointArray[n3++] = (DataPoint)vector.elementAt(n++);
            }
        }
        return dataPointArray;
    }

    public static DataPoint get(int n, String string, String string2, String string3, int n2, int n3, int n4, boolean bl, String string4, String string5, Site site, int n5, String string6, double d, String string7, boolean bl2) {
        EasSession easSession = site.getSession();
        if (easSession == null) {
            easSession = Manager.get();
        }
        DataPoint dataPoint = new DataPoint(n, string, string2, string3, n2, n3, n4, bl, string4, string5, site, n5, string6, d, string7, bl2);
        DataPoint dataPoint2 = (DataPoint)easSession.get(dataPoint);
        if (bl2 && dataPoint2 != dataPoint) {
            dataPoint2.name = string;
            dataPoint2.stationName = string2;
            dataPoint2.descr = string3;
            dataPoint2.flags = n2;
            dataPoint2.rcType = n3;
            dataPoint2.rcSubType = n4;
            dataPoint2.isMain = bl;
            dataPoint2.vtype = string4;
            dataPoint2.vunit = string5;
            dataPoint2.site = site;
            dataPoint2.setMeterField(n5);
            dataPoint2.floorarea_vunit = string6;
            dataPoint2.floorarea_value = d;
            dataPoint2.floorarea_unit = null;
            dataPoint2.status.setOutofdate(false);
        }
        return dataPoint2;
    }

    public static DataPoint get(int n, String string, String string2, String string3, int n2, int n3, int n4, boolean bl, String string4, String string5, Site site, Meter meter, String string6, double d, String string7, boolean bl2) {
        EasSession easSession = site.getSession();
        if (easSession == null) {
            easSession = Manager.get();
        }
        DataPoint dataPoint = new DataPoint(n, string, string2, string3, n2, n3, n4, bl, string4, string5, site, meter, string6, d, string7, bl2);
        DataPoint dataPoint2 = (DataPoint)easSession.get(dataPoint);
        if (bl2 && dataPoint2 != dataPoint) {
            dataPoint2.name = string;
            dataPoint2.stationName = string2;
            dataPoint2.descr = string3;
            dataPoint2.flags = n2;
            dataPoint2.rcType = n3;
            dataPoint2.rcSubType = n4;
            dataPoint2.isMain = bl;
            dataPoint2.vtype = string4;
            dataPoint2.vunit = string5;
            dataPoint2.site = site;
            dataPoint2.setMeterField(meter);
            dataPoint2.floorarea_vunit = string6;
            dataPoint2.floorarea_value = d;
            dataPoint2.floorarea_unit = null;
            dataPoint2.status.setOutofdate(false);
        }
        return dataPoint2;
    }

    public DataPoint getTemperatureDP() throws EasException {
        int n;
        DataPoint[] dataPointArray = this.getSite().getLinkedDataPoints();
        for (n = 0; dataPointArray != null && n < dataPointArray.length; ++n) {
            if (dataPointArray[n].getRcType() != RcType.OUTSIDE_AIR_TEMP.getCode() || !dataPointArray[n].isMain()) continue;
            return dataPointArray[n];
        }
        dataPointArray = this.getSite().getOwnedDataPoints();
        for (n = 0; dataPointArray != null && n < dataPointArray.length; ++n) {
            if (dataPointArray[n].getRcType() != RcType.OUTSIDE_AIR_TEMP.getCode() || !dataPointArray[n].isMain()) continue;
            return dataPointArray[n];
        }
        return null;
    }

    public static final int getAvailableLicensedDataPointCount(EasSession easSession) {
        if (easSession == null) {
            easSession = Manager.get();
        }
        return easSession.getDataPointExec().getAvailableLicensedDataPointCount();
    }

    public void load() throws EasException {
        this.load(false);
    }

    public void load(boolean bl) throws EasException {
        if (this.isTemporary()) {
            return;
        }
        if (bl || this.status.isOutofdate()) {
            if (!bl && this.status.isModified()) {
                throw new EasException("merge not supported");
            }
            DataPoint dataPoint = this.session.getDataPointExec().load(this.id);
            if (dataPoint == null) {
                throw new EasException("object doesn't exist in the database");
            }
            if (dataPoint != this) {
                this.name = dataPoint.name;
                this.stationName = dataPoint.stationName;
                this.descr = dataPoint.descr;
                this.flags = dataPoint.flags;
                this.rcType = dataPoint.rcType;
                this.rcSubType = dataPoint.rcSubType;
                this.isMain = dataPoint.isMain;
                this.vtype = dataPoint.vtype;
                this.vunit = dataPoint.vunit;
                this.site = dataPoint.site;
                this.meter_id = dataPoint.meter_id;
                this.meter_ref = dataPoint.meter_ref;
                this.floorarea_vunit = dataPoint.floorarea_vunit;
                this.floorarea_value = dataPoint.floorarea_value;
                this.floorarea_unit = null;
                this.timeZone = dataPoint.timeZone;
                this.tz = null;
            }
            this.status.setOutofdate(false);
        }
    }

    public Group[] getLinkedGroups() throws EasException {
        this.loadGroups(false);
        Group[] groupArray = new Group[this.groupsCount];
        int n = 0;
        Enumeration enumeration = this.groups.elements();
        while (enumeration.hasMoreElements()) {
            Gr gr = (Gr)enumeration.nextElement();
            if (gr.isRemoved()) continue;
            groupArray[n++] = gr.id;
        }
        return groupArray;
    }

    public void loadGroups(boolean bl) {
        if (!bl && this.groupsLoaded) {
            return;
        }
        Vector vector = this.session.getGroupExec().getDataPointGroups(this.id, this.session.getUserName());
        this.groupsCount = vector.size();
        this.groups.clear();
        for (int i = 0; i < this.groupsCount; ++i) {
            Group group = (Group)vector.elementAt(i);
            this.groups.put(group, new Gr(group));
        }
        this.groupsLoaded = true;
    }

    public void linkGroup(Group group) throws EasException {
        this.loadGroups(false);
        Gr gr = (Gr)this.groups.get(group);
        boolean bl = false;
        if (gr == null) {
            gr = new Gr(group);
            gr.setInserted(true);
            this.groups.put(gr.id, gr);
            ++this.groupsCount;
            bl = true;
        } else if (gr.isRemoved()) {
            gr.setRemoved(false);
            ++this.groupsCount;
            bl = true;
        }
        if (bl) {
            group.linkDataPoint(this);
        }
    }

    public void unlinkGroup(Group group) {
        this.loadGroups(false);
        Gr gr = (Gr)this.groups.get(group);
        boolean bl = false;
        if (gr != null && !gr.isRemoved()) {
            gr.setRemoved(true);
            --this.groupsCount;
            bl = true;
        }
        if (bl) {
            group.unlinkDataPoint(this);
        }
    }

    public void erase() throws EasException {
        this.loadGroups(false);
        boolean bl = false;
        Enumeration enumeration = this.groups.elements();
        while (this.groupsCount > 0 && enumeration.hasMoreElements()) {
            Gr gr = (Gr)enumeration.nextElement();
            if (!gr.isRemoved()) {
                gr.setRemoved(true);
                --this.groupsCount;
            }
            gr.id.unlinkDataPoint(this);
        }
        if (this.site != null) {
            this.site.remOwnedDataPoint(this);
        }
        if (this.getMeter() != null) {
            this.getMeter().remDataPoint(this);
        }
        this.status.setRemoved(true);
    }

    public void save() throws EasException {
        this.save(-1, true);
    }

    public void save(int n, boolean bl) throws EasException {
        if ((n & 4) != 0 || (n & 1) != 0) {
            if (this.status.isRemoved()) {
                this.session.getDataPointExec().erase(this.id, this.getName());
                this.session.remove(this);
                this.status.setCurrent();
            } else if (this.status.isInserted()) {
                if (this.site != null) {
                    this.site.save(1, true);
                }
                if (this.getMeter() != null) {
                    this.getMeter().save(8, true);
                }
                this.id = this.session.getDataPointExec().create(this.name, this.stationName, this.descr, this.flags, this.rcType, this.rcSubType, this.isMain, this.vtype, this.vunit, this.getSiteId(), this.getMeterId(), this.floorarea_vunit, this.floorarea_value, this.timeZone);
                if (this.id == -1) {
                    throw new EasException("Can't create new data point in the database");
                }
                this.status.setCurrent();
                this.session.get(this);
            } else if (this.status.isModified()) {
                if (this.site != null) {
                    this.site.save(1, true);
                }
                if (this.getMeter() != null) {
                    this.getMeter().save(8, true);
                }
                Manager.get().getDataPointExec().update(this.getId(), this.name, this.stationName, this.descr, this.flags, this.rcType, this.rcSubType, this.isMain, this.vtype, this.vunit, this.getSiteId(), this.getMeterId(), this.floorarea_vunit, this.floorarea_value, this.timeZone);
                this.status.setCurrent();
            }
        }
        if ((n & 1) != 0) {
            Enumeration enumeration = this.groups.elements();
            while (enumeration.hasMoreElements()) {
                Gr gr = (Gr)enumeration.nextElement();
                if (gr.isRemoved()) {
                    if (bl) {
                        this.session.getDataPointExec().remGroupLink(this.id, gr.id.getId());
                        gr.id.save(4, false);
                    }
                    this.groups.remove(gr.id);
                    continue;
                }
                if (!gr.isInserted()) continue;
                if (bl) {
                    gr.id.save(1, true);
                    this.session.getDataPointExec().addGroupLink(this.id, gr.id.getId());
                    gr.id.save(4, false);
                }
                gr.setCurrent();
            }
        }
    }

    public double getTotal(EasLocalTime easLocalTime, EasLocalTime easLocalTime2) throws EasException {
        return Manager.get().getDataPointExec().getTotal(this.getName(), easLocalTime, easLocalTime2, this.getTimeZone());
    }

    public TSDataIrregular getRawData(EasLocalTime easLocalTime, EasLocalTime easLocalTime2) throws EasException {
        BUnit bUnit = null;
        BTimeZone bTimeZone = null;
        bUnit = this.getUnit();
        bTimeZone = this.getTimeZone();
        DataSample[] dataSampleArray = Manager.get().getDataPointExec().getRawData(this.getName(), easLocalTime, easLocalTime2, bTimeZone, bUnit);
        int n = dataSampleArray.length;
        if (dataSampleArray != null && dataSampleArray.length > 0) {
            int n2 = 0;
            if (dataSampleArray[0] == null) {
                n2 = 1;
                --n;
            }
            if (dataSampleArray[n - 1] == null) {
                --n;
            }
            if (n != dataSampleArray.length) {
                DataSample[] dataSampleArray2 = new DataSample[n];
                int n3 = 0;
                while (n2 < n) {
                    dataSampleArray2[n3++] = dataSampleArray[n2++];
                }
                dataSampleArray = dataSampleArray2;
            }
        }
        TSDataIrregular tSDataIrregular = new TSDataIrregular(dataSampleArray, bTimeZone);
        try {
            tSDataIrregular.setValueUnit(this.getUnit());
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return tSDataIrregular;
    }

    public TSDataFloat getData(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n, boolean bl, int n2, double d, boolean bl2, DataPoint dataPoint) throws EasException {
        TSDataFloat tSDataFloat = null;
        if (this.unitDatabase == null) {
            this.unitDatabase = UnitDatabase.getDefault();
        }
        String string = null;
        string = this.unitDatabase.getQuantity(this.getUnit()) != null ? this.unitDatabase.getQuantity(this.getUnit()).getName() : "";
        tSDataFloat = string.equals("misc") || string.equals("temperature") ? Manager.get().getDataPointExec().getData(this.getName(), easLocalTime, easLocalTime2, BTimeZone.getTimeZone((String)this.getTimeZoneString()), RestorationMethod.AVG, this.getUnit(), this.getSamplingInterval(), bl, n2, d, bl2, dataPoint) : Manager.get().getDataPointExec().getData(this.getName(), easLocalTime, easLocalTime2, BTimeZone.getTimeZone((String)this.getTimeZoneString()), RestorationMethod.getByRcSubType(this.getRcSubTypeObj()), this.getUnit(), this.getSamplingInterval(), bl, n2, d, bl2, dataPoint);
        return tSDataFloat;
    }

    public TSDataSummary getDataSummary(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BUnit bUnit, int n, int n2, TimeInterval timeInterval, boolean bl, int n3, double d, boolean bl2, DataPoint dataPoint) throws EasException {
        return this.getDataSummary(easLocalTime, easLocalTime2, bUnit, n, n2, timeInterval, false, false, null, 0.0, bl, n3, d, bl2, dataPoint);
    }

    public TSDataSummary getDataSummary(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, BUnit bUnit, int n, int n2, TimeInterval timeInterval, boolean bl, boolean bl2, BUnit bUnit2, double d, boolean bl3, int n3, double d2, boolean bl4, DataPoint dataPoint) throws EasException {
        Object object;
        double d3 = bl ? this.getFloorAreaValue() : 1.0;
        BUnit bUnit3 = this.getFloorAreaUnit();
        String string = null;
        BUnit bUnit4 = null;
        if (bl2) {
            object = this.getTemperatureDP();
            if (object == null) {
                throw new EasException("No temperature DP for weather normalization");
            }
            string = ((DataPoint)object).getName();
            bUnit4 = ((DataPoint)object).getUnit();
            d = bUnit4.fromNormal(bUnit2.toNormal(d));
        }
        if (Manager.get() != null) {
            object = Manager.get().getDataPointExec().getDataSummary(this.getName(), easLocalTime, easLocalTime2, this.getTimeZone(), RestorationMethod.getByRcSubType(this.getRcSubTypeObj()), n, n2, this.getUnit(), bUnit, timeInterval, 0, d3, bUnit3, string, bUnit4, d, this.getSamplingInterval(), bl3, n3, d2, bl4, dataPoint);
            return object;
        }
        object = this.getSession().getDataPointExec().getDataSummary(this.getName(), easLocalTime, easLocalTime2, this.getTimeZone(), RestorationMethod.getByRcSubType(this.getRcSubTypeObj()), n, n2, this.getUnit(), bUnit, timeInterval, 0, d3, bUnit3, string, bUnit4, d, this.getSamplingInterval(), bl3, n3, d2, bl4, dataPoint);
        return object;
    }

    public static SiteSummary[] getRankedSummaries(Site[] siteArray, int n, int n2, boolean bl, int n3, String string, int[] nArray, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n4, int n5, boolean bl2, double d, BUnit bUnit, EasSession easSession, boolean bl3, int n6, double d2, boolean[] blArray, DataPoint[] dataPointArray) throws EasException {
        String string2 = "";
        if (siteArray != null) {
            for (int i = 0; i < siteArray.length; ++i) {
                if (siteArray[i] == null || siteArray[i].getId() == -1) continue;
                if (string2.length() != 0) {
                    string2 = string2 + ",";
                }
                string2 = string2 + siteArray[i].getId();
            }
        }
        return easSession.getDataPointExec().getRankedSummaries(string2, n, n2, bl, n3, string, nArray, easLocalTime, easLocalTime2, n4, n5, bl2, d, bUnit, TimeInterval.INTERVAL_15_MINUTES, bl3, n6, d2, blArray, dataPointArray);
    }

    public String getName() {
        try {
            this.load();
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return this.name;
    }

    public String getStationName() {
        try {
            this.load();
        }
        catch (EasException easException) {
            easException.printStackTrace();
        }
        return this.stationName;
    }

    public String getDescr() throws EasException {
        this.load();
        return this.descr;
    }

    public int getFlags() throws EasException {
        this.load();
        return this.flags;
    }

    public String getTimeZoneString() throws EasException {
        this.load();
        return this.timeZone;
    }

    public BTimeZone getTimeZone() throws EasException {
        this.load();
        if (this.tz != null) {
            return this.tz;
        }
        this.tz = BTimeZone.getTimeZone((String)this.getTimeZoneString());
        return this.tz;
    }

    public int getRcType() throws EasException {
        this.load();
        return this.rcType;
    }

    public int getRcSubType() throws EasException {
        this.load();
        return this.rcSubType;
    }

    public RcType getRcTypeObj() throws EasException {
        return RcType.getByCode(this.getRcType());
    }

    public RcSubtype getRcSubTypeObj() throws EasException {
        return RcSubtype.getByCode(this.getRcSubType());
    }

    public boolean isMain() throws EasException {
        this.load();
        return this.isMain;
    }

    public void setMain(boolean bl) throws EasException {
        this.load();
        if (this.isMain == bl) {
            return;
        }
        this.isMain = bl;
        this.status.setModified(true);
    }

    public String getVType() throws EasException {
        this.load();
        return this.vtype;
    }

    public String getVUnit() throws EasException {
        this.load();
        return this.vunit;
    }

    public BUnit getUnit() throws EasException {
        this.load();
        if (this.unit != null) {
            return this.unit;
        }
        if (this.getSession().getDataPointExec().isMultistate(this.getName())) {
            this.unit = BEasService.MULTISTATE;
            return this.unit;
        }
        String string = this.getVUnit();
        if (string == null) {
            string = "null";
        }
        this.unit = BUnit.getUnit((String)string);
        return this.unit;
    }

    public String getFloorAreaVUnit() throws EasException {
        this.load();
        return this.floorarea_vunit;
    }

    public double getFloorAreaValue() throws EasException {
        this.load();
        return this.floorarea_value;
    }

    public BUnit getFloorAreaUnit() throws EasException {
        this.load();
        if (this.floorarea_unit != null) {
            return this.floorarea_unit;
        }
        String string = this.getFloorAreaVUnit();
        if (string == null) {
            string = "null";
        }
        this.floorarea_unit = BUnit.getUnit((String)string);
        return this.floorarea_unit;
    }

    public Site getSite() throws EasException {
        this.load();
        return this.site;
    }

    public int getSiteId() throws EasException {
        this.load();
        return this.site == null ? -1 : this.site.getId();
    }

    public Meter getMeter() throws EasException {
        this.load();
        if (this.meter_ref != null) {
            return this.meter_ref;
        }
        if (this.meter_id != -1) {
            this.meter_ref = Meter.get(this.meter_id, this.session);
        }
        return this.meter_ref;
    }

    public int getMeterId() throws EasException {
        this.load();
        if (this.meter_ref != null) {
            return this.meter_ref.getId();
        }
        return this.meter_id;
    }

    public int getInterval() throws EasException {
        this.load();
        return this.interval;
    }

    public int getIntervalUnit() throws EasException {
        this.load();
        return this.int_unit;
    }

    public void setName(String string) throws EasException {
        this.load();
        if (this.name.equals(string)) {
            return;
        }
        this.name = string;
        this.status.setModified(true);
    }

    public void setStationName(String string) throws EasException {
        this.load();
        if (this.stationName.equals(string)) {
            return;
        }
        this.stationName = string;
        this.status.setModified(true);
    }

    public void setDescr(String string) throws EasException {
        this.load();
        if (this.descr.equals(string)) {
            return;
        }
        this.descr = string;
        this.status.setModified(true);
    }

    public void setFlags(int n) throws EasException {
        this.load();
        if (this.flags == n) {
            return;
        }
        this.flags = n;
        this.status.setModified(true);
    }

    public void setTimeZoneString(String string) throws EasException {
        this.load();
        if (string == null && this.timeZone == null) {
            return;
        }
        if (string != null && this.timeZone != null && this.timeZone.equals(string)) {
            return;
        }
        this.timeZone = string;
        this.tz = null;
        this.status.setModified(true);
    }

    public void setVType(String string) throws EasException {
        this.load();
        if (this.vtype.equals(string)) {
            return;
        }
        this.unit = null;
        this.vtype = string;
        this.status.setModified(true);
    }

    public void setRcType(RcType rcType) throws EasException {
        this.setRcType(rcType.getCode());
    }

    public void setRcType(int n) throws EasException {
        this.load();
        if (this.rcType == n) {
            return;
        }
        this.rcType = n;
        this.status.setModified(true);
    }

    public void setRcSubType(RcSubtype rcSubtype) throws EasException {
        this.setRcSubType(rcSubtype.getCode());
    }

    public void setRcSubType(int n) throws EasException {
        this.load();
        if (this.rcSubType == n) {
            return;
        }
        this.rcSubType = n;
        this.status.setModified(true);
    }

    public void setUnit(BUnit bUnit) throws EasException {
        if (bUnit == null) {
            this.setVType("misc");
            this.setVUnit("null");
        } else {
            if (this.unitDatabase == null) {
                this.unitDatabase = UnitDatabase.getDefault();
            }
            String string = null;
            string = this.unitDatabase.getQuantity(bUnit) != null ? this.unitDatabase.getQuantity(bUnit).getName() : "";
            this.setVType(string);
            this.setVUnit(bUnit.getUnitName());
        }
        this.unit = bUnit;
    }

    public void setVUnit(String string) throws EasException {
        this.load();
        if (this.vunit.equals(string)) {
            return;
        }
        this.unit = null;
        this.vunit = string == null ? "null" : string;
        this.status.setModified(true);
    }

    public void setFloorAreaUnit(BUnit bUnit) throws EasException {
        if (bUnit == null) {
            this.setFloorAreaVUnit("null");
        } else {
            this.setFloorAreaVUnit(bUnit.getUnitName());
        }
        this.floorarea_unit = bUnit;
    }

    public void setFloorAreaVUnit(String string) throws EasException {
        this.load();
        if (this.floorarea_vunit.equals(string)) {
            return;
        }
        this.floorarea_unit = null;
        this.floorarea_vunit = string == null ? "null" : string;
        this.status.setModified(true);
    }

    public void setFloorAreaValue(double d) throws EasException {
        this.load();
        if (this.floorarea_value == d) {
            return;
        }
        this.floorarea_value = d;
        this.status.setModified(true);
    }

    public void setSite(Site site) throws EasException {
        this.load();
        if (this.site == site) {
            return;
        }
        if (site == null) {
            this.site.remOwnedDataPoint(this);
        } else {
            site.addOwnedDataPoint(this);
        }
        this.site = site;
        this.status.setModified(true);
    }

    public void setMeter(Meter meter) throws EasException {
        this.load();
        Meter meter2 = this.getMeter();
        if (meter2 == meter) {
            return;
        }
        if (meter == null) {
            meter2.remDataPoint(this);
        } else {
            meter.addDataPoint(this);
        }
        this.setMeterField(meter);
        this.status.setModified(true);
    }

    public void setInterval(int n) throws EasException {
        this.load();
        if (this.interval == n) {
            return;
        }
        this.interval = n;
        this.status.setModified(true);
    }

    public void getIntervalUnit(int n) throws EasException {
        this.load();
        if (this.int_unit == n) {
            return;
        }
        this.int_unit = n;
        this.status.setModified(true);
    }

    private void setMeterField(Meter meter) {
        if (meter != null) {
            if (this.meter_id != meter.getId()) {
                this.meter_ref = meter;
                this.meter_id = meter.getId();
            }
        } else {
            this.meter_ref = null;
            this.meter_id = -1;
        }
    }

    private void setMeterField(int n) {
        if (this.meter_id != n) {
            this.meter_ref = null;
            this.meter_id = n;
        }
    }

    public String toString() {
        try {
            return this.getDescr();
        }
        catch (EasException easException) {
            easException.printStackTrace();
            return super.toString();
        }
    }

    public TimeInterval getSamplingInterval() {
        return this.samplingInterval;
    }

    private class Gr
    extends PStatus {
        public Group id;

        public Gr(Group group) {
            this.id = group;
        }
    }
}

