/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.ReportPeriod;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class BaselineReportPeriod
extends ReportPeriod {
    public static final int SAME_START_END = 1;
    public static final int WEEK_PRIOR = 2;
    public static final int MONTH_PRIOR = 3;
    public static final int YEAR_PRIOR = 4;
    public static final int LAST_PERIOD_ID = 4;
    private ReportPeriod reference = null;

    public BaselineReportPeriod(Lexicon lexicon) {
        super(lexicon);
    }

    public BaselineReportPeriod(int n, int n2, Lexicon lexicon) {
        super(n, n2, lexicon);
    }

    public BaselineReportPeriod(EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n, Lexicon lexicon) {
        super(easLocalTime, easLocalTime2, n, lexicon);
    }

    public BaselineReportPeriod(int n, EasLocalTime easLocalTime, EasLocalTime easLocalTime2, int n2, Lexicon lexicon) {
        super(n, easLocalTime, easLocalTime2, n2, lexicon);
    }

    public void setReferencePeriod(ReportPeriod reportPeriod) {
        this.reference = reportPeriod;
    }

    public ReportPeriod getReferencePeriod() {
        return this.reference;
    }

    public static String getCustomPeriodName(int n, Lexicon lexicon) {
        switch (n) {
            case 0: {
                return lexicon.getText("customPeriod");
            }
            case 1: {
                return lexicon.getText("samePeriod");
            }
            case 2: {
                return lexicon.getText("1WeekPrior");
            }
            case 3: {
                return lexicon.getText("1MonthPrior");
            }
            case 4: {
                return lexicon.getText("1YearPrior");
            }
        }
        return lexicon.getText("error");
    }

    public void applyCustomPeriod(long l) {
        if (this.getCustomPeriod() == 0 || this.reference == null) {
            return;
        }
        BTimeZone bTimeZone = BTimeZone.getLocal();
        long l2 = this.reference.getStartTimeMillis(bTimeZone);
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(new Date(l2));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (this.getCustomPeriod()) {
            case 1: {
                this.setStartTime(this.reference.getStartTime());
                this.setEndTime(this.reference.getEndTime());
                break;
            }
            case 2: {
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar));
                calendar.add(5, -6);
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 3: {
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar));
                calendar.add(5, 1);
                calendar.add(2, -1);
                this.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 4: {
                calendar.add(5, -1);
                this.setEndTime(new EasLocalTime(calendar));
                calendar.add(5, 1);
                calendar.add(1, -1);
                this.setStartTime(new EasLocalTime(calendar));
            }
        }
    }

    public int getDaysOfWeek() {
        if (this.reference != null) {
            return this.reference.getDaysOfWeek();
        }
        return super.getDaysOfWeek();
    }
}

