/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas.api;

import com.tridium.eas.api.EasException;
import com.tridium.eas.api.EasLocalTime;
import com.tridium.eas.api.Period;
import com.tridium.eas.api.ReportPeriod;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.baja.sys.BAbsTime;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;

public class BaselinePeriod
extends Period {
    public static final int FIXED_RANGE = 0;
    public static final int SAME_START = 1;
    public static final int WEEK_PRIOR = 2;
    public static final int MONTH_PRIOR = 3;
    public static final int YEAR_PRIOR = 4;
    public static final int LAST_PERIOD_ID = 4;
    private int customPeriod;
    private Period reportPeriod;
    private int durationDays;

    public BaselinePeriod(Lexicon lexicon) {
        this.lex = lexicon;
    }

    public BaselinePeriod(Period period, Lexicon lexicon) {
        this(period, period.getStartTime(), 0, lexicon);
    }

    public BaselinePeriod(Period period, EasLocalTime easLocalTime, int n, Lexicon lexicon) {
        this(1, period, easLocalTime, n, lexicon);
    }

    public BaselinePeriod(int n, Period period, EasLocalTime easLocalTime, int n2, Lexicon lexicon) {
        this.setStartTime(easLocalTime);
        this.customPeriod = n;
        this.reportPeriod = period;
        this.durationDays = n2;
        this.lex = lexicon;
        this.applyCustomPeriod();
    }

    public boolean isCustomPeriod() {
        return this.customPeriod != 0;
    }

    public int getCustomPeriod() {
        return this.customPeriod;
    }

    public static String getCustomPeriodName(int n, Lexicon lexicon) {
        switch (n) {
            case 0: {
                return lexicon.getText("customPeriod");
            }
            case 1: {
                return lexicon.getText("sameStartDate");
            }
            case 2: {
                return lexicon.getText("1WeekPrior");
            }
            case 3: {
                return lexicon.getText("1MonthPrior");
            }
            case 4: {
                return lexicon.getText("1YearPrior");
            }
        }
        return lexicon.getText("error");
    }

    public void setCustomPeriod(int n) {
        this.customPeriod = n;
        this.applyCustomPeriod();
    }

    public void setReportPeriod(Period period) {
        this.reportPeriod = period;
        this.applyCustomPeriod();
    }

    public Period getReportPeriod() {
        return this.reportPeriod;
    }

    public void setStartDay(EasLocalTime easLocalTime) {
        this.customPeriod = 0;
        super.setStartTime(easLocalTime);
        this.applyDurationDays();
    }

    public void setDurationDays(int n) {
        this.durationDays = n;
        this.applyDurationDays();
    }

    public int getDurationDays() {
        return this.durationDays;
    }

    public int getDurationMinutes() {
        return this.getDurationDays() * 24 * 60;
    }

    public void applyCustomPeriod() {
        BTimeZone bTimeZone = BTimeZone.getLocal();
        long l = this.reportPeriod.getStartTimeMillis(bTimeZone);
        if (this.customPeriod != 0 && this.customPeriod != 1) {
            long l2 = this.reportPeriod.getEndTimeMillis(bTimeZone);
            int n = 1;
            if (!BAbsTime.make((long)l, (BTimeZone)bTimeZone).inDaylightTime() && BAbsTime.make((long)l2, (BTimeZone)bTimeZone).inDaylightTime()) {
                n += 3600000;
            }
            this.setDurationDays((int)((l2 + (long)n - l) / 86400000L));
        }
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(new Date(l));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        switch (this.customPeriod) {
            case 1: {
                super.setStartTime(this.reportPeriod.getStartTime());
                break;
            }
            case 2: {
                calendar.add(5, -7);
                super.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 3: {
                calendar.add(2, -1);
                super.setStartTime(new EasLocalTime(calendar));
                break;
            }
            case 4: {
                calendar.add(1, -1);
                super.setStartTime(new EasLocalTime(calendar));
            }
        }
        this.applyDurationDays();
    }

    public void applyDurationDays() {
        Calendar calendar = Calendar.getInstance((TimeZone)BTimeZone.getLocal().tzSupport());
        calendar.setTime(new Date(this.getStartTimeMillis(BTimeZone.getLocal())));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, this.durationDays);
        super.setEndTime(new EasLocalTime(calendar, calendar.getMaximum(11), calendar.getMaximum(12), calendar.getMaximum(13), calendar.getMaximum(14)));
    }

    public void save(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.customPeriod);
        super.save(dataOutput);
        dataOutput.writeInt(this.durationDays);
        this.reportPeriod.save(dataOutput);
    }

    public void load(DataInput dataInput) throws IOException, EasException {
        this.customPeriod = dataInput.readInt();
        super.load(dataInput);
        this.durationDays = dataInput.readInt();
        this.reportPeriod = new ReportPeriod(this.lex);
        this.reportPeriod.load(dataInput);
        this.applyCustomPeriod();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.customPeriod != 0) {
            stringBuffer.append(BaselinePeriod.getCustomPeriodName(this.customPeriod, this.lex));
            stringBuffer.append(": ");
        }
        stringBuffer.append(super.toString());
        stringBuffer.append(this.lex.getText("reportPeriod") + ": ");
        stringBuffer.append(this.reportPeriod.toString());
        return stringBuffer.toString();
    }
}

