/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas;

import com.tridium.eas.BEasService;
import com.tridium.eas.EasDatabase;
import com.tridium.eas.Upload;
import com.tridium.eas.api.DataPointExec;
import com.tridium.eas.api.DynGroupExec;
import com.tridium.eas.api.EasSession;
import com.tridium.eas.api.GroupExec;
import com.tridium.eas.api.MeterExec;
import com.tridium.eas.db.DataPointDxDispatch;
import com.tridium.eas.db.DataPointExecSrv;
import com.tridium.eas.db.DynGroupDxDispatch;
import com.tridium.eas.db.DynGroupExecSrv;
import com.tridium.eas.db.GroupDxDispatch;
import com.tridium.eas.db.GroupExecSrv;
import com.tridium.eas.db.MeterDxDispatch;
import com.tridium.eas.db.MeterExecSrv;
import com.tridium.eas.xml.XmlMessage;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.collection.BICollection;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.naming.BOrd;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BObject;
import javax.baja.sys.Cursor;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;

public class EasServerDxSession
extends EasSession {
    private GroupDxDispatch groupDxDispatch = null;
    private DynGroupDxDispatch dynGroupDxDispatch = null;
    private DataPointDxDispatch dataPointDxDispatch = null;
    private MeterDxDispatch meterDxDispatch = null;
    private GroupExecSrv groupExecSrv = null;
    private DynGroupExecSrv dynGroupExecSrv = null;
    private DataPointExecSrv dataPointExecSrv = null;
    private MeterExecSrv meterExecSrv = null;
    private EasDatabase db;
    private BEasService eas;

    public EasServerDxSession(BEasService bEasService, EasDatabase easDatabase) {
        this.db = easDatabase;
        this.eas = bEasService;
        this.groupDxDispatch = new GroupDxDispatch(this);
        this.dynGroupDxDispatch = new DynGroupDxDispatch(this);
        this.dataPointDxDispatch = new DataPointDxDispatch(bEasService, this);
        this.meterDxDispatch = new MeterDxDispatch(this);
        this.groupExecSrv = new GroupExecSrv(this, easDatabase);
        this.dynGroupExecSrv = new DynGroupExecSrv(this, easDatabase);
        this.dataPointExecSrv = new DataPointExecSrv(this, easDatabase);
        this.meterExecSrv = new MeterExecSrv(this, easDatabase);
    }

    public int open() {
        boolean bl;
        Connection connection = this.db.getConnection();
        boolean bl2 = bl = connection != null;
        if (bl) {
            this.db.freeConnection(connection);
        }
        if (bl) {
            return 0;
        }
        return 3;
    }

    public void close() {
    }

    public XmlMessage handleAction(String string, XmlMessage xmlMessage) {
        String string2 = xmlMessage.getString("classname", null);
        if (string2 != null) {
            String string3 = xmlMessage.getString("serverDebug", null);
            if (string3 != null) {
                System.out.println("handleAction " + string2 + " command=" + xmlMessage.getString("command", null) + " debug=" + string3);
            }
            if (string2.equalsIgnoreCase("Group")) {
                return this.groupDxDispatch.process(xmlMessage, string);
            }
            if (string2.equalsIgnoreCase("DynGroup")) {
                return this.dynGroupDxDispatch.process(xmlMessage);
            }
            if (string2.equalsIgnoreCase("DataPoint")) {
                return this.dataPointDxDispatch.process(xmlMessage);
            }
            if (string2.equalsIgnoreCase("Meter")) {
                return this.meterDxDispatch.process(xmlMessage);
            }
        } else {
            String string4 = xmlMessage.getString("command", null);
            if (string4 == null) {
                return null;
            }
            if (string4.equalsIgnoreCase("getUnassignedLogs")) {
                return this.getUnassignedLogs(string, xmlMessage);
            }
            if (string4.equalsIgnoreCase("storeFile")) {
                return this.storeFile(string, xmlMessage);
            }
        }
        return null;
    }

    public XmlMessage getUnassignedLogs(String string, XmlMessage xmlMessage) {
        BUser bUser = BEasService.getUser(string);
        XmlMessage xmlMessage2 = new XmlMessage("getUnassignedLogs");
        try {
            int n;
            Object object;
            Object object2;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            BOrd bOrd = BOrd.make((String)"history:|bql:select * from sys.histories where recordType='history:BooleanTrendRecord' or recordType='history:NumericTrendRecord'");
            BICollection bICollection = (BICollection)bOrd.resolve((BObject)this.eas).get();
            Cursor cursor = bICollection.cursor();
            while (cursor.next()) {
                object2 = (BHistoryConfig)cursor.get();
                BHistoryId bHistoryId = object2.getId();
                object = bHistoryId.encodeToString();
                hashtable.put((String)object, (String)object);
            }
            object2 = this.getDataPointExec().getAllDataPointNames();
            for (n = 0; n < ((Vector)object2).size(); ++n) {
                hashtable.remove(((Vector)object2).elementAt(n));
            }
            n = 0;
            object = hashtable.keys();
            while (object.hasMoreElements()) {
                String string2 = object.nextElement().toString();
                xmlMessage2.add("i" + n, string2);
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xmlMessage2;
    }

    public XmlMessage storeFile(String string, XmlMessage xmlMessage) {
        XmlMessage xmlMessage2 = new XmlMessage("storeFile");
        try {
            byte[] byArray = xmlMessage.getBlob("data", new byte[0]);
            Upload upload = new Upload(xmlMessage.getString("mimeType"), xmlMessage.getString("extension"), string, byArray);
            upload.save(this.eas.getUploadDirectory());
            xmlMessage2.add("fileName", upload.getFileName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return xmlMessage2;
    }

    public GroupExec getGroupExec() {
        return this.groupExecSrv;
    }

    public DynGroupExec getDynGroupExec() {
        return this.dynGroupExecSrv;
    }

    public DataPointExec getDataPointExec() {
        return this.dataPointExecSrv;
    }

    public MeterExec getMeterExec() {
        return this.meterExecSrv;
    }

    public BUser getUser() {
        return BUserService.getService().getAdmin();
    }

    public String getUserName() {
        return this.getUser().getUsername();
    }

    public boolean hasAdminRead() {
        BPermissions bPermissions = this.getUser().getPermissionsFor((BIProtected)this.eas);
        return bPermissions.hasAdminWrite() || bPermissions.hasAdminRead();
    }

    public boolean hasAdminWrite() {
        BPermissions bPermissions = this.getUser().getPermissionsFor((BIProtected)this.eas);
        return bPermissions.hasAdminWrite();
    }

    public boolean hasOperatorRead() {
        BPermissions bPermissions = this.getUser().getPermissionsFor((BIProtected)this.eas);
        return bPermissions.hasAdminRead() || bPermissions.hasOperatorRead();
    }

    public boolean hasOperatorWrite() {
        BPermissions bPermissions = this.getUser().getPermissionsFor((BIProtected)this.eas);
        return bPermissions.hasAdminWrite() || bPermissions.hasOperatorWrite();
    }
}

