/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas;

import com.tridium.eas.BDatabaseConfiguration;
import com.tridium.eas.BEasService;
import com.tridium.eas.api.RcSubtype;
import com.tridium.eas.api.RcType;
import com.tridium.eas.enums.BDatabaseTypeEnum;
import com.tridium.eas.util.DBSpecific;
import com.tridium.eas.util.DBSpecificFactory;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.util.SqlUtil;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;

public class EasDatabase {
    private BDatabaseConfiguration dbConfig;
    private BEasService eas;
    private DBSpecific dbs;
    private Random rand = new Random();
    private static BDimension consumptionDimension = BDimension.make((int)2, (int)1, (int)-2, (int)0, (int)0, (int)0, (int)0);
    private static final Log log = Log.getLog((String)"eas");

    public EasDatabase(BEasService bEasService) {
        this.eas = bEasService;
    }

    public final int getLicensedDataPointCount() {
        return this.eas.getLicensedDataPointCount();
    }

    public final int getLicensedMeterCount() {
        return this.eas.getLicensedMeterCount();
    }

    public final boolean isEasE2Licensed() {
        return this.eas.isEasE2Licensed();
    }

    public final boolean isEasCostLicensed() {
        return this.eas.isEasCostLicensed();
    }

    public final boolean isReportLicensed(String string) {
        return this.eas.isReportLicensed(string);
    }

    public boolean isCustomRateComponentUnlocked(String string) {
        return this.eas.isCustomRateComponentUnlocked(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final int getDataPointCount() {
        SQLException sQLException2222;
        int n;
        String string;
        ResultSet resultSet;
        Connection connection;
        Statement statement;
        block17: {
            statement = null;
            connection = this.getConnection();
            resultSet = null;
            string = null;
            statement = connection.createStatement();
            string = "select NAME from " + this.getDBSpecific().getFullTableName("EAS", "DATA_POINT");
            resultSet = statement.executeQuery(string);
            int n2 = 0;
            while (resultSet.next()) {
                if (this.eas.isEasStationLicensed(this.getLog(resultSet.getString(1)))) continue;
                ++n2;
            }
            n = n2;
            Object var8_8 = null;
            if (resultSet == null) break block17;
            try {
                resultSet.close();
            }
            catch (SQLException sQLException2222) {
                sQLException2222.printStackTrace();
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException2222) {
                sQLException2222.printStackTrace();
            }
        }
        this.freeConnection(connection);
        return n;
        catch (Exception exception) {
            SQLException sQLException32222;
            block19: {
                try {
                    System.out.println(string);
                    exception.printStackTrace();
                    Object var8_9 = null;
                    if (resultSet == null) break block19;
                }
                catch (Throwable throwable) {
                    SQLException sQLException42222;
                    Object var8_10 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            sQLException42222.printStackTrace();
                        }
                    }
                    this.freeConnection(connection);
                    throw throwable;
                }
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException32222) {
                    sQLException32222.printStackTrace();
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException32222) {
                    sQLException32222.printStackTrace();
                }
            }
            this.freeConnection(connection);
            {
            }
        }
        return 0;
    }

    public void open() throws SQLException, IOException {
        if (this.eas == null) {
            throw new IOException("Cannot find EasService");
        }
        if (this.dbConfig == null) {
            this.dbConfig = this.eas.getDatabaseConfiguration();
        }
        BDatabaseTypeEnum bDatabaseTypeEnum = this.dbConfig.getDatabaseType();
        String string = this.dbConfig.getDatabaseName();
        this.dbs = bDatabaseTypeEnum == BDatabaseTypeEnum.sqlServer ? DBSpecificFactory.getDBSpecific("sqlserver") : (bDatabaseTypeEnum == BDatabaseTypeEnum.oracle ? DBSpecificFactory.getDBSpecific("oracle") : DBSpecificFactory.getDBSpecific("sqlserver"));
        this.dbs.setDbName(string);
        this.checkTableSchema();
        this.addDefaults();
    }

    public Connection getConnection() {
        try {
            return this.dbConfig.getConnection();
        }
        catch (Exception exception) {
            if (this.dbConfig.getDatabaseConnected()) {
                try {
                    this.dbConfig.doCloseDatabase();
                    this.dbConfig.doOpenDatabase();
                    return this.dbConfig.getConnection();
                }
                catch (Exception exception2) {
                    log.error("Cannot open the database connection.", (Throwable)exception2);
                }
            }
            log.error("Can't retrieve connection from the Database Configuration.", (Throwable)exception);
            return null;
        }
    }

    public void freeConnection(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            this.dbConfig.freeConnection(connection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DBSpecific getDBSpecific() {
        return this.dbs;
    }

    public int getNewId() {
        return Math.abs(this.rand.nextInt());
    }

    public void upgradeSchemaFrom0(Statement statement, Connection connection) throws SQLException {
        String string;
        block4: {
            string = "SELECT S.GROUP_ID, D.ID FROM " + this.dbs.getFullTableName("EAS", "STATION") + " S, " + this.dbs.getFullTableName("EAS", "DATA_POINT") + " D " + "WHERE S.ID = D.STATION_ID";
            Hashtable<Integer, Integer> hashtable = new Hashtable<Integer, Integer>();
            ResultSet resultSet = statement.executeQuery(string);
            while (resultSet.next()) {
                hashtable.put(new Integer(resultSet.getInt(2)), new Integer(resultSet.getInt(1)));
            }
            string = "ALTER TABLE " + this.dbs.getFullTableName("EAS", "DATA_POINT") + " ADD GROUP_ID " + this.dbs.typeInt32() + " DEFAULT -1 NOT NULL";
            statement.executeUpdate(string);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                string = "UPDATE " + this.dbs.getFullTableName("EAS", "DATA_POINT") + " SET GROUP_ID = " + v + " WHERE ID = " + k;
                statement.executeUpdate(string);
            }
            string = "DROP TABLE " + this.dbs.getFullTableName("EAS", "STATION");
            statement.executeUpdate(string);
            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "SCHEMA_VERSION") + " (" + "VERSION " + this.dbs.typeInt8() + " DEFAULT 0 NOT NULL, UNIQUE (VERSION))";
            try {
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                if (this.dbs.getSQL_Error(sQLException) == 955) break block4;
                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
            }
        }
        string = "INSERT INTO " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION") + " (VERSION) VALUES (1)";
        statement.executeUpdate(string);
    }

    public void upgradeSchemaFrom1(Statement statement, Connection connection) throws SQLException {
        String string = "ALTER TABLE " + this.dbs.getFullTableName("EAS", "DATA_POINT") + " ADD FLAGS " + this.dbs.typeInt8() + " DEFAULT " + 1;
        statement.executeUpdate(string);
        string = "DELETE FROM " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION");
        statement.executeUpdate(string);
        string = "INSERT INTO " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION") + " (VERSION) VALUES (2)";
        statement.executeUpdate(string);
    }

    public void upgradeSchemaFrom2(Statement statement, Connection connection) throws SQLException {
    }

    public void upgradeSchemaFrom3(Statement statement, Connection connection) throws SQLException {
        String string;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "BUDGET_COSTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "BUDGET " + this.dbs.typeReal64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR))";
                            try {
                                statement.executeUpdate(string);
                            }
                            catch (SQLException sQLException) {
                                if (this.dbs.getSQL_Error(sQLException) == 955) break block10;
                                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                            }
                        }
                        string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "RATE_ATTACHMENTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "RATE_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "START_TIME " + this.dbs.typeInt64() + " NOT NULL," + "END_TIME " + this.dbs.typeInt64() + " NOT NULL," + "CYCLE_NUM " + this.dbs.typeInt32() + " NOT NULL," + "CYCLE_UNITS " + this.dbs.typeInt16() + " NOT NULL," + "BILL_START " + this.dbs.typeInt64() + " NOT NULL," + "ACCOUNT " + this.dbs.typeVarchar(200) + "," + "CUST_SERV_REP " + this.dbs.typeVarchar(200) + "," + "CUST_SERV_PHONE " + this.dbs.typeVarchar(200) + "," + "CUST_SERV_EMAIL " + this.dbs.typeVarchar(200) + "," + "SALES_REP " + this.dbs.typeVarchar(200) + "," + "SALES_PHONE " + this.dbs.typeVarchar(200) + "," + "SALES_EMAIL " + this.dbs.typeVarchar(200) + ")";
                        try {
                            statement.executeUpdate(string);
                        }
                        catch (SQLException sQLException) {
                            if (this.dbs.getSQL_Error(sQLException) == 955) break block11;
                            log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                        }
                    }
                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "ACTUAL_COSTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "RATE_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "COMP_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "COST " + this.dbs.typeReal64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR, RATE_NAME, COMP_NAME))";
                    try {
                        statement.executeUpdate(string);
                    }
                    catch (SQLException sQLException) {
                        if (this.dbs.getSQL_Error(sQLException) == 955) break block12;
                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                    }
                }
                string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "BILLING_CYCLES") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "RATE_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "START_TIME " + this.dbs.typeInt64() + " NOT NULL," + "END_TIME " + this.dbs.typeInt64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR, RATE_NAME))";
                try {
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    if (this.dbs.getSQL_Error(sQLException) == 955) break block13;
                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                }
            }
            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "MISC_COSTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "MISC_COST " + this.dbs.typeReal64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR))";
            try {
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                if (this.dbs.getSQL_Error(sQLException) == 955) break block14;
                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
            }
        }
        string = "DELETE FROM " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION");
        statement.executeUpdate(string);
        string = "INSERT INTO " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION") + " (VERSION) VALUES (4)";
        statement.executeUpdate(string);
    }

    public void upgradeSchemaFrom4(Statement statement, Connection connection) throws SQLException {
        String string;
        block14: {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL PRIMARY KEY," + "PARTITION_NAME " + this.dbs.typeVarchar(200) + " NOT NULL UNIQUE)";
                            try {
                                statement.executeUpdate(string);
                            }
                            catch (SQLException sQLException) {
                                if (this.dbs.getSQL_Error(sQLException) == 955) break block10;
                                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                            }
                        }
                        string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "USER_PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL," + "USERNAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "PRIMARY KEY (PARTITION_ID, USERNAME))";
                        try {
                            statement.executeUpdate(string);
                        }
                        catch (SQLException sQLException) {
                            if (this.dbs.getSQL_Error(sQLException) == 955) break block11;
                            log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                        }
                    }
                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "OBJECT_PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL," + "TYPE_ID " + this.dbs.typeInt16() + " NOT NULL," + "OBJECT_ID " + this.dbs.typeInt32() + " NOT NULL," + "PRIMARY KEY (PARTITION_ID, TYPE_ID, OBJECT_ID))";
                    try {
                        statement.executeUpdate(string);
                    }
                    catch (SQLException sQLException) {
                        if (this.dbs.getSQL_Error(sQLException) == 955) break block12;
                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                    }
                }
                string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "RATE_PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL," + "RATE_ID " + this.dbs.typeVarchar(200) + " NOT NULL," + "PRIMARY KEY (PARTITION_ID, RATE_ID))";
                try {
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    if (this.dbs.getSQL_Error(sQLException) == 955) break block13;
                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                }
            }
            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "SAVED_REPORTS") + " (" + "REPORT_ID " + this.dbs.typeInt32() + " NOT NULL PRIMARY KEY," + "PUBLIC_REPORT " + this.dbs.typeInt8() + " NOT NULL," + "REPORT_USER " + this.dbs.typeVarchar(200) + " NOT NULL," + "REPORT_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "REPORT_TYPE " + this.dbs.typeVarchar(32) + " NOT NULL," + "REPORT_DATA " + this.dbs.typeLongBit() + " NOT NULL," + "UNIQUE (PUBLIC_REPORT, REPORT_USER, REPORT_NAME, REPORT_TYPE))";
            try {
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                if (this.dbs.getSQL_Error(sQLException) == 955) break block14;
                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
            }
        }
        this.eas.upgradeSavedReports(connection);
        string = "DELETE FROM " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION");
        statement.executeUpdate(string);
        string = "INSERT INTO " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION") + " (VERSION) VALUES (5)";
        statement.executeUpdate(string);
    }

    public void createTables(Connection connection, Statement statement) throws SQLException {
        String string;
        block58: {
            block57: {
                block56: {
                    block55: {
                        block54: {
                            block53: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block48: {
                                                    block47: {
                                                        block46: {
                                                            block45: {
                                                                block44: {
                                                                    block43: {
                                                                        block42: {
                                                                            block41: {
                                                                                block40: {
                                                                                    string = null;
                                                                                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "GROUPS") + " (" + "ID " + this.dbs.typeInt32() + " PRIMARY KEY," + "TYPE CHAR (1) NOT NULL," + "HIDDEN " + this.dbs.typeInt8() + " DEFAULT 0 NOT NULL," + "ISECT CHAR (1) DEFAULT 'N' NOT NULL, " + "NAME " + this.dbs.typeVarchar(32) + " NOT NULL," + "USERID " + this.dbs.typeVarchar(32) + "," + "UNIQUE (name))";
                                                                                    try {
                                                                                        statement.executeUpdate(string);
                                                                                    }
                                                                                    catch (SQLException sQLException) {
                                                                                        if (this.dbs.getSQL_Error(sQLException) == 955) break block40;
                                                                                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                                                    }
                                                                                }
                                                                                string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "GROUP_PROP") + " (" + "group_id " + this.dbs.typeInt32() + " NOT NULL, " + "name " + this.dbs.typeVarchar(32) + "," + "value " + this.dbs.typeVarchar(32) + "," + "nvalue " + this.dbs.typeReal64() + "," + "VUNIT " + this.dbs.typeVarchar(64) + ", " + "UNIQUE  (group_id, name))";
                                                                                try {
                                                                                    statement.executeUpdate(string);
                                                                                }
                                                                                catch (SQLException sQLException) {
                                                                                    if (this.dbs.getSQL_Error(sQLException) == 955) break block41;
                                                                                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                                                }
                                                                            }
                                                                            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "STATIC_GROUP") + " (" + "PARENT_ID " + this.dbs.typeInt32() + " NOT NULL," + "CHILD_ID " + this.dbs.typeInt32() + " NOT NULL," + "SEQ_N " + this.dbs.typeInt32() + ", UNIQUE (PARENT_ID, CHILD_ID)" + ")";
                                                                            try {
                                                                                statement.executeUpdate(string);
                                                                            }
                                                                            catch (SQLException sQLException) {
                                                                                if (this.dbs.getSQL_Error(sQLException) == 955) break block42;
                                                                                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                                            }
                                                                        }
                                                                        string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "DATA_POINT") + " (" + "ID " + this.dbs.typeInt32() + " PRIMARY KEY," + "NAME " + this.dbs.typeVarchar(200) + "," + "DESCR " + this.dbs.typeVarchar(100) + "," + "STATION_ID " + this.dbs.typeInt32() + " NOT NULL," + "GROUP_ID " + this.dbs.typeInt32() + " NOT NULL," + "METER_ID " + this.dbs.typeInt32() + "," + "RC_TYPE " + this.dbs.typeInt32() + " DEFAULT " + RcType.OTHER.getCode() + " NOT NULL," + "RC_SUBTYPE " + this.dbs.typeInt32() + " DEFAULT " + RcSubtype.OTHER.getCode() + " NOT NULL," + "MAIN " + this.dbs.typeInt8() + " DEFAULT 0 NOT NULL," + "FUNC_ID " + this.dbs.typeInt32() + "," + "INTERVAL " + this.dbs.typeInt64() + "," + "INT_UNIT " + this.dbs.typeInt8() + "," + "SCALAR_VAL " + this.dbs.typeReal64() + "," + "FLOORAREA_VUNIT " + this.dbs.typeVarchar(64) + "," + "FLOORAREA_VALUE " + this.dbs.typeReal64() + "," + "FLAGS " + this.dbs.typeInt8() + " DEFAULT " + 1 + " NOT NULL" + ")";
                                                                        try {
                                                                            statement.executeUpdate(string);
                                                                        }
                                                                        catch (SQLException sQLException) {
                                                                            if (this.dbs.getSQL_Error(sQLException) == 955) break block43;
                                                                            log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                                        }
                                                                    }
                                                                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "DYN_GROUP_FIELD") + " (" + "GROUP_ID " + this.dbs.typeInt32() + "," + "GRP " + this.dbs.typeInt8() + " DEFAULT 1 NOT NULL, " + "WHR " + this.dbs.typeInt8() + " DEFAULT 0 NOT NULL, " + "ORD " + this.dbs.typeInt8() + " DEFAULT 0 NOT NULL," + "ORIG CHAR (1)," + "NAME " + this.dbs.typeVarchar(1000) + " NOT NULL," + "VALUE " + this.dbs.typeVarchar(1000) + "," + "NVALUE " + this.dbs.typeReal64() + "," + "SEQ_N " + this.dbs.typeInt32() + " NOT NULL," + "COMP CHAR (2)," + "OPER CHAR (2)" + ")";
                                                                    try {
                                                                        statement.executeUpdate(string);
                                                                    }
                                                                    catch (SQLException sQLException) {
                                                                        if (this.dbs.getSQL_Error(sQLException) == 955) break block44;
                                                                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                                    }
                                                                }
                                                                string = "CREATE INDEX DYN_GROUP_FIELD_IDX ON " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID)";
                                                                try {
                                                                    statement.executeUpdate(string);
                                                                }
                                                                catch (SQLException sQLException) {
                                                                    if (this.dbs.getSQL_Error(sQLException) == 955) break block45;
                                                                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                                }
                                                            }
                                                            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "STATIC_DP_GROUP") + " (" + "GROUP_ID " + this.dbs.typeInt32() + " NOT NULL," + "DP_ID " + this.dbs.typeInt32() + " NOT NULL," + "UNIQUE (GROUP_ID, DP_ID)" + ")";
                                                            try {
                                                                statement.executeUpdate(string);
                                                            }
                                                            catch (SQLException sQLException) {
                                                                if (this.dbs.getSQL_Error(sQLException) == 955) break block46;
                                                                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                            }
                                                        }
                                                        string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "METER") + " (" + "ID " + this.dbs.typeInt32() + " PRIMARY KEY," + "NAME " + this.dbs.typeVarchar(32) + "," + "DESCR " + this.dbs.typeVarchar(100) + "," + "SITE_ID " + this.dbs.typeInt32() + " NOT NULL," + "RC_TYPE " + this.dbs.typeInt32() + "," + "MAIN " + this.dbs.typeInt8() + "," + "FLOORAREA_VUNIT " + this.dbs.typeVarchar(64) + "," + "FLOORAREA_VALUE " + this.dbs.typeReal64() + ")";
                                                        try {
                                                            statement.executeUpdate(string);
                                                        }
                                                        catch (SQLException sQLException) {
                                                            if (this.dbs.getSQL_Error(sQLException) == 955) break block47;
                                                            log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                        }
                                                    }
                                                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "BUDGET_COSTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "BUDGET " + this.dbs.typeReal64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR))";
                                                    try {
                                                        statement.executeUpdate(string);
                                                    }
                                                    catch (SQLException sQLException) {
                                                        if (this.dbs.getSQL_Error(sQLException) == 955) break block48;
                                                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                    }
                                                }
                                                string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "RATE_ATTACHMENTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "RATE_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "START_TIME " + this.dbs.typeInt64() + " NOT NULL," + "END_TIME " + this.dbs.typeInt64() + " NOT NULL," + "CYCLE_NUM " + this.dbs.typeInt32() + " NOT NULL," + "CYCLE_UNITS " + this.dbs.typeInt16() + " NOT NULL," + "BILL_START " + this.dbs.typeInt64() + " NOT NULL," + "ACCOUNT " + this.dbs.typeVarchar(200) + "," + "CUST_SERV_REP " + this.dbs.typeVarchar(200) + "," + "CUST_SERV_PHONE " + this.dbs.typeVarchar(200) + "," + "CUST_SERV_EMAIL " + this.dbs.typeVarchar(200) + "," + "SALES_REP " + this.dbs.typeVarchar(200) + "," + "SALES_PHONE " + this.dbs.typeVarchar(200) + "," + "SALES_EMAIL " + this.dbs.typeVarchar(200) + ")";
                                                try {
                                                    statement.executeUpdate(string);
                                                }
                                                catch (SQLException sQLException) {
                                                    if (this.dbs.getSQL_Error(sQLException) == 955) break block49;
                                                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                                }
                                            }
                                            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "ACTUAL_COSTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "RATE_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "COMP_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "COST " + this.dbs.typeReal64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR, RATE_NAME, COMP_NAME))";
                                            try {
                                                statement.executeUpdate(string);
                                            }
                                            catch (SQLException sQLException) {
                                                if (this.dbs.getSQL_Error(sQLException) == 955) break block50;
                                                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                            }
                                        }
                                        string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "BILLING_CYCLES") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "RATE_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "START_TIME " + this.dbs.typeInt64() + " NOT NULL," + "END_TIME " + this.dbs.typeInt64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR, RATE_NAME))";
                                        try {
                                            statement.executeUpdate(string);
                                        }
                                        catch (SQLException sQLException) {
                                            if (this.dbs.getSQL_Error(sQLException) == 955) break block51;
                                            log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                        }
                                    }
                                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "MISC_COSTS") + " (" + "METER_ID " + this.dbs.typeInt32() + " NOT NULL," + "MONTH " + this.dbs.typeInt16() + " NOT NULL," + "YEAR " + this.dbs.typeInt32() + " NOT NULL," + "MISC_COST " + this.dbs.typeReal64() + " NOT NULL," + "PRIMARY KEY (METER_ID, MONTH, YEAR))";
                                    try {
                                        statement.executeUpdate(string);
                                    }
                                    catch (SQLException sQLException) {
                                        if (this.dbs.getSQL_Error(sQLException) == 955) break block52;
                                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                    }
                                }
                                string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL PRIMARY KEY," + "PARTITION_NAME " + this.dbs.typeVarchar(200) + " NOT NULL UNIQUE)";
                                try {
                                    statement.executeUpdate(string);
                                }
                                catch (SQLException sQLException) {
                                    if (this.dbs.getSQL_Error(sQLException) == 955) break block53;
                                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                                }
                            }
                            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "USER_PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL," + "USERNAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "PRIMARY KEY (PARTITION_ID, USERNAME))";
                            try {
                                statement.executeUpdate(string);
                            }
                            catch (SQLException sQLException) {
                                if (this.dbs.getSQL_Error(sQLException) == 955) break block54;
                                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                            }
                        }
                        string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "OBJECT_PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL," + "TYPE_ID " + this.dbs.typeInt16() + " NOT NULL," + "OBJECT_ID " + this.dbs.typeInt32() + " NOT NULL," + "PRIMARY KEY (PARTITION_ID, TYPE_ID, OBJECT_ID))";
                        try {
                            statement.executeUpdate(string);
                        }
                        catch (SQLException sQLException) {
                            if (this.dbs.getSQL_Error(sQLException) == 955) break block55;
                            log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                        }
                    }
                    string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "RATE_PARTITIONS") + " (" + "PARTITION_ID " + this.dbs.typeInt32() + " NOT NULL," + "RATE_ID " + this.dbs.typeVarchar(200) + " NOT NULL," + "PRIMARY KEY (PARTITION_ID, RATE_ID))";
                    try {
                        statement.executeUpdate(string);
                    }
                    catch (SQLException sQLException) {
                        if (this.dbs.getSQL_Error(sQLException) == 955) break block56;
                        log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                    }
                }
                string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "SAVED_REPORTS") + " (" + "REPORT_ID " + this.dbs.typeInt32() + " NOT NULL PRIMARY KEY," + "PUBLIC_REPORT " + this.dbs.typeInt8() + " NOT NULL," + "REPORT_USER " + this.dbs.typeVarchar(200) + " NOT NULL," + "REPORT_NAME " + this.dbs.typeVarchar(200) + " NOT NULL," + "REPORT_TYPE " + this.dbs.typeVarchar(32) + " NOT NULL," + "REPORT_DATA " + this.dbs.typeLongBit() + " NOT NULL," + "UNIQUE (PUBLIC_REPORT, REPORT_USER, REPORT_NAME, REPORT_TYPE))";
                try {
                    statement.executeUpdate(string);
                }
                catch (SQLException sQLException) {
                    if (this.dbs.getSQL_Error(sQLException) == 955) break block57;
                    log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
                }
            }
            string = "CREATE TABLE " + this.dbs.getDbTableName(connection, "EAS", "SCHEMA_VERSION") + " (" + "VERSION " + this.dbs.typeInt8() + " DEFAULT 5 NOT NULL, UNIQUE (VERSION))";
            try {
                statement.executeUpdate(string);
            }
            catch (SQLException sQLException) {
                if (this.dbs.getSQL_Error(sQLException) == 955) break block58;
                log.error(sQLException.getSQLState() + " " + sQLException.getErrorCode() + " " + string, (Throwable)sQLException);
            }
        }
        string = "INSERT INTO " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION") + " (VERSION) VALUES (5)";
        try {
            statement.executeUpdate(string);
        }
        catch (SQLException sQLException) {
            log.error("Could not update schema_version table", (Throwable)sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkTableSchema() throws SQLException {
        block27: {
            block25: {
                block23: {
                    block24: {
                        var1_1 = null;
                        var2_2 = null;
                        var3_3 = 0;
                        var4_4 = null;
                        try {
                            block22: {
                                var1_1 = this.getConnection();
                                var4_4 = var1_1.createStatement();
                                var2_2 = this.dbs.getCreateSchema("EAS");
                                if (var2_2 != null) {
                                    try {
                                        var4_4.executeUpdate(var2_2);
                                    }
                                    catch (SQLException var5_5) {
                                        if (this.dbs.getSQL_Error(var5_5) == 955) break block22;
                                        EasDatabase.log.error(var5_5.getSQLState() + " " + var5_5.getErrorCode() + " " + var2_2, (Throwable)var5_5);
                                    }
                                }
                            }
                            var3_3 = this.getSchemaVersion(var4_4, var1_1);
                            switch (var3_3) {
                                case -1: {
                                    EasDatabase.log.message("Creating EAS configuration tables.");
                                    this.createTables(var1_1, var4_4);
                                    break;
                                }
                                case 0: {
                                    EasDatabase.log.message("Upgrading EAS configuration tables from EAS schema version 0.");
                                    this.upgradeSchemaFrom0(var4_4, var1_1);
                                }
                                case 1: {
                                    EasDatabase.log.message("Upgrading EAS configuration tables from EAS schema version 1.");
                                    this.upgradeSchemaFrom1(var4_4, var1_1);
                                }
                                case 2: {
                                    EasDatabase.log.message("Upgrading EAS configuration tables from EAS schema version 2.");
                                    this.upgradeSchemaFrom2(var4_4, var1_1);
                                    EasDatabase.log.error("Cannot upgrade from EAS schema version 2.  You must create a new database, or remove the conflicting tables.");
                                    throw new SQLException("Cannot upgrade from EAS schema version 2.  You must create a new database, or remove the conflicting tables.");
                                }
                                case 3: {
                                    EasDatabase.log.message("Upgrading EAS configuration tables from EAS schema version 3.");
                                    this.upgradeSchemaFrom3(var4_4, var1_1);
                                }
                                case 4: {
                                    EasDatabase.log.message("Upgrading EAS configuration tables from EAS schema version 4.");
                                    this.upgradeSchemaFrom4(var4_4, var1_1);
                                }
                                case 5: {
                                    break;
                                }
                                default: {
                                    EasDatabase.log.error("Unknown schema version " + var3_3);
                                    var7_7 = null;
                                    if (var4_4 == null) break block23;
                                    break block24;
                                }
                            }
                            try {
                                var1_1.commit();
                            }
                            catch (Exception var5_6) {
                                EasDatabase.log.error("Cannot commit connection", (Throwable)var5_6);
                            }
                            break block25;
                        }
                        catch (Throwable var6_13) {
                            var7_9 = null;
                            if (var4_4 != null) {
                                try {
                                    var4_4.close();
                                }
                                catch (SQLException var8_12) {
                                    EasDatabase.log.error("Cannot close statement", (Throwable)var8_12);
                                }
                            }
                            this.freeConnection(var1_1);
                            throw var6_13;
                        }
                    }
                    ** try [egrp 3[TRYBLOCK] [5 : 349->359)] { 
lbl70:
                    // 1 sources

                    var4_4.close();
                    break block23;
lbl72:
                    // 1 sources

                    catch (SQLException var8_10) {
                        EasDatabase.log.error("Cannot close statement", (Throwable)var8_10);
                    }
                }
                this.freeConnection(var1_1);
                return;
            }
            var7_8 = null;
            if (var4_4 != null) {
                ** try [egrp 3[TRYBLOCK] [5 : 349->359)] { 
lbl81:
                // 1 sources

                var4_4.close();
                break block27;
lbl83:
                // 1 sources

                catch (SQLException var8_11) {
                    EasDatabase.log.error("Cannot close statement", (Throwable)var8_11);
                }
            }
        }
        this.freeConnection(var1_1);
    }

    public int getSchemaVersion(Statement statement, Connection connection) throws SQLException {
        try {
            String string = "SELECT VERSION FROM " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION");
            ResultSet resultSet = statement.executeQuery(string);
            if (resultSet.next()) {
                return resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (SqlUtil.doesTableExist(connection, "EAS", "DATA_POINT")) {
            return 0;
        }
        return -1;
    }

    public void addDefaults() {
        this.addDefaultGroups();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addDefaultGroups() {
        block15: {
            Statement statement;
            Connection connection;
            block14: {
                connection = null;
                Object var2_2 = null;
                statement = null;
                connection = this.getConnection();
                statement = connection.createStatement();
                if (this.isEmpty(statement.executeQuery("select * FROM " + this.dbs.getFullTableName("EAS", "GROUPS") + " where ID=1003"))) {
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, NAME) VALUES (1003,'D','By Floor Area')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, ORIG, NAME, SEQ_N) VALUES (1003, 'G', 'floorAreaSub', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2001,'D',1,'1-50000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2002,'D',1,'50001-100000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2003,'D',1,'100001-120000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2004,'D',1,'120001-150000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2005,'D',1,'150001-200000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2001,0,1,'G','floorarea', 50000,'<=', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2002,0,1,'G','floorarea', 50000,'>', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2002,0,1,'G','floorarea', 100000,'<=', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2003,0,1,'G','floorarea', 100000,'>', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2003,0,1,'G','floorarea', 120000,'<=', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2004,0,1,'G','floorarea', 120000,'>', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2004,0,1,'G','floorarea', 150000,'<=', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2005,0,1,'G','floorarea', 150000,'>', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2005,0,1,'G','floorarea', 200000,'<=', 0)");
                }
                if (this.isEmpty(statement.executeQuery("select * FROM " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " where NAME=" + Dbx.str2db("floorAreaSub")))) {
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2001,'floorAreaSub','1-50000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2002,'floorAreaSub','50001-100000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2003,'floorAreaSub','100001-120000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2004,'floorAreaSub','120001-150000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2005,'floorAreaSub','150001-200000')");
                }
                if (this.isEmpty(statement.executeQuery("select * FROM " + this.dbs.getFullTableName("EAS", "GROUPS") + " where ID=1005"))) {
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, NAME) VALUES (1005,'D','By State and City')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, ORIG, NAME, SEQ_N) VALUES (1005, 'G', 'stateprov', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, ORIG, NAME, SEQ_N) VALUES (1005, 'G', 'city', 1)");
                }
                class DG {
                    DG(int n, String string, String string2, Statement statement) throws Exception {
                        if (EasDatabase.this.isEmpty(statement.executeQuery("select * FROM " + EasDatabase.this.dbs.getFullTableName("EAS", "GROUPS") + " where ID=" + n))) {
                            statement.executeUpdate("INSERT INTO " + EasDatabase.this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, NAME) VALUES (" + n + ",'D','" + string + "')");
                            statement.executeUpdate("INSERT INTO " + EasDatabase.this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, ORIG, NAME, SEQ_N) VALUES (" + n + ", 'G', '" + string2 + "', 0)");
                        }
                    }
                }
                new DG(1006, "By Region", "region", statement);
                new DG(1007, "By Division", "division", statement);
                new DG(1008, "By District", "district", statement);
                new DG(1009, "By Business Unit", "businessUnit", statement);
                new DG(1010, "By Electric Utility", "electricUtility", statement);
                new DG(1010, "By Gas Utility", "gasUtility", statement);
                if (this.isEmpty(statement.executeQuery("select * FROM " + this.dbs.getFullTableName("EAS", "GROUPS") + " where ID=2006"))) {
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2006,'D',1,'200001-300000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2007,'D',1,'300001-500000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUPS") + " (ID, TYPE, HIDDEN, NAME) VALUES (2008,'D',1,'500001+')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2006,'floorAreaSub','200001-300000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2007,'floorAreaSub','300001-500000')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "GROUP_PROP") + " (GROUP_ID, NAME, VALUE) VALUES (2008,'floorAreaSub','500001+')");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2006,0,1,'G','floorarea', 200000,'>', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2006,0,1,'G','floorarea', 300000,'<=', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2007,0,1,'G','floorarea', 300000,'>', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2007,0,1,'G','floorarea', 500000,'<=', 0)");
                    statement.executeUpdate("INSERT INTO " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD") + " (GROUP_ID, grp,whr, ORIG, NAME, NVALUE, COMP, SEQ_N) VALUES (2008,0,1,'G','floorarea', 500000,'>', 0)");
                }
                connection.commit();
                Object var6_4 = null;
                if (statement == null) break block14;
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    log.error("Cannot close statement", (Throwable)sQLException);
                }
            }
            this.freeConnection(connection);
            {
                break block15;
                catch (Exception exception) {
                    log.error("Error while adding default groups.", (Throwable)exception);
                    Object var6_5 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException) {
                            log.error("Cannot close statement", (Throwable)sQLException);
                        }
                    }
                    this.freeConnection(connection);
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        log.error("Cannot close statement", (Throwable)sQLException);
                    }
                }
                this.freeConnection(connection);
                throw throwable;
            }
        }
    }

    private boolean isEmpty(ResultSet resultSet) {
        try {
            return !resultSet.next();
        }
        catch (Exception exception) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTables() throws SQLException {
        Connection connection;
        block44: {
            connection = null;
            Statement statement = null;
            try {
                connection = this.getConnection();
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "GROUPS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "GROUP_PROP"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "STATIC_GROUP"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "DATA_POINT"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "DYN_GROUP_FIELD"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "STATIC_DP_GROUP"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "METER"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "BUDGET_COSTS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "RATE_ATTACHMENTS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "ACTUAL_COSTS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "BILLING_CYCLES"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "MISC_COSTS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "PARTITIONS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "USER_PARTITIONS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "OBJECT_PARTITIONS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "RATE_PARTITIONS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "SAVED_REPORTS"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    statement.executeUpdate("drop TABLE " + this.dbs.getFullTableName("EAS", "SCHEMA_VERSION"));
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    connection.commit();
                }
                catch (Exception exception) {
                }
                Object var5_22 = null;
                if (statement == null) break block44;
            }
            catch (Throwable throwable) {
                Object var5_23 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {
                        log.error("Cannot close statement", (Throwable)sQLException);
                    }
                }
                this.freeConnection(connection);
                throw throwable;
            }
            try {
                statement.close();
                break block44;
            }
            catch (SQLException sQLException) {
                log.error("Cannot close statement", (Throwable)sQLException);
            }
            {
            }
        }
        this.freeConnection(connection);
    }

    public BEasService getService() {
        return this.eas;
    }

    public BIHistory getLog(String string) {
        try {
            BOrd bOrd = BOrd.make((String)"history:");
            BHistorySpace bHistorySpace = (BHistorySpace)bOrd.resolve((BObject)this.eas).get();
            return bHistorySpace.getHistory(BHistoryId.make((String)string));
        }
        catch (Exception exception) {
            BEasService.log.error("Could not resolve history for id: " + string, (Throwable)exception);
            return null;
        }
    }

    public boolean requiresDeltaQuery(BIHistory bIHistory) {
        BBoolean bBoolean;
        if (bIHistory == null) {
            return false;
        }
        BHistoryConfig bHistoryConfig = bIHistory.getConfig();
        try {
            bBoolean = (BBoolean)bHistoryConfig.get("useDelta");
            if (bBoolean != null) {
                return bBoolean.getBoolean();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bBoolean = (BFacets)bHistoryConfig.get("valueFacets");
            BUnit bUnit = (BUnit)bBoolean.get("units", (BObject)BUnit.NULL);
            if (bUnit != null && bUnit.getDimension().equals((Object)consumptionDimension)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

