/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas;

import com.tridium.eas.BEasService;
import com.tridium.fox.sys.NiagaraStation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.baja.driver.BDevice;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public final class BEasStationConfig
extends BVector
implements BIStatus,
BIMixIn {
    public static final Property status = BEasStationConfig.newProperty((int)75, (BValue)BStatus.down, null);
    public static final Property enabled = BEasStationConfig.newProperty((int)0, (boolean)true, null);
    public static final Property faultCause = BEasStationConfig.newProperty((int)67, (String)"Not registered with EasService", null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$eas$BEasStationConfig == null ? (class$com$tridium$eas$BEasStationConfig = BEasStationConfig.class$("com.tridium.eas.BEasStationConfig")) : class$com$tridium$eas$BEasStationConfig));
    private static final BIcon icon = BIcon.make((String)"module://eas/com/tridium/eas/ui/images/trend.png");
    private static final String UNACCEPTABLE_HISTORY_SOURCE = "Could not register (not a valid source for coverage under the eas station license limit).";
    private static final HashMap obixSources = new HashMap();
    private static Class obixClientClass = null;
    private static Class obixObjClass = null;
    private static Constructor obixUriConstructor = null;
    private static Method obixRead = null;
    private static Method obixObjGet = null;
    private static Method obixObjGetHref = null;
    private static Method obixObjGetNormalizedHref = null;
    private static Method obixObjGetStr = null;
    BComplex registeredSource = null;
    MySubscriber mySubscriber = new MySubscriber(this);
    static /* synthetic */ Class class$com$tridium$eas$BEasStationConfig;
    static /* synthetic */ Class class$java$lang$String;

    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    public void setStatus(BStatus bStatus) {
        this.set(status, (BValue)bStatus, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public String getFaultCause() {
        return this.getString(faultCause);
    }

    public void setFaultCause(String string) {
        this.setString(faultCause, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final boolean isParentLegal(BComponent bComponent) {
        return bComponent instanceof NiagaraStation || obixClientClass != null && obixClientClass.isAssignableFrom(bComponent.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final boolean isAcceptedHistorySource(BComplex bComplex) {
        if (bComplex instanceof NiagaraStation) {
            return true;
        }
        if (obixClientClass != null && obixClientClass.isAssignableFrom(bComplex.getClass())) {
            try {
                Object object;
                String string;
                Object object2;
                Object object3;
                String string2;
                String string3 = ((BString)bComplex.get("lobby")).getString();
                if (!string3.endsWith("/")) {
                    string3 = string3 + "/";
                }
                Boolean bl = Boolean.FALSE;
                HashMap hashMap = obixSources;
                synchronized (hashMap) {
                    bl = (Boolean)obixSources.get(string3);
                    if (bl != null) {
                        return bl;
                    }
                }
                hashMap = (BStatus)bComplex.get("status");
                if (hashMap.isDown()) {
                    return false;
                }
                Object t = obixUriConstructor.newInstance(string3);
                Object object4 = obixRead.invoke((Object)bComplex, t);
                if (object4 == null) {
                    return false;
                }
                Object object5 = obixObjGet.invoke(object4, "about");
                if (object5 == null) {
                    return false;
                }
                if (obixObjGetHref.invoke(object5, null) != null && (string2 = (String)obixObjGetStr.invoke(object3 = obixObjGet.invoke(object5 = obixRead.invoke((Object)bComplex, object2 = obixObjGetNormalizedHref.invoke(object5, null)), "vendorName"), null)).indexOf("Tridium") >= 0 && (string = (String)obixObjGetStr.invoke(object = obixObjGet.invoke(object5, "productName"), null)).equalsIgnoreCase("Tridium Niagara Station")) {
                    bl = Boolean.TRUE;
                }
                object2 = obixSources;
                synchronized (object2) {
                    obixSources.put(string3, bl);
                }
                return bl;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public final void started() throws Exception {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("Disabled (this station will not count towards the Eas station limit).");
            return;
        }
        BEasService bEasService = null;
        try {
            bEasService = (BEasService)Sys.getService((Type)BEasService.TYPE);
        }
        catch (Exception exception) {
            bEasService = null;
        }
        if (bEasService == null) {
            this.setStatus(BStatus.down);
            this.setFaultCause("Not registered with EasService");
            return;
        }
        BComponent bComponent = this.getParent().asComponent();
        if (!(bComponent instanceof NiagaraStation) && !this.mySubscriber.isSubscribed(bComponent)) {
            this.mySubscriber.subscribe(bComponent);
        }
        this.register(bEasService);
    }

    public final void stopped() throws Exception {
        this.mySubscriber.unsubscribeAll();
        BEasService bEasService = null;
        try {
            bEasService = (BEasService)Sys.getService((Type)BEasService.TYPE);
        }
        catch (Exception exception) {
            bEasService = null;
        }
        if (bEasService == null) {
            this.setStatus(BStatus.down);
            this.setFaultCause("Not registered with EasService");
            return;
        }
        bEasService.unregisterEasStation(this, null);
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("Disabled (this station will not count towards the Eas station limit).");
        }
    }

    public final void changed(Property property, Context context) {
        if (property == enabled && this.isRunning()) {
            try {
                if (this.getEnabled()) {
                    this.started();
                } else {
                    this.stopped();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    final void register(BEasService bEasService) {
        if (!this.getEnabled()) {
            return;
        }
        if (bEasService.registerEasStation(this)) {
            this.setStatus(BStatus.ok);
            this.setFaultCause("");
        } else {
            this.setStatus(BStatus.fault);
            if (BEasStationConfig.isAcceptedHistorySource(this.getParent())) {
                this.setFaultCause("Could not register this station (check eas station license limit).");
            } else {
                this.setFaultCause(UNACCEPTABLE_HISTORY_SOURCE);
            }
        }
    }

    final void unregister(BEasService bEasService, Context context) {
        bEasService.unregisterEasStation(this, context);
        this.setStatus(BStatus.down);
        this.setFaultCause("Not registered with EasService");
    }

    public String toString(Context context) {
        return this.propertyValueToString(status, context);
    }

    public String getDisplayNameInParent(Context context) {
        return Lexicon.make((BModule)TYPE.getModule(), (Context)context).getText("easConfig");
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            obixClientClass = Sys.loadClass((String)"obixDriver", (String)"javax.baja.obix.driver.BObixClient");
            Class clazz = Sys.loadClass((String)"obix", (String)"obix.Uri");
            obixUriConstructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = BEasStationConfig.class$("java.lang.String")) : class$java$lang$String);
            obixObjClass = Sys.loadClass((String)"obix", (String)"obix.Obj");
            obixRead = obixClientClass.getMethod("obixRead", clazz);
            obixObjGet = obixObjClass.getMethod("get", class$java$lang$String == null ? (class$java$lang$String = BEasStationConfig.class$("java.lang.String")) : class$java$lang$String);
            obixObjGetHref = obixObjClass.getMethod("getHref", null);
            obixObjGetNormalizedHref = obixObjClass.getMethod("getNormalizedHref", null);
            obixObjGetStr = obixObjClass.getMethod("getStr", null);
        }
        catch (Throwable throwable) {
            obixClientClass = null;
        }
    }

    static class MySubscriber
    extends Subscriber {
        BEasStationConfig config;

        public MySubscriber(BEasStationConfig bEasStationConfig) {
            this.config = bEasStationConfig;
        }

        public void event(BComponentEvent bComponentEvent) {
            if (bComponentEvent.getId() == 0 && "status".equals(bComponentEvent.getSlotName())) {
                boolean bl;
                BDevice bDevice = (BDevice)bComponentEvent.getSourceComponent();
                boolean bl2 = bl = bDevice.isDown() || bDevice.isDisabled() || bDevice.isFatalFault();
                if (this.config.getEnabled() && !this.config.getStatus().isOk() && !bl && BEasStationConfig.UNACCEPTABLE_HISTORY_SOURCE.equals(this.config.getFaultCause())) {
                    try {
                        this.config.started();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }
}

