/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.eas;

import com.tridium.eas.BCustomRateComponents;
import com.tridium.eas.BDatabaseConfiguration;
import com.tridium.eas.BEasReport;
import com.tridium.eas.BEasReportContainer;
import com.tridium.eas.BEasStationConfig;
import com.tridium.eas.EasDatabase;
import com.tridium.eas.EasServerDxSession;
import com.tridium.eas.api.Group;
import com.tridium.eas.api.Meter;
import com.tridium.eas.api.Site;
import com.tridium.eas.cost.rate.RateHistory;
import com.tridium.eas.enums.BHomePageSelectEnum;
import com.tridium.eas.util.Dbx;
import com.tridium.eas.web.EasCostHandler;
import com.tridium.eas.web.EasServlet;
import com.tridium.fox.sys.NiagaraStation;
import com.tridium.nd.BNiagaraNetwork;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.baja.collection.BICollection;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BIHistory;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.Array;
import javax.baja.util.TextUtil;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;

public class BEasService
extends BWebServlet {
    public static final Property homePage = BEasService.newProperty((int)0, (BValue)BHomePageSelectEnum.useDefault, null);
    public static final Property customHomePage = BEasService.newProperty((int)0, (BValue)BOrd.NULL, (BFacets)BFacets.make((String)"targetType", (String)"baja:IFile"));
    public static final Property visibleCustomRateComponents = BEasService.newProperty((int)0, (BValue)BCustomRateComponents.DEFAULT, null);
    public static final Property databaseConfiguration = BEasService.newProperty((int)0, (BValue)new BDatabaseConfiguration(), null);
    public static final Property reports = BEasService.newProperty((int)7, (BValue)new BEasReportContainer(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$eas$BEasService == null ? (class$com$tridium$eas$BEasService = BEasService.class$("com.tridium.eas.BEasService")) : class$com$tridium$eas$BEasService));
    private static boolean licenseChecked = false;
    private static final BIcon icon = BIcon.make((String)"module://eas/com/tridium/eas/web/images/lineChart.png");
    private static Type[] serviceTypes = new Type[]{TYPE};
    private static boolean easFeatureLicensed = false;
    private static int licensedDataPoints = 0;
    private static int licensedCostMeters = Integer.MAX_VALUE;
    private static boolean partitioningLicensed = false;
    private static HashMap licensedReports = new HashMap();
    private static boolean allE2ReportsLicensed = false;
    private static boolean allCostReportsLicensed = false;
    private static int licensedEasStations = 0;
    private static Array registeredStations = new Array(class$javax$baja$sys$BComplex == null ? (class$javax$baja$sys$BComplex = BEasService.class$("javax.baja.sys.BComplex")) : class$javax$baja$sys$BComplex);
    private static final Context SHUTDOWN_CONTEXT = new BasicContext(){

        public boolean equals(Object object) {
            return this == object;
        }

        public String toString() {
            return "Context.easShutdown";
        }
    };
    private EasDatabase db;
    private File easHomeDir;
    private File reportsDir;
    private File dbDir;
    private File upldDir;
    private EasServerDxSession easServerSession;
    private EasServlet servlet;
    public static final Log log = Log.getLog((String)"eas");
    public static BUnit MULTISTATE = BUnit.make((String)"easMultistate", (String)"", (BDimension)BDimension.DEFAULT);
    public static final int DEMO_DP_COUNT = 88;
    static /* synthetic */ Class class$com$tridium$eas$BEasService;
    static /* synthetic */ Class class$com$tridium$eas$BEasReport;
    static /* synthetic */ Class class$javax$baja$sys$BComplex;

    public BHomePageSelectEnum getHomePage() {
        return (BHomePageSelectEnum)this.get(homePage);
    }

    public void setHomePage(BHomePageSelectEnum bHomePageSelectEnum) {
        this.set(homePage, (BValue)bHomePageSelectEnum, null);
    }

    public BOrd getCustomHomePage() {
        return (BOrd)this.get(customHomePage);
    }

    public void setCustomHomePage(BOrd bOrd) {
        this.set(customHomePage, (BValue)bOrd, null);
    }

    public BCustomRateComponents getVisibleCustomRateComponents() {
        return (BCustomRateComponents)this.get(visibleCustomRateComponents);
    }

    public void setVisibleCustomRateComponents(BCustomRateComponents bCustomRateComponents) {
        this.set(visibleCustomRateComponents, (BValue)bCustomRateComponents, null);
    }

    public BDatabaseConfiguration getDatabaseConfiguration() {
        return (BDatabaseConfiguration)this.get(databaseConfiguration);
    }

    public void setDatabaseConfiguration(BDatabaseConfiguration bDatabaseConfiguration) {
        this.set(databaseConfiguration, (BValue)bDatabaseConfiguration, null);
    }

    public BEasReportContainer getReports() {
        return (BEasReportContainer)this.get(reports);
    }

    public void setReports(BEasReportContainer bEasReportContainer) {
        this.set(reports, (BValue)bEasReportContainer, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BEasService() {
        this.setServletName("eas");
        this.setFlags((Slot)servletName, 1);
        MULTISTATE = BUnit.make((String)"easMultistate", (String)"", (BDimension)BDimension.DEFAULT);
    }

    public final void serviceStarted() throws Exception {
        BComponent[] bComponentArray = Sys.getServices((Type)TYPE);
        if (bComponentArray.length > 1) {
            for (int i = 0; i < bComponentArray.length; ++i) {
                ((BEasService)bComponentArray[i]).configFatal("Only one EAS service is allowed per station. Remove duplicate EAS services(s) and restart station.");
            }
            return;
        }
        if (this.checkLicense()) {
            this.getComponentSpace().enableMixIn(BEasStationConfig.TYPE);
            if (log.isTraceOn()) {
                log.trace("Starting the Eas Service...");
            }
            super.serviceStarted();
            this.createEasDirectories();
        }
    }

    public final void descendantsStarted() throws Exception {
        super.descendantsStarted();
        if (this.checkLicense() && !this.isFatalFault()) {
            if (Sys.isStationStarted()) {
                this.registerStations(null);
            }
            try {
                this.db = new EasDatabase(this);
                this.getDatabaseConfiguration().doOpenDatabase();
            }
            catch (Exception exception) {
                log.error("Problem initializing EasDatabase", (Throwable)exception);
            }
            finally {
                this.easServerSession = new EasServerDxSession(this, this.db);
                this.servlet = new EasServlet(this, this.easServerSession);
                this.servlet.setReady(true);
                this.servlet.init();
            }
        }
    }

    public final void stationStarted() throws Exception {
        super.stationStarted();
        if (this.checkLicense() && !this.isFatalFault()) {
            this.registerStations(null);
        }
    }

    public final void serviceStopped() throws Exception {
        if (log.isTraceOn()) {
            log.trace("Stopping the Eas Service...");
        }
        this.getComponentSpace().disableMixIn(BEasStationConfig.TYPE);
        this.unregisterStations();
        super.serviceStopped();
    }

    public final boolean isEasE2Licensed() {
        return this.isEasLicensed() && (licensedDataPoints > 0 || licensedEasStations > 0);
    }

    public final boolean isEasCostLicensed() {
        return this.isEasE2Licensed();
    }

    public final boolean isEasPartitioningLicensed() {
        return false;
    }

    public final EasDatabase getDatabase() {
        return this.db;
    }

    public final boolean isDemo() {
        return this.isEasLicensed() && !this.isEasE2Licensed();
    }

    public int getHomePageSelection() {
        return this.getHomePage().getOrdinal();
    }

    public final int getLicensedDataPointCount() {
        return licensedDataPoints;
    }

    public final int getLicensedMeterCount() {
        return licensedCostMeters;
    }

    public final boolean isEasLicensed() {
        return easFeatureLicensed;
    }

    private boolean checkLicense() {
        if (this.isFatalFault()) {
            return false;
        }
        try {
            if (!licenseChecked) {
                Feature feature = Sys.getLicenseManager().getFeature("tridium", "eas");
                if (feature == null) {
                    this.configFatal("eas not licensed");
                    throw new FeatureNotLicensedException("eas not licensed");
                }
                feature.check();
                easFeatureLicensed = true;
                String string = feature.get("dataPoint.limit", "0");
                if (string != null) {
                    licensedDataPoints = TextUtil.toLowerCase((String)string).equals("none") ? Integer.MAX_VALUE : Integer.parseInt(string);
                }
                if ((string = feature.get("station.limit", "0")) != null) {
                    licensedEasStations = TextUtil.toLowerCase((String)string).equals("none") ? Integer.MAX_VALUE : Integer.parseInt(string);
                }
                allE2ReportsLicensed = feature.getb("allE2Reports", false);
                allCostReportsLicensed = feature.getb("allCostReports", false);
                BEasReport[] bEasReportArray = this.getReportList();
                int n = 0;
                if (bEasReportArray != null) {
                    n = bEasReportArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string2 = bEasReportArray[i].getEasKey();
                        if (string2.equalsIgnoreCase("allE2Reports") || string2.equalsIgnoreCase("allCostReports")) continue;
                        int n2 = bEasReportArray[i].getEasReportType();
                        boolean bl = allE2ReportsLicensed && (n2 == 0 || n2 == 2) || allCostReportsLicensed && (n2 == 1 || n2 == 2) || feature.getb(string2, false) || this.isDemo();
                        licensedReports.put(string2, bl ? Boolean.TRUE : Boolean.FALSE);
                    }
                }
                partitioningLicensed = feature.getb("partitioning", false);
                if (this.isDemo()) {
                    log.message("The EAS service is running in DEMO mode.  To get out of DEMO mode, a new license and station restart is required.");
                }
                licenseChecked = true;
            }
        }
        catch (Exception exception) {
            licenseChecked = false;
            this.configFatal("eas not licensed");
            throw new FeatureNotLicensedException("eas not licensed");
        }
        return licenseChecked;
    }

    public final boolean isReportLicensed(String string) {
        if (string == null) {
            return false;
        }
        if (licensedReports == null) {
            return false;
        }
        Boolean bl = (Boolean)licensedReports.get(string);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public final int getAttachedMeterCount() {
        int n = 0;
        Group[] groupArray = Site.getGroups(this.easServerSession);
        if (groupArray != null) {
            for (int i = 0; i < groupArray.length; ++i) {
                Vector vector = this.easServerSession.getMeterExec().getSiteMeters((Site)groupArray[i]);
                if (vector == null) continue;
                for (int j = 0; j < vector.size(); ++j) {
                    RateHistory rateHistory = null;
                    try {
                        rateHistory = EasCostHandler.loadRateHistory(((Meter)vector.elementAt(j)).getId());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (rateHistory == null || rateHistory.getRateLinks() == null || rateHistory.getRateLinks().length <= 0) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    private void createEasDirectories() {
        File file;
        File file2 = this.getHomeDirectory();
        if (!file2.exists()) {
            file2.mkdirs();
        }
        if (!(file = this.getUploadDirectory()).exists()) {
            file.mkdirs();
        }
    }

    public File getHomeDirectory() {
        if (this.easHomeDir == null) {
            File file = Sys.getStationHome();
            this.easHomeDir = new File(file, "eas");
        }
        return this.easHomeDir;
    }

    private File getOldReportsDirectory() {
        if (this.reportsDir == null) {
            File file = this.getHomeDirectory();
            this.reportsDir = new File(file, "reports");
        }
        return this.reportsDir;
    }

    public File getUploadDirectory() {
        if (this.upldDir == null) {
            File file = this.getHomeDirectory();
            this.upldDir = new File(file, "uploads");
        }
        return this.upldDir;
    }

    public void purgeUploadDirectory() {
        long l = System.currentTimeMillis() - 300000L;
        String[] stringArray = this.getUploadDirectory().list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(this.getUploadDirectory(), stringArray[i]);
            if (file.lastModified() >= l) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSavedReports(Connection connection, File file, String string) {
        if (file == null || !file.exists()) {
            return;
        }
        String string2 = file.getName();
        String[] stringArray = file.list();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                this.updateSavedReports(connection, file2, string2);
                continue;
            }
            if (stringArray[i].indexOf(".rep") == -1 && stringArray[i].indexOf(".xml") == -1) continue;
            Statement statement = null;
            boolean bl = true;
            InputStream inputStream = null;
            try {
                if (log.isTraceOn()) {
                    log.trace("Upgrading saved report " + file2.getCanonicalPath());
                }
                String string3 = stringArray[i].substring(0, stringArray[i].length() - 4);
                statement = connection.prepareStatement("insert into " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " (REPORT_ID, PUBLIC_REPORT, REPORT_USER, REPORT_NAME, REPORT_TYPE, REPORT_DATA) VALUES (?, ?, ?, ?, ?, ?)");
                statement.setInt(2, string.equals("public") ? 1 : 0);
                statement.setString(3, string);
                statement.setString(4, string3);
                statement.setString(5, string2);
                int n2 = 10;
                while (bl && --n2 >= 0) {
                    block28: {
                        inputStream = new FileInputStream(file2);
                        statement.setBinaryStream(6, inputStream, inputStream.available());
                        try {
                            statement.setInt(1, this.getDatabase().getNewId());
                            bl = statement.executeUpdate() != 1;
                        }
                        catch (Exception exception) {
                            if (n2 != 0) break block28;
                            throw exception;
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inputStream = null;
                }
                if (bl) {
                    log.error("Could not upgrade saved report " + file2.getCanonicalPath());
                    continue;
                }
                if (log.isTraceOn()) {
                    log.trace("Removing old saved report file " + file2.getCanonicalPath());
                }
                file2.delete();
                continue;
            }
            catch (Exception exception) {
                log.error("Problem upgrading saved reports.", (Throwable)exception);
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                continue;
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        }
        try {
            if (log.isTraceOn()) {
                log.trace("Removing old saved report directory " + file.getCanonicalPath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        file.delete();
    }

    public void upgradeSavedReports(Connection connection) {
        this.updateSavedReports(connection, this.getOldReportsDirectory(), "public");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveReport(String string, String string2, String string3, byte[] byArray) throws IOException {
        Object object;
        int n = -1;
        boolean bl = false;
        Connection connection = this.getDatabase().getConnection();
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            object = "select REPORT_ID from " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where REPORT_USER=" + Dbx.str2db(string != null ? string : "public") + " and PUBLIC_REPORT=" + (string == null ? 1 : 0) + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db(string3);
            resultSet = statement.executeQuery((String)object);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            log.error("Problem checking for saved report of same name.", (Throwable)sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    log.error("Cannot close result set", (Throwable)sQLException);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    log.error("Cannot close statement", (Throwable)sQLException);
                }
            }
        }
        object = null;
        InputStream inputStream = null;
        if (bl) {
            try {
                object = connection.prepareStatement("update " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " SET REPORT_DATA = ? where REPORT_ID=" + n);
                inputStream = new ByteArrayInputStream(byArray);
                object.setBinaryStream(1, inputStream, inputStream.available());
                object.executeUpdate();
            }
            catch (SQLException sQLException) {
                log.error("Problem updating saved report.", (Throwable)sQLException);
            }
        } else {
            try {
                object = connection.prepareStatement("insert into " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " (REPORT_ID, PUBLIC_REPORT, REPORT_USER, REPORT_NAME, REPORT_TYPE, REPORT_DATA) VALUES (?, ?, ?, ?, ?, ?)");
                object.setInt(2, string == null ? 1 : 0);
                object.setString(3, string != null ? string : "public");
                object.setString(4, string2);
                object.setString(5, string3);
                boolean bl2 = true;
                int n2 = 10;
                while (bl2 && --n2 >= 0) {
                    block40: {
                        inputStream = new ByteArrayInputStream(byArray);
                        object.setBinaryStream(6, inputStream, inputStream.available());
                        try {
                            object.setInt(1, this.getDatabase().getNewId());
                            bl2 = object.executeUpdate() != 1;
                        }
                        catch (Exception exception) {
                            if (n2 != 0) break block40;
                            throw exception;
                        }
                    }
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    inputStream = null;
                }
                if (bl2) {
                    log.error("Could not save report " + string2);
                }
            }
            catch (Exception exception) {
                log.error("Problem creating saved report.", (Throwable)exception);
            }
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (object != null) {
            try {
                object.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            connection.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.getDatabase().freeConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] loadReport(String string, String string2, String string3) throws IOException {
        byte[] byArray;
        block41: {
            BufferedInputStream bufferedInputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            Statement statement;
            ResultSet resultSet;
            Connection connection;
            block32: {
                int n;
                byArray = null;
                connection = null;
                resultSet = null;
                statement = null;
                byteArrayOutputStream = null;
                bufferedInputStream = null;
                connection = this.getDatabase().getConnection();
                statement = connection.createStatement();
                String string4 = "select REPORT_DATA from " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where REPORT_USER=" + Dbx.str2db(string != null ? string : "public") + " and PUBLIC_REPORT=" + (string == null ? 1 : 0) + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db(string3);
                resultSet = statement.executeQuery(string4);
                if (resultSet.next()) {
                    int n2;
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    bufferedInputStream = new BufferedInputStream(resultSet.getBinaryStream(1));
                    byte[] byArray2 = new byte[1024];
                    while ((n2 = bufferedInputStream.read(byArray2, 0, byArray2.length)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n2);
                    }
                    byArray = byteArrayOutputStream.toByteArray();
                    break block32;
                }
                string4 = "select REPORT_DATA from " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where PUBLIC_REPORT=1" + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db(string3);
                resultSet = statement.executeQuery(string4);
                if (!resultSet.next()) break block32;
                byteArrayOutputStream = new ByteArrayOutputStream();
                bufferedInputStream = new BufferedInputStream(resultSet.getBinaryStream(1));
                byte[] byArray3 = new byte[1024];
                while ((n = bufferedInputStream.read(byArray3, 0, byArray3.length)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
            }
            Object var14_16 = null;
            try {
                byteArrayOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException exception) {
                    log.error("Cannot close result set", (Throwable)exception);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException exception) {
                    log.error("Cannot close statement", (Throwable)exception);
                }
            }
            if (connection != null) {
                this.getDatabase().freeConnection(connection);
            }
            break block41;
            {
                catch (SQLException sQLException) {
                    log.error("Problem loading saved report " + string2, (Throwable)sQLException);
                    Object var14_17 = null;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException exception) {
                            log.error("Cannot close result set", (Throwable)exception);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException exception) {
                            log.error("Cannot close statement", (Throwable)exception);
                        }
                    }
                    if (connection != null) {
                        this.getDatabase().freeConnection(connection);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException exception) {
                        log.error("Cannot close result set", (Throwable)exception);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException exception) {
                        log.error("Cannot close statement", (Throwable)exception);
                    }
                }
                if (connection != null) {
                    this.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean deleteReport(BUser bUser, String string, String string2, String string3) {
        block28: {
            SQLException sQLException222;
            boolean bl;
            Statement statement;
            ResultSet resultSet;
            Connection connection;
            block23: {
                boolean bl2 = string == null;
                BPermissions bPermissions = bUser.getPermissionsFor((BIProtected)this);
                if (bl2 && !bPermissions.hasAdminWrite()) {
                    return false;
                }
                connection = null;
                resultSet = null;
                statement = null;
                connection = this.getDatabase().getConnection();
                statement = connection.createStatement();
                String string4 = "delete from " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where REPORT_USER=" + Dbx.str2db(string != null ? string : "public") + " and PUBLIC_REPORT=" + (string == null ? 1 : 0) + " and REPORT_NAME=" + Dbx.str2db(string2) + " and REPORT_TYPE=" + Dbx.str2db(string3);
                statement.executeUpdate(string4);
                bl = true;
                Object var13_13 = null;
                if (resultSet == null) break block23;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException222) {
                    log.error("Cannot close result set", (Throwable)sQLException222);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException222) {
                    log.error("Cannot close statement", (Throwable)sQLException222);
                }
            }
            if (connection != null) {
                try {
                    connection.commit();
                }
                catch (SQLException sQLException222) {
                    // empty catch block
                }
                this.getDatabase().freeConnection(connection);
            }
            return bl;
            catch (SQLException sQLException3) {
                SQLException sQLException4222;
                block26: {
                    try {
                        log.error("Problem deleting saved report " + string2, (Throwable)sQLException3);
                        Object var13_14 = null;
                        if (resultSet == null) break block26;
                    }
                    catch (Throwable throwable) {
                        SQLException sQLException5222;
                        Object var13_15 = null;
                        if (resultSet != null) {
                            try {
                                resultSet.close();
                            }
                            catch (SQLException sQLException5222) {
                                log.error("Cannot close result set", (Throwable)sQLException5222);
                            }
                        }
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException sQLException5222) {
                                log.error("Cannot close statement", (Throwable)sQLException5222);
                            }
                        }
                        if (connection != null) {
                            try {
                                connection.commit();
                            }
                            catch (SQLException sQLException5222) {
                                // empty catch block
                            }
                            this.getDatabase().freeConnection(connection);
                        }
                        throw throwable;
                    }
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException4222) {
                        log.error("Cannot close result set", (Throwable)sQLException4222);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException4222) {
                        log.error("Cannot close statement", (Throwable)sQLException4222);
                    }
                }
                if (connection == null) break block28;
                try {
                    connection.commit();
                }
                catch (SQLException sQLException4222) {
                    // empty catch block
                }
                this.getDatabase().freeConnection(connection);
                {
                }
            }
        }
        return false;
    }

    public Hashtable getReports(String string, BUser bUser, boolean bl, boolean bl2) {
        int n;
        int n2 = n = bl ? 16 : 8;
        if (string == null) {
            n *= 9;
        }
        Hashtable hashtable = new Hashtable(n);
        this.appendReports(hashtable, string, bUser, bl, bl2);
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void appendReports(Hashtable hashtable, String string, BUser bUser, boolean bl, boolean bl2) {
        block33: {
            SQLException sQLException2222;
            Statement statement;
            ResultSet resultSet;
            Connection connection;
            block30: {
                Vector<String> vector;
                String string2;
                String string3;
                StringBuffer stringBuffer;
                connection = null;
                resultSet = null;
                statement = null;
                connection = this.getDatabase().getConnection();
                statement = connection.createStatement();
                if (bl) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("select REPORT_NAME, REPORT_TYPE from " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where PUBLIC_REPORT=1");
                    if (string != null) {
                        stringBuffer.append(" and REPORT_TYPE=" + Dbx.str2db(string));
                    }
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        string2 = resultSet.getString(2);
                        vector = (Vector<String>)hashtable.get(string2);
                        if (vector == null) {
                            vector = new Vector<String>(10);
                            hashtable.put(string2, vector);
                        }
                        vector.addElement(string3);
                    }
                }
                if (bl2 && bUser != null) {
                    stringBuffer = new StringBuffer();
                    stringBuffer.append("select REPORT_NAME, REPORT_TYPE from " + this.getDatabase().getDBSpecific().getFullTableName("EAS", "SAVED_REPORTS") + " where PUBLIC_REPORT=0" + " and REPORT_USER=" + Dbx.str2db(bUser.getUsername()));
                    if (string != null) {
                        stringBuffer.append(" and REPORT_TYPE=" + Dbx.str2db(string));
                    }
                    resultSet = statement.executeQuery(stringBuffer.toString());
                    while (resultSet.next()) {
                        string3 = resultSet.getString(1);
                        string2 = resultSet.getString(2);
                        vector = (Vector<String>)hashtable.get(string2);
                        if (vector == null) {
                            vector = new Vector<String>(10);
                            hashtable.put(string2, vector);
                        }
                        vector.addElement(string3);
                    }
                }
                Object var14_14 = null;
                if (resultSet == null) break block30;
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException2222) {
                    log.error("Cannot close result set", (Throwable)sQLException2222);
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException2222) {
                    log.error("Cannot close statement", (Throwable)sQLException2222);
                }
            }
            if (connection == null) break block33;
            try {
                connection.commit();
            }
            catch (SQLException sQLException2222) {
                // empty catch block
            }
            this.getDatabase().freeConnection(connection);
            {
                break block33;
                catch (SQLException sQLException3) {
                    SQLException sQLException42222;
                    log.error("Problem finding reports", (Throwable)sQLException3);
                    Object var14_15 = null;
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException42222) {
                            log.error("Cannot close result set", (Throwable)sQLException42222);
                        }
                    }
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException sQLException42222) {
                            log.error("Cannot close statement", (Throwable)sQLException42222);
                        }
                    }
                    if (connection == null) break block33;
                    try {
                        connection.commit();
                    }
                    catch (SQLException sQLException42222) {
                        // empty catch block
                    }
                    this.getDatabase().freeConnection(connection);
                }
            }
            catch (Throwable throwable) {
                SQLException sQLException52222;
                Object var14_16 = null;
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException52222) {
                        log.error("Cannot close result set", (Throwable)sQLException52222);
                    }
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException sQLException52222) {
                        log.error("Cannot close statement", (Throwable)sQLException52222);
                    }
                }
                if (connection != null) {
                    try {
                        connection.commit();
                    }
                    catch (SQLException sQLException52222) {
                        // empty catch block
                    }
                    this.getDatabase().freeConnection(connection);
                }
                throw throwable;
            }
        }
    }

    public final void doGet(WebOp webOp) throws Exception {
        BEasReport bEasReport;
        if (!this.isEasLicensed() || this.isDisabled() || this.isFatalFault()) {
            webOp.getResponse().sendError(405, "Get");
            return;
        }
        String string = this.stripServletPrefix(webOp.getRequest().getRequestURI());
        if (log.isTraceOn()) {
            log.trace("***********************************************");
            log.trace("Processing EasService doGet request with the following");
            log.trace("   Method: " + webOp.getRequest().getMethod());
            log.trace("   PathInfo: " + webOp.getRequest().getPathInfo());
            log.trace("   PathTranslated: " + webOp.getRequest().getPathTranslated());
            log.trace("   ContextPath: " + webOp.getRequest().getContextPath());
            log.trace("   QueryString: " + webOp.getRequest().getQueryString());
            log.trace("   RemoteUser: " + webOp.getRequest().getRemoteUser());
            log.trace("   RequestedSessionId: " + webOp.getRequest().getRequestedSessionId());
            log.trace("   RequestURI: " + webOp.getRequest().getRequestURI());
            log.trace("   RequestURL: " + webOp.getRequest().getRequestURL().toString());
            log.trace("   ServletPath: " + webOp.getRequest().getServletPath());
            log.trace("   easRequestUri: " + string);
            log.trace("***********************************************");
        }
        if ((bEasReport = this.getReports().getReportByUri(string)) != null) {
            bEasReport.doGet(webOp);
        } else {
            this.servlet.doGet(webOp);
        }
    }

    public final void doPost(WebOp webOp) throws Exception {
        BEasReport bEasReport;
        if (!this.isEasLicensed() || this.isDisabled() || this.isFatalFault()) {
            webOp.getResponse().sendError(405, "Post");
            return;
        }
        String string = this.stripServletPrefix(webOp.getRequest().getRequestURI());
        if (log.isTraceOn()) {
            log.trace("***********************************************");
            log.trace("Processing EasService doPost request with the following");
            log.trace("   Method: " + webOp.getRequest().getMethod());
            log.trace("   PathInfo: " + webOp.getRequest().getPathInfo());
            log.trace("   PathTranslated: " + webOp.getRequest().getPathTranslated());
            log.trace("   ContextPath: " + webOp.getRequest().getContextPath());
            log.trace("   QueryString: " + webOp.getRequest().getQueryString());
            log.trace("   RemoteUser: " + webOp.getRequest().getRemoteUser());
            log.trace("   RequestedSessionId: " + webOp.getRequest().getRequestedSessionId());
            log.trace("   RequestURI: " + webOp.getRequest().getRequestURI());
            log.trace("   RequestURL: " + webOp.getRequest().getRequestURL().toString());
            log.trace("   ServletPath: " + webOp.getRequest().getServletPath());
            log.trace("   easRequestUri: " + string);
            log.trace("***********************************************");
        }
        if ((bEasReport = this.getReports().getReportByUri(string)) != null) {
            bEasReport.doPost(webOp);
        } else {
            this.servlet.doPost(webOp);
        }
    }

    private String stripServletPrefix(String string) {
        String string2 = string;
        if (string.startsWith("/" + this.getServletName())) {
            string2 = string.substring(this.getServletName().length() + 1);
        } else if (string.startsWith(this.getServletName())) {
            string2 = string.substring(this.getServletName().length());
        }
        if (string2.length() > 1 && string2.endsWith("/")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public boolean isCustomRateComponentUnlocked(String string) {
        return this.getVisibleCustomRateComponents().includes(string);
    }

    public final BEasReport[] getReportList() {
        return (BEasReport[])this.getReports().getChildren(class$com$tridium$eas$BEasReport == null ? (class$com$tridium$eas$BEasReport = BEasService.class$("com.tridium.eas.BEasReport")) : class$com$tridium$eas$BEasReport);
    }

    public EasServerDxSession getEasServerSession() {
        return this.easServerSession;
    }

    public static BUser getUser(String string) {
        if (string == null || string.length() == 0) {
            return BUserService.getService().getGuestUser();
        }
        return BUserService.getService().getUser(string);
    }

    public final boolean isEasStationLicensed(BIHistory bIHistory) {
        block8: {
            if (bIHistory == null) {
                return false;
            }
            try {
                BOrd bOrd;
                BObject bObject;
                BHistoryConfig bHistoryConfig = bIHistory.getConfig();
                BOrdList bOrdList = bHistoryConfig.getSource();
                if (bOrdList.size() <= 0 || !(bObject = (bOrd = bOrdList.get(bOrdList.size() - 1)).get((BObject)this)).isComplex()) break block8;
                for (BComplex bComplex = bObject.asComplex(); bComplex != null; bComplex = bComplex.getParent()) {
                    if (!BEasStationConfig.isAcceptedHistorySource(bComplex)) continue;
                    if (bComplex instanceof NiagaraStation) {
                        try {
                            BNiagaraNetwork bNiagaraNetwork;
                            NiagaraStation niagaraStation;
                            String string = bIHistory.getId().getDeviceName();
                            if (!string.equals(((NiagaraStation)bComplex).getStationName()) && (niagaraStation = (bNiagaraNetwork = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE)).getStation(string)) != null) {
                                bComplex = (BComplex)niagaraStation;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return registeredStations.contains((Object)bComplex);
                }
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block8;
                log.trace("Cannot determine if covered under station.limit for history " + bIHistory.getId(), (Throwable)exception);
            }
        }
        return false;
    }

    public final int getLicensedStationCount() {
        return licensedEasStations;
    }

    public final int getEasStationCount() {
        return registeredStations.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean registerEasStation(BEasStationConfig bEasStationConfig) {
        if (bEasStationConfig.registeredSource != null) {
            return true;
        }
        BComplex bComplex = bEasStationConfig.getParent();
        if (!BEasStationConfig.isAcceptedHistorySource(bComplex)) {
            return false;
        }
        Array array = registeredStations;
        synchronized (array) {
            if (registeredStations.size() >= licensedEasStations) {
                return false;
            }
            registeredStations.add((Object)bComplex);
            bEasStationConfig.registeredSource = bComplex;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unregisterEasStation(BEasStationConfig bEasStationConfig, Context context) {
        if (bEasStationConfig.registeredSource == null) {
            return;
        }
        Array array = registeredStations;
        synchronized (array) {
            registeredStations.remove((Object)bEasStationConfig.registeredSource);
            bEasStationConfig.registeredSource = null;
        }
        if (SHUTDOWN_CONTEXT != context) {
            this.registerStations(bEasStationConfig);
        }
    }

    private void registerStations(BEasStationConfig bEasStationConfig) {
        BOrd bOrd = BOrd.make((String)"station:|slot:/|bql:select from eas:EasStationConfig");
        BICollection bICollection = (BICollection)bOrd.resolve().get();
        Cursor cursor = bICollection.cursor();
        while (cursor.next()) {
            BEasStationConfig bEasStationConfig2 = (BEasStationConfig)cursor.get();
            if (bEasStationConfig2 != bEasStationConfig) {
                bEasStationConfig2.register(this);
            }
            if (bEasStationConfig == null || registeredStations.size() < licensedEasStations) continue;
            break;
        }
    }

    private void unregisterStations() {
        BOrd bOrd = BOrd.make((String)"station:|slot:/|bql:select from eas:EasStationConfig");
        BICollection bICollection = (BICollection)bOrd.resolve().get();
        Cursor cursor = bICollection.cursor();
        while (cursor.next()) {
            ((BEasStationConfig)cursor.get()).unregister(this, SHUTDOWN_CONTEXT);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

