/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.ui;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.point.BEnumBitsPoint;
import com.tridium.modbusCore.point.BEnumBitsWritable;
import com.tridium.modbusCore.point.BIModbusBooleanProxyExt;
import com.tridium.modbusCore.point.BIModbusEnumBitsProxyExt;
import com.tridium.modbusCore.point.BIModbusNumericBitsProxyExt;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import com.tridium.modbusCore.point.BIModbusReadProxyExt;
import com.tridium.modbusCore.point.BIModbusRegisterBitProxyExt;
import com.tridium.modbusCore.point.BIModbusStringProxyExt;
import com.tridium.modbusCore.point.BModbusProxyExt;
import com.tridium.modbusCore.point.BNumericBitsPoint;
import com.tridium.modbusCore.point.BNumericBitsWritable;
import com.tridium.modbusCore.point.BRegisterBitPoint;
import com.tridium.modbusCore.point.BRegisterBitWritable;
import java.util.ArrayList;
import java.util.List;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BControlPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.data.BIDataValue;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.ui.point.BPointManager;
import javax.baja.driver.ui.point.PointController;
import javax.baja.driver.ui.point.PointModel;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusPointManager
extends BPointManager {
    public static final Type TYPE;
    static final Lexicon superLexicon;
    static final UiLexicon lexicon;
    static Lexicon driverLex;
    static String lexOut;
    MgrColumn colPath;
    MgrColumn colName;
    MgrColumn colType;
    MgrColumn colValue;
    MgrColumn colPollFreq;
    MgrColumn colDataAddress;
    MgrColumn colRegType;
    MgrColumn colDataType;
    MgrColumn colStatusType;
    MgrColumn colBitNumber;
    MgrColumn colBeginningBit;
    MgrColumn colNumberOfBits;
    MgrColumn colDeviceFacets;
    MgrColumn colFacets;
    MgrColumn colConversion;
    MgrColumn colEnabled;
    MgrColumn colDeviceValue;
    MgrColumn colExeResult;
    MgrColumn colTuning;
    MgrColumn colAbsAddress;
    MgrColumn colDataSource;
    MgrColumn colFaultCause;
    MgrColumn colNumRegisters;
    MgrColumn[] modbusCols;
    MgrColumn[] modbusSlaveCols;
    static /* synthetic */ Class class$com$tridium$modbusCore$ui$BModbusPointManager;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController;

    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new ModbusPointModel(this);
    }

    protected MgrController makeController() {
        return new ModbusPointController(this);
    }

    protected boolean isModbusSlave() {
        return false;
    }

    protected BAbstractProxyExt makeModbusRegisterBitExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusBooleanExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusEnumBitsExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusNumericExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusNumericBitsExt() {
        return new BNullProxyExt();
    }

    protected BAbstractProxyExt makeModbusStringExt() {
        return new BNullProxyExt();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.colPath = new MgrColumn.Path(2);
        this.colName = new MgrColumn.Name();
        this.colType = new ModbusType(3);
        this.colValue = new MgrColumn.ToString(lexOut, 0);
        this.colPollFreq = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.pollFrequency}, 3);
        this.colDataAddress = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.dataAddress}, 3);
        this.colRegType = new ModbusRegType();
        this.colDataType = new ModbusDataType();
        this.colStatusType = new ModbusStatusType();
        this.colBitNumber = new ModbusBitNumber();
        this.colBeginningBit = new ModbusBeginningBit();
        this.colNumberOfBits = new ModbusNumberOfBits();
        this.colDeviceFacets = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.deviceFacets}, 3);
        this.colFacets = new MgrColumn.Prop(BControlPoint.facets, 3);
        this.colConversion = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BModbusProxyExt.conversion}, 3);
        this.colEnabled = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.enabled}, 3);
        this.colDeviceValue = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.readValue}, 2);
        this.colExeResult = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.writeValue}, 2);
        this.colTuning = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.tuningPolicyName}, 3);
        this.colAbsAddress = new ModbusAbsAddress();
        this.colDataSource = new ModbusDataSource();
        this.colFaultCause = new MgrColumn.PropPath(new Property[]{BControlPoint.proxyExt, BProxyExt.faultCause}, 2);
        this.colNumRegisters = new ModbusNumRegisters();
        this.modbusCols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colTuning, this.colAbsAddress, this.colFaultCause, this.colPollFreq, this.colDataAddress, this.colRegType, this.colDataType, this.colStatusType, this.colBitNumber, this.colBeginningBit, this.colNumberOfBits, this.colDataSource, this.colNumRegisters, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult};
        this.modbusSlaveCols = new MgrColumn[]{this.colPath, this.colName, this.colType, this.colValue, this.colEnabled, this.colTuning, this.colPollFreq, this.colDataAddress, this.colFaultCause, this.colRegType, this.colDataType, this.colStatusType, this.colBitNumber, this.colBeginningBit, this.colNumberOfBits, this.colDeviceFacets, this.colFacets, this.colConversion, this.colDeviceValue, this.colExeResult};
    }

    public BModbusPointManager() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusCore$ui$BModbusPointManager;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$ui$BModbusPointManager = BModbusPointManager.class("[Lcom.tridium.modbusCore.ui.BModbusPointManager;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        Class clazz2 = class$javax$baja$workbench$mgr$MgrController;
        if (clazz2 == null) {
            clazz2 = class$javax$baja$workbench$mgr$MgrController = BModbusPointManager.class("[Ljavax.baja.workbench.mgr.MgrController;", false);
        }
        superLexicon = Lexicon.make((Class)clazz2);
        Class clazz3 = class$com$tridium$modbusCore$ui$BModbusPointManager;
        if (clazz3 == null) {
            clazz3 = class$com$tridium$modbusCore$ui$BModbusPointManager = BModbusPointManager.class("[Lcom.tridium.modbusCore.ui.BModbusPointManager;", false);
        }
        lexicon = new UiLexicon(clazz3);
        driverLex = Lexicon.make((String)"driver");
        lexOut = driverLex.getText("out");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ModbusPointModel
    extends PointModel {
        protected MgrColumn[] makeColumns() {
            if (BModbusPointManager.this.isModbusSlave()) {
                return BModbusPointManager.this.modbusSlaveCols;
            }
            return BModbusPointManager.this.modbusCols;
        }

        public MgrTypeInfo[] getNewTypes() {
            ArrayList arrayList = new ArrayList();
            ModbusPointModel.addBooleanPointTypes(arrayList, (boolean)true);
            ModbusPointModel.addNumericPointTypes(arrayList, (boolean)true);
            this.addRegisterBitPointTypes(arrayList, true);
            if (!BModbusPointManager.this.isModbusSlave()) {
                ModbusPointModel.addStringPointTypes(arrayList, (boolean)false);
                this.addEnumBitsPointTypes(arrayList, true);
                this.addNumericBitsPointTypes(arrayList, true);
            }
            return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
        }

        public void addEnumBitsPointTypes(List list, boolean bl) {
            if (bl) {
                list.add(MgrTypeInfo.make((TypeInfo)BEnumBitsWritable.TYPE.getTypeInfo()));
            }
            list.add(MgrTypeInfo.make((TypeInfo)BEnumBitsPoint.TYPE.getTypeInfo()));
        }

        public void addNumericBitsPointTypes(List list, boolean bl) {
            if (bl) {
                list.add(MgrTypeInfo.make((TypeInfo)BNumericBitsWritable.TYPE.getTypeInfo()));
            }
            list.add(MgrTypeInfo.make((TypeInfo)BNumericBitsPoint.TYPE.getTypeInfo()));
        }

        public void addRegisterBitPointTypes(List list, boolean bl) {
            if (bl) {
                list.add(MgrTypeInfo.make((TypeInfo)BRegisterBitWritable.TYPE.getTypeInfo()));
            }
            list.add(MgrTypeInfo.make((TypeInfo)BRegisterBitPoint.TYPE.getTypeInfo()));
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
            BBooleanPoint bBooleanPoint = null;
            BNullProxyExt bNullProxyExt = new BNullProxyExt();
            if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((TypeInfo)BRegisterBitPoint.TYPE.getTypeInfo()))) {
                bBooleanPoint = new BBooleanPoint();
                bNullProxyExt = BModbusPointManager.this.makeModbusRegisterBitExt();
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((TypeInfo)BRegisterBitWritable.TYPE.getTypeInfo()))) {
                bBooleanPoint = new BBooleanWritable();
                bNullProxyExt = BModbusPointManager.this.makeModbusRegisterBitExt();
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((TypeInfo)BEnumBitsPoint.TYPE.getTypeInfo()))) {
                bBooleanPoint = new BEnumPoint();
                bNullProxyExt = BModbusPointManager.this.makeModbusEnumBitsExt();
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((TypeInfo)BEnumBitsWritable.TYPE.getTypeInfo()))) {
                bBooleanPoint = new BEnumWritable();
                bNullProxyExt = BModbusPointManager.this.makeModbusEnumBitsExt();
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((TypeInfo)BNumericBitsPoint.TYPE.getTypeInfo()))) {
                bBooleanPoint = new BNumericPoint();
                bNullProxyExt = BModbusPointManager.this.makeModbusNumericBitsExt();
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((TypeInfo)BNumericBitsWritable.TYPE.getTypeInfo()))) {
                bBooleanPoint = new BNumericWritable();
                bNullProxyExt = BModbusPointManager.this.makeModbusNumericBitsExt();
            } else {
                bBooleanPoint = (BControlPoint)mgrTypeInfo.newInstance();
                if (bBooleanPoint instanceof BBooleanPoint) {
                    bNullProxyExt = BModbusPointManager.this.makeModbusBooleanExt();
                } else if (bBooleanPoint instanceof BNumericPoint) {
                    bNullProxyExt = BModbusPointManager.this.makeModbusNumericExt();
                } else if (bBooleanPoint instanceof BStringPoint) {
                    bNullProxyExt = BModbusPointManager.this.makeModbusStringExt();
                }
            }
            BFacets bFacets = (BFacets)bBooleanPoint.getFacets().newCopy();
            ((BProxyExt)bNullProxyExt).setDeviceFacets(bFacets);
            bBooleanPoint.setProxyExt((BAbstractProxyExt)bNullProxyExt);
            return bBooleanPoint;
        }

        public BComponent newInstance(MgrTypeInfo mgrTypeInfo, BFlexAddress bFlexAddress, int n, BDataTypeEnum bDataTypeEnum) throws Exception {
            BBooleanPoint bBooleanPoint = null;
            BNullProxyExt bNullProxyExt = new BNullProxyExt();
            if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BRegisterBitPoint.TYPE))) {
                bBooleanPoint = new BBooleanPoint();
                bNullProxyExt = BModbusPointManager.this.makeModbusRegisterBitExt();
                BFlexAddress bFlexAddress2 = new BFlexAddress();
                bFlexAddress2.setAddressFormat(bFlexAddress.getAddressFormat());
                bFlexAddress2.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n / 16);
                ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress2);
                ((BIModbusRegisterBitProxyExt)bNullProxyExt).setBitNumber(n % 16);
                if (bFlexAddress2.isModbusFormat()) {
                    if (bFlexAddress2.isModbusHoldingAddress()) {
                        ((BIModbusRegisterBitProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                    } else if (bFlexAddress2.isModbusInputAddress()) {
                        ((BIModbusRegisterBitProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BRegisterBitWritable.TYPE))) {
                bBooleanPoint = new BBooleanWritable();
                bNullProxyExt = BModbusPointManager.this.makeModbusRegisterBitExt();
                BFlexAddress bFlexAddress3 = new BFlexAddress();
                bFlexAddress3.setAddressFormat(bFlexAddress.getAddressFormat());
                bFlexAddress3.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n / 16);
                ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress3);
                ((BIModbusRegisterBitProxyExt)bNullProxyExt).setBitNumber(n % 16);
                if (bFlexAddress3.isModbusFormat()) {
                    if (bFlexAddress3.isModbusHoldingAddress()) {
                        ((BIModbusRegisterBitProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                    } else if (bFlexAddress3.isModbusInputAddress()) {
                        ((BIModbusRegisterBitProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BEnumBitsPoint.TYPE))) {
                bBooleanPoint = new BEnumPoint();
                bNullProxyExt = BModbusPointManager.this.makeModbusEnumBitsExt();
                BFlexAddress bFlexAddress4 = new BFlexAddress();
                bFlexAddress4.setAddressFormat(bFlexAddress.getAddressFormat());
                bFlexAddress4.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n / 16);
                ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress4);
                ((BIModbusNumericBitsProxyExt)bNullProxyExt).setBeginningBit(n % 16);
                if (bFlexAddress4.isModbusFormat()) {
                    if (bFlexAddress4.isModbusHoldingAddress()) {
                        ((BIModbusNumericBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                    } else if (bFlexAddress4.isModbusInputAddress()) {
                        ((BIModbusNumericBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BEnumBitsWritable.TYPE))) {
                bBooleanPoint = new BEnumWritable();
                bNullProxyExt = BModbusPointManager.this.makeModbusEnumBitsExt();
                BFlexAddress bFlexAddress5 = new BFlexAddress();
                bFlexAddress5.setAddressFormat(bFlexAddress.getAddressFormat());
                bFlexAddress5.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n / 16);
                ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress5);
                ((BIModbusEnumBitsProxyExt)bNullProxyExt).setBeginningBit(n % 16);
                if (bFlexAddress5.isModbusFormat()) {
                    if (bFlexAddress5.isModbusHoldingAddress()) {
                        ((BIModbusEnumBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                    } else if (bFlexAddress5.isModbusInputAddress()) {
                        ((BIModbusEnumBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BNumericBitsPoint.TYPE))) {
                bBooleanPoint = new BNumericPoint();
                bNullProxyExt = BModbusPointManager.this.makeModbusNumericBitsExt();
                BFlexAddress bFlexAddress6 = new BFlexAddress();
                bFlexAddress6.setAddressFormat(bFlexAddress.getAddressFormat());
                bFlexAddress6.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n / 16);
                ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress6);
                ((BIModbusNumericBitsProxyExt)bNullProxyExt).setBeginningBit(n % 16);
                if (bFlexAddress6.isModbusFormat()) {
                    if (bFlexAddress6.isModbusHoldingAddress()) {
                        ((BIModbusNumericBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                    } else if (bFlexAddress6.isModbusInputAddress()) {
                        ((BIModbusNumericBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BNumericBitsWritable.TYPE))) {
                bBooleanPoint = new BNumericWritable();
                bNullProxyExt = BModbusPointManager.this.makeModbusNumericBitsExt();
                BFlexAddress bFlexAddress7 = new BFlexAddress();
                bFlexAddress7.setAddressFormat(bFlexAddress.getAddressFormat());
                bFlexAddress7.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n / 16);
                ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress7);
                ((BIModbusNumericBitsProxyExt)bNullProxyExt).setBeginningBit(n % 16);
                if (bFlexAddress7.isModbusFormat()) {
                    if (bFlexAddress7.isModbusHoldingAddress()) {
                        ((BIModbusNumericBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                    } else if (bFlexAddress7.isModbusInputAddress()) {
                        ((BIModbusNumericBitsProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                    }
                }
            } else {
                bBooleanPoint = (BControlPoint)mgrTypeInfo.newInstance();
                if (bBooleanPoint instanceof BBooleanPoint) {
                    bNullProxyExt = BModbusPointManager.this.makeModbusBooleanExt();
                    BFlexAddress bFlexAddress8 = new BFlexAddress();
                    bFlexAddress8.setAddressFormat(bFlexAddress.getAddressFormat());
                    bFlexAddress8.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n);
                    ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress8);
                    if (bFlexAddress8.isModbusFormat()) {
                        if (bFlexAddress8.isModbusCoilAddress()) {
                            ((BIModbusBooleanProxyExt)bNullProxyExt).setStatusType(BStatusTypeEnum.coil);
                        } else if (bFlexAddress8.isModbusStatusAddress()) {
                            ((BIModbusBooleanProxyExt)bNullProxyExt).setStatusType(BStatusTypeEnum.input);
                        }
                    }
                } else if (bBooleanPoint instanceof BNumericPoint) {
                    bNullProxyExt = BModbusPointManager.this.makeModbusNumericExt();
                    BFlexAddress bFlexAddress9 = new BFlexAddress();
                    bFlexAddress9.setAddressFormat(bFlexAddress.getAddressFormat());
                    if (bDataTypeEnum.equals((Object)BDataTypeEnum.floatType) || bDataTypeEnum.equals((Object)BDataTypeEnum.longType)) {
                        bFlexAddress9.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n * 2);
                    } else {
                        bFlexAddress9.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n);
                    }
                    ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress9);
                    ((BIModbusNumericProxyExt)bNullProxyExt).setDataType(bDataTypeEnum);
                    if (bFlexAddress9.isModbusFormat()) {
                        if (bFlexAddress9.isModbusHoldingAddress()) {
                            ((BIModbusNumericProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.holding);
                        } else if (bFlexAddress9.isModbusInputAddress()) {
                            ((BIModbusNumericProxyExt)bNullProxyExt).setRegType(BRegisterTypeEnum.input);
                        }
                    }
                } else if (bBooleanPoint instanceof BStringPoint) {
                    bNullProxyExt = BModbusPointManager.this.makeModbusStringExt();
                    BFlexAddress bFlexAddress10 = new BFlexAddress();
                    bFlexAddress10.setAddressFormat(bFlexAddress.getAddressFormat());
                    bFlexAddress10.setAddressFromInt(bFlexAddress.getDataAddressNoModbusAltering() + n);
                    ((BModbusProxyExt)bNullProxyExt).setDataAddress(bFlexAddress10);
                }
            }
            BFacets bFacets = (BFacets)bBooleanPoint.getFacets().newCopy();
            ((BProxyExt)bNullProxyExt).setDeviceFacets(bFacets);
            bBooleanPoint.setProxyExt((BAbstractProxyExt)bNullProxyExt);
            return bBooleanPoint;
        }

        ModbusPointModel(BModbusPointManager bModbusPointManager2) {
            super((BPointManager)bModbusPointManager2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ModbusPointController
    extends PointController {
        String errorMsg;

        public MgrEdit promptForNew(Context context) throws Exception {
            MgrTypeInfo[] mgrTypeInfoArray = this.getManager().getModel().getNewTypes();
            if (mgrTypeInfoArray == null) {
                BDialog.error((BWidget)this.getManager(), (Object)"Must override BAbstractManager.getNewTypes()");
                return null;
            }
            BListDropDown bListDropDown = new BListDropDown();
            int n = 0;
            while (n < mgrTypeInfoArray.length) {
                bListDropDown.getList().addItem((Object)mgrTypeInfoArray[n]);
                ++n;
            }
            bListDropDown.setSelectedIndex(0);
            BTextField bTextField = new BTextField("1", 6);
            BFlexAddress bFlexAddress = new BFlexAddress();
            bFlexAddress.setAddressFormat(BAddressFormatEnum.modbus);
            BWbFieldEditor bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bFlexAddress);
            bWbFieldEditor.loadValue((BObject)bFlexAddress);
            BListDropDown bListDropDown2 = new BListDropDown();
            int[] nArray = BDataTypeEnum.integerType.getRange().getOrdinals();
            String[] stringArray = new String[nArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringArray[n2] = BDataTypeEnum.integerType.getRange().get(nArray[n2]).getTag();
                ++n2;
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                bListDropDown2.getList().addItem((Object)stringArray[n2]);
                ++n2;
            }
            bListDropDown2.setSelectedIndex(0);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel(superLexicon.getText("add.type")));
            bGridPane.add(null, (BValue)bListDropDown);
            bGridPane.add(null, (BValue)new BLabel(superLexicon.getText("add.count")));
            bGridPane.add(null, (BValue)bTextField);
            bGridPane.add(null, (BValue)new BLabel(lexicon.getText("pointManager.add.startAddress")));
            bGridPane.add(null, (BValue)bWbFieldEditor);
            bGridPane.add(null, (BValue)new BLabel(lexicon.getText("pointManager.add.dataType")));
            bGridPane.add(null, (BValue)bListDropDown2);
            String string = this.newCommand.getLabel();
            MgrTypeInfo mgrTypeInfo = null;
            int n3 = 0;
            BFlexAddress bFlexAddress2 = null;
            BDataTypeEnum bDataTypeEnum = null;
            boolean bl = false;
            while (!bl) {
                int n4 = BDialog.open((BWidget)this.getManager(), (String)string, (Object)bGridPane, (int)3);
                if (n4 == 2) {
                    return null;
                }
                mgrTypeInfo = (MgrTypeInfo)bListDropDown.getSelectedItem();
                n3 = Integer.parseInt(bTextField.getText());
                bFlexAddress2 = (BFlexAddress)bWbFieldEditor.saveValue();
                bDataTypeEnum = (BDataTypeEnum)BDataTypeEnum.integerType.getRange().get((String)bListDropDown2.getSelectedItem());
                if (!this.validAddress(mgrTypeInfo, bFlexAddress2)) {
                    BDialog.error((BWidget)this.getManager(), (Object)this.errorMsg);
                    continue;
                }
                bl = true;
            }
            MgrEdit mgrEdit = this.makeEdit(string);
            int n5 = 0;
            while (n5 < n3) {
                BComponent bComponent = ((ModbusPointModel)this.getManager().getModel()).newInstance(mgrTypeInfo, bFlexAddress2, n5, bDataTypeEnum);
                MgrEditRow mgrEditRow = new MgrEditRow(bComponent, null, mgrTypeInfoArray);
                mgrEdit.addRow(mgrEditRow);
                if (bComponent instanceof BControlPoint) {
                    BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                    if (bAbstractProxyExt instanceof BModbusProxyExt) {
                        if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                            mgrEditRow.setDefaultName(SlotPath.escape((String)(mgrTypeInfo.getDisplayName() + ((BModbusProxyExt)bAbstractProxyExt).getDataAddress().getAddress() + '-' + n5)));
                        } else if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                            mgrEditRow.setDefaultName(SlotPath.escape((String)(mgrTypeInfo.getDisplayName() + ((BModbusProxyExt)bAbstractProxyExt).getDataAddress().getAddress() + '-' + n5)));
                        } else if (bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt) {
                            mgrEditRow.setDefaultName(SlotPath.escape((String)(mgrTypeInfo.getDisplayName() + ((BModbusProxyExt)bAbstractProxyExt).getDataAddress().getAddress() + lexicon.getText("pointManager.bit") + n5 % 16)));
                        } else {
                            mgrEditRow.setDefaultName(SlotPath.escape((String)(mgrTypeInfo.getDisplayName() + ((BModbusProxyExt)bAbstractProxyExt).getDataAddress().getAddress())));
                        }
                    } else {
                        mgrEditRow.setDefaultName(SlotPath.escape((String)(mgrTypeInfo.getDisplayName() + n5)));
                    }
                } else {
                    mgrEditRow.setDefaultName(SlotPath.escape((String)(mgrTypeInfo.getDisplayName() + n5)));
                }
                ++n5;
            }
            return mgrEdit;
        }

        private final boolean validAddress(MgrTypeInfo mgrTypeInfo, BFlexAddress bFlexAddress) {
            if (!bFlexAddress.isModbusFormat()) {
                return true;
            }
            boolean bl = true;
            if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BRegisterBitPoint.TYPE)) || mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BNumericPoint.TYPE)) || mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BNumericBitsPoint.TYPE)) || mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BEnumBitsPoint.TYPE))) {
                bl = bFlexAddress.isModbusAnalogAddress();
                if (!bl) {
                    this.errorMsg = lexicon.getText("pointManager.addressError.notAnalog");
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BRegisterBitWritable.TYPE)) || mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BNumericWritable.TYPE)) || mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BNumericBitsWritable.TYPE)) || mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BEnumBitsWritable.TYPE))) {
                if (BModbusPointManager.this.isModbusSlave()) {
                    bl = bFlexAddress.isModbusAnalogAddress();
                    if (!bl) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notAnalog");
                    }
                } else {
                    bl = bFlexAddress.isModbusHoldingAddress();
                    if (!bl) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notHolding");
                    }
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BBooleanPoint.TYPE))) {
                bl = bFlexAddress.isModbusDigitalAddress();
                if (!bl) {
                    this.errorMsg = lexicon.getText("pointManager.addressError.notDigital");
                }
            } else if (mgrTypeInfo.equals((Object)MgrTypeInfo.make((Type)BBooleanWritable.TYPE))) {
                if (BModbusPointManager.this.isModbusSlave()) {
                    bl = bFlexAddress.isModbusDigitalAddress();
                    if (!bl) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notDigital");
                    }
                } else {
                    bl = bFlexAddress.isModbusCoilAddress();
                    if (!bl) {
                        this.errorMsg = lexicon.getText("pointManager.addressError.notCoil");
                    }
                }
            }
            return bl;
        }

        private final /* synthetic */ void this() {
            this.errorMsg = lexicon.getText("pointManager.addressError.unknown");
        }

        public ModbusPointController(BPointManager bPointManager) {
            super(bPointManager);
            this.this();
        }
    }

    public static class ModbusType
    extends MgrColumn.Type {
        public Object get(Object object) {
            if (object instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)object).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    if (object instanceof BEnumWritable) {
                        return BEnumBitsWritable.TYPE;
                    }
                    if (object instanceof BEnumPoint) {
                        return BEnumBitsPoint.TYPE;
                    }
                } else if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    if (object instanceof BNumericWritable) {
                        return BNumericBitsWritable.TYPE;
                    }
                    if (object instanceof BNumericPoint) {
                        return BNumericBitsPoint.TYPE;
                    }
                } else if (bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt) {
                    if (object instanceof BBooleanWritable) {
                        return BRegisterBitWritable.TYPE;
                    }
                    if (object instanceof BBooleanPoint) {
                        return BRegisterBitPoint.TYPE;
                    }
                }
            }
            return super.get(object);
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent != null && bComponent instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    MgrTypeInfo mgrTypeInfo;
                    if (bComponent instanceof BEnumWritable) {
                        mgrTypeInfo = MgrTypeInfo.make((Type)BEnumBitsWritable.TYPE);
                    } else if (bComponent instanceof BEnumPoint) {
                        mgrTypeInfo = MgrTypeInfo.make((Type)BEnumBitsPoint.TYPE);
                    } else {
                        return super.load(mgrEditRow);
                    }
                    BFacets bFacets = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BEnumRange.NULL), (Object)mgrTypeInfo);
                    return bFacets;
                }
                if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    MgrTypeInfo mgrTypeInfo;
                    if (bComponent instanceof BNumericWritable) {
                        mgrTypeInfo = MgrTypeInfo.make((Type)BNumericBitsWritable.TYPE);
                    } else if (bComponent instanceof BNumericPoint) {
                        mgrTypeInfo = MgrTypeInfo.make((Type)BNumericBitsPoint.TYPE);
                    } else {
                        return super.load(mgrEditRow);
                    }
                    BFacets bFacets = BFacets.makePickle((BFacets)BFacets.DEFAULT, (Object)mgrTypeInfo);
                    return bFacets;
                }
                if (bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt) {
                    MgrTypeInfo mgrTypeInfo;
                    if (bComponent instanceof BBooleanWritable) {
                        mgrTypeInfo = MgrTypeInfo.make((Type)BRegisterBitWritable.TYPE);
                    } else if (bComponent instanceof BBooleanPoint) {
                        mgrTypeInfo = MgrTypeInfo.make((Type)BRegisterBitPoint.TYPE);
                    } else {
                        return super.load(mgrEditRow);
                    }
                    BFacets bFacets = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)mgrTypeInfo);
                    return bFacets;
                }
            }
            return super.load(mgrEditRow);
        }

        public ModbusType(int n) {
            super(n);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusRegType
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            if (object instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)object).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusNumericProxyExt) {
                    return ((BIModbusNumericProxyExt)bAbstractProxyExt).getRegType();
                }
                if (bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt) {
                    return ((BIModbusRegisterBitProxyExt)bAbstractProxyExt).getRegType();
                }
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    return ((BIModbusEnumBitsProxyExt)bAbstractProxyExt).getRegType();
                }
                if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    return ((BIModbusNumericBitsProxyExt)bAbstractProxyExt).getRegType();
                }
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusNumericProxyExt) {
                    return ((BIModbusNumericProxyExt)bAbstractProxyExt).getRegType().newCopy();
                }
                if (bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt) {
                    return ((BIModbusRegisterBitProxyExt)bAbstractProxyExt).getRegType().newCopy();
                }
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    return ((BIModbusEnumBitsProxyExt)bAbstractProxyExt).getRegType().newCopy();
                }
                if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    return ((BIModbusNumericBitsProxyExt)bAbstractProxyExt).getRegType().newCopy();
                }
            }
            this.isDefault = true;
            return BRegisterTypeEnum.holding;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                if (((BControlPoint)bComponent).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusNumericProxyExt) {
                    ((BIModbusNumericProxyExt)bAbstractProxyExt).setRegType((BRegisterTypeEnum)bValue.newCopy());
                } else if (bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt) {
                    ((BIModbusRegisterBitProxyExt)bAbstractProxyExt).setRegType((BRegisterTypeEnum)bValue.newCopy());
                } else if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    ((BIModbusEnumBitsProxyExt)bAbstractProxyExt).setRegType((BRegisterTypeEnum)bValue.newCopy());
                } else if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    ((BIModbusNumericBitsProxyExt)bAbstractProxyExt).setRegType((BRegisterTypeEnum)bValue.newCopy());
                }
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                if (((BControlPoint)propertyArray).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusNumericProxyExt || bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt || bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt || bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("regType")};
            return ModbusRegType.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("regType")};
            ModbusRegType.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusRegType() {
            super(lexicon.getText("table.columnTitle.regType"), 3);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusDataType
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BIModbusNumericProxyExt) {
                return ((BIModbusNumericProxyExt)bAbstractProxyExt).getDataType();
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BAbstractProxyExt bAbstractProxyExt;
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusNumericProxyExt) {
                return ((BIModbusNumericProxyExt)bAbstractProxyExt).getDataType().newCopy();
            }
            this.isDefault = true;
            return BDataTypeEnum.integerType;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BAbstractProxyExt bAbstractProxyExt;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusNumericProxyExt) {
                ((BIModbusNumericProxyExt)bAbstractProxyExt).setDataType((BDataTypeEnum)bValue.newCopy());
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusNumericProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("dataType")};
            return ModbusDataType.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("dataType")};
            ModbusDataType.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusDataType() {
            super(lexicon.getText("table.columnTitle.dataType"), 3);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusStatusType
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BIModbusBooleanProxyExt) {
                return ((BIModbusBooleanProxyExt)bAbstractProxyExt).getStatusType();
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BAbstractProxyExt bAbstractProxyExt;
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusBooleanProxyExt) {
                return ((BIModbusBooleanProxyExt)bAbstractProxyExt).getStatusType().newCopy();
            }
            this.isDefault = true;
            return BStatusTypeEnum.coil;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                if (((BControlPoint)bComponent).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusBooleanProxyExt) {
                    ((BIModbusBooleanProxyExt)bAbstractProxyExt).setStatusType((BStatusTypeEnum)bValue.newCopy());
                }
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                if (((BControlPoint)propertyArray).isWritablePoint() && !((BModbusPointManager)this.getManager()).isModbusSlave()) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusBooleanProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("statusType")};
            return ModbusStatusType.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("statusType")};
            ModbusStatusType.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusStatusType() {
            super(lexicon.getText("table.columnTitle.statusType"), 3);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusBitNumber
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BIModbusRegisterBitProxyExt) {
                return new Integer(((BIModbusRegisterBitProxyExt)bAbstractProxyExt).getBitNumber());
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BAbstractProxyExt bAbstractProxyExt;
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusRegisterBitProxyExt) {
                return bAbstractProxyExt.get(bAbstractProxyExt.getProperty("bitNumber")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BAbstractProxyExt bAbstractProxyExt;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusRegisterBitProxyExt) {
                ((BIModbusRegisterBitProxyExt)bAbstractProxyExt).setBitNumber(((BInteger)bValue).getInt());
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusRegisterBitProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("bitNumber")};
            return ModbusBitNumber.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("bitNumber")};
            ModbusBitNumber.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusBitNumber() {
            super(lexicon.getText("table.columnTitle.bitNumber"), 3);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusBeginningBit
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            if (object instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)object).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    return new Integer(((BIModbusEnumBitsProxyExt)bAbstractProxyExt).getBeginningBit());
                }
                if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    return new Integer(((BIModbusNumericBitsProxyExt)bAbstractProxyExt).getBeginningBit());
                }
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BAbstractProxyExt bAbstractProxyExt;
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && ((bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusEnumBitsProxyExt || bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt)) {
                return bAbstractProxyExt.get(bAbstractProxyExt.getProperty("beginningBit")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    ((BIModbusEnumBitsProxyExt)bAbstractProxyExt).setBeginningBit(((BInteger)bValue).getInt());
                } else if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    ((BIModbusNumericBitsProxyExt)bAbstractProxyExt).setBeginningBit(((BInteger)bValue).getInt());
                }
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) && !(bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("beginningBit")};
            return ModbusBeginningBit.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("beginningBit")};
            ModbusBeginningBit.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusBeginningBit() {
            super(lexicon.getText("table.columnTitle.beginningBit"), 3);
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusNumberOfBits
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            if (object instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)object).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    return new Integer(((BIModbusEnumBitsProxyExt)bAbstractProxyExt).getNumberOfBits());
                }
                if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    return new Integer(((BIModbusNumericBitsProxyExt)bAbstractProxyExt).getNumberOfBits());
                }
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BAbstractProxyExt bAbstractProxyExt;
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && ((bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusEnumBitsProxyExt || bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt)) {
                return bAbstractProxyExt.get(bAbstractProxyExt.getProperty("numberOfBits")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint) {
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt();
                if (bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) {
                    ((BIModbusEnumBitsProxyExt)bAbstractProxyExt).setNumberOfBits(((BInteger)bValue).getInt());
                } else if (bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt) {
                    ((BIModbusNumericBitsProxyExt)bAbstractProxyExt).setNumberOfBits(((BInteger)bValue).getInt());
                }
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusEnumBitsProxyExt) && !(bAbstractProxyExt instanceof BIModbusNumericBitsProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("numberOfBits")};
            return ModbusNumberOfBits.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("numberOfBits")};
            ModbusNumberOfBits.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusNumberOfBits() {
            super(lexicon.getText("table.columnTitle.numberOfBits"), 3);
            this.this();
        }
    }

    public static class ModbusAbsAddress
    extends MgrColumn {
        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BIModbusReadProxyExt) {
                return ((BIModbusReadProxyExt)bAbstractProxyExt).getAbsoluteAddress();
            }
            return "";
        }

        public ModbusAbsAddress() {
            super(lexicon.getText("table.columnTitle.absAddress"), 0);
        }
    }

    public static class ModbusDataSource
    extends MgrColumn {
        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BIModbusReadProxyExt) {
                return ((BIModbusReadProxyExt)bAbstractProxyExt).getDataSource();
            }
            return "";
        }

        public ModbusDataSource() {
            super(lexicon.getText("table.columnTitle.dataSource"), 2);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ModbusNumRegisters
    extends MgrColumn {
        boolean isDefault;

        public Object get(Object object) {
            BAbstractProxyExt bAbstractProxyExt;
            if (object instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)object).getProxyExt()) instanceof BIModbusStringProxyExt) {
                return new Integer(((BIModbusStringProxyExt)bAbstractProxyExt).getNumberRegisters());
            }
            return "";
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BAbstractProxyExt bAbstractProxyExt;
            this.isDefault = false;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusStringProxyExt) {
                return bAbstractProxyExt.get(bAbstractProxyExt.getProperty("numberRegisters")).newCopy();
            }
            this.isDefault = true;
            return BInteger.make((int)0);
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BAbstractProxyExt bAbstractProxyExt;
            BComponent bComponent = mgrEditRow.getTarget();
            if (bComponent instanceof BControlPoint && (bAbstractProxyExt = ((BControlPoint)bComponent).getProxyExt()) instanceof BIModbusStringProxyExt) {
                ((BIModbusStringProxyExt)bAbstractProxyExt).setNumberRegisters(((BInteger)bValue).getInt());
            }
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (this.isDefault) {
                return "";
            }
            return super.toDisplayString(object, object2, context);
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            Property[] propertyArray;
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return null;
            }
            int n2 = 0;
            while (n2 < mgrEditRowArray.length) {
                propertyArray = mgrEditRowArray[n2].getTarget();
                if (!(propertyArray instanceof BControlPoint)) {
                    return null;
                }
                BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)propertyArray).getProxyExt();
                if (!(bAbstractProxyExt instanceof BIModbusStringProxyExt)) {
                    return null;
                }
                ++n2;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("numberRegisters")};
            return ModbusNumRegisters.toFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length <= 0) {
                return;
            }
            BAbstractProxyExt bAbstractProxyExt = ((BControlPoint)mgrEditRowArray[0].getTarget()).getProxyExt();
            Property[] propertyArray = new Property[]{BControlPoint.proxyExt, bAbstractProxyExt.loadSlots().getProperty("numberRegisters")};
            ModbusNumRegisters.fromFieldEditor((MgrEditRow[])mgrEditRowArray, (int)n, (BWbEditor)bWbEditor, (Property[])propertyArray);
        }

        private final /* synthetic */ void this() {
            this.isDefault = false;
        }

        public ModbusNumRegisters() {
            super(lexicon.getText("table.columnTitle.numRegisters"), 3);
            this.this();
        }
    }
}

