/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusRegisterBitProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusServerRegisterBitProxyExt
extends BModbusServerProxyExt
implements BIModbusRegisterBitProxyExt {
    public static final Property regType = BModbusServerRegisterBitProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property bitNumber = BModbusServerRegisterBitProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)15));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$server$point$BModbusServerRegisterBitProxyExt;

    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    public void setRegType(BRegisterTypeEnum bRegisterTypeEnum) {
        this.set(regType, (BValue)bRegisterTypeEnum, null);
    }

    public int getBitNumber() {
        return this.getInt(bitNumber);
    }

    public void setBitNumber(int n) {
        this.setInt(bitNumber, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
        int n = 1;
        ModbusResponse modbusResponse = new ModbusResponse(((BModbusServerNetwork)this.modbusNet()).getModbusMode(), bModbusServerDevice);
        int n2 = this.getDataAddress().getDataAddress();
        try {
            modbusResponse.data = this.isHoldingRegisterType() ? bModbusServerDevice.getHoldingRegisterValues(n2, n) : bModbusServerDevice.getInputRegisterValues(n2, n);
        }
        catch (Exception exception) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerRegisterBitProxyExt.read() caught exception: ", (Throwable)exception);
            }
            this.readFail("Exception during read (" + exception + ')');
            return;
        }
        modbusResponse.exceptionCode = 0;
        modbusResponse.byteCount = (byte)modbusResponse.data.length;
        modbusResponse.numberPoints = n;
        this.setOutValues(modbusResponse);
    }

    private final void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            this.setBinaryOutValues(modbusResponse);
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setBinaryOutValues(ModbusResponse modbusResponse) {
        int n = modbusResponse.data[1] & 0xFF | (modbusResponse.data[0] & 0xFF) << 8;
        int n2 = 1;
        boolean bl = false;
        if ((n & (n2 <<= this.getBitNumber())) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        BStatusBoolean bStatusBoolean = new BStatusBoolean(bl2);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)bStatusBoolean)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)bStatusBoolean);
        }
    }

    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)bitNumber)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        } else if (property.equals((Object)regType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusHoldingAddress()) {
                    if (!this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                    }
                } else if (this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    protected boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            int n = 1;
            if (this.isHoldingRegisterType()) {
                return bModbusServerDevice.isHoldingRegisterAddressValid(bFlexAddress.getDataAddress(), n);
            }
            return bModbusServerDevice.isInputRegisterAddressValid(bFlexAddress.getDataAddress(), n);
        }
        if (bFlexAddress.isModbusAnalogAddress()) {
            BRegisterTypeEnum bRegisterTypeEnum = BRegisterTypeEnum.holding;
            if (bFlexAddress.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                bRegisterTypeEnum = BRegisterTypeEnum.input;
            }
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            int n = 1;
            if (bRegisterTypeEnum.equals((Object)BRegisterTypeEnum.holding)) {
                return bModbusServerDevice.isHoldingRegisterAddressValid(bFlexAddress.getDataAddress(), n);
            }
            return bModbusServerDevice.isInputRegisterAddressValid(bFlexAddress.getDataAddress(), n);
        }
        return false;
    }

    private final boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (bStatusValue == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(bStatusValue);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer register bit point is not writable, disregarding write request.");
        }
        super.doWrite(bStatusValue);
    }

    private final boolean updateOutput(BStatusValue bStatusValue) {
        boolean bl = ((BStatusBoolean)bStatusValue).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            BModbusServerNetwork bModbusServerNetwork = (BModbusServerNetwork)this.modbusNet();
            int n = 1;
            int n2 = bModbusServerDevice.getDeviceAddress();
            int n3 = this.getDataAddress().getDataAddress();
            ModbusResponse modbusResponse = new ModbusResponse(bModbusServerNetwork.getModbusMode(), bModbusServerDevice);
            try {
                modbusResponse.data = this.isHoldingRegisterType() ? bModbusServerDevice.getHoldingRegisterValues(n3, n) : bModbusServerDevice.getInputRegisterValues(n3, n);
            }
            catch (Exception exception) {
                if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                    this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerRegisterBitProxyExt.read() caught exception: ", (Throwable)exception);
                }
                this.writeFail("Error when writing (" + exception + ')');
                return false;
            }
            int n4 = modbusResponse.data[1] & 0xFF | (modbusResponse.data[0] & 0xFF) << 8;
            byte[] byArray = new byte[2];
            int n5 = 1;
            n4 = bl ? (n4 |= n5) : (n4 &= ~(n5 <<= this.getBitNumber()));
            byArray[0] = (byte)(n4 >> 8 & 0xFF);
            byArray[1] = (byte)(n4 & 0xFF);
            if (this.isHoldingRegisterType()) {
                bModbusServerDevice.setHoldingRegisterValues(n3, byArray);
            } else {
                bModbusServerDevice.setInputRegisterValues(n3, byArray);
            }
        }
        catch (Exception exception) {
            this.writeFail("Error when writing (" + exception + ')');
            return false;
        }
        this.writeOk(bStatusValue);
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$server$point$BModbusServerRegisterBitProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$server$point$BModbusServerRegisterBitProxyExt = BModbusServerRegisterBitProxyExt.class("[Lcom.tridium.modbusCore.server.point.BModbusServerRegisterBitProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

