/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusServerNumericProxyExt
extends BModbusServerProxyExt
implements BIModbusNumericProxyExt {
    public static final Property regType = BModbusServerNumericProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property dataType = BModbusServerNumericProxyExt.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$server$point$BModbusServerNumericProxyExt;

    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    public void setRegType(BRegisterTypeEnum bRegisterTypeEnum) {
        this.set(regType, (BValue)bRegisterTypeEnum, null);
    }

    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    public void setDataType(BDataTypeEnum bDataTypeEnum) {
        this.set(dataType, (BValue)bDataTypeEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
        int n = 1;
        if (!this.isDataTypeInteger()) {
            n *= 2;
        }
        ModbusResponse modbusResponse = new ModbusResponse(((BModbusServerNetwork)this.modbusNet()).getModbusMode(), bModbusServerDevice);
        int n2 = this.getDataAddress().getDataAddress();
        try {
            modbusResponse.data = this.isHoldingRegisterType() ? bModbusServerDevice.getHoldingRegisterValues(n2, n) : bModbusServerDevice.getInputRegisterValues(n2, n);
        }
        catch (Exception exception) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerNumericProxyExt.read() caught exception: ", (Throwable)exception);
            }
            this.readFail("Exception during read (" + exception + ')');
            return;
        }
        modbusResponse.exceptionCode = 0;
        modbusResponse.byteCount = (byte)modbusResponse.data.length;
        modbusResponse.numberPoints = n;
        this.setOutValues(modbusResponse);
    }

    private final void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(modbusResponse, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(modbusResponse, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(modbusResponse, 4);
            }
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setIntegerOutValues(ModbusResponse modbusResponse, int n) {
        int n2;
        try {
            n2 = modbusResponse.getRegister(0, n, ((BModbusServerDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing integer value (" + illegalArgumentException + ')');
            return;
        }
        BStatusNumeric bStatusNumeric = new BStatusNumeric((double)n2);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)bStatusNumeric)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)bStatusNumeric);
        }
    }

    private final void setFloatOutValues(ModbusResponse modbusResponse, int n) {
        float f;
        try {
            f = modbusResponse.getFloat(0, n, ((BModbusServerDevice)this.getDevice()).isFloat3210Order());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing float value (" + illegalArgumentException + ')');
            return;
        }
        BStatusNumeric bStatusNumeric = new BStatusNumeric((double)f);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)bStatusNumeric)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)bStatusNumeric);
        }
    }

    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)dataType)) {
            this.setStale(true, null);
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        } else if (property.equals((Object)regType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusHoldingAddress()) {
                    if (!this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                    }
                } else if (this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    protected boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            int n = 1;
            if (!this.isDataTypeInteger()) {
                n *= 2;
            }
            if (this.isHoldingRegisterType()) {
                return bModbusServerDevice.isHoldingRegisterAddressValid(bFlexAddress.getDataAddress(), n);
            }
            return bModbusServerDevice.isInputRegisterAddressValid(bFlexAddress.getDataAddress(), n);
        }
        if (bFlexAddress.isModbusAnalogAddress()) {
            BRegisterTypeEnum bRegisterTypeEnum = BRegisterTypeEnum.holding;
            if (bFlexAddress.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                bRegisterTypeEnum = BRegisterTypeEnum.input;
            }
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            int n = 1;
            if (!this.isDataTypeInteger()) {
                n *= 2;
            }
            if (bRegisterTypeEnum.equals((Object)BRegisterTypeEnum.holding)) {
                return bModbusServerDevice.isHoldingRegisterAddressValid(bFlexAddress.getDataAddress(), n);
            }
            return bModbusServerDevice.isInputRegisterAddressValid(bFlexAddress.getDataAddress(), n);
        }
        return false;
    }

    private final boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    private final boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    public boolean isDataTypeLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public boolean isDataTypeFloat() {
        return this.getDataType().equals((Object)BDataTypeEnum.floatType);
    }

    private final boolean isDataTypeSigned() {
        if (this.getDataType().equals((Object)BDataTypeEnum.signedInteger)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (bStatusValue == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(bStatusValue);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer float point is not writable, disregarding write request.");
        }
        super.doWrite(bStatusValue);
    }

    private final boolean updateOutput(BStatusValue bStatusValue) {
        double d = ((BStatusNumeric)bStatusValue).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            BModbusServerNetwork bModbusServerNetwork = (BModbusServerNetwork)this.modbusNet();
            int n = 1;
            int n2 = bModbusServerDevice.getDeviceAddress();
            int n3 = this.getDataAddress().getDataAddress();
            byte[] byArray = this.isDataTypeInteger() ? this.setIntegerByteArray(d) : (this.isDataTypeLong() ? this.setLongByteArray(d) : this.setFloatByteArray(d));
            if (this.isDataTypeLong() || this.isDataTypeFloat()) {
                n *= 2;
            }
            if (this.isHoldingRegisterType()) {
                bModbusServerDevice.setHoldingRegisterValues(n3, byArray);
            } else {
                bModbusServerDevice.setInputRegisterValues(n3, byArray);
            }
        }
        catch (Exception exception) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerNumericWritableProxyExt.updateOutput() caught exception: ", (Throwable)exception);
            }
            this.writeFail("Error when writing (" + exception + ')');
            return false;
        }
        this.writeOk(bStatusValue);
        return true;
    }

    private final byte[] setIntegerByteArray(double d) {
        byte[] byArray = new byte[2];
        d = d >= 0.0 ? (d += 0.5) : (d -= 0.5);
        double d2 = 65535.0;
        double d3 = 0.0;
        if (this.isDataTypeSigned()) {
            d2 = 32767.0;
            d3 = -32768.0;
        }
        if (d > d2) {
            d = d2;
        } else if (d < d3) {
            d = d3;
        }
        int n = (int)d;
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    private final byte[] setLongByteArray(double d) {
        byte[] byArray = new byte[4];
        d = d >= 0.0 ? (d += 0.5) : (d -= 0.5);
        double d2 = 2.147483647E9;
        double d3 = -2.147483648E9;
        if (d > d2) {
            d = d2;
        } else if (d < d3) {
            d = d3;
        }
        int n = (int)d;
        if (((BModbusServerDevice)this.getDevice()).isLong3210Order()) {
            byArray[0] = (byte)((n & 0xFF000000) >> 24);
            byArray[1] = (byte)((n & 0xFF0000) >> 16);
            byArray[2] = (byte)((n & 0xFF00) >> 8);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)((n & 0xFF00) >> 8);
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFF000000) >> 24);
            byArray[3] = (byte)((n & 0xFF0000) >> 16);
        }
        return byArray;
    }

    private final byte[] setFloatByteArray(double d) {
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits((float)d);
        if (((BModbusServerDevice)this.getDevice()).isFloat3210Order()) {
            byArray[0] = (byte)((n & 0xFF000000) >> 24);
            byArray[1] = (byte)((n & 0xFF0000) >> 16);
            byArray[2] = (byte)((n & 0xFF00) >> 8);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)((n & 0xFF00) >> 8);
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFF000000) >> 24);
            byArray[3] = (byte)((n & 0xFF0000) >> 16);
        }
        return byArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$server$point$BModbusServerNumericProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$server$point$BModbusServerNumericProxyExt = BModbusServerNumericProxyExt.class("[Lcom.tridium.modbusCore.server.point.BModbusServerNumericProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

