/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusBooleanProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.BModbusServerNetwork;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusServerBooleanProxyExt
extends BModbusServerProxyExt
implements BIModbusBooleanProxyExt {
    public static final Property statusType = BModbusServerBooleanProxyExt.newProperty((int)0, (BValue)BStatusTypeEnum.coil, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$server$point$BModbusServerBooleanProxyExt;

    public BStatusTypeEnum getStatusType() {
        return (BStatusTypeEnum)this.get(statusType);
    }

    public void setStatusType(BStatusTypeEnum bStatusTypeEnum) {
        this.set(statusType, (BValue)bStatusTypeEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
        int n = 1;
        ModbusResponse modbusResponse = new ModbusResponse(((BModbusServerNetwork)this.modbusNet()).getModbusMode(), bModbusServerDevice);
        int n2 = this.getDataAddress().getDataAddress();
        try {
            modbusResponse.data = this.isCoilStatusType() ? bModbusServerDevice.getCoilStatusValues(n2, n) : bModbusServerDevice.getInputStatusValues(n2, n);
            modbusResponse.exceptionCode = 0;
            modbusResponse.byteCount = (byte)modbusResponse.data.length;
            modbusResponse.numberPoints = n;
        }
        catch (Exception exception) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerBooleanProxyExt.read() caught exception: ", (Throwable)exception);
            }
            this.readFail("Exception during read (" + exception + ')');
            return;
        }
        this.setOutValues(modbusResponse);
    }

    private final void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            this.setBinaryOutValues(modbusResponse);
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setBinaryOutValues(ModbusResponse modbusResponse) {
        boolean bl;
        try {
            bl = modbusResponse.getBinary(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing boolean value (" + illegalArgumentException + ')');
            return;
        }
        BStatusBoolean bStatusBoolean = new BStatusBoolean(bl);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)bStatusBoolean)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)bStatusBoolean);
        }
    }

    public BRegisterTypesEnum determineRegisterType() {
        if (this.getStatusType().equals((Object)BStatusTypeEnum.coil)) {
            return BRegisterTypesEnum.discreteCoil;
        }
        return BRegisterTypesEnum.discreteInput;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)statusType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusCoilAddress()) {
                    if (!this.isCoilStatusType()) {
                        this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
                    }
                } else if (this.isCoilStatusType()) {
                    this.set(statusType, (BValue)BStatusTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    protected boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            int n = 1;
            if (this.isCoilStatusType()) {
                return bModbusServerDevice.isCoilAddressValid(bFlexAddress.getDataAddress(), n);
            }
            return bModbusServerDevice.isStatusAddressValid(bFlexAddress.getDataAddress(), n);
        }
        if (bFlexAddress.isModbusDigitalAddress()) {
            BStatusTypeEnum bStatusTypeEnum = BStatusTypeEnum.coil;
            if (bFlexAddress.isModbusCoilAddress()) {
                this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
            } else {
                this.set(statusType, (BValue)BStatusTypeEnum.input, noAddressCheck);
                bStatusTypeEnum = BStatusTypeEnum.input;
            }
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            int n = 1;
            if (bStatusTypeEnum.equals((Object)BStatusTypeEnum.coil)) {
                return bModbusServerDevice.isCoilAddressValid(bFlexAddress.getDataAddress(), n);
            }
            return bModbusServerDevice.isStatusAddressValid(bFlexAddress.getDataAddress(), n);
        }
        return false;
    }

    private final boolean isCoilStatusType() {
        return this.getStatusType().equals((Object)BStatusTypeEnum.coil);
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (bStatusValue == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(bStatusValue);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer boolean point is not writable, disregarding write request.");
        }
        super.doWrite(bStatusValue);
    }

    private final boolean updateOutput(BStatusValue bStatusValue) {
        boolean bl = ((BStatusBoolean)bStatusValue).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            boolean bl2 = bl;
            BModbusServerDevice bModbusServerDevice = (BModbusServerDevice)this.getDevice();
            BModbusServerNetwork bModbusServerNetwork = (BModbusServerNetwork)this.modbusNet();
            boolean bl3 = true;
            int n = bModbusServerDevice.getDeviceAddress();
            int n2 = this.getDataAddress().getDataAddress();
            if (this.isCoilStatusType()) {
                bModbusServerDevice.setCoilStatusValue(n2, bl2);
            } else {
                bModbusServerDevice.setInputStatusValue(n2, bl2);
            }
        }
        catch (Exception exception) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().error(this.getParent().getName() + ": BModbusServerBooleanWritableProxyExt.updateOutput() caught exception: ", (Throwable)exception);
            }
            this.writeFail("Error when writing (" + exception + ')');
            return false;
        }
        this.writeOk(bStatusValue);
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$server$point$BModbusServerBooleanProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$server$point$BModbusServerBooleanProxyExt = BModbusServerBooleanProxyExt.class("[Lcom.tridium.modbusCore.server.point.BModbusServerBooleanProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

