/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.messages;

import com.tridium.modbusCore.messages.ModbusInputStream;

public class ModbusServerReadFileRequest {
    public int deviceAddress;
    public int functionCode;
    private int subRequestCount;
    private int[] fileNumber;
    private int[] startingRecNumber;
    private int[] recLength;

    public int getNumSubRequests() {
        return this.subRequestCount;
    }

    public int getFileNumber(int n) {
        return this.fileNumber[n];
    }

    public int getStartingRecordNumber(int n) {
        return this.startingRecNumber[n];
    }

    public int getRecordLength(int n) {
        return this.recLength[n];
    }

    public ModbusServerReadFileRequest(byte[] byArray) {
        ModbusInputStream modbusInputStream = new ModbusInputStream(byArray);
        this.deviceAddress = modbusInputStream.read() & 0xFF;
        this.functionCode = modbusInputStream.read() & 0xFF;
        int n = modbusInputStream.read() & 0xFF;
        this.subRequestCount = n / 7;
        this.fileNumber = new int[this.subRequestCount];
        this.startingRecNumber = new int[this.subRequestCount];
        this.recLength = new int[this.subRequestCount];
        int n2 = 0;
        while (n2 < this.subRequestCount) {
            int n3 = modbusInputStream.read();
            this.fileNumber[n2] = modbusInputStream.readWord();
            this.startingRecNumber[n2] = modbusInputStream.readWord();
            this.recLength[n2] = modbusInputStream.readWord();
            ++n2;
        }
    }
}

