/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import com.tridium.modbusCore.messages.ModbusReceivedMessage;
import com.tridium.modbusCore.messages.ModbusResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ModbusWriteFileRequest
extends ModbusMessage {
    private int fileNumber;
    private byte[] inputData;
    private int startIdx;
    private int endIdx;

    public final void writeRtu(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write((byte)this.deviceAddress);
        modbusOutputStream.write((byte)this.functionCode);
        int n = this.endIdx - this.startIdx;
        n = n < 0 ? 0 : ++n;
        modbusOutputStream.write((byte)(7 + n));
        modbusOutputStream.write((byte)6);
        modbusOutputStream.write((byte)((this.fileNumber & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.fileNumber & 0xFF));
        modbusOutputStream.write((byte)((this.startAddress & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.startAddress & 0xFF));
        modbusOutputStream.write((byte)((this.numberPoints & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.numberPoints & 0xFF));
        int n2 = this.startIdx;
        while (n2 <= this.endIdx) {
            modbusOutputStream.write(this.inputData[n2]);
            ++n2;
        }
        modbusOutputStream.writeCRC();
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public final void writeAscii(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[11 + this.endIdx - this.startIdx + 1];
        byArray[0] = (byte)this.deviceAddress;
        byArray[1] = (byte)this.functionCode;
        int n = this.endIdx - this.startIdx;
        n = n < 0 ? 0 : ++n;
        byArray[2] = (byte)(7 + n);
        byArray[3] = 6;
        byArray[4] = (byte)((this.fileNumber & 0xFF00) >> 8);
        byArray[5] = (byte)(this.fileNumber & 0xFF);
        byArray[6] = (byte)((this.startAddress & 0xFF00) >> 8);
        byArray[7] = (byte)(this.startAddress & 0xFF);
        byArray[8] = (byte)((this.numberPoints & 0xFF00) >> 8);
        byArray[9] = (byte)(this.numberPoints & 0xFF);
        int n2 = 10;
        int n3 = this.startIdx;
        while (n3 <= this.endIdx) {
            byArray[n2] = this.inputData[n3];
            ++n2;
            ++n3;
        }
        byArray[n2] = (byte)ModbusWriteFileRequest.calcLRC(byArray);
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write(byArray);
        outputStream.write(modbusOutputStream.toAsciiHexByteArray());
    }

    public final void writeTcp(OutputStream outputStream) throws IOException {
        int n = this.endIdx - this.startIdx;
        n = n < 0 ? 0 : ++n;
        byte[] byArray = new byte[16 + n];
        if (this.transactionIdentifier < 0) {
            this.transactionIdentifier = ModbusWriteFileRequest.getNextTransactionId(this.getMaxTransactionId());
        }
        byArray[0] = (byte)((this.transactionIdentifier & 0xFF00) >> 8);
        byArray[1] = (byte)(this.transactionIdentifier & 0xFF);
        byArray[2] = 0;
        byArray[3] = 0;
        int n2 = n + 10;
        byArray[4] = (byte)((n2 & 0xFF00) >> 8);
        byArray[5] = (byte)(n2 & 0xFF);
        byArray[6] = (byte)this.deviceAddress;
        byArray[7] = (byte)this.functionCode;
        byArray[8] = (byte)(7 + this.endIdx - this.startIdx + 1);
        byArray[9] = 6;
        byArray[10] = (byte)((this.fileNumber & 0xFF00) >> 8);
        byArray[11] = (byte)(this.fileNumber & 0xFF);
        byArray[12] = (byte)((this.startAddress & 0xFF00) >> 8);
        byArray[13] = (byte)(this.startAddress & 0xFF);
        byArray[14] = (byte)((this.numberPoints & 0xFF00) >> 8);
        byArray[15] = (byte)(this.numberPoints & 0xFF);
        int n3 = 16;
        int n4 = this.startIdx;
        while (n4 <= this.endIdx) {
            byArray[n3] = this.inputData[n4];
            ++n3;
            ++n4;
        }
        outputStream.write(byArray);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        stringBuffer.append("\n  Modbus File Number = " + this.fileNumber);
        stringBuffer.append("\n  Modbus File Record Data = " + ByteArrayUtil.toHexString((byte[])this.inputData, (int)this.startIdx, (int)(this.endIdx - this.startIdx)));
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public int getResponseMsgSize() {
        return 12 + this.numberPoints * 2;
    }

    protected Message toResponseAscii(ReceivedMessage receivedMessage) {
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        byte[] byArray = modbusReceivedMessage.getBytes();
        ModbusInputStream modbusInputStream = new ModbusInputStream(byArray);
        ModbusResponse modbusResponse = new ModbusResponse(this.comType, this.modbusDevice);
        if (modbusInputStream.read() != 58) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
        int n = modbusReceivedMessage.getLength();
        if (n <= 4) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
        byte[] byArray2 = new byte[n - 4];
        System.arraycopy(byArray, 0, byArray2, 0, n - 4);
        int n2 = ModbusWriteFileRequest.calcLRC(ModbusInputStream.convertAscii2Rtu(byArray2));
        byte[] byArray3 = new byte[]{byArray[n - 4], byArray[n - 3]};
        ModbusInputStream modbusInputStream2 = new ModbusInputStream(byArray3);
        int n3 = modbusInputStream2.readHexByte();
        if (n2 != n3) {
            modbusResponse.exceptionCode = -5;
            if (this.modbusDevice != null) {
                this.modbusDevice.incrementLrcErrors();
            }
            return modbusResponse;
        }
        modbusResponse.deviceAddress = modbusInputStream.readHexByte() & 0xFF;
        modbusResponse.functionCode = modbusInputStream.readHexByte() & 0xFF;
        modbusResponse.startAddress = this.startAddress;
        modbusResponse.numberPoints = this.numberPoints;
        if ((modbusResponse.functionCode & 0x80) != 0) {
            modbusResponse.exceptionCode = modbusInputStream.readHexByte();
            return modbusResponse;
        }
        if (modbusResponse.functionCode != this.functionCode || modbusResponse.deviceAddress != this.deviceAddress) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
        modbusResponse.exceptionCode = 0;
        modbusResponse.byteCount = (byte)(modbusInputStream.readHexByte() & 0xFF);
        modbusInputStream.readHexByte();
        modbusInputStream.readHexByte();
        modbusInputStream.readHexByte();
        modbusInputStream.readHexByte();
        modbusInputStream.readHexByte();
        modbusInputStream.readHexByte();
        modbusInputStream.readHexByte();
        modbusResponse.data = new byte[modbusResponse.byteCount - 7];
        int n4 = 0;
        while (n4 < modbusResponse.byteCount - 7) {
            modbusResponse.data[n4] = (byte)(modbusInputStream.readHexByte() & 0xFF);
            ++n4;
        }
        return modbusResponse;
    }

    public Message toResponse(ReceivedMessage receivedMessage) {
        int n;
        if (this.comType == 0) {
            return this.toResponseAscii(receivedMessage);
        }
        ModbusReceivedMessage modbusReceivedMessage = (ModbusReceivedMessage)receivedMessage;
        byte[] byArray = modbusReceivedMessage.getBytes();
        ModbusResponse modbusResponse = new ModbusResponse(this.comType, this.modbusDevice);
        modbusResponse.deviceAddress = byArray[0] & 0xFF;
        modbusResponse.functionCode = byArray[1] & 0xFF;
        modbusResponse.startAddress = this.startAddress;
        modbusResponse.numberPoints = this.numberPoints;
        if (this.comType == 1) {
            n = modbusReceivedMessage.getLength();
            if (n <= 2) {
                modbusResponse.exceptionCode = -4;
                return modbusResponse;
            }
            byte[] byArray2 = new byte[n - 2];
            System.arraycopy(byArray, 0, byArray2, 0, n - 2);
            int n2 = ModbusWriteFileRequest.calcCRC(byArray2);
            int n3 = (byArray[n - 2] & 0xFF) << 8;
            if (n2 != (n3 |= byArray[n - 1] & 0xFF)) {
                modbusResponse.exceptionCode = -1;
                if (this.modbusDevice != null) {
                    this.modbusDevice.incrementCrcErrors();
                }
                return modbusResponse;
            }
        } else if (this.comType == 2) {
            if (this.transactionIdentifier != modbusReceivedMessage.getTransactionId()) {
                modbusResponse.exceptionCode = -4;
                if (this.modbusDevice != null) {
                    this.modbusDevice.incrementTransactionIdErrors();
                }
                return modbusResponse;
            }
            modbusResponse.transactionIdentifier = this.transactionIdentifier;
        }
        try {
            if (byArray[1] < 0) {
                modbusResponse.exceptionCode = byArray[2];
                return modbusResponse;
            }
            if (modbusResponse.functionCode != this.functionCode || modbusResponse.deviceAddress != this.deviceAddress) {
                modbusResponse.exceptionCode = -4;
                return modbusResponse;
            }
            modbusResponse.exceptionCode = 0;
            modbusResponse.byteCount = byArray[2] & 0xFF;
            modbusResponse.data = new byte[modbusResponse.byteCount - 7];
            n = 0;
            while (n < modbusResponse.byteCount - 7) {
                modbusResponse.data[n] = byArray[10 + n];
                ++n;
            }
            return modbusResponse;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            modbusResponse.exceptionCode = -4;
            return modbusResponse;
        }
    }

    public ModbusWriteFileRequest(int n, BModbusDevice bModbusDevice, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) {
        super(n, bModbusDevice);
        this.deviceAddress = n2;
        this.functionCode = 21;
        this.fileNumber = n3;
        this.startAddress = n4;
        this.numberPoints = n5;
        this.inputData = byArray;
        this.startIdx = n6;
        this.endIdx = n7;
    }
}

