/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusMessage;
import com.tridium.modbusCore.messages.ModbusOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.util.ByteArrayUtil;

public class ModbusReadRequest
extends ModbusMessage {
    public final void writeRtu(OutputStream outputStream) throws IOException {
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write((byte)this.deviceAddress);
        modbusOutputStream.write((byte)this.functionCode);
        modbusOutputStream.write((byte)((this.startAddress & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.startAddress & 0xFF));
        modbusOutputStream.write((byte)((this.numberPoints & 0xFF00) >> 8));
        modbusOutputStream.write((byte)(this.numberPoints & 0xFF));
        modbusOutputStream.writeCRC();
        outputStream.write(modbusOutputStream.toByteArray());
    }

    public final void writeAscii(OutputStream outputStream) throws IOException {
        byte[] byArray;
        byArray = new byte[]{(byte)this.deviceAddress, (byte)this.functionCode, (byte)((this.startAddress & 0xFF00) >> 8), (byte)(this.startAddress & 0xFF), (byte)((this.numberPoints & 0xFF00) >> 8), (byte)(this.numberPoints & 0xFF), (byte)ModbusReadRequest.calcLRC(byArray)};
        ModbusOutputStream modbusOutputStream = new ModbusOutputStream();
        modbusOutputStream.write(byArray);
        outputStream.write(modbusOutputStream.toAsciiHexByteArray());
    }

    public final void writeTcp(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[12];
        if (this.transactionIdentifier < 0) {
            this.transactionIdentifier = ModbusReadRequest.getNextTransactionId(this.getMaxTransactionId());
        }
        byArray[0] = (byte)((this.transactionIdentifier & 0xFF00) >> 8);
        byArray[1] = (byte)(this.transactionIdentifier & 0xFF);
        byArray[2] = 0;
        byArray[3] = 0;
        byArray[4] = 0;
        byArray[5] = 6;
        byArray[6] = (byte)this.deviceAddress;
        byArray[7] = (byte)this.functionCode;
        byArray[8] = (byte)((this.startAddress & 0xFF00) >> 8);
        byArray[9] = (byte)(this.startAddress & 0xFF);
        byArray[10] = (byte)((this.numberPoints & 0xFF00) >> 8);
        byArray[11] = (byte)(this.numberPoints & 0xFF);
        outputStream.write(byArray);
    }

    public String toDebugString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toDebugString());
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.write(byteArrayOutputStream);
            stringBuffer.append("\n  Raw Bytes = " + ByteArrayUtil.toHexString((byte[])byteArrayOutputStream.toByteArray()));
        }
        catch (Exception exception) {}
        return stringBuffer.toString();
    }

    public ModbusReadRequest(int n, BModbusDevice bModbusDevice, int n2, int n3, int n4, int n5) {
        super(n, bModbusDevice);
        this.deviceAddress = n2;
        this.functionCode = n3;
        this.startAddress = n4;
        this.numberPoints = n5;
    }
}

