/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.modbusCore.messages.ModbusMessage;
import java.io.ByteArrayOutputStream;

public class ModbusOutputStream
extends ByteArrayOutputStream {
    public void write(byte by) {
        super.write(by);
    }

    public int getCount() {
        return this.count;
    }

    public byte[] toAsciiHexByteArray() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(':');
        int n = 0;
        while (n < this.count) {
            if (this.buf[n] >= 0 && this.buf[n] < 16) {
                stringBuffer.append("0" + Integer.toHexString(this.buf[n] & 0xFF));
            } else {
                stringBuffer.append(Integer.toHexString(this.buf[n] & 0xFF));
            }
            ++n;
        }
        stringBuffer.append('\r');
        stringBuffer.append('\n');
        String string = stringBuffer.toString().toUpperCase();
        byte[] byArray = new byte[stringBuffer.length()];
        string.getBytes(0, stringBuffer.length(), byArray, 0);
        return byArray;
    }

    public void writeInt(int n) {
        this.write(n & 0xFF);
        this.write(n >> 8 & 0xFF);
    }

    public void writeWord(int n) {
        this.write(n >> 8 & 0xFF);
        this.write(n & 0xFF);
    }

    public void writeLRC() {
        byte[] byArray = this.toByteArray();
        this.write((byte)ModbusMessage.calcLRC(byArray));
    }

    public void writeCRC() {
        byte[] byArray = this.toByteArray();
        int n = ModbusMessage.calcCRC(byArray);
        this.write((byte)((n & 0xFF00) >> 8));
        this.write((byte)(n & 0xFF));
    }

    public ModbusOutputStream() {
    }

    public ModbusOutputStream(int n) {
        super(n);
    }
}

