/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusRegisterBitProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientRegisterBitProxyExt
extends BModbusClientProxyExt
implements BIModbusRegisterBitProxyExt {
    public static final Property regType = BModbusClientRegisterBitProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property bitNumber = BModbusClientRegisterBitProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)15));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientRegisterBitProxyExt;

    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    public void setRegType(BRegisterTypeEnum bRegisterTypeEnum) {
        this.set(regType, (BValue)bRegisterTypeEnum, null);
    }

    public int getBitNumber() {
        return this.getInt(bitNumber);
    }

    public void setBitNumber(int n) {
        this.setInt(bitNumber, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)regType, 1);
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        int n3 = 1;
        int n4 = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice, n, n4, n2, n3);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        this.setOutValues(modbusResponse);
    }

    public void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            this.setBinaryOutValues(modbusResponse);
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setBinaryOutValues(ModbusResponse modbusResponse) {
        int n = modbusResponse.data[1] & 0xFF | (modbusResponse.data[0] & 0xFF) << 8;
        int n2 = 1;
        boolean bl = false;
        if ((n & (n2 <<= this.getBitNumber())) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        this.readOk((BStatusValue)new BStatusBoolean(bl2));
    }

    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    public BEnum getRegisterType() {
        return this.getRegType();
    }

    public int determineNumRegisters() {
        return 1;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)bitNumber)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
                } else {
                    this.getTuning().writeDesired();
                }
            }
        } else if (property.equals((Object)regType)) {
            if (context != noAddressCheck) {
                if (this.getParentPoint().isWritablePoint() && !this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                } else if (this.getDataAddress().isModbusFormat()) {
                    this.setStale(true, null);
                    if (this.getDataAddress().isModbusHoldingAddress()) {
                        if (!this.isHoldingRegisterType()) {
                            this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                        }
                    } else if (this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                    }
                }
            }
            if (this.getDevice() != null) {
                if (this.getParentPoint().isWritablePoint() && ((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
                }
                this.adjustPollSubscription();
            }
        }
    }

    public boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            return bFlexAddress.isValid();
        }
        if (bFlexAddress.isModbusAnalogAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return bFlexAddress.isModbusHoldingAddress();
            }
            if (bFlexAddress.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    public void devicePoll(BDevicePollConfigEntry bDevicePollConfigEntry) {
        block5: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
            int n = 1;
            ModbusResponse modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            int n2 = this.getAbsoluteAddress().getDataAddress();
            try {
                if (this.isHoldingRegisterType()) {
                    modbusResponse.data = bModbusClientDevice.getHoldingRegisterValues(n2, n, bDevicePollConfigEntry);
                    modbusResponse.exceptionCode = bModbusClientDevice.getHoldingRegistersReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                } else {
                    modbusResponse.data = bModbusClientDevice.getInputRegisterValues(n2, n, bDevicePollConfigEntry);
                    modbusResponse.exceptionCode = bModbusClientDevice.getInputRegistersReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                }
                modbusResponse.byteCount = (byte)modbusResponse.data.length;
                modbusResponse.numberPoints = n;
                this.setOutValues(modbusResponse);
            }
            catch (ModbusException modbusException) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block5;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)modbusException));
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (bStatusValue == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(bStatusValue);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this + "- This ModbusClient register bit point is not writable, disregarding write request.");
        }
        super.doWrite(bStatusValue);
    }

    public boolean updateOutput(BStatusValue bStatusValue) {
        ModbusWriteRequest modbusWriteRequest;
        ModbusResponse modbusResponse;
        boolean bl = ((BStatusBoolean)bStatusValue).getValue();
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork bModbusClientNetwork = (BModbusClientNetwork)this.modbusNet();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        int n3 = 1;
        int n4 = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2, n3);
        ModbusResponse modbusResponse2 = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse2 == null) {
            modbusResponse2 = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse2.exceptionCode = 9;
        }
        if (modbusResponse2.isError()) {
            this.writeFail(modbusResponse2.getExceptionString());
            return false;
        }
        int n5 = modbusResponse2.data[1] & 0xFF | (modbusResponse2.data[0] & 0xFF) << 8;
        byte[] byArray = new byte[2];
        int n6 = 1;
        n5 = bl ? (n5 |= n6) : (n5 &= ~(n6 <<= this.getBitNumber()));
        byArray[0] = (byte)(n5 >> 8 & 0xFF);
        byArray[1] = (byte)(n5 & 0xFF);
        n4 = 6;
        if (bModbusClientDevice.isPresetMultiple()) {
            n4 = 16;
        }
        if ((modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2, n3, byArray))) == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        this.writeOk(bStatusValue);
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientRegisterBitProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientRegisterBitProxyExt = BModbusClientRegisterBitProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientRegisterBitProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

