/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusErrorCodes;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigTable;
import com.tridium.modbusCore.client.point.BModbusClientPointDeviceExt;
import com.tridium.modbusCore.client.point.BModbusClientPollGroup;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataSourceEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.point.BIModbusReadProxyExt;
import com.tridium.modbusCore.point.BModbusProxyExt;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BModbusClientProxyExt
extends BModbusProxyExt
implements ModbusErrorCodes,
BIModbusReadProxyExt {
    public static final Property absoluteAddress = BModbusClientProxyExt.newProperty((int)3, (BValue)new BFlexAddress(), null);
    public static final Property dataSource = BModbusClientProxyExt.newProperty((int)3, (BValue)BDataSourceEnum.pointPoll, null);
    public static final Type TYPE;
    protected Object pollSync;
    protected boolean subscribed;
    protected boolean configFault;
    private Object lastPollGroupCode;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientProxyExt;

    public BFlexAddress getAbsoluteAddress() {
        return (BFlexAddress)this.get(absoluteAddress);
    }

    public void setAbsoluteAddress(BFlexAddress bFlexAddress) {
        this.set(absoluteAddress, (BValue)bFlexAddress, null);
    }

    public BDataSourceEnum getDataSource() {
        return (BDataSourceEnum)this.get(dataSource);
    }

    public void setDataSource(BDataSourceEnum bDataSourceEnum) {
        this.set(dataSource, (BValue)bDataSourceEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPollGroupCode() {
        Object object = this.pollSync;
        synchronized (object) {
            if (this.lastPollGroupCode != null) {
                return this.lastPollGroupCode;
            }
            BDevicePollConfigEntry bDevicePollConfigEntry = null;
            BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
            if (bModbusClientDevice != null) {
                BRegisterTypesEnum bRegisterTypesEnum = this.determineRegisterType();
                BDevicePollConfigEntry[] bDevicePollConfigEntryArray = null;
                if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.holdingRegister)) {
                    bDevicePollConfigEntryArray = bModbusClientDevice.getDevicePollConfig().getActiveHoldingRegisterPollEntries();
                } else if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.inputRegister)) {
                    bDevicePollConfigEntryArray = bModbusClientDevice.getDevicePollConfig().getActiveInputRegisterPollEntries();
                } else if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.discreteCoil)) {
                    bDevicePollConfigEntryArray = bModbusClientDevice.getDevicePollConfig().getActiveBinaryCoilPollEntries();
                } else if (bRegisterTypesEnum.equals((Object)BRegisterTypesEnum.discreteInput)) {
                    bDevicePollConfigEntryArray = bModbusClientDevice.getDevicePollConfig().getActiveBinaryInputPollEntries();
                }
                int n = this.determineNumRegisters();
                this.setCurrentAbsoluteAddress();
                int n2 = this.getAbsoluteAddress().getDataAddress();
                bDevicePollConfigEntry = BDevicePollConfigTable.findPollConfigEntry(bDevicePollConfigEntryArray, n2, n);
            }
            if (bDevicePollConfigEntry != null) {
                this.setDataSource(BDataSourceEnum.devicePoll);
                this.lastPollGroupCode = bDevicePollConfigEntry;
            } else {
                this.setDataSource(BDataSourceEnum.pointPoll);
                this.lastPollGroupCode = this;
            }
            return this.lastPollGroupCode;
        }
    }

    public Type getPollGroupType() {
        return BModbusClientPollGroup.TYPE;
    }

    public Type getDeviceExtType() {
        return BModbusClientPointDeviceExt.TYPE;
    }

    public boolean write(Context context) throws Exception {
        if (this.configFault) {
            return false;
        }
        return super.write(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readSubscribed(Context context) throws Exception {
        this.setCurrentAbsoluteAddress();
        super.readSubscribed(context);
        Object object = this.pollSync;
        synchronized (object) {
            this.subscribed = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readUnsubscribed(Context context) throws Exception {
        Object object = this.pollSync;
        synchronized (object) {
            if (!this.subscribed) {
                return;
            }
            this.subscribed = false;
        }
        super.readUnsubscribed(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void adjustPollSubscription() {
        Object object = this.pollSync;
        synchronized (object) {
            block6: {
                block5: {
                    if (!this.subscribed) break block5;
                    try {
                        this.readUnsubscribed(null);
                        this.lastPollGroupCode = null;
                        this.readSubscribed(null);
                    }
                    catch (Exception exception) {
                        this.modbusNet().getModbusLog().error(this.getParent().getName() + ">>> adjustPollSubscription error", (Throwable)exception);
                    }
                    break block6;
                }
                this.lastPollGroupCode = null;
            }
            return;
        }
    }

    public void started() throws Exception {
        BModbusClientDevice bModbusClientDevice;
        this.setCurrentAbsoluteAddress();
        if (this.getParentPoint().isWritablePoint() && (bModbusClientDevice = (BModbusClientDevice)this.getDevice()) != null) {
            if (bModbusClientDevice.writablePointAlreadyExists(this)) {
                this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
            }
            bModbusClientDevice.addWritableProxy(this);
        }
        super.started();
    }

    public void stopped() throws Exception {
        BModbusClientDevice bModbusClientDevice;
        if (this.getParentPoint().isWritablePoint() && (bModbusClientDevice = (BModbusClientDevice)this.getDevice()) != null) {
            bModbusClientDevice.removeWritableProxy(this);
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)dataAddress)) {
            this.setStale(true, null);
            if (!this.isValidAddress(this.getDataAddress()) && Sys.atSteadyState() && this.modbusNet() != null && context != Context.commit) {
                this.modbusNet().getModbusLog().error("Illegal Modbus address for point " + this.getParent().getName() + ": Modbus Address does not match Object type.");
            }
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
                this.setCurrentAbsoluteAddress();
                if (!this.configFault) {
                    this.readReset();
                }
                if (this.getParentPoint().isWritablePoint()) {
                    if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                        this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                        this.set(dataAddress, (BValue)new BFlexAddress(BAddressFormatEnum.hex, "-1"), null);
                    } else {
                        this.getTuning().writeDesired();
                    }
                }
            }
        }
    }

    public void setCurrentAbsoluteAddress() {
        if (!this.isValidAddress(this.getDataAddress())) {
            this.configFault = true;
            String string = "Illegal Modbus address " + (Object)((Object)this.getDataAddress()) + " for this point's configuration.";
            this.readFail(string);
        } else {
            this.configFault = false;
        }
        int n = 0;
        try {
            n = ((BModbusClientDevice)this.getDevice()).getRegisterBaseAddress(this.getRegisterType());
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        try {
            BFlexAddress bFlexAddress = (BFlexAddress)this.getDataAddress().newCopy();
            int n2 = bFlexAddress.isModbusFormat() ? Integer.valueOf(bFlexAddress.getAddress()).intValue() : bFlexAddress.getDataAddress();
            bFlexAddress.setAddressFromInt(n2 + n);
            this.setAbsoluteAddress(bFlexAddress);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (NumberFormatException numberFormatException) {
            BFlexAddress bFlexAddress = (BFlexAddress)this.getDataAddress().newCopy();
            bFlexAddress.setAddressFromInt(n);
            this.setAbsoluteAddress(bFlexAddress);
        }
    }

    public void poll() {
        if (this.configFault || this.isUnoperational()) {
            return;
        }
        if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> BModbusClientProxyExt.poll");
        }
        this.read();
    }

    public boolean isValidAddress(BFlexAddress bFlexAddress) {
        return bFlexAddress.isValid();
    }

    public abstract void devicePoll(BDevicePollConfigEntry var1);

    public abstract BRegisterTypesEnum determineRegisterType();

    public abstract BEnum getRegisterType();

    public abstract int determineNumRegisters();

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.pollSync = new Object();
        this.subscribed = false;
        this.configFault = false;
        this.lastPollGroupCode = null;
    }

    public BModbusClientProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientProxyExt = BModbusClientProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

