/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientNumericProxyExt
extends BModbusClientProxyExt
implements BIModbusNumericProxyExt {
    public static final Property regType = BModbusClientNumericProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    public static final Property dataType = BModbusClientNumericProxyExt.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientNumericProxyExt;

    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    public void setRegType(BRegisterTypeEnum bRegisterTypeEnum) {
        this.set(regType, (BValue)bRegisterTypeEnum, null);
    }

    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    public void setDataType(BDataTypeEnum bDataTypeEnum) {
        this.set(dataType, (BValue)bDataTypeEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)regType, 1);
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        int n3 = 1;
        if (this.isDataTypeLong()) {
            n3 *= 2;
        } else if (this.isDataTypeFloat()) {
            n3 *= 2;
        }
        int n4 = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice, n, n4, n2, n3);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        this.setOutValues(modbusResponse);
    }

    public void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(modbusResponse, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(modbusResponse, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(modbusResponse, 4);
            }
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setIntegerOutValues(ModbusResponse modbusResponse, int n) {
        int n2;
        try {
            n2 = modbusResponse.getRegister(0, n, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing integer value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)n2));
    }

    private final void setFloatOutValues(ModbusResponse modbusResponse, int n) {
        float f;
        try {
            f = modbusResponse.getFloat(0, n, ((BModbusClientDevice)this.getDevice()).isFloat3210Order());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing float value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)f));
    }

    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    public BEnum getRegisterType() {
        return this.getRegType();
    }

    public int determineNumRegisters() {
        int n = 1;
        if (!this.isDataTypeInteger()) {
            n *= 2;
        }
        return n;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            super.changed(property, context);
            return;
        }
        if (property.equals((Object)dataType)) {
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
            if (this.getParentPoint().isWritablePoint()) {
                if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.set(dataAddress, (BValue)new BFlexAddress(BAddressFormatEnum.hex, "-1"), null);
                } else {
                    this.getTuning().writeDesired();
                }
            }
        } else if (property.equals((Object)regType)) {
            if (context != noAddressCheck) {
                if (this.getParentPoint().isWritablePoint() && !this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                } else if (this.getDataAddress().isModbusFormat()) {
                    this.setStale(true, null);
                    if (this.getDataAddress().isModbusHoldingAddress()) {
                        if (!this.isHoldingRegisterType()) {
                            this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                        }
                    } else if (this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                    }
                }
            }
            if (this.getDevice() != null) {
                if (this.getParentPoint().isWritablePoint() && ((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
                }
                this.adjustPollSubscription();
            }
        } else {
            super.changed(property, context);
        }
    }

    public boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            return bFlexAddress.isValid();
        }
        if (bFlexAddress.isModbusAnalogAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return bFlexAddress.isModbusHoldingAddress();
            }
            if (bFlexAddress.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    public boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    public boolean isDataTypeLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public boolean isDataTypeFloat() {
        return this.getDataType().equals((Object)BDataTypeEnum.floatType);
    }

    public boolean isDataTypeSigned() {
        if (this.getDataType().equals((Object)BDataTypeEnum.signedInteger)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public void devicePoll(BDevicePollConfigEntry bDevicePollConfigEntry) {
        block6: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
            int n = 1;
            if (!this.isDataTypeInteger()) {
                n *= 2;
            }
            ModbusResponse modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            int n2 = this.getAbsoluteAddress().getDataAddress();
            try {
                if (this.isHoldingRegisterType()) {
                    modbusResponse.data = bModbusClientDevice.getHoldingRegisterValues(n2, n, bDevicePollConfigEntry);
                    modbusResponse.exceptionCode = bModbusClientDevice.getHoldingRegistersReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                } else {
                    modbusResponse.data = bModbusClientDevice.getInputRegisterValues(n2, n, bDevicePollConfigEntry);
                    modbusResponse.exceptionCode = bModbusClientDevice.getInputRegistersReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                }
                modbusResponse.byteCount = (byte)modbusResponse.data.length;
                modbusResponse.numberPoints = n;
                this.setOutValues(modbusResponse);
            }
            catch (ModbusException modbusException) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block6;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)modbusException));
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (bStatusValue == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(bStatusValue);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusClient float point is not writable, disregarding write request.");
        }
        super.doWrite(bStatusValue);
    }

    public boolean updateOutput(BStatusValue bStatusValue) {
        ModbusWriteRequest modbusWriteRequest;
        ModbusResponse modbusResponse;
        double d = ((BStatusNumeric)bStatusValue).getValue();
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork bModbusClientNetwork = (BModbusClientNetwork)this.modbusNet();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        byte[] byArray = this.isDataTypeInteger() ? this.setIntegerByteArray(d) : (this.isDataTypeLong() ? this.setLongByteArray(d) : this.setFloatByteArray(d));
        int n3 = 1;
        if (this.isDataTypeLong() || this.isDataTypeFloat()) {
            n3 *= 2;
        }
        int n4 = 6;
        if (bModbusClientDevice.isPresetMultiple()) {
            n4 = 16;
        }
        if ((modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2, n3, byArray))) == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        if (n4 == 6 && n3 > 1) {
            byArray[0] = byArray[2];
            byArray[1] = byArray[3];
            modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2 + 1, 1, byArray);
            modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest);
            if (modbusResponse == null) {
                modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
                modbusResponse.exceptionCode = 9;
            }
            if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
                this.writeFail(modbusResponse.getExceptionString());
                return false;
            }
        }
        this.writeOk(bStatusValue);
        return true;
    }

    protected byte[] setIntegerByteArray(double d) {
        byte[] byArray = new byte[2];
        d = d >= 0.0 ? (d += 0.5) : (d -= 0.5);
        double d2 = 65535.0;
        double d3 = 0.0;
        if (this.isDataTypeSigned()) {
            d2 = 32767.0;
            d3 = -32768.0;
        }
        if (d > d2) {
            d = d2;
        } else if (d < d3) {
            d = d3;
        }
        int n = (int)d;
        byArray[0] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)(n & 0xFF);
        return byArray;
    }

    protected byte[] setLongByteArray(double d) {
        byte[] byArray = new byte[4];
        d = d >= 0.0 ? (d += 0.5) : (d -= 0.5);
        double d2 = 2.147483647E9;
        double d3 = -2.147483648E9;
        if (d > d2) {
            d = d2;
        } else if (d < d3) {
            d = d3;
        }
        int n = (int)d;
        if (((BModbusClientDevice)this.getDevice()).isLong3210Order()) {
            byArray[0] = (byte)((n & 0xFF000000) >> 24);
            byArray[1] = (byte)((n & 0xFF0000) >> 16);
            byArray[2] = (byte)((n & 0xFF00) >> 8);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)((n & 0xFF00) >> 8);
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFF000000) >> 24);
            byArray[3] = (byte)((n & 0xFF0000) >> 16);
        }
        return byArray;
    }

    protected byte[] setFloatByteArray(double d) {
        byte[] byArray = new byte[4];
        int n = Float.floatToIntBits((float)d);
        if (((BModbusClientDevice)this.getDevice()).isFloat3210Order()) {
            byArray[0] = (byte)((n & 0xFF000000) >> 24);
            byArray[1] = (byte)((n & 0xFF0000) >> 16);
            byArray[2] = (byte)((n & 0xFF00) >> 8);
            byArray[3] = (byte)(n & 0xFF);
        } else {
            byArray[0] = (byte)((n & 0xFF00) >> 8);
            byArray[1] = (byte)(n & 0xFF);
            byArray[2] = (byte)((n & 0xFF000000) >> 24);
            byArray[3] = (byte)((n & 0xFF0000) >> 16);
        }
        return byArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientNumericProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientNumericProxyExt = BModbusClientNumericProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientNumericProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

