/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.point.BModbusClientNumericProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BAddressFormatEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusNumericBitsProxyExt;
import javax.baja.control.BNumericPoint;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientNumericBitsProxyExt
extends BModbusClientNumericProxyExt
implements BIModbusNumericBitsProxyExt {
    public static final Property beginningBit = BModbusClientNumericBitsProxyExt.newProperty((int)0, (int)0, (BFacets)BFacets.makeInt(null, (int)0, (int)15));
    public static final Property numberOfBits = BModbusClientNumericBitsProxyExt.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)16));
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientNumericBitsProxyExt;

    public int getBeginningBit() {
        return this.getInt(beginningBit);
    }

    public void setBeginningBit(int n) {
        this.setInt(beginningBit, n, null);
    }

    public int getNumberOfBits() {
        return this.getInt(numberOfBits);
    }

    public void setNumberOfBits(int n) {
        this.setInt(numberOfBits, n, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            super.changed(property, context);
            return;
        }
        if (property.equals((Object)beginningBit) || property.equals((Object)numberOfBits)) {
            if (context != noAddressCheck) {
                this.checkBitFieldSize();
            }
            if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                this.setDataAddress(new BFlexAddress(BAddressFormatEnum.hex, "-1"));
            }
        } else if (property.equals((Object)dataType)) {
            if (context != noAddressCheck && !this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
                this.set(dataType, (BValue)BDataTypeEnum.integerType, noAddressCheck);
            }
            this.setStale(true, null);
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
            if (this.getParentPoint().isWritablePoint()) {
                if (((BModbusClientDevice)this.getDevice()).writablePointAlreadyExists(this)) {
                    this.modbusNet().getModbusLog().error(this.getParent().getName() + " Duplicate Writable point for register address: " + (Object)((Object)this.getDataAddress()));
                    this.set(dataAddress, (BValue)new BFlexAddress(BAddressFormatEnum.hex, "-1"), null);
                } else {
                    this.getTuning().writeDesired();
                }
            }
        } else {
            super.changed(property, context);
        }
    }

    public void started() throws Exception {
        Property property = this.getProperty("conversion");
        this.setFlags((Slot)property, this.getFlags((Slot)property) | 4);
        property = this.getProperty("dataType");
        this.setFlags((Slot)property, this.getFlags((Slot)property) | 4);
        if (!this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            this.setDataType(BDataTypeEnum.integerType);
        }
        this.checkBitFieldSize();
        super.started();
    }

    public void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(modbusResponse, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(modbusResponse, 4);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(modbusResponse, 4);
            }
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setIntegerOutValues(ModbusResponse modbusResponse, int n) {
        int n2;
        try {
            n2 = this.getBitsValue(modbusResponse.getRegister(0, n, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing integer value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)n2));
    }

    private final void setFloatOutValues(ModbusResponse modbusResponse, int n) {
        float f;
        try {
            f = this.getBitsValue(modbusResponse.getFloat(0, n, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail("error parsing float value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusNumeric((double)f));
    }

    public boolean updateOutput(BStatusValue bStatusValue) {
        ModbusWriteRequest modbusWriteRequest;
        float f = (float)((BStatusNumeric)bStatusValue).getValue();
        if (f > (float)this.getMask()) {
            this.writeFail(f + " is greater than maximum value of " + this.getMask() + " (" + this.getNumberOfBits() + " bits)");
            return false;
        }
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork bModbusClientNetwork = (BModbusClientNetwork)this.modbusNet();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        int n3 = 1;
        if (this.isDataTypeLong() || this.isDataTypeFloat()) {
            n3 *= 2;
        }
        int n4 = this.isHoldingRegisterType() ? 3 : 4;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2, n3);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        byte[] byArray = this.isDataTypeInteger() ? this.setIntegerByteArray(this.mergeBitsValue(f, (float)modbusResponse.getRegister(0, 2, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : (this.isDataTypeLong() ? this.setLongByteArray(this.mergeBitsValue(f, (float)modbusResponse.getRegister(0, 4, ((BModbusClientDevice)this.getDevice()).isLong3210Order(), this.isDataTypeSigned()))) : this.setFloatByteArray(this.mergeBitsValue(f, modbusResponse.getFloat(0, 4, ((BModbusClientDevice)this.getDevice()).isFloat3210Order()))));
        n4 = 6;
        if (bModbusClientDevice.isPresetMultiple()) {
            n4 = 16;
        }
        if ((modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2, n3, byArray))) == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        if (n4 == 6 && n3 > 1) {
            byArray[0] = byArray[2];
            byArray[1] = byArray[3];
            modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n, n4, n2 + 1, 1, byArray);
            modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest);
            if (modbusResponse == null) {
                modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
                modbusResponse.exceptionCode = 9;
            }
            if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
                this.writeFail(modbusResponse.getExceptionString());
                return false;
            }
        }
        this.writeOk(bStatusValue);
        return true;
    }

    public boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            return bFlexAddress.isValid();
        }
        if (bFlexAddress.isModbusAnalogAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return bFlexAddress.isModbusHoldingAddress();
            }
            if (bFlexAddress.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public void checkBitFieldSize() {
        int n;
        int n2 = this.getBeginningBit();
        if (n2 + (n = this.getNumberOfBits()) > 16) {
            this.modbusNet().getModbusLog().error(this.getParent().getName() + " bits " + n2 + '-' + (n2 + n - 1) + " exceed register bounds.");
            this.setInt(this.getProperty("numberOfBits"), 16 - n2, noAddressCheck);
        }
    }

    public float getBitsValue(float f) {
        return new Integer(this.getBitsValue((int)f)).floatValue();
    }

    public int getBitsValue(int n) {
        return (n & this.getRegisterMask()) >> this.getBeginningBit();
    }

    public float mergeBitsValue(float f, float f2) {
        return this.mergeBitsValue((int)f, f2);
    }

    public float mergeBitsValue(int n, float f) {
        float f2 = (float)((BNumericPoint)this.getParent()).getOut().getValue();
        return (int)f & ~this.getRegisterMask() | n << this.getBeginningBit();
    }

    public int getMask() {
        int n = 0;
        int n2 = this.getNumberOfBits();
        int n3 = 0;
        while (n3 < n2) {
            n <<= 1;
            n |= 1;
            ++n3;
        }
        return n;
    }

    public int getRegisterMask() {
        return this.getMask() << this.getBeginningBit();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientNumericBitsProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientNumericBitsProxyExt = BModbusClientNumericBitsProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientNumericBitsProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

