/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.point;

import com.tridium.modbusCore.ModbusException;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.BModbusClientNetwork;
import com.tridium.modbusCore.client.datatypes.BDevicePollConfigEntry;
import com.tridium.modbusCore.client.point.BModbusClientProxyExt;
import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.enums.BStatusTypeEnum;
import com.tridium.modbusCore.messages.ModbusReadRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteRequest;
import com.tridium.modbusCore.point.BIModbusBooleanProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BEnum;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientBooleanProxyExt
extends BModbusClientProxyExt
implements BIModbusBooleanProxyExt {
    public static final Property statusType = BModbusClientBooleanProxyExt.newProperty((int)0, (BValue)BStatusTypeEnum.coil, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$point$BModbusClientBooleanProxyExt;

    public BStatusTypeEnum getStatusType() {
        return (BStatusTypeEnum)this.get(statusType);
    }

    public void setStatusType(BStatusTypeEnum bStatusTypeEnum) {
        this.set(statusType, (BValue)bStatusTypeEnum, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)statusType, 1);
        }
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        int n = bModbusClientDevice.getDeviceAddress();
        int n2 = this.getAbsoluteAddress().getDataAddress();
        int n3 = 1;
        int n4 = this.isCoilStatusType() ? 1 : 2;
        ModbusReadRequest modbusReadRequest = new ModbusReadRequest(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice, n, n4, n2, n3);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusReadRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        this.setOutValues(modbusResponse);
    }

    public void setOutValues(ModbusResponse modbusResponse) {
        if (!modbusResponse.isError()) {
            this.setBinaryOutValues(modbusResponse);
        } else {
            this.readFail(modbusResponse.getExceptionString());
        }
    }

    private final void setBinaryOutValues(ModbusResponse modbusResponse) {
        boolean bl;
        try {
            bl = modbusResponse.getBinary(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.readFail(this.getName() + ": error parsing boolean value (" + illegalArgumentException + ')');
            return;
        }
        this.readOk((BStatusValue)new BStatusBoolean(bl));
    }

    public BRegisterTypesEnum determineRegisterType() {
        if (this.getStatusType().equals((Object)BStatusTypeEnum.coil)) {
            return BRegisterTypesEnum.discreteCoil;
        }
        return BRegisterTypesEnum.discreteInput;
    }

    public BEnum getRegisterType() {
        return this.getStatusType();
    }

    public int determineNumRegisters() {
        return 1;
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.equals((Object)statusType)) {
            if (context != noAddressCheck) {
                if (this.getParentPoint().isWritablePoint() && !this.isCoilStatusType()) {
                    this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
                } else if (this.getDataAddress().isModbusFormat()) {
                    this.setStale(true, null);
                    if (this.getDataAddress().isModbusCoilAddress()) {
                        if (!this.isCoilStatusType()) {
                            this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
                        }
                    } else if (this.isCoilStatusType()) {
                        this.set(statusType, (BValue)BStatusTypeEnum.input, noAddressCheck);
                    }
                }
            }
            if (this.getDevice() != null) {
                this.adjustPollSubscription();
            }
        }
    }

    public boolean isValidAddress(BFlexAddress bFlexAddress) {
        if (!bFlexAddress.isModbusFormat()) {
            return bFlexAddress.isValid();
        }
        if (bFlexAddress.isModbusDigitalAddress()) {
            if (this.getParentPoint().isWritablePoint()) {
                return bFlexAddress.isModbusCoilAddress();
            }
            if (bFlexAddress.isModbusCoilAddress()) {
                this.set(statusType, (BValue)BStatusTypeEnum.coil, noAddressCheck);
            } else {
                this.set(statusType, (BValue)BStatusTypeEnum.input, noAddressCheck);
            }
            return true;
        }
        return false;
    }

    public boolean isCoilStatusType() {
        return this.getStatusType().equals((Object)BStatusTypeEnum.coil);
    }

    public void devicePoll(BDevicePollConfigEntry bDevicePollConfigEntry) {
        block5: {
            if (this.configFault || this.isUnoperational()) {
                return;
            }
            BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
            int n = 1;
            ModbusResponse modbusResponse = new ModbusResponse(((BModbusClientNetwork)bModbusClientDevice.modbusNet()).getModbusMode(), bModbusClientDevice);
            int n2 = this.getAbsoluteAddress().getDataAddress();
            try {
                if (this.isCoilStatusType()) {
                    modbusResponse.data = bModbusClientDevice.getCoilStatusValues(n2, n, bDevicePollConfigEntry);
                    modbusResponse.exceptionCode = bModbusClientDevice.getBinaryCoilsReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                } else {
                    modbusResponse.data = bModbusClientDevice.getInputStatusValues(n2, n, bDevicePollConfigEntry);
                    modbusResponse.exceptionCode = bModbusClientDevice.getBinaryInputsReadStatus(n2, n, bDevicePollConfigEntry).getErrorCode();
                }
                modbusResponse.byteCount = (byte)modbusResponse.data.length;
                modbusResponse.numberPoints = n;
                this.setOutValues(modbusResponse);
            }
            catch (ModbusException modbusException) {
                if (!this.modbusNet().getModbusLog().isTraceOn()) break block5;
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ">>> devicePoll error", (Throwable)((Object)modbusException));
            }
        }
    }

    public void doWrite(BStatusValue bStatusValue) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (bStatusValue == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(bStatusValue);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusClient boolean point is not writable, disregarding write request.");
        }
        super.doWrite(bStatusValue);
    }

    private final boolean updateOutput(BStatusValue bStatusValue) {
        int n;
        byte[] byArray;
        boolean bl = ((BStatusBoolean)bStatusValue).getValue();
        BModbusClientDevice bModbusClientDevice = (BModbusClientDevice)this.getDevice();
        BModbusClientNetwork bModbusClientNetwork = (BModbusClientNetwork)this.modbusNet();
        int n2 = bModbusClientDevice.getDeviceAddress();
        int n3 = this.getAbsoluteAddress().getDataAddress();
        if (bModbusClientDevice.isForceMultiple()) {
            byArray = new byte[]{0};
            n = 15;
            if (bl) {
                byArray[0] = 1;
            }
        } else {
            byArray = new byte[]{0, 0};
            n = 5;
            if (bl) {
                byArray[0] = -1;
            }
        }
        int n4 = 1;
        ModbusWriteRequest modbusWriteRequest = new ModbusWriteRequest(bModbusClientNetwork.getModbusMode(), bModbusClientDevice, n2, n, n3, n4, byArray);
        ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage(modbusWriteRequest);
        if (modbusResponse == null) {
            modbusResponse = new ModbusResponse(bModbusClientNetwork.getModbusMode(), bModbusClientDevice);
            modbusResponse.exceptionCode = 9;
        }
        if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
            this.writeFail(modbusResponse.getExceptionString());
            return false;
        }
        this.writeOk(bStatusValue);
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$point$BModbusClientBooleanProxyExt;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$point$BModbusClientBooleanProxyExt = BModbusClientBooleanProxyExt.class("[Lcom.tridium.modbusCore.client.point.BModbusClientBooleanProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

