/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.client.datatypes;

import com.tridium.basicdriver.message.Message;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.BModbusNetwork;
import com.tridium.modbusCore.client.BModbusClientDevice;
import com.tridium.modbusCore.client.datatypes.BCommStatus;
import com.tridium.modbusCore.datatypes.BModbusStringRecord;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusReadFileRequest;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.messages.ModbusWriteFileRequest;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BModbusClientStringRecord
extends BModbusStringRecord {
    public static final Property lastSuccessfulWrite = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailedWrite = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property writeStatus = BModbusClientStringRecord.newProperty((int)67, (BValue)new BCommStatus(-2), null);
    public static final Property lastSuccessfulRead = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property lastFailedRead = BModbusClientStringRecord.newProperty((int)67, (BValue)BAbsTime.NULL, null);
    public static final Property readStatus = BModbusClientStringRecord.newProperty((int)67, (BValue)new BCommStatus(-2), null);
    public static final Action read = BModbusClientStringRecord.newAction((int)24, null);
    public static final Topic readSuccessful = BModbusClientStringRecord.newTopic((int)8, null);
    public static final Type TYPE;
    static /* synthetic */ Class class$com$tridium$modbusCore$client$datatypes$BModbusClientStringRecord;

    public BAbsTime getLastSuccessfulWrite() {
        return (BAbsTime)this.get(lastSuccessfulWrite);
    }

    public void setLastSuccessfulWrite(BAbsTime bAbsTime) {
        this.set(lastSuccessfulWrite, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastFailedWrite() {
        return (BAbsTime)this.get(lastFailedWrite);
    }

    public void setLastFailedWrite(BAbsTime bAbsTime) {
        this.set(lastFailedWrite, (BValue)bAbsTime, null);
    }

    public BCommStatus getWriteStatus() {
        return (BCommStatus)this.get(writeStatus);
    }

    public void setWriteStatus(BCommStatus bCommStatus) {
        this.set(writeStatus, (BValue)bCommStatus, null);
    }

    public BAbsTime getLastSuccessfulRead() {
        return (BAbsTime)this.get(lastSuccessfulRead);
    }

    public void setLastSuccessfulRead(BAbsTime bAbsTime) {
        this.set(lastSuccessfulRead, (BValue)bAbsTime, null);
    }

    public BAbsTime getLastFailedRead() {
        return (BAbsTime)this.get(lastFailedRead);
    }

    public void setLastFailedRead(BAbsTime bAbsTime) {
        this.set(lastFailedRead, (BValue)bAbsTime, null);
    }

    public BCommStatus getReadStatus() {
        return (BCommStatus)this.get(readStatus);
    }

    public void setReadStatus(BCommStatus bCommStatus) {
        this.set(readStatus, (BValue)bCommStatus, null);
    }

    public void read() {
        this.invoke(read, null, null);
    }

    public void fireReadSuccessful(BValue bValue) {
        this.fire(readSuccessful, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        if (action.equals((Object)read)) {
            return this.getNetwork().postAsync((Runnable)new Invocation((BComponent)this, action, bValue, context));
        }
        return super.post(action, bValue, context);
    }

    public void doWrite() {
        BModbusDevice bModbusDevice = this.getDevice();
        if (bModbusDevice == null || bModbusDevice.isFault()) {
            BCommStatus bCommStatus = new BCommStatus(-7);
            this.getWriteStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getWriteStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusDevice.isDown()) {
            BCommStatus bCommStatus = new BCommStatus(-6);
            this.getWriteStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getWriteStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusDevice.isDisabled()) {
            BCommStatus bCommStatus = new BCommStatus(-8);
            this.getWriteStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getWriteStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusDevice instanceof BModbusClientDevice) {
            this.writeRecords((BModbusClientDevice)bModbusDevice);
        }
    }

    private final void writeRecords(BModbusClientDevice bModbusClientDevice) {
        ModbusMessageConst modbusMessageConst;
        BModbusNetwork bModbusNetwork = this.getNetwork();
        byte[] byArray = this.getInputBytes(this.getRecordLength(), this.getPadding() ? null : " ");
        int n = 0;
        int n2 = byArray.length - 1;
        int n3 = Math.min(n2, 237);
        int n4 = this.getStartingRecordNumber();
        byte[] byArray2 = null;
        while (n3 <= n2) {
            modbusMessageConst = new ModbusWriteFileRequest(bModbusNetwork.getModbusMode(), bModbusClientDevice, bModbusClientDevice.getDeviceAddress(), this.getFileNumber(), n4, (n3 - n + 1) / 2, byArray, n, n3);
            ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage((Message)modbusMessageConst);
            if (modbusResponse == null) {
                modbusResponse = new ModbusResponse(bModbusNetwork.getModbusMode(), bModbusClientDevice);
                modbusResponse.exceptionCode = 9;
            }
            if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
                BCommStatus bCommStatus = new BCommStatus(modbusResponse.exceptionCode);
                this.getWriteStatus().setErrorCode(bCommStatus.getErrorCode());
                this.getWriteStatus().setErrorDescription(bCommStatus.getErrorDescription());
                this.setLastFailedWrite(Clock.time());
                return;
            }
            byArray2 = BModbusClientStringRecord.appendBytes(byArray2, modbusResponse.data);
            if (n3 >= n2) break;
            n4 += (n3 - n + 1) / 2;
            n = n3;
            n3 = Math.min(n2, n3 + 237);
        }
        modbusMessageConst = new BCommStatus(0);
        this.getWriteStatus().setErrorCode(modbusMessageConst.getErrorCode());
        this.getWriteStatus().setErrorDescription(modbusMessageConst.getErrorDescription());
        this.setLastSuccessfulWrite(Clock.time());
        this.setOutputBytes(byArray2);
        this.fireWriteSuccessful(null);
    }

    public void doRead() {
        BModbusDevice bModbusDevice = this.getDevice();
        if (bModbusDevice == null || bModbusDevice.isFault()) {
            BCommStatus bCommStatus = new BCommStatus(-7);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusDevice.isDown()) {
            BCommStatus bCommStatus = new BCommStatus(-6);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusDevice.isDisabled()) {
            BCommStatus bCommStatus = new BCommStatus(-8);
            this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
            this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
            return;
        }
        if (bModbusDevice instanceof BModbusClientDevice) {
            this.readRecords((BModbusClientDevice)bModbusDevice);
        }
    }

    private final void readRecords(BModbusClientDevice bModbusClientDevice) {
        ModbusMessageConst modbusMessageConst;
        BModbusNetwork bModbusNetwork = this.getNetwork();
        int n = this.getStartingRecordNumber();
        int n2 = this.getRecordLength();
        int n3 = Math.min(n2, 119);
        byte[] byArray = null;
        while (n3 > 0) {
            modbusMessageConst = new ModbusReadFileRequest(bModbusNetwork.getModbusMode(), bModbusClientDevice, bModbusClientDevice.getDeviceAddress(), this.getFileNumber(), n, n3);
            ModbusResponse modbusResponse = (ModbusResponse)bModbusClientDevice.sendModbusMessage((Message)modbusMessageConst);
            if (modbusResponse == null) {
                modbusResponse = new ModbusResponse(bModbusNetwork.getModbusMode(), bModbusClientDevice);
                modbusResponse.exceptionCode = 9;
            }
            if (modbusResponse.isError() && modbusResponse.exceptionCode != 5) {
                BCommStatus bCommStatus = new BCommStatus(modbusResponse.exceptionCode);
                this.getReadStatus().setErrorCode(bCommStatus.getErrorCode());
                this.getReadStatus().setErrorDescription(bCommStatus.getErrorDescription());
                this.setLastFailedRead(Clock.time());
                return;
            }
            byArray = BModbusClientStringRecord.appendBytes(byArray, modbusResponse.data);
            n += n3;
            n3 = Math.min(n2 -= n3, 119);
        }
        modbusMessageConst = new BCommStatus(0);
        this.getReadStatus().setErrorCode(modbusMessageConst.getErrorCode());
        this.getReadStatus().setErrorDescription(modbusMessageConst.getErrorDescription());
        this.setLastSuccessfulRead(Clock.time());
        this.setOutputBytes(byArray);
        this.fireReadSuccessful(null);
    }

    private static final byte[] appendBytes(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return null;
        }
        int n = 0;
        if (byArray != null) {
            n = byArray.length;
        }
        int n2 = 0;
        if (byArray2 != null) {
            n2 = byArray2.length;
        }
        byte[] byArray3 = new byte[n + n2];
        if (n > 0) {
            System.arraycopy(byArray, 0, byArray3, 0, n);
        }
        if (n2 > 0) {
            System.arraycopy(byArray2, 0, byArray3, n, n2);
        }
        return byArray3;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BModbusClientStringRecord() {
        this.setFlags((Slot)data, 259);
    }

    static {
        Class clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientStringRecord;
        if (clazz == null) {
            clazz = class$com$tridium$modbusCore$client$datatypes$BModbusClientStringRecord = BModbusClientStringRecord.class("[Lcom.tridium.modbusCore.client.datatypes.BModbusClientStringRecord;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

